<?php
 	/*
     	Name: securecookie.sqltable.login.php3
     	Type: One time pad login handler for TWIG
     	Desc: Securely stores the login/password informations on both sides through OTP
     	Based upon: securecookie.php4session.login.php3 by Xavier Roche/Serianet
 	*/

	$global_secure_key = "";

	/* Some useful functions */

  	/* XOR between two strings - $b is the key */
  	Function strxor( $a, $b ) 
		{
	    	$c = ""; 
		$alen = strlen( $a ); 
		$blen = strlen( $b );

    		for( $i = 0; $i < $alen; $i++ )
			{
			$c .= chr( ( ord( $a[$i] ) ) ^ ( ord( $b[$i % $blen] ) ) );
			}
	
		return $c;
  		}
  	
  	/* generate a random string (length $len) */
  	Function randomstr( $len ) 
		{
	    	$c = "";

    		for( $i = 0; $i < $len; $i++ )
			{
	      		$c .= chr( rand( 0, 255 ) );
			}

		return $c;
  		}

	/* A random key */
  	Function randomkey( $len ) 
		{
    		srand( ( double )microtime() * 1000000 );

    		return randomstr( $len );
  		}

  	/* cypher (otpcrypt) / decypher (otpdecrypt) */
  	Function otpcrypt( $data, $key ) 
		{
	    	/* First add noise so that the len can not be determined precisely */
    		$data .= chr( 0 );
	        $data .= randomstr( rand( 1, 8 ) );

    		/* Then xor */
	    	return strxor( $data, $key );
  		}

  	Function otpdecrypt( $data, $key ) 
		{
	    	/* Decypher */
    		$data = strxor( $data, $key );

	    	/* Denoise */
    		$data = substr( $data, 0, strpos( $data, chr( 0 ) ) );

	    	return $data;
  		}
  
	/* encode (convbinarytoascii) / decode (convasciitobinary) binary content */
  	Function convbinarytoascii( $data ) 
		{
    		return base64_encode($data);
  		}

  	Function convasciitobinary( $data ) 
		{
    		return base64_decode( $data );
	  	}

	/* Now the TWIG Login handler itself */

	/* Retreive login informations */
	Function TWIGGetLogin() 
		{
		GLOBAL $twig_authenticated, $config, $dbconfig, $twig_cookieauth, $global_secure_key;

		if( !$twig_authenticated )
			{
			$login = array();

			return $login;
			}

	    	$login = array();
    		$login["username"] = "";
	    	$login["password"] = "";

		$query = "SELECT * FROM " . $dbconfig["scloginhandler_table"] . " WHERE LID='" . $twig_authenticated . "'";
		$result = dbquery( $query );

		if( dbnumrows( $result ) > 0 )
			{
	      		if( strlen( $twig_cookieauth ) > 0 ) 
				{
        			$key = convasciitobinary( stripslashes( $twig_cookieauth ) );

        			if( strlen( $key ) > 0 ) 
					{
					$data = dbresultarray( $result, 0 );
	
					if( $data["expire"] < time() )
						{
						TWIGStoreLogin( "", "", 0, 1 );
						$login = array();
						}

	          			$edata = convasciitobinary( stripslashes( $data["pwdata"] ) );
        	  			$data = otpdecrypt( $edata, $key );
					$global_secure_key = $key; 

          				if( strlen( $data ) > 0 ) 
						{
            					$chr1pos = strpos( $data, chr( 1 ) );

            					if( $chr1pos > 0 ) 
							{
        	      					$login["username"] = substr( $data, 0, $chr1pos );
	              					$login["password"] = substr( $data, $chr1pos + 1 );
            						}
          					}
        				}
	      			}
    			}

	    	return $login;
  		}

	/* Store login informations */
	Function TWIGStoreLogin( $username, $password, $expire, $delete = 0 ) 
		{
    		GLOBAL $twig_authenticated, $config, $dbconfig, $disabled, $twig_cookieauth, $global_secure_key, $config_dir, $vhosts, $SERVER_NAME;

	    	$dir = $config["basedir"];
    		if( $dir == "" ) { $dir = "/"; }

    		if( $delete ) 
			{
			if( isset( $twig_authenticated ) )
				{
				$data = explode( "-", $twig_authenticated );

				$query = "UPDATE " . $dbconfig["accounts_table"] . " SET onnow='0' WHERE username='" . $data[1] ."'";
				$result = dbquery( $query );

				$query = "DELETE FROM " . $dbconfig["scloginhandler_table"] . " WHERE LID='" . $twig_authenticated ."'";
				$result = dbquery( $query );

		      		SetCookie( "twig_cookieauth", "", 0, $dir );
				}
    			} 
		else 
			{
      			$query = "SELECT laston FROM " . $dbconfig["accounts_table"] . " WHERE username='" . $username . "'";
	      		$result = dbquery( $query );

      			if( dbnumrows( $result ) > 0 ) 
				{
        			$query = "UPDATE " . $dbconfig["accounts_table"] . " SET laston='" . time() . "' WHERE username='" . $username . "'";
	        		$result = dbquery( $query );
      				} 
			else 
				{
	        		if( !$disabled["autoaccounts"] ) 
					{
          				$query = "INSERT INTO " . $dbconfig["accounts_table"] . " (username,laston) VALUES ('" . $username . "','" . time() . "')";
          				$result = dbquery( $query );
 
          				$TWIGNewUserGroups = array();

					if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "newusergroups.inc.php3") ) {include($vhosts[$SERVER_NAME] . "newusergroups.inc.php3");}
					else {include($config_dir . "newusergroups.inc.php3");}
 
        	  			for( $i = 0, $j = count( $TWIGNewUserGroups ); $i < $j; $i++ ) 
						{
            					TWIGSYSAddACLGroupMember( $username, $TWIGNewUserGroups[$i] );
          					}
	        			}
      				}

			$sessiontime = time();
			$sessionid = $sessiontime . "-" . $username . "-" . rand();
			$query = "UPDATE " . $dbconfig["accounts_table"] . " SET onnow='" . $sessiontime . "' WHERE username='" . $username . "'";
			$result = dbquery( $query );

      			/* Generate a mask and store the result */
	      		$data = $username . chr(1) . $password;

			if( !$global_secure_key )
				{
        			$key = randomkey( strlen( $data ) );
				}
			else
				{
			        $key = $global_secure_key;
				}

      			/* Store the mask */
      			if( $expire <= 0 ) 
				{
                                SetCookie( "twig_authenticated", $sessionid, 0 , $dir );
        			SetCookie( "twig_cookieauth", convbinarytoascii( $key ), 0 , $dir );
      				} 
			else 
				{   
				SetCookie( "twig_authenticated", $sessionid, time() + $expire, $dir );
				SetCookie( "twig_cookieauth", convbinarytoascii($key), 0, $dir );
	    			}

			$query = "SELECT username FROM " . $dbconfig["scloginhandler_table"] . " WHERE username='" . $username . "'";
			$result = dbquery( $query );

			if( dbnumrows( $result ) > 0 )
				{
				$query = "UPDATE " . $dbconfig["scloginhandler_table"] . " SET LID='" . $sessionid . "', expire='" . ( time() + $expire ) . "', pwdata='" . convbinarytoascii( otpcrypt( $data, $key ) ) . "' WHERE username='" . $username . "'";
				$result = dbquery( $query );
				}
			else
				{
				$query = "INSERT INTO " . $dbconfig["scloginhandler_table"] . " (LID, pwdata, username, expire) VALUES ('" . $sessionid . "','" . convbinarytoascii( otpcrypt( $data, $key ) ) . "','" . sqlstring( $username ) . "'," . ( time() + $expire ) . ")";
				$result = dbquery( $query );
				}
			}
	  	}	
?>
