<p>Keeping with the modular design of TWIG, help files for a given feature
are kept in a "help/" directory under that feature's directory.  In the
help directory there are directories for various supported languages.  All
help files for a given feature in a given language are kept in those
language directories.  Those files are as follows.</p>

<p>Note:  In the following text, "$feature" refers to the name of a
major TWIG feature, such as "mail" or "contacts".  "$language" refers to
the selected language. "$topic" refers to a major help topic and is
therefore synonymous with $feature.  "$subtopic" refers to a more 
specific matter related to a given $topic.</p>

<p><b>twig/features/$feature/help</b>: Contains all help related files for
a given feature in all supported languages.</p>

<p><b>twig/features/$feature/help/$language</b>: Contains all help related
files for a given feature in a given supported language.</p>

<p><b>twig/features/$feature/help/$language/menu.$feature.help.inc.php3</b>:
This file sets up the $submenu[] array used to generate the <?php echo $TWIGphrase["Subtopic"] ?> menu. 
Each element in the array is an array with the keys "command" and "desc".
The value entered for "command" will be a $subtopic while the value
entered for "desc" is the description of that $subtopic.  The value
"command" will be used as part of a filename and therefore must not
contain any inappropriate characters.</p>

<p><b>twig/features/$feature/help/$language/$feature.help.inc.php3</b>:
This file contains general information about $feature as well as links to
more specific help subtopics.</p>

<p><b>twig/features/$feature/help/$language/$feature.$topic.help.inc.php3</b>:
This file includes information about a given subtopic concerning the
current feature.</p>
