#ifndef CALINEEDIT_H
#define CALINEEDIT_H

#include <ClanLib/core.h>
#include "cawidget.h"


/** A simple oneline edit (GUI).
    @author Andrew Mustun
*/
class CALineEdit : public CAWidget {
public:
    CALineEdit( const char* text,
                int letters,
                Alignment alignment,
                CL_Font* font );
    ~CALineEdit();

    char* getText() {
        return text.get_string();
    }

    virtual void display( bool active=true );
    virtual void handleKey( const CL_Key &key );

private:
    //! Number of letters shown at max.

    int letters;
    //! Cursor position.
    int cursor;
    //! Pointer to font.
    CL_Font*  font;
    //! The input text
    CL_String text;
};

#endif
