// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "GradientMachine.h"

namespace Torch {

GradientMachine::GradientMachine()
{
  is_free = false;
  n_params = 0;
  params = NULL;
  der_params = NULL;

  beta = NULL;
}

void GradientMachine::allocateMemory()
{
  n_params = numberOfParams();

  if(n_params > 0)
  {
    addToList(&params, n_params, (real *)xalloc(sizeof(real)*n_params));
    addToList(&der_params, n_params, (real *)xalloc(sizeof(real)*n_params));
  }

  beta = (real *)xalloc(sizeof(real)*n_inputs);
  addToList(&outputs, n_outputs, (real *)xalloc(sizeof(real)*n_outputs));
}

void GradientMachine::freeMemory()
{
  if(is_free)
    return;

  if(n_params > 0)
  {
    freeList(&params, true);
    freeList(&der_params, true);
  }

  free(beta);
  freeList(&outputs, true);
  is_free = true;
}

void GradientMachine::init()
{
  Machine::init();
  allocateMemory();
}

void GradientMachine::iterInitialize()
{
}

void GradientMachine::reset()
{
}

void GradientMachine::loadFILE(FILE *file)
{
  List *liste = params;

  while(liste)
  {
    xfread(liste->ptr, sizeof(real), liste->n, file);
    liste = liste->next;
  }
}

void GradientMachine::saveFILE(FILE *file)
{
  List *liste = params;

  while(liste)
  {
    xfwrite(liste->ptr, sizeof(real), liste->n, file);
    liste = liste->next;
  }
}

GradientMachine::~GradientMachine()
{
  freeMemory();
}

}

