namespace eval traceroute {
    variable traceroute

    # Define the traceroute array structure so that all variables are
    # defined for the callbacks in the radiobuttons and checkbuttons.
    array set traceroute {
        dialog ""
        host ""
	packetlen ""
	source_route_gateway_c ""
	set_max_ttl_c ""
	set_udp_port_c ""
	set_query_c ""
	source_addr_c ""
	set_tos_c ""
	set_wait_c ""
	set_initial_ttl_c ""
	set_ni_c ""
	source_route_gateway ""
	set_max_ttl ""
	set_udp_port ""
	set_query ""
	source_addr ""
	set_tos ""
	set_wait ""
	set_initial_ttl ""
	set_ni ""
        entry.host ""
        entry.packetlen "" 
	entry.source_route_gateway ""
	entry.set_max_ttl ""
	entry.set_udp_port ""
	entry.set_query ""
	entry.source_addr ""
	entry.set_tos ""
	entry.set_wait ""
	entry.set_initial_ttl ""
	entry.set_ni ""
	enable_socket_level ""
	dont_fragment_bit ""
	use_icmp_echo ""
	print_hop_address ""
	bypass_routing_tables ""
	verbose_output ""
	toggle_checksums ""
        list.reset ""
	list.clear ""
    }
}

# traceroute::create --
#
#   Method to create the dialog box for the traceroute command.
#
# Note
#
#   This dialog will not grab focus so the user can keep it open
#   and run other tkWorld dialogs.  Imagine how tedious it would be
#   if you had to close the dialog to run your command, then reopen
#   it to modify it.  By not making this a modal dialog, we do not
#   have to implement any last command saving characteristics since
#   the user can just leave the dialog open.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc traceroute::create { } {
    global tkWorld
    variable traceroute

    # Put the focus on the traceroute dialog if it is already open.
    if [winfo exists $traceroute(dialog)] {
        switch -- [wm state $traceroute(dialog)] {
            normal {
                raise $traceroute(dialog)
            }
            withdrawn -
            iconic {
                wm deiconify $traceroute(dialog)
            }
        }
        focus $traceroute(dialog)
        return
    } else {
        set traceroute(dialog) [dialog::create .traceroute Traceroute]
    }
   
    # The first tab has the host and some options.
    set tab1 [tabnotebook::page [dialog::interior \
            $traceroute(dialog)] "Options"]

    # Use a frame to encapsulate the file selection so that the
    # frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
            -class TabnotebookFrame]
    label $f1.label_host \
            -text "Host" \
            -width 15 \
            -anchor e
    set traceroute(entry.host) [entry $f1.entry_host \
            -width 20 \
            -textvariable traceroute::traceroute(host)]
    label $f1.label_packetlen \
            -text "Packet length" \
            -width 15 \
            -anchor e
    set traceroute(entry.packetlen) [entry $f1.entry_packetlen \
            -width 20 \
	    -textvariable traceroute::traceroute(packetlen)]
    grid $f1.label_host $f1.entry_host \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f1.label_packetlen $f1.entry_packetlen \
            -padx 2 \
            -pady 2 \
            -sticky w
    # Now build the individual checkbutton options 
    # available to the user.
    set f2 [frame $tab1.f2 \
            -class TabnotebookFrame]
    checkbutton $f2.enable_socket_level \
            -text "Enable socket level debugging" \
	    -variable traceroute::traceroute(enable_socket_level) \
	    -onvalue "d" \
	    -offvalue ""
    checkbutton $f2.dont_fragment_bit \
            -text "Set the \"don't fragment\" bit" \
	    -variable traceroute::traceroute(dont_fragment_bit) \
	    -onvalue "F" \
	    -offvalue ""
    checkbutton $f2.use_icmp_echo \
            -text "Use ICMP ECHO" \
	    -variable traceroute::traceroute(use_icmp_echo) \
	    -onvalue "I" \
	    -offvalue ""
    checkbutton $f2.print_hop_address \
            -text "Print hop address numerically" \
	    -variable traceroute::traceroute(print_hop_address) \
	    -onvalue "n" \
	    -offvalue ""
    checkbutton $f2.bypass_routing_tables \
            -text "Bypass the normal routing tables" \
	    -variable traceroute::traceroute(bypass_routing_tables) \
	    -onvalue "r" \
	    -offvalue ""
    checkbutton $f2.verbose_output \
            -text "Verbose output" \
	    -variable traceroute::traceroute(verbose_output) \
	    -onvalue "v" \
	    -offvalue ""
    checkbutton $f2.toggle_checksums \
            -text "Toggle checksums" \
	    -variable traceroute::traceroute(toggle_checksums) \
	    -onvalue "x" \
	    -offvalue ""
    grid $f2.enable_socket_level \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.dont_fragment_bit \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.use_icmp_echo \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.print_hop_address \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.bypass_routing_tables \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.verbose_output \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.toggle_checksums \
            -padx 2 \
            -pady 2 \
            -sticky w

    # The command frame.
    set tab3 [tabnotebook::page [dialog::interior \
            $traceroute(dialog)] "Command"] 
    set f3 [frame $tab3.f3 \
                -class TabnotebookFrame]
    checkbutton $f3.source_route_gateway_c \
            -text "Source route gateway" \
            -variable traceroute::traceroute(source_route_gateway_c) \
            -onvalue "g" \
            -offvalue ""
    set traceroute(entry.source_route_gateway) [entry \
            $f3.entry_source_route_gateway \
            -width 30 \
	    -textvariable traceroute::traceroute(source_route_gateway)]
    checkbutton $f3.set_max_ttl_c \
            -text "Set the max time-to-live" \
            -variable traceroute::traceroute(set_max_ttl_c) \
            -onvalue "m" \
            -offvalue ""
    set traceroute(entry.set_max_ttl) [entry $f3.entry_set_max_ttl \
            -width 30 \
	    -textvariable traceroute::traceroute(set_max_ttl)]
    checkbutton $f3.set_udp_port_c \
            -text "Set the base UDP port number" \
            -variable traceroute::traceroute(set_udp_port_c) \
            -onvalue "p" \
            -offvalue ""
    set traceroute(entry.set_udp_port) [entry $f3.entry_set_udp_port \
            -width 30 \
	    -textvariable traceroute::traceroute(set_udp_port)]
    checkbutton $f3.set_query_c \
            -text "Set the number of queries" \
            -variable traceroute::traceroute(set_query_c) \
            -onvalue "q" \
            -offvalue ""
    set traceroute(entry.set_query) [entry $f3.entry_set_query \
            -width 30 \
	    -textvariable traceroute::traceroute(set_query)]
    checkbutton $f3.source_addr_c \
            -text "Use the IP address as the source address" \
            -variable traceroute::traceroute(source_addr_c) \
            -onvalue "s" \
            -offvalue ""
    set traceroute(entry.source_addr) [entry $f3.entry_source_addr \
            -width 30 \
	    -textvariable traceroute::traceroute(source_addr)]
    checkbutton $f3.set_tos_c \
            -text "Set the type-of-services" \
            -variable traceroute::traceroute(set_tos_c) \
            -onvalue "t" \
            -offvalue ""
    set traceroute(entry.set_tos) [entry $f3.entry_set_tos \
            -width 30 \
	    -textvariable traceroute::traceroute(set_tos)]
    checkbutton $f3.set_wait_c \
            -text "Set the time to wait for a response" \
            -variable traceroute::traceroute(set_wait_c) \
            -onvalue "w" \
            -offvalue ""
    set traceroute(entry.set_wait) [entry $f3.entry_set_wait \
            -width 30 \
	    -textvariable traceroute::traceroute(set_wait)]
    checkbutton $f3.set_initial_ttl_c \
            -text "Set the initial time-to-live" \
            -variable traceroute::traceroute(set_initial_ttl_c) \
            -onvalue "f" \
            -offvalue ""
    set traceroute(entry.set_initial_ttl) [entry $f3.entry_set_initial_ttl \
            -width 30 \
	    -textvariable traceroute::traceroute(set_initial_ttl)]
    checkbutton $f3.set_ni_c \
            -text "Specify a network interface" \
            -variable traceroute::traceroute(set_ni_c) \
            -onvalue "i" \
            -offvalue ""
    set traceroute(entry.set_ni) [entry $f3.entry_set_ni \
            -width 30 \
	    -textvariable traceroute::traceroute(set_ni)]
    grid $f3.source_route_gateway_c $f3.entry_source_route_gateway \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.set_max_ttl_c $f3.entry_set_max_ttl \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.set_udp_port_c $f3.entry_set_udp_port \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.set_query_c $f3.entry_set_query \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.source_addr_c $f3.entry_source_addr \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.set_tos_c $f3.entry_set_tos \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.set_wait_c $f3.entry_set_wait \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.set_initial_ttl_c $f3.entry_set_initial_ttl \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f3.set_ni_c $f3.entry_set_ni \
            -padx 2 \
            -pady 2 \
            -sticky w
    # Create all of the tabs at once.
    pack $f1 $f2 $f3 \
            -side top \
            -fill x \
            -padx 5 \
            -pady 5 \
            -ipadx 5 \
            -ipady 5

    focus $traceroute(entry.host)
    
    # Define the lists for the reset and clear methods
    set traceroute(list.reset) "source_route_gateway_c enable_socket_level  \
               set_max_ttl_c set_udp_port_c set_query_c source_addr_c \
	       set_tos_c set_wait_c set_initial_ttl_c set_ni_c \
	       dont_fragment_bit use_icmp_echo \
	       print_hop_address bypass_routing_tables verbose_output \
	       toggle_checksums"
    set traceroute(list.clear) "host packetlen source_route_gateway \
	      set_max_ttl set_udp_port set_query source_addr set_tos set_wait \
	      set_initial_ttl set_ni"
}

# traceroute::ok --
#
#   Method to insert the command the user has created into the CC.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc traceroute::ok { } {
    global tkWorld
    variable traceroute       

    # Insert the Tcl command list in the Command Center.

    $tkWorld(cmd_center) insert insert "traceroute "

    # Build the command line argument.
    set cmd_arg ""
    set cmd_arg1 ""
    foreach x "enable_socket_level dont_fragment_bit use_icmp_echo \
        print_hop_address bypass_routing_tables verbose_output \
        toggle_checksums" {
        if [string length $traceroute($x)] {
	    append cmd_arg $traceroute($x)
	}
    }
    if [string length $cmd_arg] {
       $tkWorld(cmd_center) insert insert "-$cmd_arg "
    }
    foreach y "source_route_gateway_c set_max_ttl_c set_udp_port_c \
        set_query_c source_addr_c set_tos_c set_wait_c set_initial_ttl_c \
	set_ni_c" { 
	if [string length $traceroute($y)] {
	    switch $traceroute($y) {
	        g {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(source_route_gateway) "
		    }
		}
	        m {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(set_max_ttl) "
		    }
		}
	        p {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(set_udp_port) "
		    }
		}
	        q {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(set_query) "
		    }
		}
	        s {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(source_addr) "
		    }
		}
	        t {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(set_tos) "
		    }
		}
	        w {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(set_wait) "
		    }
		}
	        f {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(set_initial_ttl) "
		    }
		}
	        i {
	            set cmd_arg1 $traceroute($y)
	            if [string length $cmd_arg1] {
		        $tkWorld(cmd_center) insert insert \
			    "-$cmd_arg1 $traceroute(set_ni) "
		    }
		}
            }
	}
    }

    if [string length $traceroute(host)] {
        $tkWorld(cmd_center) insert insert \
	    "$traceroute(host) $traceroute(packetlen)"
    }

    # Activate the buttons in the toolbar for the command center.
    toolbar::group_state cmd_center active
    toolbar::button_state $toolbar::toolbar(stop) disabled
}          

# traceroute::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc traceroute::reset { } {
    variable traceroute

    # Reset all of the list elements.
    foreach x $traceroute(list.reset) {
        set traceroute($x) ""
    }

}

# traceroute::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc traceroute::clear { } {
    variable traceroute

    # Reset the data structure elements and bg/fg.
    foreach x $traceroute(list.clear) {
        set traceroute($x) ""
        $traceroute(entry.$x) configure -bg #ffffff -fg #000000
    }

   focus $traceroute(entry.host)
}

# traceroute::help --
#
#   Method to invoke the traceroute Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc traceroute::help { } {
    global tkWorld

        help::create "help/traceroute.html" "Traceroute Command Help"
}        

# traceroute::close --
#
#   Close the dialog up.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc traceroute::close { } {
    variable traceroute 

    balloonhelp::cancel
    destroy $traceroute(dialog)
}

# traceroute::open --
#
#   Method to add a file to the file entry and move the cursor
#   index of the entry to the end.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc traceroute::open { } {
    variable traceroute

     regsub { } [file::select] {} traceroute(host)
    $traceroute(host_entry) icursor end
}            

