/*
 * a simple program to copy a string
 * showing correct syntax, delay slots, and use of annul bit.
 * pseudo-operations:	.set, .global, .asciz, .skip
 * synthetic instructions: set, ret, retl, mov, inc, deccc, nop
 * symbolic substitution: WINDOWSIZE
 *
 *
 * This example must be compiled on a SPARCstation, ugh!
 *
 *	as -P -o sample.o sample.s
 *	ld -e main sample.o -o sample
 */

	.seg	"text"
	.global main
main:
	save	%sp, -64, %sp
	set	str, %o0		! source string
	nop
	set	stout, %o1
  	call	bcopy
	mov	24, %o2			! delay slot, length to copy


exit:
	ta	0
!	ret
	restore

	.global	bcopy
continue:
	inc	%o0			! inc from address
	stb	%o4, [%o1]		! write to address
	inc	%o1			! in the delay slot: inc to add
bcopy:
	subcc	%o2, 1, %o2		! dec count, set condition codes
	bge,a	continue		! loop until done
	ldub	[%o0], %o4		! delay slot: read from address
	retl				! leaf routine return
	nop

	.seg	"data"
str:
	.asciz	"this is a sample string"

stout:
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
