/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993 -- 1998
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED
 = "$Id: isemGX.cpp 1.3 Sat, 13 Sep 1997 12:04:11 -0600 maccabe $";

// -- isemGX.c ---------------------------------------------------------------
//
// This module adds a GX widget
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tk.h>

#include "config.h"

#include "sizedefs.h"

#define CMND_LEN 256

enum { WIDTH = 512, HEIGHT = 512 };	// window size

enum { STATUS = 0, CMD };		// buffer indexes

enum {
    OPEN	= 0,
    CLOSE	= 1,
    COLOR	= 2,
    OP		= 3,
    LINE	= 4,
    FILL	= 5,
    BLIT	= 6
};	// command numbers

enum {
    PIXEL	= 2,		// color
    FUNCTION	= 2,		// op
    LINE_X1	= 2,		// line
    LINE_Y1	= 3,
    LINE_X2	= 4,
    LINE_Y2	= 5,
    FILL_X	= 2,		// fill
    FILL_Y	= 3,
    FILL_W	= 4,
    FILL_H	= 5,
    BLIT_X1	= 2,		// blit
    BLIT_Y1	= 3,
    BLIT_W	= 4,
    BLIT_H	= 5,
    BLIT_X2	= 6,
    BLIT_Y2	= 7
};

struct GX_INFO {
    Display*       display;
    Pixmap         pixmap;
    GC             gc;
    unsigned long  black;
    unsigned long  white;
    int            update_pend;
    int            status;
    Tk_Window      tkwin;
    UInt32         cmnd[CMND_LEN];
};

static void do_update( ClientData cd )
{
    GX_INFO *gx = (GX_INFO *)cd;

    gx->update_pend = 0;	// we're going to perform the update
    GC gc = Tk_GetGC( gx->tkwin, 0, NULL );

    XCopyArea( gx->display, gx->pixmap, Tk_WindowId(gx->tkwin), gc, 0, 0,
	       WIDTH, HEIGHT, 0, 0);
}

static void sch_update( GX_INFO *gx )
{
    if( !gx->update_pend ) {
	gx->update_pend = 1;
	Tk_DoWhenIdle( do_update, gx );
    }
}

static void GX_event( ClientData cd, XEvent *eventPtr ) {
    GX_INFO *gx = (GX_INFO*)cd;

    if( eventPtr->type == Expose ) {
	sch_update( gx );
    }
}

static int GX_cmd( ClientData cd, Tcl_Interp *interp, int argc, char *argv[] )
{
    //
    // pathname (read|write) [value cmnd_loc]
    //
    GX_INFO *gx = (GX_INFO*)cd;

    if( !((argc==2 && strcmp(argv[1],"read")==0) 
	  || (argc==4 && strcmp(argv[1],"write")==0)) ) {
	sprintf( interp->result, "%s:  invalid number of arguments: %d",
		 Tk_PathName(gx->tkwin), argc );
	return TCL_ERROR;
    }

    if( argc==4 ) {
	UInt32 value = strtol( argv[2], NULL, 0 );
	UInt32 index = strtol( argv[3], NULL, 0 );

	index >>= 2;
	index &= 255;
	gx->cmnd[index] = value;

	if( index == CMD ) {
	    switch( value ) {
	    case OPEN:
		XSetForeground( gx->display, gx->gc, gx->white );
		XSetFunction( gx->display, gx->gc, GXcopy );
		XFillRectangle( gx->display, gx->pixmap, gx->gc, 0, 0, WIDTH,
				HEIGHT+64 );
		XSetForeground( gx->display, gx->gc, gx->black );
		sch_update( gx );
    
		gx->status = 1;
		break;
		
	    case CLOSE:
		gx->status = 0;
		break;
		
	    case COLOR:
		if( gx->cmnd[PIXEL] == 0) {
		    XSetForeground( gx->display, gx->gc, gx->black );
		} else {
		    XSetForeground( gx->display, gx->gc, gx->white );
		}
		break;
		
	    case OP:
		if ( gx->cmnd[FUNCTION] <= 0xf ) {
		    XSetFunction( gx->display, gx->gc, gx->cmnd[FUNCTION] );
		}
		break;
		
	    case LINE:
		XDrawLine( gx->display, gx->pixmap, gx->gc, gx->cmnd[LINE_X1],
			   gx->cmnd[LINE_Y1], gx->cmnd[LINE_X2],
			   gx->cmnd[LINE_Y2] );
		sch_update( gx );
		break;
		
	    case FILL:
		XFillRectangle( gx->display, gx->pixmap, gx->gc, 
				gx->cmnd[FILL_X], gx->cmnd[FILL_Y], 
				gx->cmnd[FILL_W], gx->cmnd[FILL_H] );
		sch_update( gx );
		break;
		
	    case BLIT:
		XCopyArea( gx->display, gx->pixmap, gx->pixmap, gx->gc,
			   gx->cmnd[BLIT_X1], gx->cmnd[BLIT_Y1],
			   gx->cmnd[BLIT_W], gx->cmnd[BLIT_H],
			   gx->cmnd[BLIT_X2], gx->cmnd[BLIT_Y2] );
		sch_update( gx );
		break;
	    }
	}
    }

    sprintf( interp->result, "0x%.8x", gx->status );
    return TCL_OK;
}

int Isem_GX( ClientData, Tcl_Interp *interp, int argc, char *argv[] ) {
    //
    // isem_gx path
    //
    // create a gx window for drawing -- it's not open yet
    //
    if( argc != 2 ) {
	sprintf( interp->result, "isem_gx:  invalid number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    GX_INFO *gx = new GX_INFO;

    gx->update_pend = 0;
    gx->status = 0;

    Tk_Window main_win = Tk_MainWindow( interp );
    gx->display = Tk_Display( main_win );

    // create the window, set its class, establish the event handler, 
    // and establish the command procedure
    gx->tkwin = Tk_CreateWindowFromPath( interp, main_win, argv[1], NULL );
    if( gx->tkwin == NULL ) {
	return TCL_ERROR;
    }
    Tk_SetClass( gx->tkwin, "GX" );
    Tk_CreateEventHandler( gx->tkwin, ExposureMask | StructureNotifyMask, 
			   GX_event, (ClientData)gx );
    Tcl_CreateCommand( interp, Tk_PathName(gx->tkwin), GX_cmd, 
		      (ClientData)gx, NULL );

    // gx->gc = DefaultGC( gx->display, Tk_ScreenNumber(main_win) );
    // gx->gc = Tk_GetGC( gx->tkwin, 0, NULL );
    gx->black = BlackPixel( gx->display, Tk_ScreenNumber(main_win) );
    gx->white = WhitePixel( gx->display, Tk_ScreenNumber(main_win) );

    // create a pixmap for the actual drawing operations
    Tk_MakeWindowExist( gx->tkwin );
    gx->pixmap = Tk_GetPixmap( gx->display, Tk_WindowId(gx->tkwin),
			       WIDTH, HEIGHT+64, Tk_Depth(gx->tkwin) );
    gx->gc = XCreateGC( gx->display, gx->pixmap, 0, NULL );

    // clear the window
    XSetForeground( gx->display, gx->gc, gx->white );
    XFillRectangle( gx->display, gx->pixmap, gx->gc, 0, 0, WIDTH, HEIGHT+64 );
    XSetForeground( gx->display, gx->gc, gx->black );
    sch_update( gx );
    
    // establish the size of the display area
    Tk_GeometryRequest( gx->tkwin, WIDTH, HEIGHT );
    Tk_SetInternalBorder( gx->tkwin, 0 );

    interp->result = Tk_PathName( gx->tkwin );
    return TCL_OK;
}
