/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: multiply.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//--------------------------------------------------------------------------
// Multiply Instructions - see p175 of SPARC Architecture Manual, Version 8
//--------------------------------------------------------------------------

#include "Assert.h"
#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"


inline UInt32 LSH(UInt32 n) {
    return n & 0xffff;
}

inline UInt32 MSH(UInt32 n) {
    return n >> 16;
}

// multiply_unsigned - 32bit * 32bit 
//
static void
multiply_unsigned(UInt32& Y, UInt32& result, UInt32 op1, UInt32 op2) {
    UInt32 temp;

    UInt32 a = MSH(op1);
    UInt32 b = LSH(op1);

    UInt32 c = MSH(op2);
    UInt32 d = LSH(op2);

    UInt32 bd = b * d;
    UInt32 ad = a * d;
    UInt32 bc = b * c;
    UInt32 ac = a * c;

    temp   = MSH(bd) + LSH(ad) + LSH(bc);
    result = LSH(bd) | (LSH(temp) << 16);
    Y      = MSH(temp) + MSH(ad) + MSH(bc) + ac;
}


static void
multiply_signed(UInt32& Y, UInt32& result, UInt32 op1, UInt32 op2) {
    Int32 sop1 = (Int32)op1;
    Int32 sop2 = (Int32)op2;

    int sign = 1;

    if (sop1 < 0) {
	sop1 = -sop1;
	sign *= -1;
    }

    if (sop2 < 0) {
	sop2 = -sop2;
	sign *= -1;
    }

    UInt32 temp;
    multiply_unsigned(Y, temp, sop1, sop2);

    if (sign < 0) {
	result = ~temp + 1;

	Y = ~Y;
	if ((result & (1 << 31)) == (temp & (1 << 31)))
	    Y++;
    }
    else {
	result = temp;
    }
}

void IntegerUnit::multiply(const Instruction& inst){
    UInt32 operand2 = (inst.i() == 0) ? reg[inst.rs2()] : inst.simm13();
    
    UInt32 result;   

    switch ( inst.op3() ) {
    case Instruction::UMUL:
    case Instruction::UMULcc:
        multiply_unsigned(IU_Y, result, reg[inst.rs1()], operand2); 
	break;

    case Instruction::SMUL:
    case Instruction::SMULcc:
        multiply_signed(IU_Y, result, reg[inst.rs1()], operand2); 
	break;

    default:
	Assert(0, "Unknown op3: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }
    // next

    reg[inst.rd()] = result;

    if ((inst.op3() == Instruction::UMULcc) ||
	(inst.op3() == Instruction::SMULcc))
    {
        IU_N = (result >> 31);         
        IU_Z = (result == 0) ? 1 : 0;
        IU_V = 0;
        IU_C = 0;
    }
}
