/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: RegBlock.h 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
//

//
// RegBlock.h  - Class declaration for RegisterBlock
//          by Jeff VanDyke
//          modified by Gerard Rollins
//  7/22/92

// modified 11/11/94 by  A.B. Maccabe
//    fixed register windows so they wrap around correctly
//

#ifndef _RegBlock_h
#define _RegBlock_h

#include "Assert.h"

class RegisterBlock {
public:
    // public Constructor / Destructor
    //
    inline RegisterBlock(int n_of_register_windows);
    inline ~RegisterBlock();

    // public Member functions
    //
    inline void    CWP(int i);
    inline int     CWP();

    // public Member operators
    //
    inline UInt32& operator [] ( int );
	
private:
    int     _cwp;
    int     NWINDOWS;
    UInt32  globals[8];		// global registers
    UInt32  wins[32*16];	// register windows
};

//
// inline definitions
//

//
// public Constructor / Destructor
//
inline RegisterBlock::RegisterBlock( int nwins )
    : _cwp(nwins-2), NWINDOWS(nwins)
{
}

inline RegisterBlock::~RegisterBlock() {
}


//
// public Member functions
//
inline void RegisterBlock::CWP(int i) {
    Assert(_cwp >= 0, "current window pointer out of range");
    Assert(_cwp <  NWINDOWS, "current window pointer out of range");

    _cwp = i;
}


inline int RegisterBlock::CWP() {
    return _cwp;
}


//
// public Member operators
//
inline UInt32& RegisterBlock::operator [] (int i) {
    Assert( i >= 0, "register index out of range");
    Assert( i < 32, "register index out of range");

    //

    // check for a global register
    if ( i < 8 ) {
	// it's hard to determine if we're in a left or right side context,
	//  so, we'll ignore the problem and let the user change the value
	//  of globals[0] -- but, we'll always set it to 0, so if they
	//  read it, they'll get 0
	globals[0] = 0;
	return globals[i];
    } else {
	// ok, it's in one of the register windows ... we need to make
	// sure that we wrap around at the right spot......

	int reg_set_base = _cwp * 16;

	i -= 8;	                // normalize i (account for missing globals)

	int index =  (reg_set_base+i) % (NWINDOWS*16);

	return wins[ index ];
    }
}

#endif /* _RegBlock_h */
