## This is the plugin to handle the mounting of Broadcast
## network volumes. It requires the afpfs package which
## implements an Broadcast mounter
##
## Ethan Gold <etgold@cs.vassar.edu> 2/24/98
##

if {[debug]} { puts "loading Broadcast plugin..." }

## register the plugin with the main chooser
register_plugin appletalk broadcast Broadcast

#### required procedures that simply return plugin information
proc broadcast.geticon {} { return "broadcast.ppm" }
proc broadcast.getpubname {} { return "Broadcast" }
proc broadcast.getprotocol {} { return "appletalk" }

#### real plugin functionality below here##

########## required functions #################

## start function - required
proc broadcast.start {} {
    global plug_globalflat
    if {[debug]} { puts "started Broadcast Plugin" }

    set entlabel [plug_list_label]
    $entlabel configure -text "Suckers:"
    update
    broadcast.widgets stop
    broadcast.widgets start
    broadcast.newzone
}

## stop funtion - required
proc broadcast.stop {} {
    if {[debug]} { puts "stopped Broadcast Plugin" }
    broadcast.clearentities
    broadcast.widgets stop
}

## function to call when a listitem is double-clicked
proc broadcast.doubleclick {} {
    if {[debug]} { puts "Broadcast: got double-click with [get_curr_item]" }
    broadcast.sendto
}

proc broadcast.newzone {} {
    set plugframe [plug_frame]
    $plugframe.status configure -text "scanning [appletalk.getcurrzone]..."
    update
    broadcast.clearentities
    broadcast.showentities [broadcast.getnames]
    $plugframe.status configure -text "ready."
}

############# End required functions ##################

proc broadcast.sendo {} {
    set sucker [get_curr_item]
    if {[string compare $sucker ""] == 0} {
	return
    }
    puts "Broadcast: pretending to bother $sucker"
}

## procedure to build and destroy Broadcast widgets
proc broadcast.widgets {command} {
    set plugframe [plug_frame]

    if {[string compare $command "start"] == 0} {
	button $plugframe.mount -text "Send..." -command broadcast.sendto
	pack $plugframe.mount
    } else {
	destroy $plugframe.mount
    }
    
}

## function to return the laserwriters in the current zone
proc broadcast.getnames {} {
    return [appletalk.namesfromlkup [broadcast.getentities]]
}

proc broadcast.getentities {} {
    set currzone [appletalk.getcurrzone]
    set entity "=:Broadcast@$currzone"
    set results [appletalk.nbplkup $entity]
    set results [appletalk.namesfromlkup $results]
    return $results
}

## function to display passed in entities in
## the plugin's entity list frame
proc broadcast.showentities {entitylist} {
    set lbox [plug_list]
    foreach entity $entitylist {
	$lbox insert end $entity
    }
}

proc broadcast.clearentities {} {
    set lbox [plug_list]
    $lbox delete 0 end
}

if {[debug]} { puts "finished loading Broadcast." }

