# $Id: splash.tcl,v 1.23 2006/05/26 22:01:38 aleksey Exp $

proc splash_start {{aboutP 0}} {
    global splash_count splash_image splash_info splash_max splash_text
    global version

    set splash_info   ""
    set splash_count   0
    set splash_max   219

    array set splash_text [list					   \
        autoaway            [::msgcat::mc "auto-away"]             \
        avatars             [::msgcat::mc "avatars"]               \
        balloon             [::msgcat::mc "balloon help"]          \
        browser             [::msgcat::mc "browsing"]              \
        bwidget_workarounds [::msgcat::mc "bwidget workarounds"]   \
        chats               [::msgcat::mc "jabber chat"]           \
        config              [::msgcat::mc "configuration"]         \
        datagathering       [::msgcat::mc "utilities"]             \
        disco               [::msgcat::mc "service discovery"]     \
        dkflib              [::msgcat::mc "utilities"]             \
        dockingtray         [::msgcat::mc "kde"]                   \
        emoticons           [::msgcat::mc "emoticons"]             \
        filetransfer        [::msgcat::mc "file transfer"]         \
        filters             [::msgcat::mc "message filters"]       \
        gpgme               [::msgcat::mc "cryptographics"]        \
        hooks               [::msgcat::mc "extension management"]  \
        iface               [::msgcat::mc "user interface"]        \
        iq                  [::msgcat::mc "jabber iq"]             \
        itemedit            [::msgcat::mc "utilities"]             \
        jabberlib           [::msgcat::mc "jabber xml"]            \
        jidlink             [::msgcat::mc "jidlink"]               \
        joingrdialog        [::msgcat::mc "jabber groupchats"]     \
        login               [::msgcat::mc "connections"]           \
        messages            [::msgcat::mc "message/headline"]      \
        muc                 [::msgcat::mc "multi-user chat"]       \
        negotiate           [::msgcat::mc "negotiation"]           \
        plugins             [::msgcat::mc "plugin management"]     \
        presence            [::msgcat::mc "jabber presence"]       \
        privacy             [::msgcat::mc "privacy rules"]         \
        register            [::msgcat::mc "jabber registration"]   \
        roster              [::msgcat::mc "rosters"]               \
        search              [::msgcat::mc "searching"]             \
        sound               [::msgcat::mc "sound"]                 \
        textundo            [::msgcat::mc "text undo"]             \
        userinfo            [::msgcat::mc "presence"]              \
        utils               [::msgcat::mc "utilities"]             \
        wmdock              [::msgcat::mc "wmaker"]                \
    ]

    wm withdraw .

    set w [toplevel .splash -relief $::tk_relief -borderwidth $::tk_borderwidth]

    wm withdraw $w
    wm overrideredirect $w 1

    catch {
	if {[lsearch -exact [wm attributes $w] -topmost] >= 0} {
	    wm attributes $w -topmost 1
	}
    }
    catch {
	if {[lsearch -exact [wm attributes $w] -alpha] >= 0} {
	    wm attributes $w -alpha 0.7
	}
    }

    if {$aboutP} {
	set h 180
    } else {
	set h 240
    }
    if {![info exists splash_image_$h]} {
	set splash_image_$h [image create photo -height $h -width 380]
    }
#    label $w.back                           \
#	  -image      [set splash_image_$h]

    frame $w.frame

    image create photo tkabber/logo \
	  -file [fullpath pixmaps default tkabber tkabber-logo.gif]

    label $w.frame.image -image tkabber/logo

    label $w.frame.msg   \
	  -anchor  nw    \
	  -justify left  \
	  -text          \
"Tkabber $version

Copyright \u00a9 2002-2006 [::msgcat::mc {Alexey Shchepin}]

[::msgcat::mc Authors:]
    [::msgcat::mc {Alexey Shchepin}]
    [::msgcat::mc {Marshall T. Rose}]
    [::msgcat::mc {Sergei Golovan}]
    [::msgcat::mc {Michail Litvak}]

http://tkabber.jabberstudio.org/"

    grid $w.frame.image -row 0 -column 0 -sticky w
    grid $w.frame.msg   -row 0 -column 1 -sticky e -padx 10m -pady 5m

    if {$aboutP} {
	bind $w <ButtonPress> ""
	bind $w <ButtonRelease> "destroy $w"
    } else {
	ProgressBar $w.frame.bar     \
	    -variable   splash_count \
	    -width      100          \
	    -height     10           \
	    -maximum    $splash_max
	label $w.frame.info           \
	    -textvariable splash_info

#	label $w.frame.hack \
#	    -text       ""

#	grid $w.frame.hack -row 1 -column 0 -sticky s -columnspan 2 -padx 5m
        grid $w.frame.bar  -row 2 -column 0 -sticky s -columnspan 2
	grid $w.frame.info -row 3 -column 0 -sticky s -columnspan 2
    }

#    place $w.frame -relx 0.00 -rely 0.00 -anchor nw
    pack $w.frame -anchor nw

#    pack  $w.back

    if {(~$aboutP) && (![string compare [info commands splash_source] ""])} {
        rename source splash_source
        rename splash_progress source
    }

    BWidget::place $w 0 0 center
    wm deiconify $w
}

proc splash_progress {args} {
    global splash_count splash_info splash_text

    if {([winfo exists .splash]) && ([llength $args] == 1)} {
        set file [file rootname [file tail [lindex $args 0]]]
        catch { set splash_info $splash_text($file) }
        incr splash_count
        update
    }

    uplevel 1 splash_source $args
}

proc splash_done {} {
    global debug_winP

    if {![winfo exists .splash]} {
        return
    }
    destroy .splash

    rename source splash_progress
    rename splash_source source
}

hook::add finload_hook splash_done

splash_start

