# $Id: datagathering.tcl,v 1.32 2004/03/02 21:09:37 aleksey Exp $

namespace eval data {
    set winid 0

    # Registration & search fields (see JEP-0077 & JEP-0055)

    array set field_labels [list \
	username     [::msgcat::mc "Username:"] \
	nick         [::msgcat::mc "Nickname:"] \
	password     [::msgcat::mc "Password:"] \
	name         [::msgcat::mc "Full Name:"] \
	first        [::msgcat::mc "First Name:"] \
	last         [::msgcat::mc "Last Name:"] \
	email        [::msgcat::mc "Email:"] \
	address      [::msgcat::mc "Address:"] \
	city         [::msgcat::mc "City:"] \
	state        [::msgcat::mc "State:"] \
	zip          [::msgcat::mc "Zip:"] \
	phone        [::msgcat::mc "Phone:"] \
	url          [::msgcat::mc "URL:"] \
	date         [::msgcat::mc "Date:"] \
	misc         [::msgcat::mc "Misc:"] \
	text         [::msgcat::mc "Text:"] \
	key          [::msgcat::mc "Key:"]]
}

proc data::fill_fields {g items} {
    variable data
    variable field_labels
    global font

    set row 0
    set data(varlist,$g) {}
    
    grid columnconfig $g 1 -weight 1 -minsize 0

    foreach item $items {
	jlib::wrapper:splitxml $item tag vars isempty chdata children
	set xmlns [jlib::wrapper:getattr $vars xmlns]
	if {$xmlns == "jabber:x:data" || $xmlns == "jabber:iq:data"} {
	    fill_fields_x $g $children
	    return
	}
    }

    set fields {}
    foreach item $items {
	jlib::wrapper:splitxml $item tag vars isempty chdata children

	switch -- $tag {
	    instructions {
		message $g.instructions$row -text $chdata -width 10c
		grid $g.instructions$row -row $row -column 0 -columnspan 2 \
		    -sticky w -pady 2m
		incr row
	    }
	    registered -
	    x {}
	    default {
                lappend fields $tag $chdata
	    }
	}
    }
    foreach {tag chdata} $fields {
	lappend data(varlist,$g) $tag

	if {[info exists field_labels($tag)]} {
	    label $g.l$row -text $field_labels($tag)
	} else {
	    label $g.l$row -text $tag
	}
	switch -- $tag {
	    key {
		entry $g.$row \
		    -textvariable [namespace current]::data(var,$g,$tag) \
		    -state disabled -font $font
	    }
	    password {
		entry $g.$row \
		    -textvariable [namespace current]::data(var,$g,$tag) \
		    -show * -font $font
	    }
	    default {
		entry $g.$row \
		    -textvariable [namespace current]::data(var,$g,$tag) \
		    -font $font
	    }
	}

	if {$chdata != {}} {
	    set data(var,$g,$tag) $chdata
	}

	grid $g.l$row -row $row -column 0 -sticky e
	grid $g.$row  -row $row -column 1 -sticky we

	incr row
    }
}


proc data::get_tags {g} {
    variable data

    if {[info exists data(x,$g)]} {
	return [get_tags_x $g]
    }

    set restags {}

    foreach var $data(varlist,$g) {
	lappend restags [jlib::wrapper:createtag $var \
			     -chdata $data(var,$g,$var)]
    }

    return $restags
}

proc data::get_reported_fields {g} {
    variable data

    return $data(varlist,$g)
}

###############################################################################
# x:data processing
###############################################################################

proc data::add_label {g row label {required 0}} {
    if {$label != ""} {
	if {$required} {
	    set prefix *
	} else {
	    set prefix ""
	}
	if {![string is punct [cindex $label end]]} {
	    set suffix :
	} else {
	    set suffix ""
	}
	label $g.label$row -text ${prefix}${label}$suffix
	grid $g.label$row -row $row -column 0 -sticky en
    }
}

proc data::fill_fields_x {g items} {
    variable data
    global font

    set data(x,$g) 1
    set row 0
    set data(allvarlist,$g) {}

    foreach item $items {
	jlib::wrapper:splitxml $item tag vars isempty chdata children

	switch -- $tag {
	    instructions {
		#add_label $g $row [::msgcat::mc "Instructions"]
		message $g.instructions$row -text $chdata -width 15c
		grid $g.instructions$row -row $row -column 0 \
		    -columnspan 2 -sticky w -pady 2m
		incr row
	    }
	    field {
		fill_field_x $g $row $tag $vars $chdata $children
		incr row
	    }
	    title {
		set top [winfo toplevel $g]
		if {$top != "."} {
		    wm title $top $chdata
		    wm iconname $top $chdata
		}
	    }
	    default {
		debugmsg filetransfer "XDATA: unknown tag $tag"
	    }
	}
    }

    # FIX THIS
    set data(varlist,$g) $data(allvarlist,$g)
}


proc data::fill_field_x {g row tag vars chdata childrens} {
    variable data
    global font

    set required 0
    set desc {}
    set options {}
    set vals {}
    set var   [jlib::wrapper:getattr $vars var]
    set type  [jlib::wrapper:getattr $vars type]
    set label [jlib::wrapper:getattr $vars label]
    set data(var,$g,$var) ""

    foreach item $childrens {
	jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	switch $tag1 {
	    required {set required 1}
	    value {
		set data(var,$g,$var) $chdata1
		lappend vals $chdata1
	    }
	    desc {set desc $chdata1}
	    option {
		set lab [jlib::wrapper:getattr $vars1 label]
		foreach item $children1 {
		    jlib::wrapper:splitxml $item \
			tag2 vars2 isempty2 chdata2 children2
		    switch $tag2 {
			value {set val $chdata2}
		    }
		}
		lappend options $lab $val
	    }
	}
    }

    switch $type {
	jid-single -
	text-single -
	text-private {
	    add_label $g $row $label $required
	    entry $g.entry$row \
		-textvariable [namespace current]::data(var,$g,$var) \
		-font $font
	    if {$type == "text-private"} {
		$g.entry$row configure -show *
	    }
	    grid $g.entry$row  -row $row -column 1 -sticky we
	}
	jid-multi -
	text-multi {
	    add_label $g $row $label $required
	    set sw [ScrolledWindow $g.textsw$row -scrollbar vertical]
	    text $g.text$row -font $font -height 6 -width 50
	    $sw setwidget $g.text$row
	    bind $g.text$row <Control-Key-Return> { }
	    bind $g.text$row <Return> "[bind Text <Return>]\nbreak"
	    set data(var,$g,$var) [join $vals \n]
	    catch { $g.text$row insert end $data(var,$g,$var) }
	    grid $sw -row $row -column 1 -sticky we
	    set data(text,$g,$var) $g.text$row
	}
	boolean {
	    add_label $g $row $label $required
	    checkbutton $g.cb$row \
		-variable [namespace current]::data(var,$g,$var)
	    grid $g.cb$row  -row $row -column 1 -sticky w
	}
	fixed {
	    add_label $g $row $label $required
	    catch { message $g.m$row -text $data(var,$g,$var) -width 10c }
	    grid $g.m$row -row $row -column 1 \
		-sticky w
	    set dont_report 1
	}
	list-single {
	    add_label $g $row $label $required
	    set height 0
	    foreach {lab val} $options {
		lappend data(combol$row,$g,$var) $lab
		incr height
		if {[string equal $data(var,$g,$var) $val]} {
		    set data(combov$row,$g,$var) $lab
		}
	    }
	    if {$height > 10} {
		set height 10
	    }
	    set cb [ComboBox $g.combo$row \
			-font $font \
			-height $height \
			-editable no \
			-values $data(combol$row,$g,$var) \
			-textvariable \
			[namespace current]::data(combov$row,$g,$var)]
	    grid $cb -row $row -column 1 -sticky we
	    trace variable [namespace current]::data(combov$row,$g,$var) w \
		[list data::trace_combo $options \
		     [namespace current]::data(var,$g,$var)]
	}
	list-multi {
	    add_label $g $row $label $required
	    set sw [ScrolledWindow $g.sw$row]
	    set l [listbox $g.lb$row -font $font -height 6 \
		       -selectmode multiple -exportselection no]
	    $sw setwidget $l
	    foreach {lab val} $options {
		$l insert end $lab
		if {[lcontain $vals $val]} {
		    $l selection set end
		}
	    }
	    grid $sw  -row $row -column 1 -sticky we
	    set data(multi,$g,$var) 1
	    trace_listmulti $l $options \
		data::data(var,$g,$var)
	    bind $l <<ListboxSelect>> \
		[list data::trace_listmulti %W $options \
		     [namespace current]::data(var,$g,$var)]
	}
	hidden {}

	default {
	    debugmsg filetransfer "XDATA: unknown field type '$type'"
	}
    }

    if {![info exists dont_report]} {
	lappend data(allvarlist,$g) $var
    }
}

proc data::trace_combo {assoc dst name1 name2 op} {
    foreach {lab val} $assoc {
	if {[string equal $lab [set ${name1}($name2)]]} {
	    set $dst $val
	}
    }
}

proc data::trace_listmulti {l assoc dst} {
    set $dst {}
    foreach idx [$l curselection] {
	#debugmsg filetransfer [lindex $assoc [expr $idx * 2 + 1]]
	lappend $dst [lindex $assoc [expr $idx * 2 + 1]]
    }
}


proc data::get_tags_x {g} {
    variable data

    set restags {}

    foreach var $data(varlist,$g) {
	if {[info exists data(multi,$g,$var)]} {
	    set vartags {}
	    foreach val $data(var,$g,$var) {
	        lappend vartags [jlib::wrapper:createtag value \
	        		     -chdata $val]
	    }
	} elseif {[info exists data(text,$g,$var)]} {
	    set data(var,$g,$var) [$data(text,$g,$var) get 1.0 "end -1c"]
	    set vartags {}
	    foreach val [split $data(var,$g,$var) \n] {
	        lappend vartags [jlib::wrapper:createtag value \
	        		     -chdata $val]
	    }
	} else {
	    set vartags [list [jlib::wrapper:createtag value \
	        		   -chdata $data(var,$g,$var)]]
	}
	lappend restags [jlib::wrapper:createtag field \
			     -vars [list var $var] \
			     -subtags $vartags]
    }

    set restag [list [jlib::wrapper:createtag x \
			  -vars [list xmlns jabber:x:data type submit] \
			  -subtags $restags]]

    return $restag
}

###############################################################################

proc data::draw_window {items send_cmd {cancel_cmd destroy}} {
    variable winid

    set w .datagathering$winid
    incr winid

    if {[winfo exists $w]} {
	destroy $w
    }

    toplevel $w -class XData
    wm title $w ""
    wm iconname $w ""
    wm withdraw $w
    set geometry [option get $w geometry XData]
    if {$geometry != ""} {
	wm geometry $w $geometry
    }

    set sw [ScrolledWindow $w.sw]
    set sf [ScrollableFrame $w.fields -constrainedwidth yes]
    set f [$sf getframe]
    $sw setwidget $sf
    data::fill_fields $f $items

    set bbox [ButtonBox $w.bbox -spacing 10 -padx 10 -default 0]
    pack $bbox -side bottom -anchor e -padx 2m -pady 2m
    $bbox add -text [::msgcat::mc "Send"] \
	-command [list eval $send_cmd $w \[data::get_tags $f\]]
    $bbox add -text [::msgcat::mc "Cancel"] \
	-command [list eval $send_cmd $w \
		      [list [list [jlib::wrapper:createtag x \
				       -vars [list xmlns jabber:x:data \
						  type cancel]]]]]
	#-command [list eval $cancel_cmd [list $w]]
    bind $w <Return> "ButtonBox::invoke $bbox default"
    bind $w <Escape> "ButtonBox::invoke $bbox 1"

    bindscroll $f $sf

    pack [Separator $w.sep] -side bottom -fill x  -pady 1m

    set hf [frame $w.hf]
    pack $hf -side top
    set vf [frame $w.vf]
    pack $vf -side left
    pack $sw -side top -expand yes -fill both -padx 2m -pady 2m

    update idletasks
    $hf configure -width [expr {[winfo reqwidth $f] + [winfo pixels $f 1c]}]

    set h [winfo reqheight $f]
    set sh [winfo screenheight $w]
    if {$h > $sh - 200} {
	set h [expr {$sh - 200}]
    }
    $vf configure -height [expr {$h + [winfo pixels $f 4m]}]
    wm deiconify $w

    return $w
}

###############################################################################


proc data::request_data {xmlns jid node args} {
    set vars [list xmlns $xmlns]
    if {$node != ""} {
	lappend vars node $node
    }

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars $vars] \
	-to $jid -command [list [namespace current]::receive_data $xmlns $jid $node]
}

proc data::receive_data {xmlns jid node res child} {
    if {![cequal $res OK]} {
	MessageDlg .data_err -aspect 50000 -icon error \
	    -message [format \
			  [::msgcat::mc "Error requesting data: %s"] \
			  [error_to_string $child]] \
	    -type user -buttons ok -default 0 -cancel 0
	return
    }

    switch -- $xmlns {
	jabber:iq:data {
	    set children [list $child]
	}
	default {
	    jlib::wrapper:splitxml $child tag vars isempty chdata children
	}
    }

    data::draw_window $children \
	[list [namespace current]::send_data $xmlns $jid $node]
}

proc data::send_data {xmlns jid node w restags} {
    switch -- $xmlns {
	jabber:iq:data {
	    set child [lindex $restags 0]
	    jlib::wrapper:splitxml $child tag vars isempty chdata children

	    array set arr $vars
	    set arr(xmlns) $xmlns
	    set vars [array get arr]
	}
	default {
	    set children $restags
	    set vars [list xmlns $xmlns]
	}
    }

    if {$node != ""} {
        lappend vars node $node
    }
    
    jlib::send_iq set [jlib::wrapper:createtag query \
			   -vars $vars \
			   -subtags $children] \
	-to $jid \
	-command [list [namespace current]::test_error_res $xmlns $jid $node]

    destroy $w
}

proc data::test_error_res {xmlns jid node res child} {
    if {[cequal $res OK]} return

    MessageDlg .data_err -aspect 50000 -icon error \
	-message [format \
		      [::msgcat::mc "Error submitting data: %s"] \
		      [error_to_string $child]] \
	-type user -buttons ok -default 0 -cancel 0
}

disco::browser::register_feature_handler jabber:iq:data \
    [list [namespace current]::data::request_data jabber:iq:data] -node 1 \
    -desc [list * [::msgcat::mc "Data form"]]
browser::register_ns_handler jabber:iq:data \
    [list [namespace current]::data::request_data jabber:iq:data] -node 1 \
    -desc [list * [::msgcat::mc "Data form"]]

disco::browser::register_feature_handler ejabberd:config \
    [list [namespace current]::data::request_data ejabberd:config] -node 1 \
    -desc [list * [::msgcat::mc "Configure service"]]
browser::register_ns_handler ejabberd:config \
    [list [namespace current]::data::request_data ejabberd:config] -node 1 \
    -desc [list * [::msgcat::mc "Configure service"]]
