/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INPUTCONTROL_H
#define INPUTCONTROL_H

#include "lektion.h"
#include <wx/wx.h>

class TtInputControl : public wxTextCtrl {
public:
  TtInputControl (wxWindow* parent);
  ~TtInputControl ();

  void onKeyDown (wxKeyEvent& event);
  void onChar (wxKeyEvent& event);
  void onMouse (wxMouseEvent& event);
  void onEnter (wxCommandEvent& e);

  void Clear();

  void setFont (wxFont& newFont);
  inline wxFont* getFont () { return localfont; };

  void setBgColor (wxColor* newColor) { bgcolor= newColor; };
  wxColor* getBgColor () { return bgcolor; };

  void setTextColor (wxColor* newColor) { textcolor= newColor; };
  wxColor* getTextColor () { return textcolor; };

  void appendChar (wxUChar c);
  void updateLook ();

private:
  wxFont* localfont;
  wxColour* textcolor;
  wxColour* bgcolor;

  wxUChar specialLineEnd;

  //steadily updated
  Lektion* lesson;

  DECLARE_EVENT_TABLE()  
};

#endif
