/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "SingleLesson.H"
#include "dirs.H"
#include "lektion.h"
#include "main.h"
#include "lektionsauswahl.h"
#include "lektionsauswertung.h"
#include "lektionsanweisung.h"
#include "ConfigFile.H"
#include "LEntry.H"

BEGIN_EVENT_TABLE(SingleLesson,LessonController)
  LESSON_START(wxID_ANY, SingleLesson::onLessonStart)
  LESSON_ABORT(wxID_ANY, SingleLesson::onLessonAbort)
  LESSON_FINISH(wxID_ANY, SingleLesson::onLessonFinish)
END_EVENT_TABLE()

SingleLesson::SingleLesson(wxWindow* parent)
  : parent(parent)
{
  Init();
  LektionLaden();
}

SingleLesson::SingleLesson (wxWindow* parent, unsigned int lesson)
  : parent(parent)
{
  Init();
  if (lesson == 0) {
    LektionLaden();
  } else {
    LektionLaden(lesson);
  }
}

SingleLesson::~SingleLesson () {
  if (runningLesson()) {
    lesson->LektionAbbrechen();
    delete lesson;
  }
}

void SingleLesson::Init () {
  controllerName=_("lesson");
  lesson=0;
  if (!Hauptfenster::getPtr()->setLessonController(this)) {
    throw Abbruch();
  }
}

/* Load lesson
 * Calls a chooser dialog first
 */
void SingleLesson::LektionLaden ()
{
  Lektionsauswahl la(parent);
  la.Center();
  if (la.ShowModal()==wxID_CANCEL) {
    throw Abbruch();;
  } else {
    LektionLaden(la.GetLektion());
  }
}
/* Load lesson
 */
void SingleLesson::LektionLaden (unsigned int index)
{
  m_lektion = index;
  lesson = new Lektion(index,this);
}

/* Ergebnis der Lektion speichern
 */
void SingleLesson::ErgebnisSpeichern () {
  LEntry temp = lesson->GetLessonData();
  temp.setLine(0);
  temp.setColumn(0);
  if (m_lektion > 0) {
    TtConfigFile::getPtr()->storeLessonData(m_lektion,temp);
  }
}


/*  Lektionsanweisung anzeigen
 */
bool SingleLesson::Lektionsanweisung (int l) {
  wxString s;
  s << _("Lesson ") << l;
  LessonStartDlg la(parent, l, _T(""), -1, s);
  la.Centre();
  la.ShowModal();
  return true;
}

void SingleLesson::onLessonStart (wxCommandEvent& WXUNUSED(e)) {
  Lektionsanweisung(m_lektion);
}

void SingleLesson::onLessonAbort (wxCommandEvent& WXUNUSED(e)) {
  lauswertung laus(parent, _("Lesson statistics"), lesson);
  laus.ShowModal();
  delete lesson;
  lesson=0;
}

void SingleLesson::onLessonFinish (wxCommandEvent& WXUNUSED(e)) {
  ErgebnisSpeichern();
  lauswertung laus(parent, _("Lesson statistics"), lesson);
  laus.ShowModal();
  delete lesson;
  lesson=0;
  try {
    LektionLaden();
  }
  catch (Abbruch) {
    Hauptfenster::getPtr()->setLessonController(0);
  }
}

