/***************************************************************************
                          lektionsauswahl.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jan 13 20:00:09 MET 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <fstream>
#include <wx/config.h>
#include <stdio.h>


#include "lektionsauswahl.h"

enum
{
  // Controls
  LB = 1,
  TC = 2,
  B1 = 3,
  B2 = 4
};

BEGIN_EVENT_TABLE(Lektionsauswahl, wxDialog)
  EVT_BUTTON(B1, Lektionsauswahl::OnLektionStarten)
  EVT_BUTTON(B2, Lektionsauswahl::OnProgrammBeenden)
  EVT_LISTBOX(LB, Lektionsauswahl::OnListBox)
  EVT_LISTBOX_DCLICK(LB, Lektionsauswahl::OnLektionStarten)
  EVT_CLOSE(Lektionsauswahl::OnCloseWindow)
END_EVENT_TABLE()


//**************************************************************************
//* Konstruktor
//**************************************************************************

Lektionsauswahl::Lektionsauswahl(wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos = wxDefaultPosition, 
const wxSize& size =wxDefaultSize, long style = wxDEFAULT_DIALOG_STYLE, const wxString& name = "dialogBox") : wxDialog(parent, id, title, pos, size, style, name)
{
  SetAutoLayout(TRUE);

  // Listbox fr Lektionen
  lb = new wxListBox(this, LB);

  wxLayoutConstraints *b1 = new wxLayoutConstraints;
  b1->centreX.SameAs(this, wxLeft);
  b1->top.SameAs(this, wxTop, 5);
  b1->left.SameAs(this, wxLeft, 5);
  b1->width.PercentOf(this, wxWidth, 56);
  b1->height.PercentOf(this, wxHeight, 80);
  lb->SetConstraints(b1);

  // Okaybutton zum besttigen
  ok = new wxButton(this, B1,_("Lektion starten"));
  
  wxLayoutConstraints *b2 = new wxLayoutConstraints;
  b2->centreX.SameAs(this, wxLeft);
  b2->top.SameAs(lb, wxBottom, 10);
  b2->left.SameAs(this, wxLeft, 5);
  b2->width.PercentOf(this, wxWidth, 48);
  b2->height.PercentOf(this, wxHeight, 10);

  ok->SetConstraints(b2);
  // Button zum Beenden des Programmes
  ab = new wxButton(this, B2, _("Lektionsauswahl abbrechen"));

  wxLayoutConstraints *b3 = new wxLayoutConstraints;
  b3->centreX.SameAs(this, wxLeft);
  b3->top.SameAs(lb, wxBottom, 10);
  b3->left.SameAs(ok, wxRight, 10);
  b3->width.PercentOf(this, wxWidth, 48);
  b3->height.PercentOf(this, wxHeight, 10);
  
  ab->SetConstraints(b3);

  tc = new wxTextCtrl(this, TC, 
_("Status der Lektion\n ---------------\n Hier soll spter angezeigt werden ob die Lektion bereits bearbeitet wurde."), 
		      wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE | wxTE_READONLY);
  tc->SetEditable(false);
  
  wxLayoutConstraints *b4 = new wxLayoutConstraints;
  b4->centreX.SameAs(this, wxLeft);
  b4->top.SameAs(this, wxTop, 5);
  b4->left.SameAs(lb, wxRight, 10);
  b4->width.PercentOf(this, wxWidth, 40);
  b4->height.PercentOf(this, wxHeight, 80);
  
  tc->SetConstraints(b4);

  // Lektionsindex laden
  wxString f;

   wxConfigBase *pConfig = wxConfigBase::Get();
   wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
   
   f <<  L_DIR << "/" << tlayout << "/lektion.index";

   ifstream is(f.c_str());
  char zeile[256];
  if (is)
    {
      while (!is.eof())
	{
	  is.getline(zeile, 256, '\n');
	  if (!is.eof())
	    lb->Append(zeile);
	}
      // Infos fr Lektion Anzeigen
      OnListBox((wxCommandEvent*)NULL);
    }
  else
    {
      wxString msg;
	   msg << _("Die Datei lektion.index wurde nicht im Verzeichnis ") << L_DIR
	       << _(" \ngefunden oder konnte nicht geffnet werden!");
	   wxMessageBox(msg, "Datei nicht gefunden", wxICON_EXCLAMATION, GetParent());
       ok->Enable(FALSE);
       SetReturnCode(99);
    }
}

//**************************************************************
//* Button Programm beenden
//**************************************************************

void Lektionsauswahl::OnProgrammBeenden(wxCommandEvent* event)
{
  SetReturnCode(99);
  EndModal(GetReturnCode());
}

//**************************************************************
//* Lektion Laden
//**************************************************************

void Lektionsauswahl::OnLektionStarten(wxCommandEvent* event)
{
  //wxLogError("Lektionsauswahl::OnLektionStarten");
  if (lb->GetSelection() != -1)
    EndModal(GetReturnCode());
  else
    {
      wxLogError(_("Keine Lektion ausgewhlt!\n"));
    }
}


//***************************************************************
//* Statusanzeige bei Klick auf Listbox aktualisieren
//***************************************************************

void Lektionsauswahl::OnListBox(wxCommandEvent* event)
{
  wxString s;
  s << "/Lektionen/Lektion" <<  lb->GetSelection() +1;
  wxConfigBase *pConfig = wxConfigBase::Get();
  pConfig->SetPath(s);
  int f, r, a, pos;
  double fp;
  wxString z;
  f = pConfig->Read("Fehler", -1 );
  r = pConfig->Read("Richtig", -1);
  pos = pConfig->Read("Pos", -1);
  fp = pConfig->Read("FP", -1);
  z = pConfig->Read("Zeit",  "00:00:00");
  a = pConfig->Read("apm", -1);
  // Nur wenn die vorherige Lektion geladen wurde kann die nchste bearbeitet werden
  struct bnm {};
  try
    {
      if (lb->GetSelection() > 0)
	{
	  wxString t;
	  // Lektionssperre vorlufig ausgeklammert
	  // bool eb
	  //t << "/Lektionen/Lektion" << lb->GetSelection() << "/eb";
	  //eb = pConfig->Read(t, false);
	  //if (!eb) throw bnm();
	};
      ok->Enable(true);
      wxString t;
      if (f==-1)
	{
	  tc->Clear();
	  t  << _("Lektion ") << lb->GetSelection()+1 << "\n";
	  t   << "------------\n";
	  t  << _("Die ausgewhlte Lektion \nwurde noch nicht bearbeitet");
	}
      else
	{
	  tc->Clear();
	  t << _("Lektion ") << lb->GetSelection()+1 << "\n"
	    "-------------\n"
	    << _("Richtig:                            ") << r << "\n"
	    << _("Fehler:                             ") << f << "\n"
	    << _("Fehler in Promille:             ") << fp << "\n"
	    << _("bentigte Zeit:            ") << z << "\n"
	    << _("Anschlge pro Minute:       ") << a << "\n";
	}
      tc->AppendText(t);
    }
  catch (bnm)
    {
      ok->Enable(false);
      tc->Clear();
      tc->AppendText(_("Lektion kann nicht geladen\n werden, da vorherige\n Lektion noch nicht\n bearbeitet wurde"));
    }
}

void Lektionsauswahl::OnCloseWindow(wxCloseEvent& e)
{
  //kein Event Skip, um schlieen des Modalen Dialoges ber das
  //Systembutton zu verhindern
}
