#include <gtk/gtk.h>
#include "gloo/gloo-pulse-button.h"

static void
on_start_clicked (GtkWidget *widget, GlooPulseButton *pulse_button)
{
	gloo_pulse_button_start_pulsing (pulse_button);
}

static void
on_stop_clicked (GtkWidget *widget, GlooPulseButton *pulse_button)
{
	gloo_pulse_button_stop_pulsing (pulse_button);
}

int
main (int argc, char **argv)
{
	GtkWidget *button_window;
	GtkWidget *pulse_button;
	GtkWidget *control_window;
	GtkWidget *control_box;
	GtkWidget *temp_button;
	
	gtk_init (&argc, &argv);
	
	button_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	pulse_button = g_object_new (GLOO_TYPE_PULSE_BUTTON,
								 "label", "Pulse Button",
								 NULL);
	gtk_container_add (GTK_CONTAINER (button_window), pulse_button);


	control_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	control_box = gtk_hbox_new (FALSE, 6);
	temp_button = g_object_new (GTK_TYPE_BUTTON,
								"label", "Start",
								NULL);
	g_signal_connect (G_OBJECT (temp_button), "clicked",
					  G_CALLBACK (on_start_clicked), pulse_button);
	gtk_box_pack_start_defaults (GTK_BOX (control_box), temp_button);
	
	temp_button = g_object_new (GTK_TYPE_BUTTON,
								"label", "Stop",
								NULL);
	g_signal_connect (G_OBJECT (temp_button), "clicked",
					  G_CALLBACK (on_stop_clicked), pulse_button);
	gtk_box_pack_start_defaults (GTK_BOX (control_box), temp_button);

	gtk_container_add (GTK_CONTAINER (control_window), control_box);

	gtk_widget_show_all (button_window);
	gtk_widget_show_all (control_window);

	gtk_main ();
	return 0;
}
