#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>

void main(int,char**);

//enum types {SYNTAX,FILEOPENIN,FILEOPENOUT,WRONGBMP} error;


void main(int argc, char** argv){

	FILE *infile, *outfile;
   int i,row,col;
   unsigned short int dataMatrix[64][12];
   unsigned short int buffer;

	if(argc < 3){
        printf("Bmp2Z80 v1.0 by Peter Martijn Kuipers (central@hyperfield.com)\nUsage bmp2z80 inputfile outputfile\n\n");
        printf("inputfile    : A monochrome windows bitmap with dimensions 96 x 64\n");
		  printf("outputfile   : the name of the file to write the .db codes to\n\n");
        printf("Publised under the Gnu Public License\n");
      exit(1);
		}

   if(( infile = fopen(argv[1], "r") ) == NULL){  //opening inputfile
      printf("Error opening inputfile\n");
      exit(2);
		}

   if(( outfile = fopen(argv[2], "w") ) == NULL){ //opening outputfile
      printf("Error opening outputfile\n");
      exit(2);
		}
   setmode(fileno(infile), O_BINARY);		// set in and ouput to binary, so we won't get weird output
   setmode(fileno(outfile), O_BINARY);    //

   for(i=0;i<=61;i++){							// read the bitmap header, and pick out the size
		buffer = fgetc(infile);  				//
      if((i == 0x12 && buffer != 0x60) || (i == 0x16 && buffer != 0x40)){
      	printf("The input bitmap has an incorrect format.\nThe correct format = 96 x 64 monochrome\n");
         exit(3);
         }
      }

   for(row=63;row>=0;row--){            //get all of the rows and columns, starting with the rows left under,
		for(col=0;col<=11;col++){         //the columns are left to right and the rows bottom up in a bitmap
			buffer = fgetc(infile);        //
			buffer = buffer ^ 255;         //
         dataMatrix[row][col] = buffer; //
         }
      }


   fclose(infile); // ach ja, we hebben hem toch niet meer nodig


   for(row=0;row<64;row++){ //place all of the .db statements, one per row
   	fprintf(outfile,"        .db $%X,$%X,$%X,$%X,$%X,$%X,$%X,$%X,$%X,$%X,$%X,$%X\n"
      		,dataMatrix[row][0]
      		,dataMatrix[row][1]
      		,dataMatrix[row][2]
            ,dataMatrix[row][3]
            ,dataMatrix[row][4]
            ,dataMatrix[row][5]
            ,dataMatrix[row][6]
            ,dataMatrix[row][7]
            ,dataMatrix[row][8]
            ,dataMatrix[row][9]
            ,dataMatrix[row][10]
            ,dataMatrix[row][11]
            );
      }

   fclose(outfile); //we're done
	exit(0);
	}
