/*
 * window.h - a header fiel for window.c
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

/* Cursor */
#define CURSOR_READING     1
#define CURSOR_READY       2
#define CURSOR_DRAWING     3
#define CURSOR_DRAWING_PS  4
Public void x_change_cursor(int);
Public int  x_currenct_cursor(void);


/* Window cache */
#define WINDOW_HASH            7
#define WIN_CACHE_EMPTY        0
#define WIN_CACHE_COMPLETED    1
#define WIN_CACHE_INTERRUPTED  2
typedef struct s_win_cache  *WIN_CACHE;
struct s_win_cache {
  int          page;
  Pixmap       win;
  int          flag;
  DVI_CONTEXT  context;
};



Import Display  *x_display;
Import Window   x_window;
#define EVENT_MASK  \
        (KeyPressMask|ButtonPressMask|ExposureMask|StructureNotifyMask)

Public void  x_open_display(char*);
Public void  x_init(void);
Public int   x_visual_color_rgb32(void);
Public int   x_visual_color(void);
Public void  x_change_color_fg(int,double,double,double);
Public void  x_change_color_bg(int,double,double,double);
Public void  x_clear_window(void);
Public void  x_window_shrink(void);
Public void  x_window_enlarge(void);
Public void  x_resized_window(unsigned int,unsigned int);
Public void  x_restore_current_page(void);
Public void  x_put_bitmap(DVI_BITMAP,long,long);
Public void  x_put_pixmap_rgb(DVI_PIXMAP_RGB,long,long);
Public void  x_put_graymap(DVI_GRAYMAP,long,long);
Public void  x_put_rectangle(long,long,long,long);
Public void  x_put_border(void);
Public int   x_shift_view_x(int,int);
Public int   x_shift_view_y(int,int);
Public void  x_correct_view(void);

Public void       x_cache_reset(void);
Public Pixmap     x_cache_get_window(void);
Public WIN_CACHE  x_cache_get(void);

/*EOF*/
