struct ntfs_boot_sector {
	uint8_t	ignored[3];	/* 0x00 Boot strap short or near jump */
	int8_t	system_id[8];	/* 0x03 Name : NTFS */
	uint8_t	sector_size[2];	/* 0x0B bytes per logical sector */
	uint8_t	sectors_per_cluster;	/* 0x0D sectors/cluster */
	uint16_t	reserved;	/* 0x0E reserved sectors = 0 */
	uint8_t	fats;		/* 0x10 number of FATs = 0 */
	uint8_t	dir_entries[2];	/* 0x11 root directory entries = 0 */
	uint8_t	sectors[2];	/* 0x13 number of sectors = 0 */
	uint8_t	media;		/* 0x15 media code (unused) */
	uint16_t	fat_length;	/* 0x16 sectors/FAT = 0 */
	uint16_t	secs_track;	/* 0x18 sectors per track */
	uint16_t	heads;		/* 0x1A number of heads */
	uint32_t	hidden;		/* 0x1C hidden sectors (unused) */
	uint32_t	total_sect;	/* 0x20 number of sectors = 0 */
	uint8_t	physical_drive;	/* 0x24 physical drive number  */
	uint8_t	unused;		/* 0x25 */
	uint16_t	reserved2;	/* 0x26 usually 0x80 */
	uint64_t	sectors_nbr;	/* 0x28 total sectors nbr */
	uint64_t	mft_lcn;	/* 0x30 Cluster location of mft data.*/
	uint64_t	mftmirr_lcn;	/* 0x38 Cluster location of copy of mft.*/
	int8_t   clusters_per_mft_record;		/* 0x40 */
	uint8_t  	reserved0[3];               	/* zero */
	int8_t	clusters_per_index_record;	/* 0x44 clusters per index block */
	uint8_t  	reserved1[3];               	/* zero */
	uint64_t 	volume_serial_number;       	/* 0x48 Irrelevant (serial number). */
	uint32_t 	checksum;                   	/* 0x50 Boot sector checksum. */
	uint8_t  	bootstrap[426];             	/* 0x54 Irrelevant (boot up code). */
	uint16_t	marker;				/* 0x1FE */
	} __attribute__ ((__packed__));
int set_NTFS_info(t_param_disk *disk_car, const struct ntfs_boot_sector*ntfs_header,t_partition *partition,const int debug, const int dump_ind);
int recover_NTFS(t_param_disk *disk_car, const struct ntfs_boot_sector*ntfs_header,t_partition *partition,const int debug, const int dump_ind, const int backup);
int check_NTFS(t_param_disk *disk_car,t_partition *partition,const int debug,const int dump_ind);
int test_NTFS(const t_param_disk *disk_car,const struct ntfs_boot_sector*ntfs_header, t_partition *partition,const int debug, const int dump_ind);
int dir_ntfs(WINDOW *window,t_param_disk *disk_car,t_partition *partition);
int is_ntfs(const int part_type);
int dump_2ntfs_rapport(const struct ntfs_boot_sector *nh1, const struct ntfs_boot_sector *nh2);
int dump_ntfs_rapport(const struct ntfs_boot_sector *ntfs_header);
int dir_partition_ntfs(WINDOW *window,t_param_disk *disk_car,t_partition *partition, const int debug);
