%define oname targetcli

Name:           targetcli
License:        AGPLv3
Group:          Applications/System
Summary:        RisingTide Systems generic SCSI target CLI shell.
Version:        2.0rc1
Release:        1%{?dist}
URL:            http://www.risingtidesystems.com/git/
Source:         %{oname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-rpmroot
BuildArch:      noarch
BuildRequires:  python-devel, python-rtslib, python-configshell
Requires:       python-rtslib, python-configshell, lio-utils
Vendor:         RisingTide Systems

%description
RisingTide Systems generic SCSI target CLI shell.

%prep
%setup -q -n %{oname}-%{version}

%build
%{__python} setup.py build

%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root %{buildroot}

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{python_sitelib}
%{_bindir}/targetcli
%doc COPYING README

%changelog
* Thu Sep 22 2011 Jerome Martin <jxm@risingtidesystems.com> 2.0rc1-1
Now using a tarball-release based Makefile.
  - Removed useless obsolete targets (setup.py based)
  - Merged version templating in Makefile (removed bin/gen_changelog*).
  - Added 'release' make target that generates a dist/*.tar.gz official
    versionned release tarball from which one can just use setup.py,
    dpkg-buildpackage or rpmbuild (no Makefile in it).
  - Removed obsolete bin/lint as well.
  - Now the 'rpm' and 'deb' Makefile targets use the generated release build.
  - Makefile commands now use no echo mode.
  - Added timestamps for virtual targets.
  - Removed obsolete (empty) doc packages generation. The shell is
    self-documenting.
  - Cleaned up setup.py alignements.
* Tue Sep 20 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.47.g7158711-1
Spacing between classes is now two lines.
* Tue Sep 20 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.46.g0df5ee8-1
Changed name to targetcli at community request.
* Fri Sep 16 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.45.g179e8d8-1
Updated version numbering code.
  - Now uses 'git describe --tags' output, just replacing dashes with dots for
    compatibility with RPM version numbers.
  - For coherency, RPM and debian version numbers are now the same.
  - Removed the timestamp, as it is not needed anymore (even when reordering
    commits, the version is non-ambiguous, as for non-tagged commits we have part
    of the last commit hash and the number of commits since last tag).
* Fri Jul 29 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.44.ge9d33c3-1
Fixed build branch (in git export) in Makefile.
* Tue Jul 19 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.43.g37f175c-1
Fixed build and install dependencies.
  - Added lio-utils dependency to rtsadmin packages.
  - Added python-rtslib and python-configshell to build requires.
* Tue Jul 19 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.42.g5a80388-1
Root UI now imports tcm_dump directly.
* Mon Jul 18 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.41.g0876739-1
Moved saveconfig to /, added hostname reminder.
  - Reminder is useful for remote access.
  - Moving to root node makes it clear that the whole config is saved,
    not just the current node or subtree.
  - Removes command clutter from nodes.
* Mon Jul 18 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.40.g1b06ee3-1
Removed temporary debug hidden cmds _sh and _cfs.
  - Were not even proper UI commands (just hardcoded test cases)
  - Now useless as that part has been debugged
  - Shell access can be dangerous using remote access.
* Tue Jun 14 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.39.ge83faf7-1
Converted to refactored ConfigShell/Node layout.
  - Now using console, log, prefs through shell.
  - Root node binds to shell, not the other way.
  - Replaced del_child() calls by remove_child()
  - Replaced a children loop scan by ConfigNode get_child() method.
* Fri Jun 10 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.38.gccb88b2-1
Fixed error for nonexisting IP on portal creation.
  - Message is now less wordy and includes faulty IP Address.
* Thu Jun 9 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.37.g0e45214-1
Now check for acls_auth feature in ACL UI.
  - Prevents exposing auth config group when the feature is not implemented.
* Thu Jun 9 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.36.g6b17137-1
Added discovery_auth support to fabric modules UI.
* Wed Jun 8 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.35.g0466fe1-1
Using config params wrappers, not direct access.
* Tue Jun 7 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.33.g8244fc8-1
Missed 'writable' flag to some globals params.
* Tue Jun 7 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.34.g42c08cd-1
Now using configshell new ui_type style.
  - Instead of using directly ui_type_* methods, use the type name.
* Sat Jun 4 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.32.g5491acd-1
Merged UIAttributes/UIParameters to UIRTSLibNode.
  - As a result all UIRTSLibNode have the capabilities to use attributes and
    parameters.
  - Added a couple of checks to actually enable the feature only if the
    underlying rtslib node has attributes/parameters.
  - Added the writable flag to the Attributes/Parameters.
* Wed Jun 1 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.31.gc68f426-1
Added auto_cd_after_create global.
  - Automatically cd's to newly created object after a 'create' command if true.
  - Added autosave (always) of last created node's path under @last bookmark.
* Wed Jun 1 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.30.gc436cb8-1
'version' command now warns if version is not set.
* Wed Jun 1 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.29.g13e1ab6-1
Code cleanup: unused imports, indents, unused vars.
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.28.ge92dfc3-1
Fixed regression from 1d55a9f7 (target creation)
  - Only impacts non multi-TPG targets, was a non-converted object name.
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.27.ga52d7bf-1
Added version command to new style storage objects.
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.26.g41010d2-1
Fixed some line breaks.
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.25.g637cb21-1
Added autocompletion for "acls/ delete".
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.24.g10e5bee-1
Fixed regression in 1d55a9f (catch RTSLibNotInCFS)
  - An abusive catch of RTSLibNotInCFS in execute_command was retrying the
    command endlessly, which is bad on general principle but even worse
    when the RTSLibNotInCFS is legit and should get through (i.e. trying
    to delete a non-existent MappedLUN would result in and endless loop).
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.23.gb91a614-1
Fixed legacy storage object and backstore deletion.
  - Wrong object reference after previous wholesale conversion to
    using "rtsnode" for underlying configFS objects in UIRTSLibNode.
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.22.g43fa474-1
Fixed .gitignore to be more precise.
* Tue May 31 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.21.gc052aad-1
Switched to 1:1 hba:storage view.
  - Added 'legacy_hba_view' global boolean to select legacy view if needed.
  - Added root refresh when setting a global parameter.
  - All backstore plugins now part of the backstores/ tree
  - Only one storage object by backstore.
  - We now hide indiviual backstores. As they are mapped 1:1 with
    storage objects, both levels are collapsed.
* Fri May 27 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.20.ga0f9dba-1
Fixed missing space in help text.
* Thu May 26 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.19.gdb64b75-1
Now creates first TPG for multi TPG target.
  - The target is useless without at least one TPG, so now we create it
    automatically.
* Thu May 26 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.18.g2ed9989-1
Global 'auto_add_mapped_luns' now defaults to true.
* Thu May 26 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.17.g6b08759-1
Better handling of non-existing configfs objects.
  - If rtslib/configfs objects have been deleted under us, catch the (new)
    RTSLibNotInCFS exception and refresh before executing the command.
  - All UI objects attached to a configfs/rtslib node now check that they still
    exist before executing a command. If not, display an error, refresh the tree
    and go back to root (i.e. after doing '../ delete object' while in /parent/object).
    Done via a new class UIRTSLibNode.
  - Refactored a bit UIRTSLibNode to use self.rtsnode instead of self.lun,
    self.tpg, etc.
* Thu May 26 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.16.gd4df22f-1
Added auto_add_mapped_luns global.
  - Also added add_mapped_luns parameter to both 'luns/ create' and 'acls/
    create', both boolean and defaulting to auto_add_mapped_luns.
  - When true, that parameter automatically add mapped LUNs, either
    for all existing TPG LUNs (acls/ create) or to all existing ACLs
    (luns/ create).
* Wed May 18 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.15.g1fa4164-1
Added sed* inplace tmp files to clean target.
* Tue May 17 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.14.g78be4fb-1
Added 'auth' attributes set/get to node ACLs.
  - Allows setting/getting auth passwd/userid/mutual_passwd/mutual_userid.
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.13.gace144a-1
For RPM build, include docs and proper version.
* Sat May 14 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.12.gc20750b-1
RPM: Fixed 'Group:' tag to Applications/System.
* Sat May 14 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.10.g51d0f2d-1
Cleanly abort startup if RTSLibError happens.
* Sat May 14 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.11.gd9c8421-1
Build process cleanup, added rpm/deb targets.
  - Now builds rpm and deb separately, intended to be used on debian and redhat
    systems respectively. No more deb -> rpm conversion using alien.
  - Integrated bin/clean into Makefile
  - Now make clean does not remove packages, added cleanall target for that.
  - Added .gitignore file.
  - Added python-rtslib to rtsadmin control
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.9.g21867ef-1
Fixed typo in UIIBlockBackstore creation.
  - Was using the wrong method name for prm_gen_wwn.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.8.g24cd2d6-1
Now correctly create multi TPG target objects.
  - Was always creating no-TPG target before, needing refresh to actually display
    multi-TPG targets correctly.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.7.g3b392b2-1
Cleaned up trailing whitespaces from *.py
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.6.g0428a6c-1
Cleaned up storage object creation bool params.
  - Renamed 'wwn' parameter to 'generate_wwn'
  - Both 'generate_wwn' and 'buffered' paramters are now using ui_type_bool.
  - Converted to use new configshell ui_eval_param() helper.
  - Fixed typo that lead to ignoring those parameters default value (True) and
    made it False, thus not generating vpd_serial_unit wwn by default (reported
    by Nic).
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.5.g7492053-1
Global 'auto_enable_tpg' type is now bool.
  - Reflects configshell-side conversion of ui_type_onoff to ui_type_bool, using
    true|false instead of on|off values.
* Wed May 11 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.4.g947874b-1
Disable privileged commands if user is not root.
* Wed May 11 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.3.g063b214-1
Fixed acls refresh issue upon LUN deletion.
  - When deleting a LUN, we must refresh the whole TPG UI so that potentially
    deleted acls mapped LUNs get accounted for too.
* Tue May 10 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.2.g92e5595-1
Fixed typo in README.
* Tue May 10 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.1.gf8a2f9e-1
Added public repo URL to README.
* Wed May 4 2011 Nicholas Bellinger <nab@risingtidesystems.com> 1.99-1
initial rtsadmin commit
  Signed-off-by: Nicholas Bellinger <nab@risingtidesystems.com>
