# Config file for C++ demos
# Only some files have comments in //. style

from Synopsis.Config import Base

class Config (Base):
    class Parser:
	class CXX (Base.Parser.CXX):
	    #include_path = Base.Parser.CXX.include_path + ['.',
	    #	'/usr/include/g++-v3', 
	    #	'/usr/include/g++-v3/i386-linux', 
	    #	'/usr/lib/gcc-lib/i386-linux/3.0/include/']
	    main_file = 1
	modules = {
	    'C++':CXX,
	}
	    
    class Linker:
	class LinkerSSD (Base.Linker.Linker):
	    comment_processors = ['ssd', 'group', 'javatags', 'summary']
	    class XRefCompiler (Base.Linker.Linker.XRefCompiler):
		no_locals = 0
	class LinkerJava (Base.Linker.Linker):
	    comment_processors = ['java', 'javatags', 'summary']
	class LinkerMapper (LinkerSSD):
	    map_declaration_names = 'Parser::Cxx'
	modules = {
	    'Linker':LinkerSSD,
	    'Linker-employee':LinkerJava,
	    'Linker-module':LinkerMapper,
	}

    class Formatter:
	class HTML (Base.Formatter.HTML):
	    stylesheet_file = '../html.css'
	class XrefHTML (Base.Formatter.HTML):
	    stylesheet_file = '../html.css'
	    pages = Base.Formatter.HTML.pages + ['FilePages', 'XRefPages']
	    toc_out = 'GapBuffer.toc'
	    class ScopePages (Base.Formatter.HTML.ScopePages):
		summary_formatters = \
		    Base.Formatter.HTML.ScopePages.summary_formatters + \
		    ['XRefLinker','SourceLinker']
	    class XRefPages:
		xref_file = 'GapBuffer.xref'
	    class FilePages (Base.Formatter.HTML.FilePages):
		toc_files = ['GapBuffer.toc']
	    class FileTree (Base.Formatter.HTML.FileTree):
		link_to_pages = 1
	class SxrHTML (XrefHTML):
	    pages=['DirBrowse', 'ScopePages', 'ModuleListing',
	    'InheritanceTree', 'InheritanceGraph', 'FilePages',
	    'RawFilePages', 'NameIndex', 'XRefPages']
	    default_toc = 'XRefPages'
	    start_dir = ''
	    base_dir = '.'
	    page_format = 'TemplatePageFormat'
	    class TemplatePageFormat:
		file = 'template-sxr.html'
		copy_files = [('gapbuffer-logo.png', 'logo.png')]
	    class XRefPages:
		xref_file = 'GapBuffer.xref'
		link_to_scopepages = 1
	    class FilePages (Base.Formatter.HTML.FilePages):
		toc_from = 'XRefPages'
		
		
	modules = Base.Formatter.modules
	modules['HTML'] = HTML
	modules['XrefHTML'] = XrefHTML
	modules['SxrHTML'] = SxrHTML

