/* === S Y N F I G ========================================================= */
/*!	\file cellrenderer_gradient.cpp
**	\brief Template File
**
**	$Id: cellrenderer_gradient.cpp 1143 2007-11-13 09:13:07Z pabs $
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === H E A D E R S ======================================================= */

#ifdef USING_PCH
#	include "pch.h"
#else
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include "cellrenderer_gradient.h"
#include "widget_gradient.h"
#include "app.h"

#include "general.h"

#endif

/* === U S I N G =========================================================== */

using namespace std;
//using namespace etl;
using namespace synfig;
using namespace studio;

/* === M A C R O S ========================================================= */

/* === G L O B A L S ======================================================= */

/* === P R O C E D U R E S ================================================= */

/* === M E T H O D S ======================================================= */

CellRenderer_Gradient::CellRenderer_Gradient():
	Glib::ObjectBase	(typeid(CellRenderer_Gradient)),
	Gtk::CellRendererText	(),
	property_gradient_(*this,"gradient",synfig::Gradient())
{
	//CellRendererText::signal_edited().connect(sigc::mem_fun(*this,&studio::CellRenderer_Gradient::string_edited_));
}

CellRenderer_Gradient::~CellRenderer_Gradient()
{
}


void
CellRenderer_Gradient::render_vfunc(
		const Glib::RefPtr<Gdk::Drawable>& window,
		Gtk::Widget& /*widget*/,
		const Gdk::Rectangle& /*background_area*/,
		const Gdk::Rectangle& ca,
		const Gdk::Rectangle& /*expose_area*/,
		Gtk::CellRendererState /*flags*/)
{
	if(!window)
		return;
	render_gradient_to_window(window,ca,property_gradient_.get_value());
}


Gtk::CellEditable*
CellRenderer_Gradient::start_editing_vfunc(
	GdkEvent* /*event*/,
	Gtk::Widget& /*widget*/,
	const Glib::ustring& /*path*/,
	const Gdk::Rectangle& /*background_area*/,
	const Gdk::Rectangle& /*cell_area*/,
	Gtk::CellRendererState /*flags*/)
{
	return 0;
}
