
#include "config.h"

#include "i18n.h"

#include <unistd.h>
#include <sys/fcntl.h>
#ifdef HAVE_RPM
#include <apt-pkg/rpmpm.h>
#endif

#include "rinstallprogress.h"


void *RInstallProgress::loop(void *data)
{
    RInstallProgress *me = (RInstallProgress*)data;

    me->startUpdate();
    
    while (me->_thread_id >= 0) {
	me->updateInterface();
    }
    
    me->finishUpdate();

    pthread_exit(NULL);
    
    return NULL;
}



pkgPackageManager::OrderResult RInstallProgress::start(pkgPackageManager *pm)
{
    void *dummy;
    pkgPackageManager::OrderResult res;
 
#ifdef HAVE_RPM
    ((pkgRPMPM*)pm)->setNonInteractive();
    
    int fd[2];
    /*
     * This will make a pipe from where we can read child's output
     */
    // our stdout will be _stdout from now on
    _stdout = dup(1); 

    // create our comm. channel with the child
    pipe(fd);

    // close our official stdout
    close(1);
    
    // make the write end of the pipe to the child become the new stdout 
    // (for the child)
    dup2(fd[1],1);

    // this is where we read stuff from the child
    _childin = fd[0];

    // make it nonblocking
    fcntl(_childin, F_SETFL, O_NONBLOCK);
#endif /* HAVE_RPM */

    _thread_id = pthread_create(&_thread, NULL, loop, this);

    res = pm->DoInstall();

    _thread_id = -1;
    
    pthread_join(_thread, &dummy);

#ifdef HAVE_RPM
    /*
     * Clean-up stuff so that everything is like before
     */
    close(1);
    close(_childin);
    dup2(_stdout, 1);
    close(_stdout);
#endif /* HAVE_RPM */
    return res;
}

