#ifndef SWORDAPI_H
#define SWORDAPI_H

#include <swmodule.h>
#include <swkey.h>
#include <versekey.h>

#ifdef __cplusplus
extern "C" {
#endif
void _export PASCAL YoYo(int x, int y);
int  _export PASCAL NewModule(char FAR *type, void *iparams);
void _export PASCAL DeleteModule(SWModule FAR *mod);
char _export PASCAL ModSetKeyText(SWModule FAR *mod, char FAR *key);
char _export PASCAL ModSetKeyKey(SWModule FAR *mod, SWKey FAR *key);
int  _export PASCAL ModGetTextLen(SWModule FAR *mod);
void _export PASCAL ModGetText(SWModule FAR *mod, char FAR *buf, int size);
void _export PASCAL ModGetKeyText(SWModule FAR *mod, char FAR *buf, int size);
int  _export PASCAL ModGetKey(SWModule FAR *mod);
void _export PASCAL ModInc(SWModule FAR *mod);
void _export PASCAL ModDec(SWModule FAR *mod);
int  _export PASCAL ModSearch(SWModule FAR *mod, char FAR *stext);
int  _export PASCAL ModError(SWModule FAR *mod);


/******************************************************************************
 * Key routines
 */

int  _export PASCAL NewKey(char FAR *type);
void _export PASCAL DeleteKey(SWKey FAR *hkey);
void _export PASCAL KeySetPersist(SWKey *hkey, int ipersist);
int  _export PASCAL KeyGetPersist(SWKey *hkey);
int  _export PASCAL KeyError(SWKey *hkey);
void _export PASCAL KeyGetText(SWKey FAR *hkey, char FAR *buf, int size);
void _export PASCAL KeySetText(SWKey FAR *hkey, char FAR *buf);
void _export PASCAL KeySetKey(SWKey FAR *hkey, SWKey FAR *skey);
void _export PASCAL KeyInc(SWKey FAR *hkey);
void _export PASCAL KeyDec(SWKey FAR *hkey);


//-------- VerseKey specifics ----------------

int  _export PASCAL VerseKeyGetTestament(VerseKey *hkey);
int  _export PASCAL VerseKeyGetBook(VerseKey *hkey);
int  _export PASCAL VerseKeyGetChapter(VerseKey *hkey);
int  _export PASCAL VerseKeyGetVerse(VerseKey *hkey);
void _export PASCAL VerseKeySetTestament(VerseKey *hkey, int val);
void _export PASCAL VerseKeySetBook(VerseKey *hkey, int val);
void _export PASCAL VerseKeySetChapter(VerseKey *hkey, int val);
void _export PASCAL VerseKeySetVerse(VerseKey *hkey, int val);
void _export PASCAL VerseKeyNormalize(VerseKey *hkey);
void _export PASCAL VerseKeySetAutoNormalize(VerseKey *hkey, int val);
int  _export PASCAL VerseKeyGetAutoNormalize(VerseKey *hkey);

#ifdef __cplusplus
}
#endif

#endif
