/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.NoSuchAttributeException;

public class WidgetMethodHandler
extends AbstractHandler
implements IExecutableExtension {
    private static final Set ATTRIBUTE_NAMES = new HashSet();
    private static final String ATTRIBUTE_ENABLED = "enabled";
    private static final String ATTRIBUTE_ID = "id";
    private static final Class[] METHOD_PARAMETERS = new Class[0];
    private String methodName;

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_ENABLED);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_ID);
    }

    public final void execute(Object parameter) throws ExecutionException {
        Method methodToExecute = this.getMethodToExecute();
        if (methodToExecute != null) {
            try {
                Control focusControl = Display.getCurrent().getFocusControl();
                methodToExecute.invoke((Object)focusControl, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException(e.getTargetException());
            }
        }
    }

    private final Method getMethodToExecute() {
        Control focusControl = Display.getCurrent().getFocusControl();
        try {
            return focusControl.getClass().getMethod(this.methodName, METHOD_PARAMETERS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public final Object getAttributeValue(String attributeName) throws NoSuchAttributeException {
        if (attributeName.equals(ATTRIBUTE_ENABLED)) {
            return this.getMethodToExecute() == null ? Boolean.FALSE : Boolean.TRUE;
        }
        if (attributeName.equals(ATTRIBUTE_ID)) {
            return null;
        }
        throw new NoSuchAttributeException("This handler doesn't have the '" + attributeName + "' attribute");
    }

    public final Set getDefinedAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.methodName = data.toString();
    }
}

