/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.BoxLayout;
import swingwtx.swing.JPanel;

public class Box
extends JPanel {
    public Box(int axis) {
        this(null, axis);
    }

    public Box(Container target, int axis) {
        if (target != null) {
            target.add(this);
            this.setLayout(new BoxLayout(target, axis));
        } else {
            this.setLayout(new BoxLayout(this, axis));
        }
    }

    public static Box createHorizontalBox() {
        return new Box(0);
    }

    public static Box createVerticalBox() {
        return new Box(1);
    }

    public static Box createHorizontalBox(Container target) {
        return new Box(target, 0);
    }

    public static Box createVerticalBox(Container target) {
        return new Box(target, 1);
    }

    public static Component createRigidArea(Dimension d) {
        return new Filler(d, d, d);
    }

    public static Component createHorizontalStrut(int width) {
        return new Filler(new Dimension(width, 0), new Dimension(width, 0), new Dimension(width, Short.MAX_VALUE));
    }

    public static Component createVerticalStrut(int height) {
        return new Filler(new Dimension(0, height), new Dimension(0, height), new Dimension(Short.MAX_VALUE, height));
    }

    public static Component createGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public static Component createHorizontalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
    }

    public static Component createVerticalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
    }

    public static class Filler
    extends JPanel {
        private Dimension reqMin;
        private Dimension reqPref;
        private Dimension reqMax;

        public Filler(Dimension min, Dimension pref, Dimension max) {
            this.reqMin = min;
            this.reqPref = pref;
            this.reqMax = max;
        }

        public void changeShape(Dimension min, Dimension pref, Dimension max) {
            this.reqMin = min;
            this.reqPref = pref;
            this.reqMax = max;
        }

        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        public Dimension getPreferredSize() {
            return this.reqPref;
        }

        public Dimension getMaximumSize() {
            return this.reqMax;
        }
    }
}

