#ifndef _SubtitleEditor_h
#define _SubtitleEditor_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <iostream>
#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/dialog.h>
#include <gtkmm/label.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/actiongroup.h>
#include <gtkmm/statusbar.h>

#include <libglademm.h>

#include "Document.h"
#include "Dialog.h"
#include "SubtitleView.h"

#include "DialogAbout.h"
#include "DialogChangeFPS.h"
#include "DialogScale.h"
#include "DialogStyleEditor.h"
#include "DialogScriptProperties.h"
#include "DialogFind.h"
#include "DialogMoveSubtitles.h"
#include "TimingSystem.h"

#include "ISubtitleEditor.h"


class SubtitleEditor : public Gtk::Window, public ISubtitleEditor
{
	static SubtitleEditor* m_static_subtitleEditor;
public:
	SubtitleEditor(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
	~SubtitleEditor();
	
	/*
	 *
	 */
	static SubtitleEditor* getInstance();
	
	void open_subtitle(const Glib::ustring &file);
	void open_movie(const Glib::ustring &uri);


	void loadCfg();
	void saveCfg();

	void setStatusbar(const char *format, ...);
	void createMenuBar();
	
	/*
	 *
	 */
	SubtitleView* getSubtitleView();
	
	/*
	 *
	 */
	Document* getDocument();

	
	//Signal&	getSignal();

	// file
	void on_new_subtitle();
	void on_quit();
	void on_open_subtitle();
	void on_save_subtitle();
	void on_save_as_subtitle();
	
	void on_properties();

	void on_import_text();
	void on_export_text();
	// view
	void on_preferences();

	// edit
	void on_select_previous_subtitle();
	void on_select_next_subtitle();

	void on_move_subtitles();

	void on_add_100_ms();
	void on_remove_100_ms();

	void on_add_100_ms_to_start();
	void on_remove_100_ms_to_start();

	void on_add_100_ms_to_duration();
	void on_remove_100_ms_to_duration();

	void on_insert_before_subtitle();
	void on_insert_after_subtitle();
	void on_delete_subtitle();
	void on_change_fps();
	void on_scale();

	void on_move_subtitle_text_forward();
	void on_move_subtitle_text_backward();

	//	tools
	void on_find();
	void on_find_next();
	void on_find_and_replace();
	void on_remove_line_nul();
	void on_check_time();
	void on_spell_check();
	void on_set_all_end_time();
	void on_apply_translation();
	
	void on_split();
	void on_joint();

	// timing
	void on_open_media_for_timing();
	void on_save_waveform();

	void on_timing_play_previous_subtitle();
	void on_timing_play_current_subtitle();
	void on_timing_play_next_subtitle();
	void on_timing_stop();

	void on_timing_play_previous_second();
	void on_timing_play_first_second();
	void on_timing_play_last_second();
	void on_timing_play_next_second();

	// movie
	void on_open_movie();
	void on_play_movie();

	// help
	void on_about();

	//
	void on_style_editor();
	
	template<class T>
	bool create_dialog(const Glib::ustring &name, T **dialog);
protected:

	//Signal		m_signal;

	//Glib::RefPtr<Document>	m_refDocument;
	Document	m_refDocument;

	TimingSystem*				m_timingSystem;
	SubtitleView*				m_treeviewSubtitle;
	Gtk::Statusbar*			m_statusbar;

	// garde en memoire le dernier texte rechercher
	Glib::ustring				last_text_find;

	DialogFindAndReplace*	m_dialogFindAndReplace;

	//
	DialogOpenSubtitle	m_dialogOpenSubtitle;
	DialogSaveSubtitle	m_dialogSaveSubtitle;
	DialogOpenMovie			m_dialogOpenMovie;
	DialogImportText		m_dialogImportText;
	DialogExportText		m_dialogExportText;

	DialogMoveSubtitles*	m_dialogMoveSubtitles;
	DialogScale*				m_dialogScale;
	DialogChangeFPS*		m_dialogChangeFPS;
	DialogSetAllEndTime	m_dialogSetAllEndTime;

	SubtitleColumnRecorder m_column;
};


#endif//_SubtitleEditor_h
