#ifndef _DialogStyleEditor_h
#define _DialogStyleEditor_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <libglademm/xml.h>
#include <gtkmm.h>
#include "ISubtitleEditor.h"


class DialogStyleEditor : public Gtk::Dialog
{
public:
	DialogStyleEditor(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
	
	void execute();

protected:

	/*
	 *	y a t'il un style select pour edition
	 */
	bool has_select();
	
	void on_select_style_changed();

	/*
	 *	init l'interface avec le style select
	 */
	void on_init_style();
	
	void on_entry_name_changed();

	void on_button_font_changed();
	
	void on_button_bold_toggled();
	void on_button_italic_toggled();
	void on_button_underline_toggled();
	void on_button_strikeout_toggled();
	
	void on_color_primary_changed();
	void on_color_secondary_changed();
	void on_color_outline_changed();
	void on_color_shadow_changed();
	
	void on_spin_margin_l_changed();
	void on_spin_margin_r_changed();
	void on_spin_margin_v_changed();

	void on_spin_angle_changed();
	void on_spin_scale_x_changed();
	void on_spin_scale_y_changed();
	void on_spin_spacing_changed();

	void on_radio_outline_changed();
	void on_spin_outline_changed();
	void on_spin_shadow_changed();
	void on_radio_opaque_box_changed();

	void on_button_alignment_changed(unsigned int num);

	void on_new_style();
	void on_delete_style();
	void on_copy_style();
	void on_manage_styles();
protected:
	Document*	ref_document;
	Glib::RefPtr<StyleModel> ref_styleModel;

	StyleColumnRecorder column;
	Gtk::TreeIter				iter;
	
	Gtk::Button*				buttonNewStyle;
	Gtk::Button*				buttonDeleteStyle;
	Gtk::Button*				buttonCopyStyle;
	Gtk::Button*				buttonManageStyles;
	
	Gtk::TreeView*			treeviewStyle;


	Gtk::Widget*				vbox2;	// box widget edit
	Gtk::Entry*					entryName;
	Gtk::FontButton*		buttonFont;

	Gtk::ToggleButton*	buttonBold;
	Gtk::ToggleButton*	buttonItalic;
	Gtk::ToggleButton*	buttonUnderline;
	Gtk::ToggleButton*	buttonStrikeout;

	Gtk::ColorButton*		buttonPrimaryColor;
	Gtk::ColorButton*		buttonSecondaryColor;
	Gtk::ColorButton*		buttonOutlineColor;
	Gtk::ColorButton*		buttonShadowColor;
	
	Gtk::SpinButton*		spinMarginL;
	Gtk::SpinButton*		spinMarginR;
	Gtk::SpinButton*		spinMarginV;

	Gtk::SpinButton*		spinAngle;
	Gtk::SpinButton*		spinScaleX;
	Gtk::SpinButton*		spinScaleY;
	Gtk::SpinButton*		spinSpacing;

	Gtk::RadioButton*		radioOutline;
	Gtk::SpinButton*		spinOutline;
	Gtk::SpinButton*		spinShadow;
	Gtk::RadioButton*		radioOpaqueBox;

	Gtk::ToggleButton*	buttonAlignment[9];
};


#endif//_DialogStyleEditor_h

