/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COPYCMD_H
#define _SC_COPYCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class CopyParam;

/**
 * Command for copying files in working copy or a repository.
 */
class CopyCmd : public ScCmd
{
public:
  /**
   * Construct a CopyCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  CopyCmd( CopyParam* param, CmdResultCallback* cb );
  ~CopyCmd();

  void run();

private:
  // in
  CopyParam*         _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_COPYCMD_H
