/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MOVEDIALOG_H
#define _SC_MOVEDIALOG_H

// sc
class RevisionWidget;
class ExternProvider;
class ExternButton;
namespace svn
{
  class Revision;
}

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;


class MoveDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  MoveDialog( ExternProvider* p, QWidget *parent = 0, const char *name=0 );
  virtual ~MoveDialog();

  //void enableRepositoryUrl( bool enable );
  //void enableWorkingCopyPath( bool enable );

  //QString getRepositoryUrl();
  //void setRepositoryUrl( QString& url );

  QString getWcTargetPath();
  void setWcTargetPath( QString& path );

  svn::Revision* getRevision();
  bool isForce();

public slots:
  void selectWcPath();
  void checkOk( const QString& text );

private slots:
  void repExtern();

private:
  void handleExtern( QComboBox* e );

private:
  RevisionWidget* _rw;

  QCheckBox*      _force;

  //QComboBox*      _rep;
  //ExternButton*   _repEx;

  QComboBox*      _wc;
  ExternButton*   _wcEx;

  QPushButton*    _ok;

  ExternProvider* _p;
};

#endif // _SC_MOVEDIALOG_H
