/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _COMMANDARGS_H
#define _COMMANDARGS_H

// sc
#include "util/String.h"

// apr
struct apr_pool_t;


class CommandArgs
{
public:
  CommandArgs( const sc::String& pattern, apr_pool_t* pool );

  // in
  void setArg( const sc::String& key, const sc::String& value );

  // out
  const sc::String& getPath() const;
  char**            getArgs() const;

private:
  apr_pool_t* _pool;

  sc::String  _path;
  char**      _args;
};

#endif // _COMMANDARGS_H
