/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_PROPERTY_H
#define _SVN_PROPERTY_H

// sc
#include "util/String.h"

// sys
#include <vector>

// svn
struct svn_prop_t;


namespace svn
{

/**
 * This struct represents the subversion type
 * - svn_props/svn_prop_t
 */
// 
class Property
{
public:
  Property( svn_prop_t* );

  const sc::String& getName() const;
  const sc::String& getValue() const;
  bool needsTranslation() const;

  static bool needsTranslation( const sc::String& name );

private:
  sc::String _name;
  sc::String _value;
};

typedef std::vector< Property >  Properties;

} // namespace

#endif // _SVN_PROPERTY_H

