/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse spl_yyparse
#define yylex   spl_yylex
#define yyerror spl_yyerror
#define yylval  spl_yylval
#define yychar  spl_yychar
#define yydebug spl_yydebug
#define yynerrs spl_yynerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID = 258,
     FUNC_ID = 259,
     VALUE = 260,
     SPECIALREF = 261,
     NOTOKEN = 262,
     TRANSLATE_PREFIX = 263,
     TRANSLATE_SEPERATOR = 264,
     TRANSLATE_END = 265,
     STRING_EOL = 266,
     STRING_EOL_S = 267,
     STRING_LABEL = 268,
     STRING_LABEL_S = 269,
     DBLCOMMA = 270,
     DEBUG = 271,
     WARNING = 272,
     ERROR = 273,
     DELETE = 274,
     FUNCTION = 275,
     METHOD = 276,
     IMPORT = 277,
     LOAD = 278,
     OBJECT = 279,
     VAR = 280,
     STATIC = 281,
     NEW = 282,
     THIS = 283,
     IF = 284,
     ELSE = 285,
     DO = 286,
     WHILE = 287,
     FOR = 288,
     FOREACH = 289,
     ASM = 290,
     RETURN = 291,
     EXIT = 292,
     DECLARED = 293,
     UNDEF = 294,
     GOTO = 295,
     BREAK = 296,
     CONTINUE = 297,
     ARRAYREF = 298,
     TRY = 299,
     CATCH = 300,
     THROW = 301,
     SWITCH = 302,
     DEFAULT = 303,
     CASE = 304,
     EF_BEGIN = 305,
     EF_END = 306,
     BLK_BEGIN_NOCTX = 307,
     INSERT_PROG_BEGIN = 308,
     INSERT_PROG_END = 309,
     RVALUE_CONTEXT_BEGIN = 310,
     RVALUE_CONTEXT_END = 311,
     XCHG = 312,
     SAPPEND = 313,
     OPOWEQ = 314,
     OMODEQ = 315,
     ODIVEQ = 316,
     OMULEQ = 317,
     OSUBEQ = 318,
     OADDEQ = 319,
     FPOWEQ = 320,
     FMODEQ = 321,
     FDIVEQ = 322,
     FMULEQ = 323,
     FSUBEQ = 324,
     FADDEQ = 325,
     IPOWEQ = 326,
     IMODEQ = 327,
     IDIVEQ = 328,
     IMULEQ = 329,
     ISUBEQ = 330,
     IADDEQ = 331,
     POWEQ = 332,
     MODEQ = 333,
     DIVEQ = 334,
     MULEQ = 335,
     SUBEQ = 336,
     ADDEQ = 337,
     SETCOPY = 338,
     LOR = 339,
     LAND = 340,
     REGEX_SEP = 341,
     NREGEX_EVAL_R = 342,
     REGEX_EVAL_R = 343,
     NREGEX_EVAL = 344,
     REGEX_EVAL = 345,
     NREGEX_SUBST_R = 346,
     REGEX_SUBST_R = 347,
     NREGEX_SUBST = 348,
     REGEX_SUBST = 349,
     NREGEX = 350,
     REGEX = 351,
     SGE = 352,
     SLE = 353,
     SGT = 354,
     SLT = 355,
     SNE = 356,
     SEQ = 357,
     OGE = 358,
     OLE = 359,
     OGT = 360,
     OLT = 361,
     ONE = 362,
     OEQ = 363,
     FGE = 364,
     FLE = 365,
     FGT = 366,
     FLT = 367,
     FNE = 368,
     FEQ = 369,
     IGE = 370,
     ILE = 371,
     IGT = 372,
     ILT = 373,
     INE = 374,
     IEQ = 375,
     GE = 376,
     LE = 377,
     GT = 378,
     LT = 379,
     NE = 380,
     EQ = 381,
     PNE = 382,
     PEQ = 383,
     ELEMENTSOF = 384,
     LENGTHOF = 385,
     EVAL = 386,
     PREV = 387,
     NEXT = 388,
     UNSHIFT = 389,
     PUSH = 390,
     SHIFT = 391,
     POP = 392,
     OADD = 393,
     OSUB = 394,
     FADD = 395,
     FSUB = 396,
     IADD = 397,
     ISUB = 398,
     ADD = 399,
     SUB = 400,
     OMOD = 401,
     ODIV = 402,
     OMUL = 403,
     FMOD = 404,
     FDIV = 405,
     FMUL = 406,
     IMOD = 407,
     IDIV = 408,
     IMUL = 409,
     MOD = 410,
     DIV = 411,
     MUL = 412,
     OPOW = 413,
     FPOW = 414,
     IPOW = 415,
     POW = 416,
     LNOT = 417,
     DEC = 418,
     INC = 419,
     NEG = 420,
     DEFINED = 421,
     ENC = 422,
     CAT = 423
   };
#endif
#define ID 258
#define FUNC_ID 259
#define VALUE 260
#define SPECIALREF 261
#define NOTOKEN 262
#define TRANSLATE_PREFIX 263
#define TRANSLATE_SEPERATOR 264
#define TRANSLATE_END 265
#define STRING_EOL 266
#define STRING_EOL_S 267
#define STRING_LABEL 268
#define STRING_LABEL_S 269
#define DBLCOMMA 270
#define DEBUG 271
#define WARNING 272
#define ERROR 273
#define DELETE 274
#define FUNCTION 275
#define METHOD 276
#define IMPORT 277
#define LOAD 278
#define OBJECT 279
#define VAR 280
#define STATIC 281
#define NEW 282
#define THIS 283
#define IF 284
#define ELSE 285
#define DO 286
#define WHILE 287
#define FOR 288
#define FOREACH 289
#define ASM 290
#define RETURN 291
#define EXIT 292
#define DECLARED 293
#define UNDEF 294
#define GOTO 295
#define BREAK 296
#define CONTINUE 297
#define ARRAYREF 298
#define TRY 299
#define CATCH 300
#define THROW 301
#define SWITCH 302
#define DEFAULT 303
#define CASE 304
#define EF_BEGIN 305
#define EF_END 306
#define BLK_BEGIN_NOCTX 307
#define INSERT_PROG_BEGIN 308
#define INSERT_PROG_END 309
#define RVALUE_CONTEXT_BEGIN 310
#define RVALUE_CONTEXT_END 311
#define XCHG 312
#define SAPPEND 313
#define OPOWEQ 314
#define OMODEQ 315
#define ODIVEQ 316
#define OMULEQ 317
#define OSUBEQ 318
#define OADDEQ 319
#define FPOWEQ 320
#define FMODEQ 321
#define FDIVEQ 322
#define FMULEQ 323
#define FSUBEQ 324
#define FADDEQ 325
#define IPOWEQ 326
#define IMODEQ 327
#define IDIVEQ 328
#define IMULEQ 329
#define ISUBEQ 330
#define IADDEQ 331
#define POWEQ 332
#define MODEQ 333
#define DIVEQ 334
#define MULEQ 335
#define SUBEQ 336
#define ADDEQ 337
#define SETCOPY 338
#define LOR 339
#define LAND 340
#define REGEX_SEP 341
#define NREGEX_EVAL_R 342
#define REGEX_EVAL_R 343
#define NREGEX_EVAL 344
#define REGEX_EVAL 345
#define NREGEX_SUBST_R 346
#define REGEX_SUBST_R 347
#define NREGEX_SUBST 348
#define REGEX_SUBST 349
#define NREGEX 350
#define REGEX 351
#define SGE 352
#define SLE 353
#define SGT 354
#define SLT 355
#define SNE 356
#define SEQ 357
#define OGE 358
#define OLE 359
#define OGT 360
#define OLT 361
#define ONE 362
#define OEQ 363
#define FGE 364
#define FLE 365
#define FGT 366
#define FLT 367
#define FNE 368
#define FEQ 369
#define IGE 370
#define ILE 371
#define IGT 372
#define ILT 373
#define INE 374
#define IEQ 375
#define GE 376
#define LE 377
#define GT 378
#define LT 379
#define NE 380
#define EQ 381
#define PNE 382
#define PEQ 383
#define ELEMENTSOF 384
#define LENGTHOF 385
#define EVAL 386
#define PREV 387
#define NEXT 388
#define UNSHIFT 389
#define PUSH 390
#define SHIFT 391
#define POP 392
#define OADD 393
#define OSUB 394
#define FADD 395
#define FSUB 396
#define IADD 397
#define ISUB 398
#define ADD 399
#define SUB 400
#define OMOD 401
#define ODIV 402
#define OMUL 403
#define FMOD 404
#define FDIV 405
#define FMUL 406
#define IMOD 407
#define IDIV 408
#define IMUL 409
#define MOD 410
#define DIV 411
#define MUL 412
#define OPOW 413
#define FPOW 414
#define IPOW 415
#define POW 416
#define LNOT 417
#define DEC 418
#define INC 419
#define NEG 420
#define DEFINED 421
#define ENC 422
#define CAT 423




/* Copy the first part of user declarations.  */
#line 30 "compiler.y"


#define _GNU_SOURCE

#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <stdio.h>
#include <ctype.h>

#ifdef ENABLE_PTHREAD_SUPPORT
#include <pthread.h>
#endif

#include "spl.h"

#define COMPAT_H_NO_WIN_INCL
#include "compat.h"

static int spl_yylex (void);
static void spl_yyerror (char const *);

static struct spl_asm *as;

static int gen_debug_info;
static int no_checkp_insn;
static void create_debug_op(int force);

static int rvtolv_counter;
static int import_asm_label_counter;

static int label_stack[1024];
static int label_stack_index;
static int label_stack_counter;

static void lbstack_push() {
	label_stack[++label_stack_index] = ++label_stack_counter;
}

static void lbstack_pop() {
	label_stack_index--;
}

static int lbstack_value() {
	return label_stack[label_stack_index];
}

static int breakcont_stack[1024];
static int breakcont_stack_index;
static int breakcont_stack_counter;

static void breakcont_begin() {
	breakcont_stack[++breakcont_stack_index] = ++breakcont_stack_counter;
}

static void breakcont_end() {
	breakcont_stack_index--;
}

static int breakcont_value() {
	return breakcont_stack[breakcont_stack_index];
}

static int breakcont_label(char type) {
	char label[100];
	snprintf(label, 100, "%c%d:%d", type, lbstack_value(), breakcont_value());
	if ( spl_asm_setlabel(as, label, spl_asm_add(as, SPL_OP_NOP, 0)) < 0 ) {
		spl_yyerror("Assembler error"); free(label); return 1;
	}

	return 0;
}

static void breakcont_goto(char type) {
	char label[100];
	snprintf(label, 100, "%c%d:%d", type, lbstack_value(), breakcont_value());
	spl_asm_reflabel(as, label, spl_asm_add(as, SPL_OP_GOTO, 0));
}

static int packpatch_stack[1024];
static int packpatch_stack_index;

static int pbstack_push(int v) {
	return packpatch_stack[packpatch_stack_index++] = v;
}

static int pbstack_pop() {
	return packpatch_stack[--packpatch_stack_index];
}

static int php_like_tags_active;
static int php_like_tags_indenting_delim;
static char *php_like_tags_term;

#ifdef ENABLE_PTHREAD_SUPPORT
static pthread_mutex_t compiler_lck = PTHREAD_MUTEX_INITIALIZER;
#endif

#define CHECKPOINT() \
	do { if (!no_checkp_insn) spl_asm_add(as, SPL_OP_CHECKP, 0); } while (0)

#define REGEX_EVAL_SUBST  1
#define REGEX_EVAL_RETURN 2
#define REGEX_EVAL_NEG    4



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 146 "compiler.y"
typedef union YYSTYPE {
	char *text;
	char ch;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 533 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 545 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3923

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  184
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  127
/* YYNRULES -- Number of rules. */
#define YYNRULES  332
/* YYNRULES -- Number of states. */
#define YYNSTATES  667

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   423

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,   181,   180,     2,     2,     2,
     176,   177,     2,     2,   178,     2,    50,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   175,   173,
       2,    58,     2,   182,   183,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   179,     2,   174,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   171,     2,   172,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    51,    52,    53,    54,    55,
      56,    57,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     4,     5,     9,    10,    15,    18,    23,
      25,    30,    31,    36,    40,    42,    44,    48,    52,    53,
      61,    62,    63,    64,    73,    74,    75,    76,    87,    88,
      89,    90,    91,    92,    93,   109,   110,   111,   121,   122,
     123,   135,   136,   144,   145,   152,   153,   154,   165,   169,
     170,   171,   179,   183,   187,   188,   192,   195,   196,   201,
     205,   209,   213,   217,   221,   222,   225,   226,   229,   231,
     235,   239,   241,   245,   247,   251,   253,   257,   259,   263,
     264,   265,   269,   271,   274,   275,   281,   283,   286,   287,
     291,   295,   298,   301,   302,   304,   306,   309,   312,   315,
     318,   321,   322,   328,   330,   334,   336,   338,   340,   341,
     345,   347,   351,   353,   355,   357,   360,   362,   365,   368,
     371,   374,   377,   380,   384,   385,   390,   393,   396,   399,
     401,   404,   407,   408,   414,   415,   416,   427,   428,   433,
     434,   443,   444,   445,   446,   453,   454,   461,   462,   467,
     469,   470,   471,   480,   481,   482,   483,   493,   494,   502,
     503,   510,   512,   516,   521,   526,   528,   532,   536,   537,
     542,   543,   548,   549,   554,   555,   560,   561,   566,   567,
     572,   573,   578,   579,   584,   585,   590,   591,   596,   597,
     602,   603,   608,   609,   614,   615,   620,   621,   626,   627,
     632,   633,   638,   639,   644,   645,   650,   651,   656,   657,
     662,   663,   668,   669,   674,   675,   680,   681,   686,   687,
     688,   696,   699,   702,   707,   712,   717,   722,   725,   727,
     729,   733,   737,   741,   745,   749,   753,   757,   761,   765,
     769,   773,   777,   781,   785,   789,   793,   797,   801,   805,
     809,   813,   817,   821,   825,   829,   833,   837,   841,   845,
     849,   853,   857,   861,   865,   869,   873,   877,   881,   885,
     889,   893,   897,   901,   905,   909,   913,   917,   921,   925,
     929,   933,   937,   941,   945,   949,   953,   954,   959,   960,
     965,   972,   981,   990,   991,   999,  1000,  1010,  1011,  1021,
    1022,  1023,  1032,  1033,  1036,  1037,  1039,  1043,  1044,  1049,
    1053,  1055,  1059,  1061,  1062,  1064,  1068,  1070,  1073,  1076,
    1077,  1079,  1083,  1084,  1086,  1090,  1091,  1094,  1096,  1099,
    1102,  1106,  1108
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     185,     0,    -1,    -1,    -1,   185,   186,   187,    -1,    -1,
     171,   188,   185,   172,    -1,   262,   173,    -1,   233,    59,
     233,   173,    -1,   173,    -1,    53,   185,   174,   172,    -1,
      -1,     3,   175,   189,   187,    -1,    40,     3,   173,    -1,
      41,    -1,    42,    -1,    25,   217,   173,    -1,    26,   219,
     173,    -1,    -1,    29,   176,   262,   177,   190,   187,   221,
      -1,    -1,    -1,    -1,    32,   191,   176,   262,   177,   192,
     187,   193,    -1,    -1,    -1,    -1,    31,   194,   187,   195,
      32,   176,   262,   177,   173,   196,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    33,   176,   197,   216,   173,   198,   262,
     173,   199,   200,   216,   177,   201,   187,   202,    -1,    -1,
      -1,    34,   230,     3,   203,   176,   262,   177,   204,   187,
      -1,    -1,    -1,   231,     3,   176,   205,   303,   298,   177,
     206,   171,   185,   172,    -1,    -1,    24,   233,   233,   171,
     207,   185,   172,    -1,    -1,    24,   233,   171,   208,   185,
     172,    -1,    -1,    -1,    44,   176,     3,   177,   171,   209,
     185,   210,   223,   172,    -1,    46,   262,   173,    -1,    -1,
      -1,    47,   171,   211,   185,   212,   226,   172,    -1,    35,
     215,   173,    -1,    36,   262,   173,    -1,    -1,    36,   173,
     213,    -1,    37,   173,    -1,    -1,    19,   233,   173,   214,
      -1,    16,   262,   173,    -1,    17,   262,   173,    -1,    18,
     262,   173,    -1,    22,   262,   173,    -1,    23,   262,   173,
      -1,    -1,   215,     5,    -1,    -1,    25,   217,    -1,   262,
      -1,   216,   178,   262,    -1,   216,    15,   262,    -1,   218,
      -1,   217,   178,   218,    -1,   233,    -1,   233,    58,   262,
      -1,   220,    -1,   219,   178,   218,    -1,   233,    -1,   233,
      58,   262,    -1,    -1,    -1,    30,   222,   187,    -1,   224,
      -1,   223,   224,    -1,    -1,    45,     3,   175,   225,   185,
      -1,   227,    -1,   226,   227,    -1,    -1,   229,   228,   185,
      -1,    49,   262,   175,    -1,    48,   175,    -1,   179,   174,
      -1,    -1,    20,    -1,    21,    -1,   290,    90,    -1,   290,
      89,    -1,   233,    92,    -1,   233,    91,    -1,   236,   237,
      -1,    -1,   235,    50,   234,   238,   237,    -1,   253,    -1,
     176,   262,   177,    -1,     3,    -1,    28,    -1,     6,    -1,
      -1,    50,   238,   237,    -1,     3,    -1,   179,   262,   174,
      -1,     6,    -1,     5,    -1,   239,    -1,   240,   239,    -1,
     261,    -1,   233,   166,    -1,   233,   165,    -1,   166,   233,
      -1,   165,   233,    -1,   132,   241,    -1,   131,   241,    -1,
     241,   170,   241,    -1,    -1,     3,   169,   242,   290,    -1,
     146,   290,    -1,   147,   290,    -1,   164,   290,    -1,    39,
      -1,   168,   241,    -1,    38,   233,    -1,    -1,   179,   243,
     299,   298,   174,    -1,    -1,    -1,   231,   176,   244,   303,
     298,   177,   245,   171,   185,   172,    -1,    -1,    51,   246,
     185,    52,    -1,    -1,    54,   215,   173,   247,   185,    55,
     215,   173,    -1,    -1,    -1,    -1,    56,   248,   249,   290,
      57,   250,    -1,    -1,   302,   176,   251,   305,   298,   177,
      -1,    -1,     8,   252,   306,    10,    -1,   253,    -1,    -1,
      -1,    27,   254,   261,   176,   255,   305,   298,   177,    -1,
      -1,    -1,    -1,   159,   256,   302,   176,   257,   258,   305,
     298,   177,    -1,    -1,   180,     3,   176,   259,   305,   298,
     177,    -1,    -1,     4,   176,   260,   305,   298,   177,    -1,
     240,    -1,   176,   262,   177,    -1,   181,   176,   262,   177,
      -1,    50,   176,   262,   177,    -1,   233,    -1,   233,    58,
     262,    -1,   233,    85,   262,    -1,    -1,   233,    84,   263,
     262,    -1,    -1,   233,    83,   264,   262,    -1,    -1,   233,
      82,   265,   262,    -1,    -1,   233,    81,   266,   262,    -1,
      -1,   233,    80,   267,   262,    -1,    -1,   233,    79,   268,
     262,    -1,    -1,   233,    78,   269,   262,    -1,    -1,   233,
      77,   270,   262,    -1,    -1,   233,    76,   271,   262,    -1,
      -1,   233,    75,   272,   262,    -1,    -1,   233,    74,   273,
     262,    -1,    -1,   233,    73,   274,   262,    -1,    -1,   233,
      72,   275,   262,    -1,    -1,   233,    71,   276,   262,    -1,
      -1,   233,    70,   277,   262,    -1,    -1,   233,    69,   278,
     262,    -1,    -1,   233,    68,   279,   262,    -1,    -1,   233,
      67,   280,   262,    -1,    -1,   233,    66,   281,   262,    -1,
      -1,   233,    65,   282,   262,    -1,    -1,   233,    64,   283,
     262,    -1,    -1,   233,    63,   284,   262,    -1,    -1,   233,
      62,   285,   262,    -1,    -1,   233,    61,   286,   262,    -1,
      -1,   233,    60,   287,   262,    -1,    -1,    -1,   290,   182,
     288,   262,   175,   289,   262,    -1,   139,   241,    -1,   138,
     241,    -1,   137,   233,   178,   262,    -1,   136,   233,   178,
     262,    -1,   135,   290,   178,   241,    -1,   134,   290,   178,
     241,    -1,   133,   241,    -1,   290,    -1,   241,    -1,   290,
     130,   290,    -1,   290,   129,   290,    -1,   290,   146,   290,
      -1,   290,   147,   290,    -1,   290,   159,   290,    -1,   290,
     158,   290,    -1,   290,   157,   290,    -1,   290,   163,   290,
      -1,   290,   128,   290,    -1,   290,   127,   290,    -1,   290,
     126,   290,    -1,   290,   123,   290,    -1,   290,   124,   290,
      -1,   290,   125,   290,    -1,   290,   144,   290,    -1,   290,
     145,   290,    -1,   290,   156,   290,    -1,   290,   155,   290,
      -1,   290,   154,   290,    -1,   290,   162,   290,    -1,   290,
     122,   290,    -1,   290,   121,   290,    -1,   290,   120,   290,
      -1,   290,   117,   290,    -1,   290,   118,   290,    -1,   290,
     119,   290,    -1,   290,   142,   290,    -1,   290,   143,   290,
      -1,   290,   153,   290,    -1,   290,   152,   290,    -1,   290,
     151,   290,    -1,   290,   161,   290,    -1,   290,   116,   290,
      -1,   290,   115,   290,    -1,   290,   114,   290,    -1,   290,
     111,   290,    -1,   290,   112,   290,    -1,   290,   113,   290,
      -1,   290,   140,   290,    -1,   290,   141,   290,    -1,   290,
     150,   290,    -1,   290,   149,   290,    -1,   290,   148,   290,
      -1,   290,   160,   290,    -1,   290,   110,   290,    -1,   290,
     109,   290,    -1,   290,   108,   290,    -1,   290,   105,   290,
      -1,   290,   106,   290,    -1,   290,   107,   290,    -1,   290,
     104,   290,    -1,   290,   103,   290,    -1,   290,   102,   290,
      -1,   290,    99,   290,    -1,   290,   100,   290,    -1,   290,
     101,   290,    -1,    -1,   290,    86,   291,   290,    -1,    -1,
     290,    87,   292,   290,    -1,   290,    98,   290,    88,   290,
      88,    -1,   290,    94,   290,    88,   290,    88,   290,    88,
      -1,   233,    96,   290,    88,   290,    88,   290,    88,    -1,
      -1,   290,    97,   290,    88,   290,    88,   293,    -1,    -1,
     290,    93,   290,    88,   290,    88,   290,    88,   294,    -1,
      -1,   233,    95,   290,    88,   290,    88,   290,    88,   295,
      -1,    -1,    -1,   232,   296,   290,    88,   290,    88,   297,
     290,    -1,    -1,   178,   298,    -1,    -1,   300,    -1,   299,
     178,   300,    -1,    -1,   262,    43,   301,   262,    -1,   310,
     175,   262,    -1,   262,    -1,   176,   262,   177,    -1,   233,
      -1,    -1,   304,    -1,   303,   178,   304,    -1,     3,    -1,
     183,     3,    -1,   157,     3,    -1,    -1,   307,    -1,   305,
     178,   307,    -1,    -1,   307,    -1,   306,     9,   307,    -1,
      -1,   308,   309,    -1,   262,    -1,   183,   262,    -1,   157,
     262,    -1,   310,   175,   262,    -1,     5,    -1,   233,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   237,   237,   238,   238,   243,   242,   247,   250,   253,
     256,   261,   260,   272,   281,   284,   287,   290,   294,   293,
     299,   305,   307,   298,   319,   324,   326,   318,   336,   341,
     343,   344,   348,   350,   336,   375,   386,   374,   437,   443,
     436,   463,   462,   475,   474,   497,   511,   496,   526,   530,
     532,   529,   544,   547,   551,   550,   554,   558,   557,   561,
     564,   567,   570,   573,   578,   579,   592,   593,   594,   595,
     596,   600,   601,   605,   606,   610,   611,   615,   616,   626,
     628,   627,   638,   639,   644,   643,   674,   675,   680,   679,
     696,   697,   702,   703,   707,   708,   712,   713,   714,   715,
     719,   722,   721,   735,   736,   740,   742,   744,   748,   749,
     754,   757,   760,   765,   769,   770,   781,   783,   784,   785,
     786,   788,   789,   791,   794,   793,   804,   805,   806,   808,
     810,   812,   816,   815,   820,   825,   819,   837,   836,   851,
     850,   856,   857,   859,   855,   863,   862,   872,   871,   879,
     884,   886,   883,   903,   905,   906,   902,   923,   922,   932,
     931,   942,   943,   945,   948,   951,   955,   957,   961,   960,
     972,   971,   983,   982,   994,   993,  1005,  1004,  1016,  1015,
    1027,  1026,  1038,  1037,  1049,  1048,  1060,  1059,  1071,  1070,
    1082,  1081,  1093,  1092,  1104,  1103,  1115,  1114,  1126,  1125,
    1137,  1136,  1148,  1147,  1159,  1158,  1170,  1169,  1181,  1180,
    1192,  1191,  1203,  1202,  1214,  1213,  1225,  1224,  1236,  1241,
    1235,  1251,  1253,  1255,  1257,  1259,  1261,  1264,  1267,  1271,
    1273,  1274,  1276,  1277,  1278,  1279,  1280,  1281,  1283,  1284,
    1285,  1286,  1287,  1288,  1290,  1291,  1292,  1293,  1294,  1295,
    1297,  1298,  1299,  1300,  1301,  1302,  1304,  1305,  1306,  1307,
    1308,  1309,  1311,  1312,  1313,  1314,  1315,  1316,  1318,  1319,
    1320,  1321,  1322,  1323,  1325,  1326,  1327,  1328,  1329,  1330,
    1332,  1333,  1334,  1335,  1336,  1337,  1345,  1344,  1357,  1356,
    1368,  1371,  1374,  1378,  1377,  1382,  1381,  1386,  1385,  1390,
    1409,  1389,  1504,  1505,  1508,  1509,  1510,  1515,  1514,  1518,
    1520,  1525,  1526,  1529,  1530,  1531,  1535,  1537,  1544,  1554,
    1555,  1556,  1559,  1560,  1561,  1565,  1565,  1572,  1588,  1605,
    1622,  1641,  1642
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "FUNC_ID", "VALUE", "SPECIALREF", 
  "NOTOKEN", "TRANSLATE_PREFIX", "TRANSLATE_SEPERATOR", "TRANSLATE_END", 
  "STRING_EOL", "STRING_EOL_S", "STRING_LABEL", "STRING_LABEL_S", 
  "DBLCOMMA", "DEBUG", "WARNING", "ERROR", "DELETE", "FUNCTION", "METHOD", 
  "IMPORT", "LOAD", "OBJECT", "VAR", "STATIC", "NEW", "THIS", "IF", 
  "ELSE", "DO", "WHILE", "FOR", "FOREACH", "ASM", "RETURN", "EXIT", 
  "DECLARED", "UNDEF", "GOTO", "BREAK", "CONTINUE", "ARRAYREF", "TRY", 
  "CATCH", "THROW", "SWITCH", "DEFAULT", "CASE", "'.'", "EF_BEGIN", 
  "EF_END", "BLK_BEGIN_NOCTX", "INSERT_PROG_BEGIN", "INSERT_PROG_END", 
  "RVALUE_CONTEXT_BEGIN", "RVALUE_CONTEXT_END", "'='", "XCHG", "SAPPEND", 
  "OPOWEQ", "OMODEQ", "ODIVEQ", "OMULEQ", "OSUBEQ", "OADDEQ", "FPOWEQ", 
  "FMODEQ", "FDIVEQ", "FMULEQ", "FSUBEQ", "FADDEQ", "IPOWEQ", "IMODEQ", 
  "IDIVEQ", "IMULEQ", "ISUBEQ", "IADDEQ", "POWEQ", "MODEQ", "DIVEQ", 
  "MULEQ", "SUBEQ", "ADDEQ", "SETCOPY", "LOR", "LAND", "REGEX_SEP", 
  "NREGEX_EVAL_R", "REGEX_EVAL_R", "NREGEX_EVAL", "REGEX_EVAL", 
  "NREGEX_SUBST_R", "REGEX_SUBST_R", "NREGEX_SUBST", "REGEX_SUBST", 
  "NREGEX", "REGEX", "SGE", "SLE", "SGT", "SLT", "SNE", "SEQ", "OGE", 
  "OLE", "OGT", "OLT", "ONE", "OEQ", "FGE", "FLE", "FGT", "FLT", "FNE", 
  "FEQ", "IGE", "ILE", "IGT", "ILT", "INE", "IEQ", "GE", "LE", "GT", "LT", 
  "NE", "EQ", "PNE", "PEQ", "ELEMENTSOF", "LENGTHOF", "EVAL", "PREV", 
  "NEXT", "UNSHIFT", "PUSH", "SHIFT", "POP", "OADD", "OSUB", "FADD", 
  "FSUB", "IADD", "ISUB", "ADD", "SUB", "OMOD", "ODIV", "OMUL", "FMOD", 
  "FDIV", "FMUL", "IMOD", "IDIV", "IMUL", "MOD", "DIV", "MUL", "OPOW", 
  "FPOW", "IPOW", "POW", "LNOT", "DEC", "INC", "NEG", "DEFINED", "ENC", 
  "CAT", "'{'", "'}'", "';'", "']'", "':'", "'('", "')'", "','", "'['", 
  "'$'", "'#'", "'?'", "'@'", "$accept", "prog", "@1", "cmd", "@2", "@3", 
  "@4", "@5", "@6", "@7", "@8", "@9", "@10", "@11", "@12", "@13", "@14", 
  "@15", "@16", "@17", "@18", "@19", "@20", "@21", "@22", "@23", "@24", 
  "@25", "@26", "@27", "@28", "asm_list", "for_cmds", "var_decl", 
  "var_decl_entry", "static_decl", "static_decl_entry", "else_branch", 
  "@29", "catch_list", "catch_list_entry", "@30", "case_list", 
  "case_list_entry", "@31", "case_list_entry_cond", "foreach_type", 
  "function_method", "regex_eval_mode", "lvalue", "@32", 
  "rvalue_to_lvalue_head", "lvalue_head", "lvalue_tail_list", 
  "lvalue_tail", "val_list_entry", "val_list", "rvalue", "@33", "@34", 
  "@35", "@36", "@37", "@38", "@39", "@40", "@41", "@42", "@43", 
  "simple_call", "@44", "@45", "@46", "@47", "@48", "@49", "@50", 
  "rvalue_primitives", "complex_expr", "@51", "@52", "@53", "@54", "@55", 
  "@56", "@57", "@58", "@59", "@60", "@61", "@62", "@63", "@64", "@65", 
  "@66", "@67", "@68", "@69", "@70", "@71", "@72", "@73", "@74", "@75", 
  "@76", "@77", "basic_expr", "@78", "@79", "@80", "@81", "@82", "@83", 
  "@84", "optional_list_tail", "array_list", "array_element", "@85", 
  "func_expr", "arglist_def", "arglist_def_entry", "arglist_call", 
  "translate_args", "arglist_call_entry", "@86", 
  "arglist_call_entry_tail", "hash_index_lvalue", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      46,   305,   306,   307,   308,   309,   310,   311,    61,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   123,   125,    59,    93,    58,    40,    41,    44,    91,
      36,    35,    63,    64
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   184,   185,   186,   185,   188,   187,   187,   187,   187,
     187,   189,   187,   187,   187,   187,   187,   187,   190,   187,
     191,   192,   193,   187,   194,   195,   196,   187,   197,   198,
     199,   200,   201,   202,   187,   203,   204,   187,   205,   206,
     187,   207,   187,   208,   187,   209,   210,   187,   187,   211,
     212,   187,   187,   187,   213,   187,   187,   214,   187,   187,
     187,   187,   187,   187,   215,   215,   216,   216,   216,   216,
     216,   217,   217,   218,   218,   219,   219,   220,   220,   221,
     222,   221,   223,   223,   225,   224,   226,   226,   228,   227,
     229,   229,   230,   230,   231,   231,   232,   232,   232,   232,
     233,   234,   233,   235,   235,   236,   236,   236,   237,   237,
     238,   238,   238,   239,   240,   240,   241,   241,   241,   241,
     241,   241,   241,   241,   242,   241,   241,   241,   241,   241,
     241,   241,   243,   241,   244,   245,   241,   246,   241,   247,
     241,   248,   249,   250,   241,   251,   241,   252,   241,   241,
     254,   255,   253,   256,   257,   258,   253,   259,   253,   260,
     253,   261,   261,   261,   261,   261,   262,   262,   263,   262,
     264,   262,   265,   262,   266,   262,   267,   262,   268,   262,
     269,   262,   270,   262,   271,   262,   272,   262,   273,   262,
     274,   262,   275,   262,   276,   262,   277,   262,   278,   262,
     279,   262,   280,   262,   281,   262,   282,   262,   283,   262,
     284,   262,   285,   262,   286,   262,   287,   262,   288,   289,
     262,   262,   262,   262,   262,   262,   262,   262,   262,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   291,   290,   292,   290,
     290,   290,   290,   293,   290,   294,   290,   295,   290,   296,
     297,   290,   298,   298,   299,   299,   299,   301,   300,   300,
     300,   302,   302,   303,   303,   303,   304,   304,   304,   305,
     305,   305,   306,   306,   306,   308,   307,   309,   309,   309,
     309,   310,   310
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     0,     3,     0,     4,     2,     4,     1,
       4,     0,     4,     3,     1,     1,     3,     3,     0,     7,
       0,     0,     0,     8,     0,     0,     0,    10,     0,     0,
       0,     0,     0,     0,    15,     0,     0,     9,     0,     0,
      11,     0,     7,     0,     6,     0,     0,    10,     3,     0,
       0,     7,     3,     3,     0,     3,     2,     0,     4,     3,
       3,     3,     3,     3,     0,     2,     0,     2,     1,     3,
       3,     1,     3,     1,     3,     1,     3,     1,     3,     0,
       0,     3,     1,     2,     0,     5,     1,     2,     0,     3,
       3,     2,     2,     0,     1,     1,     2,     2,     2,     2,
       2,     0,     5,     1,     3,     1,     1,     1,     0,     3,
       1,     3,     1,     1,     1,     2,     1,     2,     2,     2,
       2,     2,     2,     3,     0,     4,     2,     2,     2,     1,
       2,     2,     0,     5,     0,     0,    10,     0,     4,     0,
       8,     0,     0,     0,     6,     0,     6,     0,     4,     1,
       0,     0,     8,     0,     0,     0,     9,     0,     7,     0,
       6,     1,     3,     4,     4,     1,     3,     3,     0,     4,
       0,     4,     0,     4,     0,     4,     0,     4,     0,     4,
       0,     4,     0,     4,     0,     4,     0,     4,     0,     4,
       0,     4,     0,     4,     0,     4,     0,     4,     0,     4,
       0,     4,     0,     4,     0,     4,     0,     4,     0,     4,
       0,     4,     0,     4,     0,     4,     0,     4,     0,     0,
       7,     2,     2,     4,     4,     4,     4,     2,     1,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     0,     4,     0,     4,
       6,     8,     8,     0,     7,     0,     9,     0,     9,     0,
       0,     8,     0,     2,     0,     1,     3,     0,     4,     3,
       1,     3,     1,     0,     1,     3,     1,     2,     2,     0,
       1,     3,     0,     1,     3,     0,     2,     1,     2,     2,
       3,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       2,     3,     1,     0,   105,     0,   113,   107,   147,     0,
       0,     0,     0,    94,    95,     0,     0,     0,     0,     0,
     150,   106,     0,    24,    20,     0,    93,    64,     0,     0,
       0,   129,     0,    14,    15,     0,     0,     0,     0,   137,
       2,    64,   141,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,     0,     0,     0,     0,     5,
       9,     0,   132,     0,     0,     4,     0,   299,   165,     0,
     108,   114,   161,   229,   149,   116,     0,   228,     0,   124,
      11,   159,   325,   105,     0,   165,     0,     0,     0,   105,
       0,     0,   103,     0,     0,     0,     0,    71,    73,     0,
      75,    77,     0,     0,     0,     0,    28,     0,     0,     0,
      54,     0,    56,   131,     0,     0,     0,    49,     0,     2,
       3,     0,   142,   165,   122,   121,   227,   165,     0,     0,
       0,     0,   222,   221,   126,   127,     0,   128,   120,   119,
     130,     2,     0,   304,     0,     0,     0,   134,     0,     0,
       0,   216,   214,   212,   210,   208,   206,   204,   202,   200,
     198,   196,   194,   192,   190,   188,   186,   184,   182,   180,
     178,   176,   174,   172,   170,   168,     0,    99,    98,     0,
       0,   118,   117,   101,     0,   100,   115,     0,     7,   286,
     288,    97,    96,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   218,   145,     0,     0,   325,     0,   323,
       0,    59,    60,    61,     0,    57,    62,    63,    43,     0,
      16,     0,     0,    17,     0,     0,     0,   165,     0,     0,
      25,     0,    66,    92,    35,    65,    52,    55,    53,    13,
       0,    48,     2,     0,     3,     0,   139,     0,     0,     0,
       0,     0,     0,   312,     0,     3,   162,   113,   165,   310,
     302,   305,     0,   157,     0,    38,   313,     0,   166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   167,     0,     0,     0,   110,
     112,     0,   108,   123,     0,     0,     0,     0,     0,     0,
     283,   284,   285,   282,   281,   280,   277,   278,   279,   276,
     275,   274,   265,   266,   267,   264,   263,   262,   253,   254,
     255,   252,   251,   250,   241,   242,   243,   240,   239,   238,
     231,   230,   268,   269,   256,   257,   244,   245,   232,   233,
     272,   271,   270,   260,   259,   258,   248,   247,   246,   236,
     235,   234,   273,   261,   249,   237,     0,   325,   125,    12,
     302,   320,   325,   148,     0,     0,   327,   326,     0,   104,
      58,     2,    41,    72,    74,    76,    78,     0,   151,    18,
       0,     0,     0,     0,    68,     0,     0,     3,   164,   138,
      10,     2,     0,   226,   225,   224,   223,     0,   154,     6,
     307,   302,     0,     0,   325,   163,   313,   316,     0,     0,
     302,   314,     0,     8,   217,   215,   213,   211,   209,   207,
     205,   203,   201,   199,   197,   195,   193,   191,   189,   187,
     185,   183,   181,   179,   177,   175,   173,   171,   169,     0,
       0,   108,     0,   109,   287,   289,     0,     0,     0,     0,
       0,   302,   325,     0,   324,   329,   328,     0,     3,     2,
     104,   325,     0,     0,    21,    67,     0,    29,     0,     0,
      45,     0,     3,   143,   104,   155,     0,   302,   303,   306,
     133,   309,   302,   302,   318,   317,   302,     0,     0,     0,
       0,   102,   111,     0,     0,     0,     0,   219,     0,   321,
     160,   330,    44,     3,   302,    79,     0,     0,    70,     0,
      69,     0,     2,     0,     0,     0,    86,    88,    64,   144,
     325,   308,     0,     0,   315,   135,   300,     0,     0,     0,
       0,   293,   290,     0,   146,    42,     0,    80,    19,     0,
      22,     0,    36,     3,    91,     0,    51,    87,     2,     0,
     302,   158,    39,     0,     0,     0,     0,     0,     0,   294,
     220,   152,     0,     0,    23,    30,     0,     0,    90,     3,
     140,     0,     0,     2,   301,   297,   292,   295,   291,    81,
      26,    31,    37,     0,     0,    82,   156,     2,     3,   298,
     296,    27,    66,     0,    47,    83,     3,   136,     0,    84,
      40,    32,     2,     0,     3,    33,    34
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     3,    65,   141,   256,   522,   105,   567,   624,
     104,   440,   651,   282,   569,   641,   652,   663,   666,   445,
     626,   466,   632,   519,   431,   572,   627,   292,   531,   287,
     430,   109,   443,    96,    97,    99,   100,   598,   622,   644,
     645,   662,   575,   576,   608,   577,   108,    84,    67,   127,
     348,    69,    70,   185,   352,    71,    72,    73,   255,   143,
     316,   613,   119,   451,   122,   297,   579,   417,    82,    74,
     102,   521,   136,   535,   580,   464,   257,    75,    76,   344,
     343,   342,   341,   340,   339,   338,   337,   336,   335,   334,
     333,   332,   331,   330,   329,   328,   327,   326,   325,   324,
     323,   322,   321,   320,   416,   593,    77,   354,   355,   619,
     650,   649,   148,   614,   538,   310,   311,   536,    78,   470,
     471,   420,   258,   421,   260,   427,   312
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -394
static const short yypact[] =
{
    -394,    52,  -394,  1060,  -112,  -120,  -394,  -394,  -394,  1516,
    1516,  1516,   104,  -394,  -394,  1516,  1516,   104,   104,   104,
    -394,  -394,  -107,  -394,  -394,   -98,   -91,  -394,  1115,   -78,
     104,  -394,    95,  -394,  -394,   -73,  1516,   -65,   -67,  -394,
    -394,  -394,  -394,   238,   238,   238,   238,   238,   104,   104,
     238,   238,   238,   238,  -394,   238,   104,   104,   238,  -394,
    -394,  1516,  -394,   110,   -56,  -394,    14,  -394,   640,    86,
      87,  -394,   136,   -27,    94,  -394,   -28,  1892,   -26,  -394,
    -394,  -394,    84,   -21,   -25,  1733,   -24,   -20,   -17,  -394,
    1516,   -16,  -394,   -15,   -10,    58,  -108,  -394,   106,  -101,
    -394,   109,    16,  1516,  1060,    -8,  -394,    -4,   149,    13,
    -394,     1,  -394,  -394,     3,   168,     4,  -394,  1516,  -394,
       5,    27,  -394,   -92,   -27,   -27,   -27,    43,  1978,  2060,
       0,    17,   -27,   -27,  -394,  -394,   195,  -394,  -394,  -394,
     -27,  -394,    12,  1570,     6,  1516,    18,  -394,   238,  1516,
     104,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  1516,  -394,  -394,   238,
     238,  -394,  -394,  -394,    23,  -394,  -394,   238,  -394,  -394,
    -394,  -394,  -394,   238,   238,   238,   238,   238,   238,   238,
     238,   238,   238,   238,   238,   238,   238,   238,   238,   238,
     238,   238,   238,   238,   238,   238,   238,   238,   238,   238,
     238,   238,   238,   238,   238,   238,   238,   238,   238,   238,
     238,   238,   238,   238,   238,   238,   238,   238,   238,   238,
     238,   238,   238,   238,   238,   238,   238,   238,   238,   238,
     238,   238,   238,  -394,  -394,   238,  1060,   -66,   113,  -394,
     772,  -394,  -394,  -394,    28,  -394,  -394,  -394,  -394,    10,
    -394,   104,  1516,  -394,   104,  1516,  1516,  -394,    31,    29,
    -394,  1516,  1296,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
      34,  -394,  -394,    35,   163,    44,  -394,   238,   238,   238,
    1516,  1516,  1516,  -394,    42,    48,   -22,    49,  1694,   178,
      47,  -394,    51,  -394,    50,  -394,     8,  2142,  -394,    55,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  -394,  2220,  2298,    23,  -394,
    -394,  1516,    87,  -394,   238,   238,  2376,  2454,  2532,  2610,
    3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,
    3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,
    3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,  3760,
    3760,  3760,   348,   348,   348,   348,   348,   348,   348,   348,
     -44,   -44,   -44,   -44,   -44,   -44,   -44,   -44,   -44,   -44,
     -44,   -44,  -394,  -394,  -394,  -394,  1516,   -66,  -394,  -394,
      53,  -394,  -394,  -394,  1516,  1516,  -394,  -394,    57,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,    59,  -394,  -394,
     198,    60,   104,    15,  -394,    63,    64,    76,  -394,  -394,
    -394,  -394,  1814,   -27,   -27,  -394,  -394,    68,  -394,  -394,
    -394,  1350,    66,  1516,   -66,  -394,     8,  -394,   244,   245,
      71,  -394,   238,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,   238,
     238,    87,    78,  -394,  3545,  3620,   238,   238,   238,   238,
      75,    53,   -51,    83,  -394,  -394,  -394,  1516,    89,  -394,
      79,   -66,  1060,    88,  -394,    92,  1516,  -394,  1516,  1516,
    -394,    81,   207,  -394,    91,  -394,  1516,    96,  -394,  -394,
    -394,  -394,    53,    71,  -394,  -394,     2,    98,  2688,  2766,
    2844,  -394,  -394,  2922,  3000,  3078,  3156,  -394,   108,  -394,
    -394,  -394,  -394,   114,    53,   251,  1516,  1060,  -394,  1516,
    -394,   123,  -394,   112,  1516,    11,  -394,  -394,  -394,  -394,
     -66,  -394,   124,   125,  -394,  -394,  -394,   238,   238,   238,
     238,  -394,  -394,  1516,  -394,  -394,   126,  -394,  -394,   128,
    -394,   118,  -394,   261,  -394,   132,  -394,  -394,  -394,    30,
      53,  -394,  -394,   137,   238,  3234,  3312,  3390,  3468,  -394,
    -394,  -394,  1060,   138,  -394,  -394,  1060,   264,  -394,    32,
    -394,   133,   141,  -394,  3695,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,   310,   -11,  -394,  -394,  -394,   142,  -394,
    -394,  -394,  1296,   140,  -394,  -394,   144,  -394,    36,  -394,
    -394,  -394,  -394,  1060,    -6,  -394,  -394
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -394,   -36,  -394,   -94,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,   -39,  -310,   -96,  -192,  -394,  -394,  -394,  -394,  -394,
    -297,  -394,  -394,  -226,  -394,  -394,  -394,    -2,  -394,    -3,
    -394,  -394,  -394,  -329,    20,   279,  -394,    46,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,    19,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,   250,   346,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -394,  -394,   806,  -394,  -394,  -394,
    -394,  -394,  -394,  -394,  -260,  -394,  -103,  -394,   217,  -106,
    -187,  -393,  -394,   -79,  -394,  -394,   103
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -333
static const short yytable[] =
{
      68,    66,   121,   259,   120,   467,    85,    85,    85,    91,
     280,   467,    85,    85,    95,    98,   101,   146,   285,    89,
       5,     6,     7,   503,   511,    85,   349,   113,  -104,   350,
     526,    92,   285,    85,   643,   285,    92,    92,    92,   -85,
     123,   123,   123,    20,    21,   130,   131,   123,   123,    92,
     462,   526,     2,   138,   139,   123,    81,    79,    85,   573,
     574,    89,     5,    80,     7,   270,    38,    92,    92,   103,
     271,   542,   273,   181,   182,    92,    92,   274,   106,   433,
     -89,   -89,   435,   294,  -312,    20,    21,    85,   107,   124,
     125,   126,   269,  -322,  -322,   112,   132,   133,   114,   277,
      85,    68,    66,   115,   140,   305,   117,    89,     5,   118,
       7,  -319,  -319,   144,    92,    85,   249,   250,   251,   252,
     145,    92,   422,   423,   -50,   -50,  -302,   537,   564,   573,
     574,    20,    21,   303,   177,   178,   183,   184,   179,   180,
     308,     6,    85,   187,  -103,   188,    85,   319,    79,   261,
     254,   147,   284,   262,  -311,    92,   263,   265,   266,   468,
     513,   654,   419,   267,   272,   468,   -85,   275,   281,    92,
     283,   290,   551,    85,   288,    54,   289,   291,   300,   295,
     537,   432,   313,   606,   123,   469,   286,   610,   527,   306,
     147,   469,   276,   528,   315,   301,    63,    64,    89,     5,
     296,     7,   351,   630,   -89,   429,   439,   438,   181,   182,
     547,   446,   448,   661,   528,   449,   450,    54,   458,  -312,
     459,   460,    20,    21,  -331,   461,   463,   465,   473,   268,
     523,   512,   517,   353,    90,   530,   520,   524,    63,   529,
     540,    83,     5,     6,     7,   534,     8,   544,   545,   546,
     557,   558,   552,    68,    66,  -162,   447,   308,    13,    14,
     560,   562,   578,    54,   566,    20,    21,  -311,    98,    85,
     271,    98,    85,    85,   537,   585,    30,    31,    85,    85,
      90,   597,   582,   583,    63,   594,   595,   604,    38,    39,
      92,   625,    41,    92,    42,   123,   123,    85,    85,    85,
     602,   611,   612,   621,   596,   623,   -46,   628,   633,   643,
     646,   640,   647,   653,   657,   659,   660,    85,    85,    85,
      85,    85,    85,    85,    85,    85,    85,    85,    85,    85,
      85,    85,    85,    85,    85,    85,    85,    85,    85,    85,
      85,    85,   658,   514,   453,   454,   525,   655,    85,   607,
     631,   186,   278,   304,    54,    86,    87,    88,   539,   584,
     543,    93,    94,   428,     0,     0,     0,     0,   501,    43,
      44,   302,     0,     0,   111,    63,     0,     0,     0,     0,
       0,     0,   116,     0,    52,    53,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   518,     0,    54,     0,     0,
       0,     0,    55,    56,    57,     0,    58,   142,     0,     0,
       0,     0,     0,    85,    61,   532,     0,    62,    63,    64,
       0,    85,    85,     0,     0,     0,     0,     0,   565,     0,
       0,     0,     0,   559,     0,     0,   264,     0,     0,    98,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   279,
       0,     0,     0,     0,     0,     0,     0,     0,   308,     0,
      85,    92,     0,     0,   293,     0,     0,     0,     0,     0,
       0,     0,     0,   600,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   563,     0,     0,     0,     0,     0,   309,
       0,   314,     0,     0,     0,   318,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,    85,     0,     0,     0,     0,    68,
      66,     0,   345,    85,     0,    85,    85,     0,   639,     0,
       0,     0,   642,    85,     0,     0,   603,     0,     0,   609,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    85,    68,    66,    85,     0,     0,   665,
       0,    85,   629,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      85,     0,     0,     0,     0,     0,     0,   648,     0,     0,
       0,     0,     0,     0,     0,     0,   426,     0,     0,     0,
       0,   656,     0,     0,     0,     0,     0,     0,   434,    68,
      66,   436,   437,    68,    66,     0,   664,   441,   444,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,    85,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      68,    66,     0,     0,     0,     0,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   502,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,     0,     0,     0,     0,
       0,   177,   178,     0,     0,   179,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   510,     0,     0,     0,     0,     0,     0,     0,
     515,   516,     0,     0,     0,    83,     5,   307,     7,     0,
       8,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    13,    14,     0,     0,     0,     0,     0,    20,
      21,     0,     0,     0,     0,   181,   182,   309,     0,   541,
      30,    31,     0,     0,     0,     0,  -312,     0,     0,     0,
       0,     0,    38,    39,     0,     0,    41,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   128,   129,     0,     0,     0,     0,   134,   135,
       0,   137,     0,   561,     0,     0,     0,     0,     0,     0,
       0,     0,   568,     0,   570,   571,     0,     0,     0,     0,
       0,     0,   581,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,    44,    45,    46,    47,    48,    49,
      50,    51,   599,     0,     0,   601,     0,     0,    52,    53,
     605,     0,     0,     0,     0,     0,     0,     0,     0,   424,
       0,    54,     0,     0,     0,     0,    55,    56,    57,   620,
      58,     0,     0,     0,     0,     0,     0,     0,    61,     0,
       0,    62,    63,    64,   317,   425,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   444,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,     0,
       0,   418,     0,     4,     5,     6,     7,     0,     8,     0,
       0,     0,     0,     0,     0,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
       0,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,   452,    35,     0,    36,    37,     0,     0,
      38,    39,     0,    40,    41,     0,    42,     0,    83,     5,
       6,     7,     0,     8,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    13,    14,     0,     0,     0,
       0,     0,    20,    21,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,    31,     0,     0,     0,     0,     0,
     504,   505,     0,     0,     0,    38,    39,     0,     0,    41,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,    44,    45,    46,    47,    48,    49,    50,    51,
       0,     0,     0,     0,     0,     0,    52,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,    55,    56,    57,     0,    58,     0,
       0,    59,     0,    60,     0,     0,    61,     0,     0,    62,
      63,    64,     0,     0,     0,     0,    43,    44,    45,    46,
      47,    48,    49,    50,    51,     0,     0,     0,     0,     0,
       0,    52,    53,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,   548,    55,
      56,    57,     0,    58,     0,     0,     0,     0,   110,     0,
       0,    61,     0,     0,    62,    63,    64,     0,     0,    83,
       5,     6,     7,     0,     8,   549,   550,     0,     0,     0,
       0,     0,   553,   554,   555,   556,    13,    14,     0,     0,
       0,   442,     0,    20,    21,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,    31,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    38,    39,     0,     0,
      41,     0,    42,    83,     5,   307,     7,     0,     8,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      13,    14,     0,     0,     0,     0,     0,    20,    21,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,    31,
       0,     0,     0,   615,   616,   617,   618,     0,     0,     0,
      38,    39,     0,     0,    41,     0,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     634,     0,     0,     0,     0,     0,     0,    43,    44,    45,
      46,    47,    48,    49,    50,    51,     0,     0,     0,     0,
       0,     0,    52,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
      55,    56,    57,     0,    58,     0,     0,     0,     0,     0,
       0,     0,    61,     0,     0,    62,    63,    64,     0,     0,
       0,    43,    44,    45,    46,    47,    48,    49,    50,    51,
       0,     0,     0,     0,     0,     0,    52,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,    55,    56,    57,     0,    58,    83,
       5,     6,     7,     0,     8,     0,    61,     0,   537,    62,
      63,    64,     0,     0,     0,     0,    13,    14,     0,     0,
       0,     0,     0,    20,    21,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,    31,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    38,    39,     0,     0,
      41,     0,    42,    83,     5,   307,     7,     0,     8,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      13,    14,     0,     0,     0,     0,     0,    20,    21,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,    31,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      38,    39,     0,     0,    41,     0,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,    44,    45,
      46,    47,    48,    49,    50,    51,     0,     0,     0,     0,
       0,     0,    52,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
      55,    56,    57,     0,    58,     0,     0,     0,     0,     0,
       0,     0,    61,     0,     0,    62,    63,    64,     0,     0,
       0,    43,    44,    45,    46,    47,    48,    49,    50,    51,
       0,     0,     0,     0,     0,     0,    52,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,    55,    56,    57,     0,    58,     0,
       0,     0,     0,     0,     0,     0,    61,     0,     0,    62,
      63,    64,   149,     0,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
       0,     0,     0,     0,     0,   177,   178,     0,     0,   179,
     180,   149,     0,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,     0,
       0,     0,     0,     0,   177,   178,     0,     0,   179,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,     0,     0,     0,     0,     0,     0,     0,     0,  -332,
    -312,   533,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
     189,   190,     0,   191,   192,     0,     0,   193,   194,  -312,
       0,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   189,   190,
       0,   191,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
       0,     0,     0,     0,   189,   190,     0,   191,   192,     0,
       0,   193,   194,     0,   253,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   189,   190,     0,   191,
     192,     0,     0,   193,   194,     0,   298,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   189,   190,
     472,   191,   192,     0,     0,   193,   194,     0,   299,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   189,   190,   499,   191,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   189,   190,   500,   191,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   189,   190,   506,   191,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     189,   190,   507,   191,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   189,   190,
     508,   191,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   189,   190,   509,   191,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   189,   190,   586,   191,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   189,   190,   587,   191,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     189,   190,   588,   191,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   189,   190,
     589,   191,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   189,   190,   590,   191,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   189,   190,   591,   191,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   189,   190,   592,   191,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     189,   190,   635,   191,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   189,   190,
     636,   191,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   189,   190,   637,   191,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   189,   190,   638,   191,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   190,     0,   191,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   191,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,  -333,  -333,     0,     0,  -333,  -333,
       0,     0,  -333,  -333,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,  -333,
    -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,
    -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,
    -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,
    -333,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252
};

static const short yycheck[] =
{
       3,     3,    41,    82,    40,     3,     9,    10,    11,    12,
     104,     3,    15,    16,    17,    18,    19,     3,     5,     3,
       4,     5,     6,   352,   417,    28,     3,    30,    50,     6,
      15,    12,     5,    36,    45,     5,    17,    18,    19,    45,
      43,    44,    45,    27,    28,    48,    49,    50,    51,    30,
     310,    15,     0,    56,    57,    58,   176,   169,    61,    48,
      49,     3,     4,   175,     6,   173,    50,    48,    49,   176,
     178,   464,   173,   165,   166,    56,    57,   178,   176,   271,
      48,    49,   274,   119,   176,    27,    28,    90,   179,    43,
      44,    45,    95,     9,    10,   173,    50,    51,     3,   102,
     103,   104,   104,   176,    58,   141,   171,     3,     4,   176,
       6,   177,   178,     3,    95,   118,   160,   161,   162,   163,
     176,   102,     9,    10,    48,    49,   177,   178,   521,    48,
      49,    27,    28,   136,    91,    92,    50,    50,    95,    96,
     143,     5,   145,   170,    50,   173,   149,   150,   169,   173,
     176,   176,     3,   173,   176,   136,   173,   173,   173,   157,
     420,   172,   256,   173,    58,   157,   172,    58,   176,   150,
     174,     3,   501,   176,   173,   159,   173,   173,   178,   174,
     178,   171,   176,   172,   187,   183,   173,   580,   173,   177,
     176,   183,   176,   178,   176,   178,   180,   181,     3,     4,
     173,     6,   179,   173,   172,   177,   177,   176,   165,   166,
     470,   177,   177,   177,   178,    52,   172,   159,   176,   176,
     172,    43,    27,    28,   175,   178,   175,   177,   173,   171,
      32,   178,   175,   187,   176,   171,   177,   177,   180,   176,
     174,     3,     4,     5,     6,   177,     8,     3,     3,   178,
     175,   511,   174,   256,   256,   176,   292,   260,    20,    21,
     177,   172,    55,   159,   176,    27,    28,   176,   271,   272,
     178,   274,   275,   276,   178,   177,    38,    39,   281,   282,
     176,    30,   542,   543,   180,   177,   172,   175,    50,    51,
     271,   173,    54,   274,    56,   298,   299,   300,   301,   302,
     177,   177,   177,   177,   564,   177,    45,   175,   171,    45,
     177,   173,   171,     3,   172,   175,   172,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   652,   422,   298,   299,   442,   644,   351,   575,
     610,    72,   102,   136,   159,     9,    10,    11,   461,   546,
     466,    15,    16,   260,    -1,    -1,    -1,    -1,   348,   131,
     132,   176,    -1,    -1,    28,   180,    -1,    -1,    -1,    -1,
      -1,    -1,    36,    -1,   146,   147,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   431,    -1,   159,    -1,    -1,
      -1,    -1,   164,   165,   166,    -1,   168,    61,    -1,    -1,
      -1,    -1,    -1,   416,   176,   451,    -1,   179,   180,   181,
      -1,   424,   425,    -1,    -1,    -1,    -1,    -1,   522,    -1,
      -1,    -1,    -1,   512,    -1,    -1,    90,    -1,    -1,   442,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   461,    -1,
     463,   442,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   567,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   519,    -1,    -1,    -1,    -1,    -1,   143,
      -1,   145,    -1,    -1,    -1,   149,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,    -1,    -1,   517,    -1,    -1,    -1,    -1,   522,
     522,    -1,   176,   526,    -1,   528,   529,    -1,   622,    -1,
      -1,    -1,   626,   536,    -1,    -1,   572,    -1,    -1,   578,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   566,   567,   567,   569,    -1,    -1,   663,
      -1,   574,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,    -1,    -1,    -1,    -1,   633,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   647,    -1,    -1,    -1,    -1,    -1,    -1,   272,   622,
     622,   275,   276,   626,   626,    -1,   662,   281,   282,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   300,   301,   302,   652,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     663,   663,    -1,    -1,    -1,    -1,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,    -1,    -1,    -1,    -1,    -1,    -1,   351,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    -1,    -1,    -1,
      -1,    91,    92,    -1,    -1,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     424,   425,    -1,    -1,    -1,     3,     4,     5,     6,    -1,
       8,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    20,    21,    -1,    -1,    -1,    -1,    -1,    27,
      28,    -1,    -1,    -1,    -1,   165,   166,   461,    -1,   463,
      38,    39,    -1,    -1,    -1,    -1,   176,    -1,    -1,    -1,
      -1,    -1,    50,    51,    -1,    -1,    54,    -1,    56,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    47,    -1,    -1,    -1,    -1,    52,    53,
      -1,    55,    -1,   517,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   526,    -1,   528,   529,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   566,    -1,    -1,   569,    -1,    -1,   146,   147,
     574,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   157,
      -1,   159,    -1,    -1,    -1,    -1,   164,   165,   166,   593,
     168,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,
      -1,   179,   180,   181,   148,   183,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   179,   180,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   652,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,    -1,
      -1,   255,    -1,     3,     4,     5,     6,    -1,     8,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,   297,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    -1,    53,    54,    -1,    56,    -1,     3,     4,
       5,     6,    -1,     8,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    20,    21,    -1,    -1,    -1,
      -1,    -1,    27,    28,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    38,    39,    -1,    -1,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,    50,    51,    -1,    -1,    54,
      -1,    56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
      -1,    -1,    -1,    -1,    -1,    -1,   146,   147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   159,
      -1,    -1,    -1,    -1,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,    -1,    -1,   176,    -1,    -1,   179,
     180,   181,    -1,    -1,    -1,    -1,   131,   132,   133,   134,
     135,   136,   137,   138,   139,    -1,    -1,    -1,    -1,    -1,
      -1,   146,   147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   159,    -1,    -1,    -1,   472,   164,
     165,   166,    -1,   168,    -1,    -1,    -1,    -1,   173,    -1,
      -1,   176,    -1,    -1,   179,   180,   181,    -1,    -1,     3,
       4,     5,     6,    -1,     8,   499,   500,    -1,    -1,    -1,
      -1,    -1,   506,   507,   508,   509,    20,    21,    -1,    -1,
      -1,    25,    -1,    27,    28,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    38,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    50,    51,    -1,    -1,
      54,    -1,    56,     3,     4,     5,     6,    -1,     8,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      20,    21,    -1,    -1,    -1,    -1,    -1,    27,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    38,    39,
      -1,    -1,    -1,   587,   588,   589,   590,    -1,    -1,    -1,
      50,    51,    -1,    -1,    54,    -1,    56,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     614,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,    -1,    -1,    -1,    -1,
      -1,    -1,   146,   147,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   159,    -1,    -1,    -1,    -1,
     164,   165,   166,    -1,   168,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   176,    -1,    -1,   179,   180,   181,    -1,    -1,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
      -1,    -1,    -1,    -1,    -1,    -1,   146,   147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   159,
      -1,    -1,    -1,    -1,   164,   165,   166,    -1,   168,     3,
       4,     5,     6,    -1,     8,    -1,   176,    -1,   178,   179,
     180,   181,    -1,    -1,    -1,    -1,    20,    21,    -1,    -1,
      -1,    -1,    -1,    27,    28,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    38,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    50,    51,    -1,    -1,
      54,    -1,    56,     3,     4,     5,     6,    -1,     8,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      20,    21,    -1,    -1,    -1,    -1,    -1,    27,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    38,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      50,    51,    -1,    -1,    54,    -1,    56,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,    -1,    -1,    -1,    -1,
      -1,    -1,   146,   147,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   159,    -1,    -1,    -1,    -1,
     164,   165,   166,    -1,   168,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   176,    -1,    -1,   179,   180,   181,    -1,    -1,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
      -1,    -1,    -1,    -1,    -1,    -1,   146,   147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   159,
      -1,    -1,    -1,    -1,   164,   165,   166,    -1,   168,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,    -1,   179,
     180,   181,    58,    -1,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    95,
      96,    58,    -1,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    95,    96,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   165,
     166,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,
     176,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   165,   166,
      86,    87,    -1,    89,    90,    -1,    -1,    93,    94,   176,
      -1,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,    86,    87,
      -1,    89,    90,    -1,    -1,    93,    94,    -1,    -1,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    87,    -1,    89,    90,    -1,
      -1,    93,    94,    -1,   182,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,    -1,    -1,    -1,    -1,    86,    87,    -1,    89,
      90,    -1,    -1,    93,    94,    -1,   178,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,    -1,    -1,    -1,    -1,    86,    87,
      88,    89,    90,    -1,    -1,    93,    94,    -1,   178,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,    86,    87,    88,    89,
      90,    -1,    -1,    93,    94,    -1,    -1,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,    86,    87,    88,    89,    90,    -1,
      -1,    93,    94,    -1,    -1,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,    86,    87,    88,    89,    90,    -1,    -1,    93,
      94,    -1,    -1,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
      86,    87,    88,    89,    90,    -1,    -1,    93,    94,    -1,
      -1,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,    86,    87,
      88,    89,    90,    -1,    -1,    93,    94,    -1,    -1,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,    86,    87,    88,    89,
      90,    -1,    -1,    93,    94,    -1,    -1,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,    86,    87,    88,    89,    90,    -1,
      -1,    93,    94,    -1,    -1,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,    86,    87,    88,    89,    90,    -1,    -1,    93,
      94,    -1,    -1,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
      86,    87,    88,    89,    90,    -1,    -1,    93,    94,    -1,
      -1,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,    86,    87,
      88,    89,    90,    -1,    -1,    93,    94,    -1,    -1,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,    86,    87,    88,    89,
      90,    -1,    -1,    93,    94,    -1,    -1,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,    86,    87,    88,    89,    90,    -1,
      -1,    93,    94,    -1,    -1,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,    86,    87,    88,    89,    90,    -1,    -1,    93,
      94,    -1,    -1,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
      86,    87,    88,    89,    90,    -1,    -1,    93,    94,    -1,
      -1,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,    86,    87,
      88,    89,    90,    -1,    -1,    93,    94,    -1,    -1,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,    86,    87,    88,    89,
      90,    -1,    -1,    93,    94,    -1,    -1,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,    86,    87,    88,    89,    90,    -1,
      -1,    93,    94,    -1,    -1,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,    87,    -1,    89,    90,    -1,    -1,    93,    94,
      -1,    -1,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,    89,
      90,    -1,    -1,    93,    94,    -1,    -1,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,    89,    90,    -1,    -1,    93,    94,
      -1,    -1,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   185,     0,   186,     3,     4,     5,     6,     8,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    44,    46,    47,    50,    51,
      53,    54,    56,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   146,   147,   159,   164,   165,   166,   168,   171,
     173,   176,   179,   180,   181,   187,   231,   232,   233,   235,
     236,   239,   240,   241,   253,   261,   262,   290,   302,   169,
     175,   176,   252,     3,   231,   233,   262,   262,   262,     3,
     176,   233,   253,   262,   262,   233,   217,   218,   233,   219,
     220,   233,   254,   176,   194,   191,   176,   179,   230,   215,
     173,   262,   173,   233,     3,   176,   262,   171,   176,   246,
     185,   215,   248,   233,   241,   241,   241,   233,   290,   290,
     233,   233,   241,   241,   290,   290,   256,   290,   233,   233,
     241,   188,   262,   243,     3,   176,     3,   176,   296,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    91,    92,    95,
      96,   165,   166,    50,    50,   237,   239,   170,   173,    86,
      87,    89,    90,    93,    94,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   182,   176,   242,   189,   260,   306,   307,
     308,   173,   173,   173,   262,   173,   173,   173,   171,   233,
     173,   178,    58,   173,   178,    58,   176,   233,   261,   262,
     187,   176,   197,   174,     3,     5,   173,   213,   173,   173,
       3,   173,   211,   262,   185,   174,   173,   249,   178,   178,
     178,   178,   176,   233,   302,   185,   177,     5,   233,   262,
     299,   300,   310,   176,   262,   176,   244,   290,   262,   233,
     287,   286,   285,   284,   283,   282,   281,   280,   279,   278,
     277,   276,   275,   274,   273,   272,   271,   270,   269,   268,
     267,   266,   265,   264,   263,   262,   290,   290,   234,     3,
       6,   179,   238,   241,   291,   292,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   290,   290,   290,   290,
     290,   290,   290,   290,   290,   290,   288,   251,   290,   187,
     305,   307,     9,    10,   157,   183,   262,   309,   310,   177,
     214,   208,   171,   218,   262,   218,   262,   262,   176,   177,
     195,   262,    25,   216,   262,   203,   177,   185,   177,    52,
     172,   247,   290,   241,   241,   262,   262,   262,   176,   172,
      43,   178,   298,   175,   259,   177,   205,     3,   157,   183,
     303,   304,    88,   173,   262,   262,   262,   262,   262,   262,
     262,   262,   262,   262,   262,   262,   262,   262,   262,   262,
     262,   262,   262,   262,   262,   262,   262,   262,   262,    88,
      88,   238,   262,   237,   290,   290,    88,    88,    88,    88,
     262,   305,   178,   298,   307,   262,   262,   175,   185,   207,
     177,   255,   190,    32,   177,   217,    15,   173,   178,   176,
     171,   212,   185,    57,   177,   257,   301,   178,   298,   300,
     174,   262,   305,   303,     3,     3,   178,   298,   290,   290,
     290,   237,   174,   290,   290,   290,   290,   175,   298,   307,
     177,   262,   172,   185,   305,   187,   176,   192,   262,   198,
     262,   262,   209,    48,    49,   226,   227,   229,    55,   250,
     258,   262,   298,   298,   304,   177,    88,    88,    88,    88,
      88,    88,    88,   289,   177,   172,   298,    30,   221,   262,
     187,   262,   177,   185,   175,   262,   172,   227,   228,   215,
     305,   177,   177,   245,   297,   290,   290,   290,   290,   293,
     262,   177,   222,   177,   193,   173,   204,   210,   175,   185,
     173,   298,   206,   171,   290,    88,    88,    88,    88,   187,
     173,   199,   187,    45,   223,   224,   177,   171,   185,   295,
     294,   196,   200,     3,   172,   224,   185,   172,   216,   175,
     172,   177,   225,   201,   185,   187,   202
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 238 "compiler.y"
    { create_debug_op(0); }
    break;

  case 5:
#line 243 "compiler.y"
    { spl_asm_add(as, SPL_OP_BEGIN, 0); }
    break;

  case 6:
#line 245 "compiler.y"
    { spl_asm_add(as, SPL_OP_END, 0); }
    break;

  case 7:
#line 248 "compiler.y"
    { spl_asm_add(as, SPL_OP_DROP, 0); CHECKPOINT(); }
    break;

  case 8:
#line 251 "compiler.y"
    { spl_asm_add(as, SPL_OP_LXCHG, 0); }
    break;

  case 9:
#line 254 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 11:
#line 261 "compiler.y"
    {
			char *label;
			my_asprintf(&label, "L%d:%s", lbstack_value(), yyvsp[-1].text);
			if ( spl_asm_setlabel(as, label, spl_asm_add(as, SPL_OP_NOP, 0)) < 0 ) {
				spl_yyerror("Assembler error"); free(label); YYABORT;
			}
			free(label);
			free(yyvsp[-1].text);
		}
    break;

  case 13:
#line 273 "compiler.y"
    {
			char *label;
			my_asprintf(&label, "L%d:%s", lbstack_value(), yyvsp[-1].text);
			spl_asm_reflabel(as, label, spl_asm_add(as, SPL_OP_GOTO, 0));
			free(label);
			free(yyvsp[-1].text);
		}
    break;

  case 14:
#line 282 "compiler.y"
    { breakcont_goto('B'); }
    break;

  case 15:
#line 285 "compiler.y"
    { breakcont_goto('C'); }
    break;

  case 16:
#line 288 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 17:
#line 291 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 18:
#line 294 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNLESS, 0); pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0)); }
    break;

  case 19:
#line 296 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 20:
#line 299 "compiler.y"
    {
			pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0));
			breakcont_begin();
			if (breakcont_label('C')) YYABORT;
		}
    break;

  case 21:
#line 305 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNLESS, 0); pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0)); }
    break;

  case 22:
#line 307 "compiler.y"
    {
			int label_end = pbstack_pop();
			int label_begin = pbstack_pop();
			spl_asm_setaddr(as, spl_asm_add(as, SPL_OP_JUMP, 0), label_begin);
			spl_asm_setaddr(as, label_end, spl_asm_add(as, SPL_OP_NOP, 0));

			if (breakcont_label('B')) YYABORT;
			breakcont_end();
		}
    break;

  case 23:
#line 316 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 24:
#line 319 "compiler.y"
    {
			pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0));
			breakcont_begin();
		}
    break;

  case 25:
#line 324 "compiler.y"
    { if (breakcont_label('C')) YYABORT; }
    break;

  case 26:
#line 326 "compiler.y"
    {
			int label_begin = pbstack_pop();
			spl_asm_add(as, SPL_OP_IF, 0);
			spl_asm_setaddr(as, spl_asm_add(as, SPL_OP_JUMP, 0), label_begin);

			if (breakcont_label('B')) YYABORT;
			breakcont_end();
		}
    break;

  case 27:
#line 334 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 28:
#line 336 "compiler.y"
    {
			breakcont_begin();
			spl_asm_add(as, SPL_OP_BEGIN, 0);
		}
    break;

  case 29:
#line 341 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0)); }
    break;

  case 30:
#line 343 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNLESS, 0); pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0)); }
    break;

  case 31:
#line 344 "compiler.y"
    {
			pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0));
		}
    break;

  case 32:
#line 348 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0)); }
    break;

  case 33:
#line 350 "compiler.y"
    {
			if (breakcont_label('C')) YYABORT;

			int label_body_start  = pbstack_pop();
			int label_extra_start = pbstack_pop();
			int label_finish_jump = pbstack_pop();
			int label_cond_start  = pbstack_pop();
			int label_body_end    = spl_asm_add(as, SPL_OP_JUMP, 0);

			spl_asm_setaddr(as, label_body_end, label_cond_start);
			spl_asm_setaddr(as, label_finish_jump, spl_asm_add(as, SPL_OP_NOP, 0));

			spl_asm_shuffle(as,
				label_body_end - label_body_start, label_body_start, label_extra_start,
				label_body_start - label_extra_start, label_extra_start,
					label_extra_start + (label_body_end - label_body_start),
				-1);
			spl_asm_add(as, SPL_OP_END, 0);

			if (breakcont_label('B')) YYABORT;
			breakcont_end();
		}
    break;

  case 34:
#line 372 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 35:
#line 375 "compiler.y"
    {
			breakcont_begin();
			spl_asm_add(as, SPL_OP_BEGIN, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "#index");
			spl_asm_add(as, SPL_OP_UNDEF, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "#array");
		}
    break;

  case 36:
#line 386 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_POPL, 0);

			if (breakcont_label('C')) YYABORT;
			pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0));

			spl_asm_add(as, SPL_OP_PUSHC, "#index");
			spl_asm_add(as, SPL_OP_PUSH, "#array");
			spl_asm_add(as, SPL_OP_PUSH, "#index");

			spl_asm_add(as, SPL_OP_NEXT, 0);
			spl_asm_add(as, SPL_OP_COPY, 0);

			spl_asm_add(as, SPL_OP_DEFINED, 0);
			spl_asm_add(as, SPL_OP_UNLESS, 0);
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));

			spl_asm_add(as, SPL_OP_POPL, 0);

			if (yyvsp[-5].ch == 'V') {
				spl_asm_add(as, SPL_OP_PUSHC, yyvsp[-4].text);
				spl_asm_add(as, SPL_OP_PUSHC, "#array");
				spl_asm_add(as, SPL_OP_PUSH, "#index");
				spl_asm_add(as, SPL_OP_HENC, 0);
				spl_asm_add(as, SPL_OP_DOTCAT, 0);
				spl_asm_add(as, SPL_OP_GETVAL, 0);
				spl_asm_add(as, SPL_OP_POPL, 0);
			} else {
				spl_asm_add(as, SPL_OP_PUSHC, yyvsp[-4].text);
				spl_asm_add(as, SPL_OP_PUSH, "#index");
				spl_asm_add(as, SPL_OP_POPL, 0);
			}
		}
    break;

  case 37:
#line 420 "compiler.y"
    {
			int finish_jump = pbstack_pop();

			spl_asm_setaddr(as, spl_asm_add(as, SPL_OP_JUMP, 0), pbstack_pop());

			spl_asm_setaddr(as, finish_jump, spl_asm_add(as, SPL_OP_DROP, 0));
			spl_asm_add(as, SPL_OP_DROP, 0);
			spl_asm_add(as, SPL_OP_END, 0);

			if (breakcont_label('B')) YYABORT;
			breakcont_end();

			CHECKPOINT();
			free(yyvsp[-6].text);
		}
    break;

  case 38:
#line 437 "compiler.y"
    {
			lbstack_push();
			spl_asm_add(as, SPL_OP_PUSHC, yyvsp[-1].text);
			pbstack_push(spl_asm_add(as, yyvsp[-2].ch == 'F' ? SPL_OP_REGF : SPL_OP_REGM, 0));
		}
    break;

  case 39:
#line 443 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_CLEARA, 0);
			if (gen_debug_info) {
				spl_asm_add(as, SPL_OP_PUSHC, "#func");
				spl_asm_add(as, SPL_OP_PUSHC, yyvsp[-5].text);
				spl_asm_add(as, SPL_OP_POPL, 0);
			}
		}
    break;

  case 40:
#line 452 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_UNDEF, 0);
			spl_asm_add(as, SPL_OP_RETURN, 0);
			spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_POPL, 0));

			CHECKPOINT();
			lbstack_pop();
			free(yyvsp[-9].text);
		}
    break;

  case 41:
#line 463 "compiler.y"
    {
			lbstack_push();
			spl_asm_add(as, SPL_OP_OBJECT, 0);
		}
    break;

  case 42:
#line 468 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_ENDOBJ, 0);
			CHECKPOINT();
			lbstack_pop();
		}
    break;

  case 43:
#line 475 "compiler.y"
    {
			lbstack_push();
			spl_asm_add(as, SPL_OP_UNDEF, 0);
			spl_asm_add(as, SPL_OP_OBJECT, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "init");
			pbstack_push(spl_asm_add(as, SPL_OP_REGM, 0));
			spl_asm_add(as, SPL_OP_CLEARA, 0);
			spl_asm_add(as, SPL_OP_PUSH, "!THIS");
			spl_asm_add(as, SPL_OP_RETURN, 0);

			spl_asm_setaddr(as, pbstack_pop(),
					spl_asm_add(as, SPL_OP_POPL, 0));
		}
    break;

  case 44:
#line 490 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_ENDOBJ, 0);
			CHECKPOINT();
			lbstack_pop();
		}
    break;

  case 45:
#line 497 "compiler.y"
    {
			lbstack_push();
			spl_asm_add(as, SPL_OP_BEGIN, 0);

			spl_asm_add(as, SPL_OP_PUSHC, yyvsp[-2].text);
			spl_asm_add(as, SPL_OP_TRY, 0);
			free(yyvsp[-2].text);

			int j = spl_asm_add(as, SPL_OP_JUMP, 0);
			int n = spl_asm_add(as, SPL_OP_NOP, 0);
			pbstack_push(n);
			pbstack_push(j);
		}
    break;

  case 46:
#line 511 "compiler.y"
    {
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));
		}
    break;

  case 47:
#line 515 "compiler.y"
    {
			spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0));

			int j = pbstack_pop();
			int n = pbstack_pop();
			spl_asm_setaddr(as, j, n);

			spl_asm_add(as, SPL_OP_END, 0);
			lbstack_pop();
		}
    break;

  case 48:
#line 527 "compiler.y"
    { spl_asm_add(as, SPL_OP_THROW, 0); }
    break;

  case 49:
#line 530 "compiler.y"
    { spl_asm_add(as, SPL_OP_BEGIN, 0); }
    break;

  case 50:
#line 532 "compiler.y"
    {
			int case_begin_jump = spl_asm_add(as, SPL_OP_JUMP, 0);
			int fin_jump = spl_asm_add(as, SPL_OP_JUMP, 0);
			spl_asm_setaddr(as, case_begin_jump, spl_asm_add(as, SPL_OP_NOP, 0));
			pbstack_push(fin_jump);
		}
    break;

  case 51:
#line 539 "compiler.y"
    {
			spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0));
			spl_asm_add(as, SPL_OP_END, 0);
		}
    break;

  case 52:
#line 545 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 53:
#line 548 "compiler.y"
    { spl_asm_add(as, SPL_OP_RETURN, 0); }
    break;

  case 54:
#line 551 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNDEF, 0); }
    break;

  case 55:
#line 552 "compiler.y"
    { spl_asm_add(as, SPL_OP_RETURN, 0); }
    break;

  case 56:
#line 555 "compiler.y"
    { spl_asm_add(as, SPL_OP_HALT, 0); }
    break;

  case 57:
#line 558 "compiler.y"
    { spl_asm_add(as, SPL_OP_DELETE, 0); }
    break;

  case 58:
#line 559 "compiler.y"
    { CHECKPOINT(); }
    break;

  case 59:
#line 562 "compiler.y"
    { spl_asm_add(as, SPL_OP_DEBUG, 0); }
    break;

  case 60:
#line 565 "compiler.y"
    { spl_asm_add(as, SPL_OP_WARNING, 0); }
    break;

  case 61:
#line 568 "compiler.y"
    { spl_asm_add(as, SPL_OP_ERROR, 0); }
    break;

  case 62:
#line 571 "compiler.y"
    { spl_asm_add(as, SPL_OP_IMPORT, 0); }
    break;

  case 63:
#line 574 "compiler.y"
    { spl_asm_add(as, SPL_OP_LOAD, 0); }
    break;

  case 65:
#line 579 "compiler.y"
    { spl_asm_parse_line(as, yyvsp[0].text); free(yyvsp[0].text); }
    break;

  case 68:
#line 594 "compiler.y"
    { spl_asm_add(as, SPL_OP_DROP, 0); CHECKPOINT(); }
    break;

  case 69:
#line 595 "compiler.y"
    { spl_asm_add(as, SPL_OP_DROP, 0); CHECKPOINT(); }
    break;

  case 70:
#line 596 "compiler.y"
    { spl_asm_add(as, SPL_OP_DROP, 0); CHECKPOINT(); }
    break;

  case 73:
#line 605 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNDEF, 0); spl_asm_add(as, SPL_OP_POPL, 0); }
    break;

  case 74:
#line 606 "compiler.y"
    { spl_asm_add(as, SPL_OP_POPL, 0); }
    break;

  case 77:
#line 615 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNDEF, 0); spl_asm_add(as, SPL_OP_POPS, 0); }
    break;

  case 78:
#line 616 "compiler.y"
    { spl_asm_add(as, SPL_OP_POPS, 0); }
    break;

  case 79:
#line 626 "compiler.y"
    { spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0)); }
    break;

  case 80:
#line 628 "compiler.y"
    {
			int else_label = pbstack_pop();
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));
			spl_asm_setaddr(as, else_label, spl_asm_add(as, SPL_OP_NOP, 0));
		}
    break;

  case 81:
#line 634 "compiler.y"
    { spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0)); }
    break;

  case 84:
#line 644 "compiler.y"
    {
		int fin = pbstack_pop();
		int frm = pbstack_pop();

		spl_asm_setaddr(as, frm, spl_asm_add(as, SPL_OP_NOP, 0));

		spl_asm_add(as, SPL_OP_PUSHC, yyvsp[-1].text);
		int c = spl_asm_add(as, SPL_OP_CATCH, 0);
		free(yyvsp[-1].text);

		frm = spl_asm_add(as, SPL_OP_JUMP, 0);

		pbstack_push(frm);
		pbstack_push(fin);

		spl_asm_setaddr(as, c, spl_asm_add(as, SPL_OP_NOP, 0));
	}
    break;

  case 85:
#line 662 "compiler.y"
    {
		int fin = pbstack_pop();
		int frm = pbstack_pop();

		spl_asm_setaddr(as, spl_asm_add(as, SPL_OP_JUMP, 0), fin);

		pbstack_push(frm);
		pbstack_push(fin);
	}
    break;

  case 88:
#line 680 "compiler.y"
    {
		spl_asm_add(as, SPL_OP_UNLESS, 0);
		pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));
	}
    break;

  case 89:
#line 685 "compiler.y"
    {
		int next_jump = pbstack_pop();
		int fin_jump = pbstack_pop();
		pbstack_push(fin_jump);

		spl_asm_setaddr(as, spl_asm_add(as, SPL_OP_JUMP, 0), fin_jump);
		spl_asm_setaddr(as, next_jump, spl_asm_add(as, SPL_OP_NOP, 0));
	}
    break;

  case 91:
#line 698 "compiler.y"
    { spl_asm_add(as, SPL_OP_ONE, 0); }
    break;

  case 92:
#line 702 "compiler.y"
    { yyval.ch = 'V'; }
    break;

  case 93:
#line 703 "compiler.y"
    { yyval.ch = 'K'; }
    break;

  case 94:
#line 707 "compiler.y"
    { yyval.ch = 'F'; }
    break;

  case 95:
#line 708 "compiler.y"
    { yyval.ch = 'M'; }
    break;

  case 96:
#line 712 "compiler.y"
    { yyval.ch = REGEX_EVAL_RETURN; }
    break;

  case 97:
#line 713 "compiler.y"
    { yyval.ch = REGEX_EVAL_RETURN|REGEX_EVAL_NEG; }
    break;

  case 98:
#line 714 "compiler.y"
    { yyval.ch = REGEX_EVAL_SUBST; }
    break;

  case 99:
#line 715 "compiler.y"
    { yyval.ch = REGEX_EVAL_SUBST|REGEX_EVAL_NEG; }
    break;

  case 101:
#line 722 "compiler.y"
    {
			char varname[32];
			snprintf(varname, 32, "#rvtolv%d", rvtolv_counter++);
			spl_asm_add(as, SPL_OP_PUSHC, varname);
			spl_asm_add(as, SPL_OP_XCHG, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);
			spl_asm_add(as, SPL_OP_PUSHC, varname);
		}
    break;

  case 102:
#line 731 "compiler.y"
    { spl_asm_add(as, SPL_OP_DOTCAT, 0);  }
    break;

  case 105:
#line 740 "compiler.y"
    { spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text); free(yyvsp[0].text); }
    break;

  case 106:
#line 742 "compiler.y"
    { spl_asm_add(as, SPL_OP_PUSHC, "!THIS"); }
    break;

  case 107:
#line 745 "compiler.y"
    { spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text); free(yyvsp[0].text); }
    break;

  case 109:
#line 750 "compiler.y"
    { spl_asm_add(as, SPL_OP_DOTCAT, 0);  }
    break;

  case 110:
#line 755 "compiler.y"
    { spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text); free(yyvsp[0].text); }
    break;

  case 111:
#line 758 "compiler.y"
    { spl_asm_add(as, SPL_OP_HENC, 0); }
    break;

  case 112:
#line 761 "compiler.y"
    { spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text); free(yyvsp[0].text); }
    break;

  case 113:
#line 765 "compiler.y"
    { spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text); free(yyvsp[0].text); }
    break;

  case 115:
#line 771 "compiler.y"
    { spl_asm_add(as, SPL_OP_CAT, 0); }
    break;

  case 117:
#line 783 "compiler.y"
    { spl_asm_add(as, SPL_OP_POSTINC, 0); }
    break;

  case 118:
#line 784 "compiler.y"
    { spl_asm_add(as, SPL_OP_POSTDEC, 0); }
    break;

  case 119:
#line 785 "compiler.y"
    { spl_asm_add(as, SPL_OP_PREINC, 0); }
    break;

  case 120:
#line 786 "compiler.y"
    { spl_asm_add(as, SPL_OP_PREDEC, 0); }
    break;

  case 121:
#line 788 "compiler.y"
    { spl_asm_add(as, SPL_OP_LENGTH, 0); }
    break;

  case 122:
#line 789 "compiler.y"
    { spl_asm_add(as, SPL_OP_ELEMENTS, 0); }
    break;

  case 123:
#line 791 "compiler.y"
    { spl_asm_add(as, SPL_OP_CAT, 0); }
    break;

  case 124:
#line 794 "compiler.y"
    { spl_asm_add(as, SPL_OP_ZERO, 0); }
    break;

  case 125:
#line 796 "compiler.y"
    {
			char *fname;
			my_asprintf(&fname, "encode_%s", yyvsp[-3].text);
			spl_asm_add(as, SPL_OP_PUSHAV, 0);
			spl_asm_add(as, SPL_OP_DCALL, fname);
			free(fname); free(yyvsp[-3].text);
		}
    break;

  case 127:
#line 805 "compiler.y"
    { spl_asm_add(as, SPL_OP_NEG, 0); }
    break;

  case 128:
#line 806 "compiler.y"
    { spl_asm_add(as, SPL_OP_LNOT, 0); }
    break;

  case 129:
#line 809 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNDEF, 0); }
    break;

  case 130:
#line 811 "compiler.y"
    { spl_asm_add(as, SPL_OP_DEFINED, 0); }
    break;

  case 131:
#line 813 "compiler.y"
    { spl_asm_add(as, SPL_OP_DECLARED, 0); }
    break;

  case 132:
#line 816 "compiler.y"
    { spl_asm_add(as, SPL_OP_UNDEF, 0); }
    break;

  case 134:
#line 820 "compiler.y"
    {
			lbstack_push();
			pbstack_push(spl_asm_add(as, yyvsp[-1].ch == 'F' ? SPL_OP_REGF : SPL_OP_REGM, 0));
		}
    break;

  case 135:
#line 825 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_CLEARA, 0);
		}
    break;

  case 136:
#line 829 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_UNDEF, 0);
			spl_asm_add(as, SPL_OP_RETURN, 0);
			spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0));
			lbstack_pop();
		}
    break;

  case 137:
#line 837 "compiler.y"
    {
			lbstack_push();
			pbstack_push(spl_asm_add(as, SPL_OP_ENTER, 0));
		}
    break;

  case 138:
#line 842 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_UNDEF, 0);
			spl_asm_add(as, SPL_OP_RETURN, 0);
			spl_asm_setaddr(as, pbstack_pop(),
			spl_asm_add(as, SPL_OP_NOP, 0));
			lbstack_pop();
		}
    break;

  case 139:
#line 851 "compiler.y"
    { no_checkp_insn++; }
    break;

  case 140:
#line 853 "compiler.y"
    { no_checkp_insn--; }
    break;

  case 141:
#line 856 "compiler.y"
    { no_checkp_insn++; }
    break;

  case 142:
#line 857 "compiler.y"
    { spl_asm_add(as, SPL_OP_BEGIN, 0); }
    break;

  case 143:
#line 859 "compiler.y"
    { spl_asm_add(as, SPL_OP_END, 0); }
    break;

  case 144:
#line 860 "compiler.y"
    { no_checkp_insn--; }
    break;

  case 145:
#line 863 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_ZERO, 0)); }
    break;

  case 146:
#line 865 "compiler.y"
    {
			pbstack_pop();
			spl_asm_add(as, SPL_OP_LIFTCALL, 0);
			spl_asm_add(as, SPL_OP_CALL, 0);
		}
    break;

  case 147:
#line 872 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_ZERO, 0)); }
    break;

  case 148:
#line 874 "compiler.y"
    {
			pbstack_pop();
			spl_asm_add(as, SPL_OP_DCALL, "_");
		}
    break;

  case 150:
#line 884 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0)); }
    break;

  case 151:
#line 886 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_ZERO, 0)); }
    break;

  case 152:
#line 888 "compiler.y"
    {
			int call_pos = spl_asm_add(as, SPL_OP_NEW, 0);
			int arg_pos = pbstack_pop();
			int fp_pos = pbstack_pop();

			int fp_size = arg_pos - fp_pos;
			int arg_size = call_pos - arg_pos;

			spl_asm_shuffle(as,
				fp_size, fp_pos, fp_pos + arg_size,
				arg_size, arg_pos, fp_pos,
				-1);
		}
    break;

  case 153:
#line 903 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0)); }
    break;

  case 154:
#line 905 "compiler.y"
    { spl_asm_add(as, SPL_OP_SETCTX, 0); }
    break;

  case 155:
#line 906 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_ZERO, 0)); }
    break;

  case 156:
#line 908 "compiler.y"
    {
			int call_pos = spl_asm_add(as, SPL_OP_CALL, 0);
			int arg_pos = pbstack_pop();
			int fp_pos = pbstack_pop();

			int fp_size = arg_pos - fp_pos;
			int arg_size = call_pos - arg_pos;

			spl_asm_shuffle(as,
				fp_size, fp_pos, fp_pos + arg_size,
				arg_size, arg_pos, fp_pos,
				-1);
		}
    break;

  case 157:
#line 923 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_ZERO, 0)); }
    break;

  case 158:
#line 925 "compiler.y"
    {
			pbstack_pop();
			spl_asm_add(as, SPL_OP_CLIB, yyvsp[-5].text);
			free(yyvsp[-5].text);
		}
    break;

  case 159:
#line 932 "compiler.y"
    { pbstack_push(spl_asm_add(as, SPL_OP_ZERO, 0)); }
    break;

  case 160:
#line 934 "compiler.y"
    {
			pbstack_pop();
			spl_asm_add(as, SPL_OP_DCALL, yyvsp[-5].text);
			free(yyvsp[-5].text);
		}
    break;

  case 163:
#line 946 "compiler.y"
    { spl_asm_add(as, SPL_OP_TOINT, 0); }
    break;

  case 164:
#line 949 "compiler.y"
    { spl_asm_add(as, SPL_OP_TOFLOAT, 0); }
    break;

  case 165:
#line 951 "compiler.y"
    { spl_asm_add(as, SPL_OP_GETVAL, 0); }
    break;

  case 166:
#line 956 "compiler.y"
    { spl_asm_add(as, SPL_OP_POPIC, 0); }
    break;

  case 167:
#line 958 "compiler.y"
    { spl_asm_add(as, SPL_OP_POPUC, 0); }
    break;

  case 168:
#line 961 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 169:
#line 966 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_ADD, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 170:
#line 972 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 171:
#line 977 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_SUB, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 172:
#line 983 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 173:
#line 988 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_MUL, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 174:
#line 994 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 175:
#line 999 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_DIV, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 176:
#line 1005 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 177:
#line 1010 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_MOD, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 178:
#line 1016 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 179:
#line 1021 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_POW, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 180:
#line 1027 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 181:
#line 1032 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_IADD, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 182:
#line 1038 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 183:
#line 1043 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_ISUB, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 184:
#line 1049 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 185:
#line 1054 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_IMUL, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 186:
#line 1060 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 187:
#line 1065 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_IDIV, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 188:
#line 1071 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 189:
#line 1076 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_IMOD, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 190:
#line 1082 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 191:
#line 1087 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_IPOW, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 192:
#line 1093 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 193:
#line 1098 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_FADD, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 194:
#line 1104 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 195:
#line 1109 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_FSUB, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 196:
#line 1115 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 197:
#line 1120 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_FMUL, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 198:
#line 1126 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 199:
#line 1131 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_FDIV, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 200:
#line 1137 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 201:
#line 1142 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_FMOD, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 202:
#line 1148 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 203:
#line 1153 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_FPOW, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 204:
#line 1159 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 205:
#line 1164 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_OBJOP, "add");
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 206:
#line 1170 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 207:
#line 1175 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_OBJOP, "sub");
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 208:
#line 1181 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 209:
#line 1186 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_OBJOP, "mul");
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 210:
#line 1192 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 211:
#line 1197 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_OBJOP, "div");
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 212:
#line 1203 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 213:
#line 1208 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_OBJOP, "mod");
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 214:
#line 1214 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 215:
#line 1219 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_OBJOP, "pow");
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 216:
#line 1225 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
		}
    break;

  case 217:
#line 1230 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_CAT, 0);
			spl_asm_add(as, SPL_OP_POPIC, 0);
		}
    break;

  case 218:
#line 1236 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_UNLESS, 0);
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));
		}
    break;

  case 219:
#line 1241 "compiler.y"
    {
			int bp_pos = pbstack_pop();
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));
			spl_asm_setaddr(as, bp_pos, spl_asm_add(as, SPL_OP_NOP, 0));
		}
    break;

  case 220:
#line 1247 "compiler.y"
    {
			spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0));
		}
    break;

  case 221:
#line 1252 "compiler.y"
    { spl_asm_add(as, SPL_OP_APOP, 0); }
    break;

  case 222:
#line 1254 "compiler.y"
    { spl_asm_add(as, SPL_OP_ASHIFT, 0); }
    break;

  case 223:
#line 1256 "compiler.y"
    { spl_asm_add(as, SPL_OP_APUSH, 0); }
    break;

  case 224:
#line 1258 "compiler.y"
    { spl_asm_add(as, SPL_OP_AUNSHIFT, 0); }
    break;

  case 225:
#line 1260 "compiler.y"
    { spl_asm_add(as, SPL_OP_NEXT, 0); }
    break;

  case 226:
#line 1262 "compiler.y"
    { spl_asm_add(as, SPL_OP_PREV, 0); }
    break;

  case 227:
#line 1265 "compiler.y"
    { spl_asm_add(as, SPL_OP_EVAL, 0); }
    break;

  case 230:
#line 1273 "compiler.y"
    { spl_asm_add(as, SPL_OP_PEQ, 0); }
    break;

  case 231:
#line 1274 "compiler.y"
    { spl_asm_add(as, SPL_OP_PEQ, 0); spl_asm_add(as, SPL_OP_LNOT, 0); }
    break;

  case 232:
#line 1276 "compiler.y"
    { spl_asm_add(as, SPL_OP_ADD, 0); }
    break;

  case 233:
#line 1277 "compiler.y"
    { spl_asm_add(as, SPL_OP_SUB, 0); }
    break;

  case 234:
#line 1278 "compiler.y"
    { spl_asm_add(as, SPL_OP_MUL, 0); }
    break;

  case 235:
#line 1279 "compiler.y"
    { spl_asm_add(as, SPL_OP_DIV, 0); }
    break;

  case 236:
#line 1280 "compiler.y"
    { spl_asm_add(as, SPL_OP_MOD, 0); }
    break;

  case 237:
#line 1281 "compiler.y"
    { spl_asm_add(as, SPL_OP_POW, 0); }
    break;

  case 238:
#line 1283 "compiler.y"
    { spl_asm_add(as, SPL_OP_EQ, 0); }
    break;

  case 239:
#line 1284 "compiler.y"
    { spl_asm_add(as, SPL_OP_NE, 0); }
    break;

  case 240:
#line 1285 "compiler.y"
    { spl_asm_add(as, SPL_OP_LT, 0); }
    break;

  case 241:
#line 1286 "compiler.y"
    { spl_asm_add(as, SPL_OP_GE, 0); }
    break;

  case 242:
#line 1287 "compiler.y"
    { spl_asm_add(as, SPL_OP_LE, 0); }
    break;

  case 243:
#line 1288 "compiler.y"
    { spl_asm_add(as, SPL_OP_GT, 0); }
    break;

  case 244:
#line 1290 "compiler.y"
    { spl_asm_add(as, SPL_OP_IADD, 0); }
    break;

  case 245:
#line 1291 "compiler.y"
    { spl_asm_add(as, SPL_OP_ISUB, 0); }
    break;

  case 246:
#line 1292 "compiler.y"
    { spl_asm_add(as, SPL_OP_IMUL, 0); }
    break;

  case 247:
#line 1293 "compiler.y"
    { spl_asm_add(as, SPL_OP_IDIV, 0); }
    break;

  case 248:
#line 1294 "compiler.y"
    { spl_asm_add(as, SPL_OP_IMOD, 0); }
    break;

  case 249:
#line 1295 "compiler.y"
    { spl_asm_add(as, SPL_OP_IPOW, 0); }
    break;

  case 250:
#line 1297 "compiler.y"
    { spl_asm_add(as, SPL_OP_IEQ, 0); }
    break;

  case 251:
#line 1298 "compiler.y"
    { spl_asm_add(as, SPL_OP_INE, 0); }
    break;

  case 252:
#line 1299 "compiler.y"
    { spl_asm_add(as, SPL_OP_ILT, 0); }
    break;

  case 253:
#line 1300 "compiler.y"
    { spl_asm_add(as, SPL_OP_IGE, 0); }
    break;

  case 254:
#line 1301 "compiler.y"
    { spl_asm_add(as, SPL_OP_ILE, 0); }
    break;

  case 255:
#line 1302 "compiler.y"
    { spl_asm_add(as, SPL_OP_IGT, 0); }
    break;

  case 256:
#line 1304 "compiler.y"
    { spl_asm_add(as, SPL_OP_FADD, 0); }
    break;

  case 257:
#line 1305 "compiler.y"
    { spl_asm_add(as, SPL_OP_FSUB, 0); }
    break;

  case 258:
#line 1306 "compiler.y"
    { spl_asm_add(as, SPL_OP_FMUL, 0); }
    break;

  case 259:
#line 1307 "compiler.y"
    { spl_asm_add(as, SPL_OP_FDIV, 0); }
    break;

  case 260:
#line 1308 "compiler.y"
    { spl_asm_add(as, SPL_OP_FMOD, 0); }
    break;

  case 261:
#line 1309 "compiler.y"
    { spl_asm_add(as, SPL_OP_FPOW, 0); }
    break;

  case 262:
#line 1311 "compiler.y"
    { spl_asm_add(as, SPL_OP_FEQ, 0); }
    break;

  case 263:
#line 1312 "compiler.y"
    { spl_asm_add(as, SPL_OP_FNE, 0); }
    break;

  case 264:
#line 1313 "compiler.y"
    { spl_asm_add(as, SPL_OP_FLT, 0); }
    break;

  case 265:
#line 1314 "compiler.y"
    { spl_asm_add(as, SPL_OP_FGE, 0); }
    break;

  case 266:
#line 1315 "compiler.y"
    { spl_asm_add(as, SPL_OP_FLE, 0); }
    break;

  case 267:
#line 1316 "compiler.y"
    { spl_asm_add(as, SPL_OP_FGT, 0); }
    break;

  case 268:
#line 1318 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "add"); }
    break;

  case 269:
#line 1319 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "sub"); }
    break;

  case 270:
#line 1320 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "mul"); }
    break;

  case 271:
#line 1321 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "div"); }
    break;

  case 272:
#line 1322 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "mod"); }
    break;

  case 273:
#line 1323 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "pow"); }
    break;

  case 274:
#line 1325 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "eq"); }
    break;

  case 275:
#line 1326 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "ne"); }
    break;

  case 276:
#line 1327 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "lt"); }
    break;

  case 277:
#line 1328 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "ge"); }
    break;

  case 278:
#line 1329 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "le"); }
    break;

  case 279:
#line 1330 "compiler.y"
    { spl_asm_add(as, SPL_OP_OBJOP, "gt"); }
    break;

  case 280:
#line 1332 "compiler.y"
    { spl_asm_add(as, SPL_OP_SEQ, 0); }
    break;

  case 281:
#line 1333 "compiler.y"
    { spl_asm_add(as, SPL_OP_SNE, 0); }
    break;

  case 282:
#line 1334 "compiler.y"
    { spl_asm_add(as, SPL_OP_SLT, 0); }
    break;

  case 283:
#line 1335 "compiler.y"
    { spl_asm_add(as, SPL_OP_SGE, 0); }
    break;

  case 284:
#line 1336 "compiler.y"
    { spl_asm_add(as, SPL_OP_SLE, 0); }
    break;

  case 285:
#line 1337 "compiler.y"
    { spl_asm_add(as, SPL_OP_SGT, 0); }
    break;

  case 286:
#line 1345 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_IF, 0);
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));
			spl_asm_add(as, SPL_OP_DROP, 0);
		}
    break;

  case 287:
#line 1352 "compiler.y"
    {
			spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0));
		}
    break;

  case 288:
#line 1357 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_UNLESS, 0);
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));
			spl_asm_add(as, SPL_OP_DROP, 0);
		}
    break;

  case 289:
#line 1364 "compiler.y"
    {
			spl_asm_setaddr(as, pbstack_pop(), spl_asm_add(as, SPL_OP_NOP, 0));
		}
    break;

  case 290:
#line 1369 "compiler.y"
    { spl_asm_add(as, SPL_OP_REMATCH, 0); }
    break;

  case 291:
#line 1372 "compiler.y"
    { spl_asm_add(as, SPL_OP_RESUBST, 0); }
    break;

  case 292:
#line 1375 "compiler.y"
    { spl_asm_add(as, SPL_OP_RESUBST, 0); }
    break;

  case 293:
#line 1378 "compiler.y"
    { spl_asm_add(as, SPL_OP_REMATCH, 0); }
    break;

  case 294:
#line 1379 "compiler.y"
    { spl_asm_add(as, SPL_OP_LNOT, 0); }
    break;

  case 295:
#line 1382 "compiler.y"
    { spl_asm_add(as, SPL_OP_RESUBST, 0); }
    break;

  case 296:
#line 1383 "compiler.y"
    { spl_asm_add(as, SPL_OP_LNOT, 0); }
    break;

  case 297:
#line 1386 "compiler.y"
    { spl_asm_add(as, SPL_OP_RESUBST, 0); }
    break;

  case 298:
#line 1387 "compiler.y"
    { spl_asm_add(as, SPL_OP_LNOT, 0); }
    break;

  case 299:
#line 1390 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_BEGIN, 0);

			if (yyvsp[0].ch & REGEX_EVAL_SUBST) {
				spl_asm_add(as, SPL_OP_COPY, 0);
				spl_asm_add(as, SPL_OP_PUSHC, "#name");
				spl_asm_add(as, SPL_OP_XCHG, 0);
				spl_asm_add(as, SPL_OP_POPL, 0);
				spl_asm_add(as, SPL_OP_GETVAL, 0);
			}

			spl_asm_add(as, SPL_OP_PUSHC, "#text");
			spl_asm_add(as, SPL_OP_XCHG, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "#array");
			spl_asm_add(as, SPL_OP_PUSH, "#text");
		}
    break;

  case 300:
#line 1409 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_REMATCH, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "#index");
			spl_asm_add(as, SPL_OP_UNDEF, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "#newtext");
			spl_asm_add(as, SPL_OP_UNDEF, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);

			pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0));

			spl_asm_add(as, SPL_OP_PUSHC, "#index");
			spl_asm_add(as, SPL_OP_PUSH, "#array");
			spl_asm_add(as, SPL_OP_PUSH, "#index");
			spl_asm_add(as, SPL_OP_NEXT, 0);
			spl_asm_add(as, SPL_OP_COPY, 0);
			spl_asm_add(as, SPL_OP_DEFINED, 0);
			spl_asm_add(as, SPL_OP_UNLESS, 0);
			pbstack_push(spl_asm_add(as, SPL_OP_JUMP, 0));

			spl_asm_add(as, SPL_OP_POPL, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "#reres");
			spl_asm_add(as, SPL_OP_PUSHC, "#array");
			spl_asm_add(as, SPL_OP_PUSH, "#index");
			spl_asm_add(as, SPL_OP_HENC, 0);
			spl_asm_add(as, SPL_OP_DOTCAT, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);

			spl_asm_add(as, SPL_OP_PUSHC, "#newtext");
			spl_asm_add(as, SPL_OP_PUSH, "#newtext");
			spl_asm_add(as, SPL_OP_PUSH, "#reres.=NC");
			spl_asm_add(as, SPL_OP_CAT, 0);

			spl_asm_add(as, SPL_OP_BEGIN, 0);
		}
    break;

  case 301:
#line 1450 "compiler.y"
    {
			spl_asm_add(as, SPL_OP_END, 0);

			int finish_jump = pbstack_pop();

			spl_asm_add(as, SPL_OP_CAT, 0);
			spl_asm_add(as, SPL_OP_POPL, 0);

			spl_asm_setaddr(as, spl_asm_add(as, SPL_OP_JUMP, 0), pbstack_pop());
			spl_asm_setaddr(as, finish_jump, spl_asm_add(as, SPL_OP_DROP, 0));
			spl_asm_add(as, SPL_OP_DROP, 0);

			spl_asm_add(as, SPL_OP_PUSH, "#newtext");
			spl_asm_add(as, SPL_OP_DEFINED, 0);
			spl_asm_add(as, SPL_OP_UNLESS, 0);
			int p1 = spl_asm_add(as, SPL_OP_JUMP, 0);

			if (yyvsp[-7].ch & REGEX_EVAL_SUBST)
				spl_asm_add(as, SPL_OP_PUSH, "#name");

			spl_asm_add(as, SPL_OP_PUSH, "#newtext");
			spl_asm_add(as, SPL_OP_PUSHC, "#array");
			spl_asm_add(as, SPL_OP_PUSH, "#index");
			spl_asm_add(as, SPL_OP_HENC, 0);
			spl_asm_add(as, SPL_OP_DOTCAT, 0);
			spl_asm_add(as, SPL_OP_PUSHC, "=LC");
			spl_asm_add(as, SPL_OP_DOTCAT, 0);
			spl_asm_add(as, SPL_OP_GETVAL, 0);
			spl_asm_add(as, SPL_OP_CAT, 0);

			if (yyvsp[-7].ch & REGEX_EVAL_SUBST) {
				spl_asm_add(as, SPL_OP_POPI, 0);
				spl_asm_setaddr(as, p1, spl_asm_add(as, SPL_OP_NOP, 0));
			}

			if (yyvsp[-7].ch & REGEX_EVAL_RETURN) {
				int p2 = spl_asm_add(as, SPL_OP_JUMP, 0);
				spl_asm_setaddr(as, p1, spl_asm_add(as, SPL_OP_PUSH, "#text"));
				spl_asm_setaddr(as, p2, spl_asm_add(as, SPL_OP_NOP, 0));
			}

			if (yyvsp[-7].ch & REGEX_EVAL_SUBST) {
				spl_asm_add(as, SPL_OP_PUSH, "#array");
				spl_asm_add(as, SPL_OP_ZERO, 0);
				spl_asm_add(as, SPL_OP_IADD, 0);
			}

			spl_asm_add(as, SPL_OP_END, 0);
			if (yyvsp[-7].ch & REGEX_EVAL_NEG)
				spl_asm_add(as, SPL_OP_LNOT, 0);
			CHECKPOINT();
		}
    break;

  case 307:
#line 1515 "compiler.y"
    { spl_asm_add(as, SPL_OP_HENC, 0); }
    break;

  case 308:
#line 1517 "compiler.y"
    { spl_asm_add(as, SPL_OP_APUSHREFID, 0); }
    break;

  case 309:
#line 1519 "compiler.y"
    { spl_asm_add(as, SPL_OP_APUSHREFID, 0); }
    break;

  case 310:
#line 1521 "compiler.y"
    { spl_asm_add(as, SPL_OP_APUSHREF, 0); }
    break;

  case 312:
#line 1526 "compiler.y"
    { spl_asm_add(as, SPL_OP_GETVAL, 0); }
    break;

  case 316:
#line 1535 "compiler.y"
    { spl_asm_add(as, SPL_OP_POPA, yyvsp[0].text); free(yyvsp[0].text); }
    break;

  case 317:
#line 1538 "compiler.y"
    {
		spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text);
		spl_asm_add(as, SPL_OP_APOPA, 0);
		free(yyvsp[0].text);
	}
    break;

  case 318:
#line 1545 "compiler.y"
    {
		spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text);
		spl_asm_add(as, SPL_OP_UNDEF, 0);
		spl_asm_add(as, SPL_OP_POPLC, 0);
		spl_asm_add(as, SPL_OP_HGETA, 0);
		free(yyvsp[0].text);
	}
    break;

  case 325:
#line 1565 "compiler.y"
    {
		pbstack_push(spl_asm_add(as, SPL_OP_NOP, 0));
	}
    break;

  case 327:
#line 1573 "compiler.y"
    {
		int begin_this_param = pbstack_pop();
		int begin_param_list = pbstack_pop() + 1;

		int size_list = begin_this_param - begin_param_list;
		int size_this = spl_asm_add(as, SPL_OP_PUSHAV, 0) + 1 - begin_this_param;

		spl_asm_shuffle(as,
			size_list, begin_param_list, begin_param_list+size_this,
			size_this, begin_this_param, begin_param_list,
			-1);

		pbstack_push(begin_param_list - 1);
	}
    break;

  case 328:
#line 1590 "compiler.y"
    {
		int begin_this_param = pbstack_pop();
		int begin_param_list = pbstack_pop() + 1;

		int size_list = begin_this_param - begin_param_list;
		int size_this = spl_asm_add(as, SPL_OP_APUSHA, 0) + 1 - begin_this_param;

		spl_asm_shuffle(as,
			size_list, begin_param_list, begin_param_list+size_this,
			size_this, begin_this_param, begin_param_list,
			-1);

		pbstack_push(begin_param_list - 1);
	}
    break;

  case 329:
#line 1607 "compiler.y"
    {
		int begin_this_param = pbstack_pop();
		int begin_param_list = pbstack_pop() + 1;

		int size_list = begin_this_param - begin_param_list;
		int size_this = spl_asm_add(as, SPL_OP_HSETA, 0) + 1 - begin_this_param;

		spl_asm_shuffle(as,
			size_list, begin_param_list, begin_param_list+size_this,
			size_this, begin_this_param, begin_param_list,
			-1);

		pbstack_push(begin_param_list - 1);
	}
    break;

  case 330:
#line 1624 "compiler.y"
    {
		int begin_this_param = pbstack_pop();
		int begin_param_list = pbstack_pop() + 1;

		int size_list = begin_this_param - begin_param_list;
		int size_this = spl_asm_add(as, SPL_OP_APUSHREFID, 0) + 1 - begin_this_param;

		spl_asm_shuffle(as,
			size_list, begin_param_list, begin_param_list+size_this,
			size_this, begin_this_param, begin_param_list,
			-1);

		pbstack_push(begin_param_list - 1);
	}
    break;

  case 331:
#line 1641 "compiler.y"
    { spl_asm_add(as, SPL_OP_PUSHC, yyvsp[0].text); free(yyvsp[0].text); }
    break;


    }

/* Line 991 of yacc.c.  */
#line 4800 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#if ! defined(__cplusplus)
  __attribute__ ((__unused__))
#endif
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1645 "compiler.y"


static struct {
	char *text;
	int lex;
} lex_ops[] = {
	{ "(**)=", OPOWEQ },
	{ "#**=", IPOWEQ },
	{ ".**=", FPOWEQ },

	{ "(**)", OPOW },

	{ "(+)=", OADDEQ },
	{ "(-)=", OSUBEQ },
	{ "(*)=", OMULEQ },
	{ "(/)=", ODIVEQ },
	{ "(%)=", OMODEQ },

	{ "(==)", OEQ },
	{ "(!=)", ONE },
	{ "(<=)", OLE },
	{ "(>=)", OGE },

	{ "(<)", OLT },
	{ "(>)", OGT },

	{ "(+)", OADD },
	{ "(-)", OSUB },
	{ "(*)", OMUL },
	{ "(/)", ODIV },
	{ "(%)", OMOD },

	{ "[*]", SPECIALREF },
	{ "[+]", SPECIALREF },
	{ "[/]", SPECIALREF },
	{ "[.]", SPECIALREF },

	{ ">>>", STRING_EOL },
	{ "<<<", STRING_EOL_S },

	{ "<=>", XCHG },

	{ "^==", PEQ },
	{ "^!=", PNE },

	{ "#==", IEQ },
	{ "#!=", INE },
	{ "#<=", ILE },
	{ "#>=", IGE },

	{ ".==", FEQ },
	{ ".!=", FNE },
	{ ".<=", FLE },
	{ ".>=", FGE },

	{ "~==", SEQ },
	{ "~!=", SNE },
	{ "~<=", SLE },
	{ "~>=", SGE },

	{ "#+=", IADDEQ },
	{ "#-=", ISUBEQ },
	{ "#*=", IMULEQ },
	{ "#/=", IDIVEQ },
	{ "#%=", IMODEQ },

	{ ".+=", FADDEQ },
	{ ".-=", FSUBEQ },
	{ ".*=", FMULEQ },
	{ "./=", FDIVEQ },
	{ ".%=", FMODEQ },

	{ "**=", POWEQ },
	{ "#**", IPOW },
	{ ".**", FPOW },

	{ ">>", STRING_LABEL },
	{ "<<", STRING_LABEL_S },

	{ "#<", ILT },
	{ "#>", IGT },

	{ ".<", FLT },
	{ ".>", FGT },

	{ "~<", SLT },
	{ "~>", SGT },

	{ ",,", DBLCOMMA },
	{ ":=", SETCOPY },

	{ "||", LOR },
	{ "&&", LAND },

	{ "++", INC },
	{ "--", DEC },

	{ "==", EQ },
	{ "!=", NE },
	{ "<=", LE },
	{ ">=", GE },

	{ "+=", ADDEQ },
	{ "-=", SUBEQ },
	{ "*=", MULEQ },
	{ "/=", DIVEQ },
	{ "%=", MODEQ },

	{ "#+", IADD },
	{ "#-", ISUB },
	{ "#*", IMUL },
	{ "#/", IDIV },
	{ "#%", IMOD },

	{ ".+", FADD },
	{ ".-", FSUB },
	{ ".*", FMUL },
	{ "./", FDIV },
	{ ".%", FMOD },

	{ "**", POW },

	{ "::", ENC },
	{ "~=", SAPPEND },

	{ "=>", ARRAYREF },

	{ "<", LT },
	{ ">", GT },

	{ "!", LNOT },

	{ "+", ADD },
	{ "-", SUB },
	{ "*", MUL },
	{ "/", DIV },
	{ "%", MOD },

	{ "~", CAT },

	{ 0, 0 }
};

static struct {
	char *text;
	int lex;
} lex_keywords[] = {
	{ "debug", DEBUG },
	{ "warning", WARNING },
	{ "panic", ERROR },
	{ "delete", DELETE },
	{ "function", FUNCTION },
	{ "method", METHOD },
	{ "import", IMPORT },
	{ "load", LOAD },
	{ "new", NEW },
	{ "this", THIS },
	{ "object", OBJECT },
	{ "var", VAR },
	{ "static", STATIC },
	{ "if", IF },
	{ "else", ELSE },
	{ "do", DO },
	{ "while", WHILE },
	{ "for", FOR },
	{ "foreach", FOREACH },
	{ "asm", ASM },
	{ "return", RETURN },
	{ "exit", EXIT },
	{ "defined", DEFINED },
	{ "declared", DECLARED },
	{ "undef", UNDEF },
	{ "goto", GOTO },
	{ "break", BREAK },
	{ "continue", CONTINUE },
	{ "pop", POP },
	{ "shift", SHIFT },
	{ "push", PUSH },
	{ "unshift", UNSHIFT },
	{ "next", NEXT },
	{ "prev", PREV },
	{ "eval", EVAL },

	{ "not",  LNOT },
	{ "and",  LAND },
	{ "or",   LOR },

	{ "try",   TRY },
	{ "catch", CATCH },
	{ "throw", THROW },

	{ "switch", SWITCH },
	{ "default", DEFAULT },
	{ "case", CASE },

	{ "lengthof", LENGTHOF },
	{ "elementsof", ELEMENTSOF },

	{ 0, 0 }
};

struct lex_srcfile;
struct lex_srcfile {
	struct lex_srcfile *next;
	const char *text;
	const char *name;
};

struct lex_item;
struct lex_item {
	char *text;
	int lex;
	struct lex_item *next, *prev;
	struct lex_srcfile *src;
	const char *pos;
};

static const char *input;
static char *encoding;

static spl_malloc_file_function *malloc_file_func;
static struct lex_item *lex_item_list_first;
static struct lex_item *lex_item_list_last;
static struct lex_item *lex_last_item;

static struct lex_item *lex_translate_ptr;
int lex_translate_count;

static struct lex_srcfile *lex_srcfile_list;
static struct lex_srcfile *lex_srcfile_current;

static jmp_buf lex_goterr;
static char *lex_errstr;

struct define {
	int active, isarg;
	char *name, *text, *args;
	struct define *next;
};

static int in_pragma_arg;
static struct define *define_list;
static char *current_define;
static int define_recursion;

static struct lex_item *lex_insert(struct lex_item *insertafter, int lex, char *text)
{
	if (in_pragma_arg) {
		if (text)
			free(text);
		return 0;
	}

	struct lex_item *item = calloc(1, sizeof(struct lex_item));

	if (spl_yydebug)
		fprintf(stderr, "[Lexer: new symbol %s (%d) with (%s) value]\n",
			yytname[YYTRANSLATE(lex)], lex, text ? text : "");

	item->text = text;
	item->lex = lex;

	item->src = lex_srcfile_current;
	item->pos = input;

	if (insertafter == lex_item_list_last)
		insertafter = 0;

	if (insertafter) {
		struct lex_item *next = insertafter->next;
		next->prev = insertafter->next = item;
		item->prev = insertafter;
		item->next = next;
	} else {
		if (lex_item_list_first) {
			lex_item_list_last->next = item;
			item->prev = lex_item_list_last;
		} else
			lex_item_list_first = item;
		lex_item_list_last = item;
	}

	return item;
}

static struct lex_item *lex_new(int lex, char *text)
{
	return lex_insert(0, lex, text);
}

static struct lex_item *lex_new_translate(int lex, char *text)
{
	if (!lex_translate_ptr)
		return lex_insert(0, lex, text);

	lex_translate_ptr = lex_insert(lex_translate_ptr, lex, text);
	return lex_translate_ptr;
}

static int spl_yylex()
{
	if ( !lex_item_list_first )
		return 0;

	int lex = lex_item_list_first->lex;
	spl_yylval.text = lex_item_list_first->text;

	if (spl_yydebug)
		fprintf(stderr, "[Lexer: shifting symbol %s (%d) with (%s) value] ",
			yytname[YYTRANSLATE(lex)], lex, spl_yylval.text ? spl_yylval.text : "");

	if (lex_last_item)
		free(lex_last_item);

	lex_last_item = lex_item_list_first;
	lex_item_list_first = lex_item_list_first->next;

	return lex;
}

static void spl_lex_pragma();
static void spl_lex_string(char *term, int flags, int indenting_delim);
static void spl_lex_prog_string(char *text);
static void spl_lex_prog(char *term);

#define LEX_STRING_BACKSLASHES	0x0001
#define LEX_STRING_SPLTAGS	0x0002
#define LEX_STRING_REGEX	0x0004

static char *malloc_file_wrapper(const char *filename, int is_embedded)
{
	if ( is_embedded ) {
		char *token;
		my_asprintf(&token, "#embedded-file %s ", filename);

		const char *begin = strstr(lex_srcfile_current->text, token);
		int token_size = strlen(token);
		free(token);
		if ( !begin ) return 0;
		begin += token_size;

		token_size = strcspn(begin, " \r\n\t");
		if ( token_size <= 0 ) return 0;
		token = my_strndup(begin, token_size);
		begin = begin + token_size;
		if ( *begin == ' ' || *begin == '\t' ||
				*begin == '\r' || *begin == '\n' ) begin++;

		const char *end = strstr(begin, token);
		free(token);
		if ( !end ) return 0;

		return my_strndup(begin, end-begin);
	}
	if ( malloc_file_func ) {
		char *retval;
		if (*filename != '/' && as->vm && as->vm->current_dir_name) {
			char fullname[strlen(filename) + strlen(as->vm->current_dir_name) + 2];
			sprintf(fullname, "%s/%s", as->vm->current_dir_name, filename);
			retval = malloc_file_func(fullname, 0);
		} else
			retval = malloc_file_func(filename, 0);
		if (retval) {
			if (encoding) {
				char *orig_retval = retval;
				retval = spl_utf8_import(orig_retval, encoding);
				free(orig_retval);
				if (!retval) {
					spl_report(SPL_REPORT_COMPILER, as,
						"Character set (#encoding) '%s' is unknown!\n", encoding);
					return 0;
				}
			}
			if ( spl_utf8_check(retval) ) {
				spl_report(SPL_REPORT_COMPILER, as,
						"Compiler tried to load non-utf8 encoded text!\n"
						"A decoder bug or just a missing '#encoding' pragma?\n");
				free(retval);
				return 0;
			}
		}
		return retval;
	}
	return 0;
}

static char *get_pragma_body()
{
	int data_len = strcspn(input, "\n");

	while (input[data_len] == '\n' && input[data_len+1] == '\\')
		data_len += strcspn(input+data_len+1, "\n")+1;

	char *ret = my_strndup(input, data_len);
	input += data_len;

	for (char *in=ret, *out=ret; (*out = *in) != 0; in++, out++)
		if (in[0] == '\n' && in[1] == '\\') in++;

	return ret;
}

static void import_asm(int mode, unsigned char *bytecode, unsigned char *map, int offset, int bytecode_len)
{
	int next_condit = 0;

next_op:
	if (offset < 16 || offset >= bytecode_len) {
		my_asprintf(&lex_errstr, "Error while importing bytecode file.");
		longjmp(lex_goterr, __LINE__);
	}

	unsigned char op = bytecode[offset];
	int arg_size = 0, arg = 0;
	char *txtarg = 0;

	if (op == SPL_OP_HALT || (mode == 0 && map[offset]))
		return;

	int this_offset = offset++;

	if (op < 0x60) {
		arg_size = 4 - (op & 3);
		op = op & ~3;

		arg = spl_bytes_to_int(arg_size, bytecode + offset);
		offset += arg_size;

		if (op >= 0x20) {
			if (offset + arg >= bytecode_len || offset + arg < 16) {
				my_asprintf(&lex_errstr, "Error while importing bytecode file.");
				longjmp(lex_goterr, __LINE__);
			}
			txtarg = (char*)(bytecode + offset + arg);
		}
	}

	if (mode == 0) {
		int optype = spl_optype(op);
		map[this_offset] = 1;

		int this_condit = next_condit;
		next_condit = optype == 'C';

		if (optype == 'J' && !this_condit) {
			offset += arg;
			goto next_op;
		}

		if (optype == 'J' || optype == 'B')
			import_asm(mode, bytecode, map, offset + arg, bytecode_len);

		if (optype == 'E')
			return;
	}

	if (mode == 1) {
		char buffer[100 + (txtarg ? strlen(txtarg)*2 : 0)];
		int pos = sprintf(buffer, ":BCI_%d_%d %s", import_asm_label_counter, this_offset, spl_asm_op2txt(op));

		if (txtarg) {
			buffer[pos++] = ' ';
			buffer[pos++] = '\"';

			for (int i=0; txtarg[i]; i++)
			{
				if (txtarg[i] == '\n') {
					buffer[pos++] = '\\';
					buffer[pos++] = 'n';
					continue;
				}
				if (txtarg[i] == '\"') {
					buffer[pos++] = '\\';
					buffer[pos++] = '\"';
					continue;
				}
				if (txtarg[i] == '\\') {
					buffer[pos++] = '\\';
					buffer[pos++] = '\\';
					continue;
				}
				buffer[pos++] = txtarg[i];
			}

			buffer[pos++] = '\"';
		}

		if (op < 0x20)
			pos += sprintf(buffer+pos, " :BCI_%d_%d", import_asm_label_counter, offset + arg);

		buffer[pos++] = 0;
		lex_new(VALUE, strdup(buffer));

		while (offset < bytecode_len && !map[offset]) offset++;
		if (offset >= bytecode_len) return;
	}

	goto next_op;
}

static void spl_lex_pragma()
{
	static const char *stop_string = " \t\r\n;,(){}[]*-+~!\'\"@#$%^&=?";
	static const char *hard_pragmas[] = {
		"define", "undef", "encoding",
		"file-as-const", "file-as-code", "file-as-template",
		"file-as-bytecode", "embedded-file",
		0
	};

	// ignore '#!...\n' strings
	if (*input == '!') {
		while (*input && *input != '\n') input++;
		return;
	}

	int stmt_len = strcspn(input, stop_string);

	for (int i=0; hard_pragmas[i]; i++) {
		int len = strlen(hard_pragmas[i]);
		if (!strncmp(input, hard_pragmas[i], len) &&
		    strcspn(input+len, stop_string) == 0) {
			stmt_len = len;
			break;
		}
	}

	char *stmt = my_strndupa(input, stmt_len);

	input += stmt_len;
	input += strspn(input, " \t\r\n");

	int arg_has_asterisk_prefix = 0;
	char *arg = 0;

	if (!strncmp(stmt, "file-as-", 8))
		if ( *input == '*' ) { arg_has_asterisk_prefix=1; input++; }

	if (!strncmp(stmt, "file-as-", 8) || !strcmp(stmt, "encoding") ||
	    !strcmp(stmt, "define") || !strcmp(stmt, "undef") ||
	    !strcmp(stmt, "embedded-file")) {
		int arg_len = strcspn(input, stop_string);
		arg = my_strndupa(input, arg_len);
		input += arg_len;
	}

	if ( !strcmp(stmt, "encoding") ) {
		return;
	}

	if ( !strcmp(stmt, "define") ) {
		if (in_pragma_arg) {
			free(get_pragma_body());
			return;
		}
		struct define *def = calloc(1, sizeof(struct define));
		if (*input == '(') {
			int len = strcspn(input+1, ")");
			def->args = my_strndup(input+1, len);
			for (char *in=def->args, *out=def->args;
					(*out = *in) != 0; in++, out++) {
				while (in[1] == '\n' || in[1] == '\r' ||
				       in[1] == '\t' || in[1] == ' ') in++;
			}
			input += len+2;
		}
		def->name = strdup(arg);
		def->text = get_pragma_body();
		def->next = define_list;
		define_list = def;
		return;
	}

	if ( !strcmp(stmt, "embedded-file") && *input == ' ' ) {
		int token_size = strcspn(++input, " \r\n\t");
		if ( token_size <= 0 ) goto unknown_pragma;

		char *token = my_strndup(input, token_size);
		input = input + token_size;

		const char *end = strstr(input, token);
		free(token);
		if ( !end ) {
			my_asprintf(&lex_errstr, "Can't find end label for #%s.", stmt);
			longjmp(lex_goterr, __LINE__);
		}

		input = end + token_size;
		return;
	}

	if (in_pragma_arg)
		return;

	if ( !strcmp(stmt, "undef") ) {
		struct define **lastp = &define_list;
		struct define *def = define_list;
		while (def) {
			if (!def->isarg && !strcmp(def->name, arg)) {
				*lastp = def->next;
				free(def->name);
				free(def->text);
				if (def->args)
					free(def->args);
				free(def);
				def = *lastp;
			} else {
				lastp = &def->next;
				def = def->next;
			}
		}
		return;
	}

	if ( !strcmp(stmt, "file-as-const") ) {
		char *text = malloc_file_wrapper(arg, arg_has_asterisk_prefix);
		if ( !text ) {
			my_asprintf(&lex_errstr, "Can't open #file-as-const file (%s%s).",
				arg_has_asterisk_prefix ? "*" : "", arg);
			longjmp(lex_goterr, __LINE__);
		}
		lex_new(VALUE, text);
		return;
	}

	if ( !strcmp(stmt, "file-as-code") ) {
		char *text = malloc_file_wrapper(arg, arg_has_asterisk_prefix);
		if ( !text ) {
			my_asprintf(&lex_errstr, "Can't open #file-as-code file (%s%s).",
				arg_has_asterisk_prefix ? "*" : "", arg);
			longjmp(lex_goterr, __LINE__);
		}

		struct lex_srcfile *oldsrc = lex_srcfile_current;
		const char *oldinput = input;

		lex_srcfile_current = malloc(sizeof(struct lex_srcfile));
		lex_srcfile_current->text = input = text;
		lex_srcfile_current->name = strdup(arg);

		lex_srcfile_current->next = lex_srcfile_list;
		lex_srcfile_list = lex_srcfile_current;

		spl_lex_prog(0);

		lex_srcfile_current = oldsrc;
		input = oldinput;
		return;
	}

	if ( !strcmp(stmt, "file-as-template") ) {
		char *text = malloc_file_wrapper(arg, arg_has_asterisk_prefix);
		if ( !text ) {
			my_asprintf(&lex_errstr, "Can't open #file-as-template file (%s%s).",
				arg_has_asterisk_prefix ? "*" : "", arg);
			longjmp(lex_goterr, __LINE__);
		}

		struct lex_srcfile *oldsrc = lex_srcfile_current;
		const char *oldinput = input;

		lex_srcfile_current = malloc(sizeof(struct lex_srcfile));
		lex_srcfile_current->text = input = text;
		lex_srcfile_current->name = strdup(arg);

		lex_srcfile_current->next = lex_srcfile_list;
		lex_srcfile_list = lex_srcfile_current;

		spl_lex_string(0, LEX_STRING_SPLTAGS, 0);

		lex_srcfile_current = oldsrc;
		input = oldinput;
		return;
	}

	if ( !strcmp(stmt, "file-as-bytecode") ) {
		unsigned char *bytecode = 0;
		int bytecode_len = 0;

		if (malloc_file_func) {
			if (*arg != '/' && as->vm && as->vm->current_dir_name) {
				char fullname[strlen(arg) + strlen(as->vm->current_dir_name) + 2];
				sprintf(fullname, "%s/%s", as->vm->current_dir_name, arg);
				bytecode = malloc_file_func(fullname, &bytecode_len);
			} else
				bytecode = malloc_file_func(arg, &bytecode_len);
		}
		if (!bytecode) {
			my_asprintf(&lex_errstr, "Can't open #file-as-bytecode file (%s).", arg);
			longjmp(lex_goterr, __LINE__);
		}
		if (bytecode_len < 16 || memcmp(bytecode, SPL_SIGNATURE, 16)) {
			my_asprintf(&lex_errstr, "Bytecode from #file-as-bytecode file (%s) has invalid signature.", arg);
			longjmp(lex_goterr, __LINE__);
		}

		lex_new(ASM, 0);
		import_asm_label_counter++;
		unsigned char *map = calloc(1, bytecode_len);
		import_asm(0, bytecode, map, 16, bytecode_len);
		import_asm(1, bytecode, map, 16, bytecode_len);
		lex_new(';', 0);

		free(bytecode);
		free(map);
		return;
	}

	for (struct define *def = define_list; def; def = def->next)
		if (!strcmp(def->name, stmt)) {
			lex_new(VALUE, strdup(def->text));
			return;
		}

unknown_pragma:
	my_asprintf(&lex_errstr, "Unknown compiler-pragma #%s.", stmt);
	longjmp(lex_goterr, __LINE__);
}

static void spl_lex_new_string(char *text, int flags)
{
	if ( flags & LEX_STRING_BACKSLASHES ) {
		int i, j;
		for (i=0, j=0; text[i]; i++, j++)
			if ( text[i] == '\\' && text[i+1] ) {
				switch ( text[++i] ) {
					case 'a': text[j] = '\a'; break;
					case 'b': text[j] = '\b'; break;
					case 't': text[j] = '\t'; break;
					case 'n': text[j] = '\n'; break;
					case 'v': text[j] = '\v'; break;
					case 'f': text[j] = '\f'; break;
					case 'r': text[j] = '\r'; break;
					default:  text[j] = input[i];
				}
			} else
				text[j] = text[i];
		text[j] = text[i];
	} else {
		int i, j;
		for (i=0, j=0; text[i]; i++, j++) {
			text[j] = text[i];
		}
		text[j] = text[i];
	}

	if (lex_translate_ptr)
	{
		int newtext_len = 0;
		char *newtext;

		for (int i=0; text[i]; i++, newtext_len++)
			if (text[i] == '{') newtext_len++;

		newtext = malloc(newtext_len+1);
		for (int i=0, j=0; text[i]; i++) {
			newtext[j++] = text[i];
			if (text[i] == '{') newtext[j++] = '}';
		}
		newtext[newtext_len] = 0;

		free(text);
		text = newtext;
	}

	lex_new_translate(VALUE, text);
}

static int spl_lex_findelsetag()
{
	int offset = strspn(input, " \t\r\n");
	if (!strncmp(input + offset, "<spl:else>", 10)) {
		input += offset + 10;
		return 1;
	}
	return 0;
}

static void spl_lex_splifcalltag(int flags, int indenting_delim, int isiftag)
{
	int len = strcspn(input, " \t\r\n>");
	char *funcname, *endtag;
	int hasbody = 1;

	my_asprintf(&funcname, "%s_%.*s",
		isiftag ? "splif" : "splcall",
		len, input);
	my_asprintf(&endtag, "</%s:%.*s>",
		isiftag ? "splif" : "splcall",
		len, input);
	input += len;

	lex_new('(', 0);
	lex_new(ID, funcname);
	lex_new('(', 0);

	while (1)
	{
		input += strspn(input, " \t\r\n");

		if (!isiftag && input[0] == '/' && input[1] == '>') {
			hasbody = 0;
			input++;
		}

		if (*input == '>' || *input == 0) {
			if (*input)
				input++;
			break;
		}

		len = strcspn(input, " \t\r\n=\"\'(>");
		lex_new(ID, my_strndup(input, len));
		lex_new(':', 0);

		input += len;
		input += strcspn(input, "\'\"(>");

		if (*input == '"') {
			input++;
			spl_lex_string("\"", LEX_STRING_BACKSLASHES, 0);
			if (*input == '"') input++;
		}
		if (*input == '\'') {
			input++;
			spl_lex_string("'", LEX_STRING_BACKSLASHES, 0);
			if (*input == '"') input++;
		}
		if (*input == '(') {
			input++;
			spl_lex_prog(")");
			if (*input == ')') input++;
		}

		lex_new(',', 0);
	}

	if (!isiftag && hasbody) {
		lex_new(FUNCTION, 0);
		lex_new('(', 0);
		lex_new(')', 0);
		lex_new('{', 0);
		lex_new(RETURN, 0);
		spl_lex_string(endtag, flags, indenting_delim);
		lex_new(';', 0);
		lex_new('}', 0);
	}

	lex_new(')', 0);

	if (isiftag) {
		lex_new('?', 0);
		spl_lex_string(endtag, flags, indenting_delim);
		lex_new(':', 0);
		if (spl_lex_findelsetag())
			spl_lex_string("</spl:else>", flags, indenting_delim);
		else
			lex_new(VALUE, strdup(""));
	}

	lex_new(')', 0);
	free(endtag);
}

static void spl_lex_spltag(int flags, int indenting_delim)
{
	int len = strcspn(input, " \t\r\n>");
	char *tag = my_strndupa(input, len);

	char *attr_var = 0;
	char *attr_list = 0;
	char *attr_code = 0;
	char *attr_char = 0;

	input += len;
	input += strspn(input, " \t\r\n");

	while ( *input && *input != '>' ) {
		int len = strcspn(input, " \t\r\n\"=>");

		char *attr = my_strndupa(input, len);
		input += len;

		if ( *input == '=' )
		{
			input++;

			if ( *input == '"' ) {
				input++;
				len = strcspn(input, "\"");
			} else
				len = strcspn(input, " \t\r\n\">");

			char *value = my_strndupa(input, len);
			input += len;

			if (*input == '"') input++;
			input += strspn(input, " \t\r\n");

			if ( !strcmp(attr, "var") ) attr_var = value;
			if ( !strcmp(attr, "list") ) attr_list = value;
			if ( !strcmp(attr, "code") ) attr_code = value;
			if ( !strcmp(attr, "char") ) attr_char = value;
		}
	}
	if (*input == '>') input++;

	if ( tag[0] == '_' && tag[strlen(tag)-1] == '_' )
	{
		int endtag_len = strlen(tag) + 10;
		char endtag[endtag_len];

		snprintf(endtag, endtag_len, "</spl:%s>", tag);

		lex_new('(', 0);
		lex_new(ID, strdup(tag));
		spl_lex_string(endtag, flags, indenting_delim);
		lex_new(')', 0);
		return;
	}

	if ( !strcmp(tag, "comment") )
	{
		char *end = strstr(input, "</spl:comment>");
		if (!end) {
			my_asprintf(&lex_errstr, "missing </spl:comment>.");
			longjmp(lex_goterr, __LINE__);
		}
		input = end + strlen("</spl:comment>");
		lex_new(VALUE, strdup(""));
		return;
	}

	if ( !strcmp(tag, "inline") )
	{
		lbstack_push();
		lex_new(INSERT_PROG_BEGIN, 0);
		lex_new(';', 0);
		spl_lex_prog("</spl:inline>");
		input += strlen("</spl:inline>");
		lex_new(INSERT_PROG_END, 0);
		lex_new(VALUE, strdup("undef"));
		lex_new(';', 0);
		lbstack_pop();
		return;
	}

	if ( !strcmp(tag, "code") )
	{
		if ( !attr_code ) {
			lex_new(EF_BEGIN, 0);
			spl_lex_prog("</spl:code>");
			input += strlen("</spl:code>");
			lex_new(EF_END, 0);
		} else {
			lex_new(EF_BEGIN, 0);

			lex_new(VAR, 0);
			lex_new(ID, strdup("_data_"));
			lex_new('=', 0);
			spl_lex_string("</spl:code>", flags, indenting_delim);
			lex_new(';', 0);

			lex_new(RETURN, 0);

			spl_lex_prog_string(strdup(attr_code));

			lex_new(';', 0);

			lex_new(EF_END, 0);
		}
		return;
	}

	if ( !strcmp(tag, "var") )
	{
		if ( !attr_var ) {
			my_asprintf(&lex_errstr, "<spl:var ..> requires attribute 'var'.");
			longjmp(lex_goterr, __LINE__);
		}

		lex_new(EF_BEGIN, 0);

		char *var_name_dup;
		my_asprintf(&var_name_dup, "[*].%s", attr_var);

		if ( !attr_code )
		{
			lex_new(VAR, 0);
			spl_lex_prog_string(var_name_dup);
			lex_new('=', 0);
			spl_lex_string("</spl:var>", flags, indenting_delim);
			lex_new(';', 0);
		}
		else
		{
			lex_new(VAR, 0);
			lex_new(ID, strdup("_data_"));
			lex_new('=', 0);
			spl_lex_string("</spl:var>", flags, indenting_delim);
			lex_new(';', 0);

			lex_new(VAR, 0);
			spl_lex_prog_string(var_name_dup);
			lex_new('=', 0);

			spl_lex_prog_string(strdup(attr_code));

			lex_new(';', 0);
		}

		lex_new(EF_END, 0);

		return;
	}

	if ( !strcmp(tag, "if") )
	{
		if ( !attr_code ) {
			my_asprintf(&lex_errstr, "<spl:if ..> requires attribute 'code'.");
			longjmp(lex_goterr, __LINE__);
		}

		lex_new('(', 0);

		spl_lex_prog_string(strdup(attr_code));

		lex_new('?', 0);

		spl_lex_string("</spl:if>", flags, indenting_delim);

		lex_new(':', 0);

		if (spl_lex_findelsetag())
			spl_lex_string("</spl:else>", flags, indenting_delim);
		else
			lex_new(VALUE, strdup(""));

		lex_new(')', 0);

		return;
	}

	if ( !strcmp(tag, "foreach") )
	{
		if ( !attr_var || !attr_list ) {
			my_asprintf(&lex_errstr, "<spl:foreach ..> requires attributes 'var' and 'list'.");
			longjmp(lex_goterr, __LINE__);
		}

		lex_new(EF_BEGIN, 0);

		lex_new(VAR, 0);
		lex_new(ID, strdup("#iret"));
		lex_new(';', 0);

		lex_new(FOREACH, 0);
		spl_lex_prog_string(strdup(attr_var));
		lex_new('(', 0);
		spl_lex_prog_string(strdup(attr_list));
		lex_new(')', 0);

		lex_new(ID, strdup("#iret"));
		lex_new('=', 0);
		lex_new(ID, strdup("#iret"));
		lex_new(CAT, 0);

		spl_lex_string("</spl:foreach>", flags, indenting_delim);
		lex_new(';', 0);

		lex_new(RETURN, 0);
		lex_new(ID, strdup("#iret"));
		lex_new(';', 0);

		lex_new(EF_END, 0);

		return;
	}

	if ( !strcmp(tag, "indent") )
	{
		lex_new('(', 0);
		spl_lex_string("</spl:indent>", flags, attr_char ? *attr_char : 0);
		lex_new(')', 0);
		return;
	}

	if ( !strcmp(tag, "else") )
	{
		my_asprintf(&lex_errstr, "Found <spl:else> tag without prior <spl:if> or <splif:*> tag.");
		longjmp(lex_goterr, __LINE__);
	}

	my_asprintf(&lex_errstr, "Unknown <spl:*> tag: %s", tag);
	longjmp(lex_goterr, __LINE__);
}

static char *strndup_with_indenting_delim(const char *str, int len, int indenting_delim, int *id_status)
{
	if (!indenting_delim) return my_strndup(str, len);

	char *text = malloc(len + 1);
	int i=0, j=0;

	while (str[i] && i < len) {
		if (!*id_status) {
			if (!strchr(" \t\n\r", str[i])) {
				if (str[i] == indenting_delim) {
					if (str[++i] == ' ') i++;
				}
				*id_status = 1;
				continue;
			}
		} else {
			if (str[i] == '\n')
				*id_status = 0;
			text[j++] = str[i];
		}
		i++;
	}

	text[j++] = 0;
	return realloc(text, j);
}

static void spl_lex_string(char *term, int flags, int indenting_delim)
{
	int len, tlen = term ? strlen(term) : 0;
	int old_php_like_tags_active;
	int old_php_like_tags_indenting_delim;
	int old_lex_translate_count;
	struct lex_item *old_lex_translate_ptr;
	int called_in_php_like_tags_context = 0;
	int term_is_newline = 0;
	int id_status = 0;

	old_lex_translate_count = lex_translate_count;
	old_lex_translate_ptr = lex_translate_ptr;

	if (lex_item_list_last && lex_item_list_last->lex == ID)
	{
		char *translate_id = lex_item_list_last->text;
		int translate_id_len = strlen(translate_id);

		if (!strcmp(translate_id, "_")) {
			translate_id = 0;
		} else {
			if (translate_id_len < 3 || translate_id[0] != '_' || translate_id[translate_id_len-1] != '_')
				goto not_a_translate_call;
			translate_id = my_strndup(translate_id+1, translate_id_len-2);
		}

		lex_translate_ptr = lex_item_list_last;
		lex_item_list_last->lex = TRANSLATE_PREFIX;
		free(lex_item_list_last->text);
		lex_item_list_last->text = 0;
		flags &= ~LEX_STRING_SPLTAGS;

		lex_new(TRANSLATE_SEPERATOR, 0);

		if (translate_id)
			lex_new(VALUE, translate_id);
		else
			lex_new(UNDEF, 0);

not_a_translate_call:;
	}

	if ( term && !strcmp(term, "\n") ) {
		term_is_newline = 1;
		tlen = 0;
	}

	old_php_like_tags_active = php_like_tags_active;
	old_php_like_tags_indenting_delim = php_like_tags_indenting_delim;
	php_like_tags_active = 0;

	if ( term && !strcmp(term, "<?spl?>") ) {
		php_like_tags_active = 1;
		called_in_php_like_tags_context = 1;
		indenting_delim = php_like_tags_indenting_delim;
		term = php_like_tags_term;
		tlen = term ? strlen(term) : 0;
		lex_new(ID, strdup("#tpldata"));
		lex_new(SAPPEND, 0);
	}

	if (!called_in_php_like_tags_context && (flags & LEX_STRING_SPLTAGS)) {
		lbstack_push();
		lex_new(RVALUE_CONTEXT_BEGIN, 0);
	}

	for (len = 0; input[len]; len++)
	{
		if ( flags & (LEX_STRING_BACKSLASHES|LEX_STRING_REGEX) ) {
			if ( input[len] == '\\' && input[len+1] ) { len++; continue; }
		}

		if ( term ) {
			if ( term_is_newline ) {
				if (input[len] == '\r' || input[len] == '\n') {
					if (input[len] == '\r') len++;
					if (input[len] == '\n') len++;
					break;
				}
			} else
				if ( !strncmp(input+len, term, tlen) )
					break;
		}

		if ( flags & LEX_STRING_SPLTAGS )
		{
			if ( !strncmp(input+len, "<splif:", 7) )
			{
				spl_lex_new_string(strndup_with_indenting_delim(input, len, indenting_delim, &id_status), flags);
				input += len + 7;
				lex_new(CAT, 0);

				spl_lex_splifcalltag(flags, indenting_delim, 1);

				lex_new(CAT, 0);
				len = -1;
				continue;
			}

			if ( !strncmp(input+len, "<splcall:", 9) )
			{
				spl_lex_new_string(strndup_with_indenting_delim(input, len, indenting_delim, &id_status), flags);
				input += len + 9;
				lex_new(CAT, 0);

				spl_lex_splifcalltag(flags, indenting_delim, 0);

				lex_new(CAT, 0);
				len = -1;
				continue;
			}

			if ( !strncmp(input+len, "<spl:", 5) )
			{
				spl_lex_new_string(strndup_with_indenting_delim(input, len, indenting_delim, &id_status), flags);
				input += len + 5;
				lex_new(CAT, 0);

				spl_lex_spltag(flags, indenting_delim);

				lex_new(CAT, 0);
				len = -1;
				continue;
			}

			if ( !strncmp(input+len, "<?spl", 5) &&
			     (input[len+5] == ' ' || input[len+5] == '\t' ||
			      input[len+5] == '\r' || input[len+5] == '\n' ||
			      input[len+5] == '?') ) {
				spl_lex_new_string(strndup_with_indenting_delim(input, len, indenting_delim, &id_status), flags);
				input += len + 5;

				if ( called_in_php_like_tags_context ) {
					lex_new(';', 0);
					return;
				}

				if ( !php_like_tags_active ) {
					lex_new(CAT, 0);
					lex_new(INSERT_PROG_BEGIN, 0);
					lex_new(';', 0);

					lex_new(VAR, 0);
					lex_new(ID, strdup("#tpldata"));

					php_like_tags_active = 1;
					php_like_tags_term = term;
					php_like_tags_indenting_delim = indenting_delim;
				}

				lex_new(';', 0);
				spl_lex_prog("?>");
				input += 2;

				lex_new(ID, strdup("#tpldata"));
				lex_new(SAPPEND, 0);

				len = -1;
				continue;
			}
		}

		if ( input[len] == '$' && (!(flags & LEX_STRING_REGEX) ||
		     isalpha((unsigned char)input[len+1]) || strchr("_({$:[", input[len+1])) )
		{
			spl_lex_new_string(strndup_with_indenting_delim(input, len, indenting_delim, &id_status), flags);
			input += len + 1;

			if (lex_translate_ptr) {
				char *translate_token;
				my_asprintf(&translate_token, "{%d}", lex_translate_count++);
				lex_new_translate(CAT, 0);
				lex_new_translate(VALUE, translate_token);
				lex_new(TRANSLATE_SEPERATOR, 0);
			} else
				lex_new(CAT, 0);

			switch ( *input )
			{
				case '(':
					lex_new(EF_BEGIN, 0); input++;
					spl_lex_prog(")");
					lex_new(EF_END, 0); input++;
					break;

				case '{':
					lex_new('(', 0); input++;
					spl_lex_prog("}");
					lex_new(')', 0); input++;
					break;

				case '@':
				case '#':
				case ']': {
					char prog[3] = { '$', *input, 0 };
					spl_lex_prog_string(strdup(prog));
					input++;
					break;
				}

				case '$':
				case ':':
				case '?':
					len = 0;
					goto skip_2nd_cat_op;

				case ' ':
				case '\t':
				case '\r':
				case '\n':
					len = -1;
					while (*input == ' ' || *input == '\t') input++;
					if (*input == '\r') input++;
					if (*input == '\n') input++;
					goto skip_2nd_cat_op;

				case '[':
					len = -1;
					while (*input && *input != ']') input++;
					if (*input == ']') input++;
					goto skip_2nd_cat_op;

				case '<': {
					char *regex_result_id;
					int len = strcspn(++input, ">");
					my_asprintf(&regex_result_id, "#reres.%.*s", len, input);
					lex_new(ID, regex_result_id);
					input += len;
					if (*input == '>') input++;
					break;
				}

				case '-':
				case '+':
				case '0' ... '9': {
					char *regex_result_id;
					int len = 1; /* strspn(input, "0123456789"); */
					if (*input == '-' || *input == '+')
						my_asprintf(&regex_result_id, "#reres.%s", *input == '-' ? "=NC" : "=LC");
					else
						my_asprintf(&regex_result_id, "#reres.%.*s", len, input);
					lex_new(ID, regex_result_id);
					input += len;
					break;
				}

				case 'a' ... 'z':
				case 'A' ... 'Z':
				case '_': {
					int len = 0;
					while (1) {
						if (input[len] >= 'a' && input[len] <= 'z') len++;
						else if (input[len] >= 'A' && input[len] <= 'Z') len++;
						else if (input[len] >= '0' && input[len] <= '9') len++;
						else if (input[len] == '_' || input[len] == '.') len++;
						else break;
					}
					while ( input[len-1] == '.' ) len--;

					lex_new('(', 0);
					spl_lex_prog_string(my_strndup(input, len));
					lex_new(')', 0);

					input += len;
					break;
				}

				default:
					my_asprintf(&lex_errstr, "Unrecognised $ substitution in string.");
					longjmp(lex_goterr, __LINE__);
					break;
			}

			lex_new_translate(CAT, 0);
			len = -1;
skip_2nd_cat_op:;
		}
	}

	spl_lex_new_string(strndup_with_indenting_delim(input, len, indenting_delim, &id_status), flags);
	input += len + tlen;

	if (php_like_tags_active) {
		lex_new(';', 0);
		lex_new(INSERT_PROG_END, 0);
		lex_new(VALUE, strdup("push \"#tpldata\""));
		lex_new(';', 0);
	}

	if (!called_in_php_like_tags_context && (flags & LEX_STRING_SPLTAGS)) {
		lex_new(RVALUE_CONTEXT_END, 0);
		lbstack_pop();
	}

	if (lex_translate_ptr && !old_lex_translate_ptr) {
		lex_new(TRANSLATE_END, 0);
		lex_translate_count = old_lex_translate_count;
		lex_translate_ptr = old_lex_translate_ptr;
	}

	php_like_tags_active = old_php_like_tags_active;
	php_like_tags_indenting_delim = old_php_like_tags_indenting_delim;
}

static void spl_lex_prog_string(char *text)
{
	const char *oldinput = input;
	struct lex_srcfile *oldsrc = lex_srcfile_current;

	lex_srcfile_current = malloc(sizeof(struct lex_srcfile));
	lex_srcfile_current->text = input = text;
	my_asprintf((char**)&lex_srcfile_current->name, "%s:byte(%d)",
			oldsrc->name, (int)(oldinput - oldsrc->text));

	lex_srcfile_current->next = lex_srcfile_list;
	lex_srcfile_list = lex_srcfile_current;

	spl_lex_prog(0);

	lex_srcfile_current = oldsrc;
	input = oldinput;
}

static void spl_lex_prog(char *term)
{
	int tlen = term ? strlen(term) : 0;
	int last_was_id = 0;

	struct lex_item *old_lex_translate_ptr = lex_translate_ptr;
	int old_lex_translate_count = lex_translate_count;
	lex_translate_ptr = 0;
	lex_translate_count = 0;

next_symbol:
	if ( last_was_id > 0 ) last_was_id--;
	input += strspn(input, " \t\r\n");
	switch (*input)
	{
		case 0:
			if (!term) goto lex_prog_return;
			my_asprintf(&lex_errstr, "Unexpected end-of-file (expected '%s').", term);
			longjmp(lex_goterr, __LINE__);

		case '"':
		case '\'': {
			char *new_term = my_strndupa(input++, 1);
			spl_lex_string(new_term, LEX_STRING_BACKSLASHES, 0);
			goto next_symbol;
		}

		case '#':
			if ((input[1] < 'a' || input[1] > 'z') && input[1] != '!')
				goto just_a_normal_operator;
			input++;
			spl_lex_pragma();
			goto next_symbol;

		case '.':
			if (input[1] < '0' || input[1] > '9')
				goto just_a_normal_operator;

		case '0' ... '9':
			if (input[0] == '0' && input[1] == 'x') {
				char *buffer;
				my_asprintf(&buffer, "%ld", strtol(input+2, (char**)&input, 16));
				lex_new(VALUE, buffer);
			} else
			if (input[0] == '0' && input[1] == 'o') {
				char *buffer;
				my_asprintf(&buffer, "%ld", strtol(input+2, (char**)&input, 8));
				lex_new(VALUE, buffer);
			} else
			if (input[0] == '0' && input[1] == 'b') {
				char *buffer;
				my_asprintf(&buffer, "%ld", strtol(input+2, (char**)&input, 2));
				lex_new(VALUE, buffer);
			} else {
				int len = strspn(input, "0123456789.");
				while (input[len-1] == '.') len--;
				lex_new(VALUE, my_strndup(input, len));
				input += len;
			}
			goto next_symbol;

		case '$': {
			char *regex_result_id;
			int len = 0;

			switch (input[1])
			{
			case '<':
				input += 2;
				len = strcspn(input, ">");
				my_asprintf(&regex_result_id, "#reres.%.*s", len++, input);
				break;
			case '$':
				len = 2;
				regex_result_id = strdup("#reres");
				break;
			case '-':
				len = 2;
				regex_result_id = strdup("#reres.=NC");
				break;
			case '+':
				len = 2;
				regex_result_id = strdup("#reres.=LC");
				break;
			case '0' ... '9':
				input += 1;
				len = 1; /* strspn(input, "0123456789"); */
				my_asprintf(&regex_result_id, "#reres.%.*s", len, input);
				break;
			case '@':
				len = 2;
				regex_result_id = strdup("#array");
				break;
			case '#':
				len = 2;
				regex_result_id = strdup("#index");
				break;
			case '[':
			case ']':
				len = 2;
				lex_new('(', 0);
				lex_new(LNOT, 0);
				lex_new(DEFINED, 0);
				lex_new('(', 0);
				if (input[1] == '[')
					lex_new(PREV, 0);
				else
					lex_new(NEXT, 0);
				lex_new(ID, strdup("#array"));
				lex_new(',', 0);
				lex_new(ID, strdup("#index"));
				lex_new(')', 0);
				lex_new(')', 0);
				goto ignore_regex_result_id;
			default:
				goto just_a_normal_operator;
			}

			lex_new(ID, regex_result_id);
ignore_regex_result_id:
			input += len;
			last_was_id = 2;
			goto next_symbol;
		}

		case 'a' ... 'z':
		case 'A' ... 'Z':
		case '_': {
			int len = 0;
			while (1) {
				if (input[len] >= 'a' && input[len] <= 'z') len++;
				else if (input[len] >= 'A' && input[len] <= 'Z') len++;
				else if (input[len] >= '0' && input[len] <= '9') len++;
				else if (input[len] == '_') len++;
				else break;
			}

			char *text = my_strndup(input, len);
			input += len;

			if (!lex_item_list_last || lex_item_list_last->lex != '.' )
				for (int i=0; lex_keywords[i].text; i++)
					if ( !strcmp(lex_keywords[i].text, text) ) {
						lex_new(lex_keywords[i].lex, 0);
						free(text);
						goto next_symbol;
					}

			if (!in_pragma_arg)
				for (struct define *def = define_list; def; def=def->next) {
					if ((!def->active || strcmp(current_define, def->name)) && !strcmp(def->name, text))
					{
						char *expanded_text = strdup(def->text);
						free(text);

						if (define_recursion > 1000) {
							my_asprintf(&lex_errstr, "Endless recursion in macro expansion.");
							longjmp(lex_goterr, __LINE__);
						}

						struct define *args_start = 0;
						struct define *args_stop = 0;

						if (def->args) {
							char *this_args = strdup(def->args);
							char *this_arg, *this_args_p = this_args;

							input += strcspn(input, "(");
							if (*input) input++;

							this_arg = my_strsep(&this_args_p, ",");
							while (this_arg) {
								struct define *adef = calloc(1, sizeof(struct define));
								adef->isarg = 1;
								adef->name = strdup(this_arg);

								in_pragma_arg=1;
								const char *begin = input;
								spl_lex_prog(this_args_p ? "," : ")");
								adef->text=my_strndup(begin, input-begin);
								if (*input) input++;
								in_pragma_arg=0;

								adef->next = define_list;
								define_list = args_start = adef;
								if (!args_stop) args_stop = adef;

								this_arg = my_strsep(&this_args_p, ",");
							}

							free(this_args);

							int new_expanded_len = 1;
							for (int i=0; expanded_text[i]; i++) {
								if (expanded_text[i] == '<') {
									struct define *idef = args_start;
									while (idef) {
										if (!strncmp(expanded_text+i+1, idef->name, strlen(idef->name)) && expanded_text[i+1+strlen(idef->name)] == '>') {
											new_expanded_len += strlen(idef->text);
											i += strlen(idef->name) + 1;
											break;
										}
										if (idef == args_stop) break;
										idef = idef->next;
									}
								}
								new_expanded_len++;
							}

							char *new_expanded_text = malloc(new_expanded_len);
							int new_expanded_text_pos = 0;
							for (int i=0; expanded_text[i]; i++) {
								if (expanded_text[i] == '<') {
									struct define *idef = args_start;
									while (idef) {
										if (!strncmp(expanded_text+i+1, idef->name, strlen(idef->name)) && expanded_text[i+1+strlen(idef->name)] == '>') {
											strcpy(new_expanded_text+new_expanded_text_pos, idef->text);
											new_expanded_text_pos += strlen(idef->text);
											i += strlen(idef->name) + 1;
											goto do_not_copy_char;
										}
										if (idef == args_stop) break;
										idef = idef->next;
									}
								}
								new_expanded_text[new_expanded_text_pos++] = expanded_text[i];
do_not_copy_char:;
							}

							free(expanded_text);
							new_expanded_text[new_expanded_text_pos] = 0;
							expanded_text = new_expanded_text;
						}

						def->active = 1;
						define_recursion++;
						char *old_current_define = current_define;
						current_define = def->name;
						spl_lex_prog_string(expanded_text);
						current_define = old_current_define;
						define_recursion--;
						def->active = 0;

						struct define *idef = define_list;
						struct define **lastp = &define_list;
						while (idef) {
							if (idef == args_start) {
								*lastp = idef->next;
								free(idef->name);
								free(idef->text);
								if (idef->args)
									free(idef->args);
								free(idef);
								if (idef == args_stop)
									break;
								idef = args_start = *lastp;
							} else {
								lastp = &idef->next;
								idef = idef->next;
							}
						}

						goto next_symbol;
					}
				}

			lex_new(ID, text);
			last_was_id = 2;
			goto next_symbol;
		}

		case ']':
			lex_new(']', 0);
			input++;
			last_was_id = 2;
			goto next_symbol;

		case '}':
		case ')':
			if ( term && !strncmp(input, term, tlen) ) goto lex_prog_return;
			my_asprintf(&lex_errstr, "Unexpected '%c'.", *input);
			longjmp(lex_goterr, __LINE__);

		case '{':
			if (input[1] == '[') {
				lex_new(BLK_BEGIN_NOCTX, 0);
				input += 2;
			} else {
				lex_new('{', 0);
				input++;
			}
			spl_lex_prog("}");
			lex_new('}', 0); input++;
			goto next_symbol;

		case '(':
			for (int i=0; lex_ops[i].text; i++)
				if ( !strncmp(input, lex_ops[i].text, strlen(lex_ops[i].text)) )
					goto just_a_normal_operator;

			if ( input[1] == '{' ) {
				lex_new(EF_BEGIN, 0); input+=2;
				spl_lex_prog("})");
				lex_new(EF_END, 0); input+=2;
			} else {
				if ( lex_item_list_last &&
				     lex_item_list_last->lex == ID ) {
					if ( lex_item_list_last->prev &&
					     lex_item_list_last->prev->lex != '.' &&
					     lex_item_list_last->prev->lex != ']' &&
					     lex_item_list_last->prev->lex != '&' &&
					     lex_item_list_last->prev->lex != '$' &&
					     lex_item_list_last->prev->lex != MUL &&
					     lex_item_list_last->prev->lex != FUNCTION &&
					     lex_item_list_last->prev->lex != METHOD &&
					     lex_item_list_last->prev->lex != FOREACH &&
					     lex_item_list_last->prev->lex != NEW )
						lex_item_list_last->lex = FUNC_ID;
					if ( !lex_item_list_last->prev )
						lex_item_list_last->lex = FUNC_ID;
				}
				lex_new('(', 0); input++;
				spl_lex_prog(")");
				lex_new(')', 0); input++;
			}
			goto next_symbol;

		case '=':
		case '!': {
			if (input[1] != '~') goto just_a_normal_operator;

			int not_mode = *input == '!';
			int eval_mode = 0;
			int len = 0;

			input += 2;
			input += strspn(input, " \t\r\n");

			static char seplist[] = "/:,!%@";
			char sepstr[] = "X";

			struct lex_item *subst_lex = 0;

			if ( input[0] == 's' && strchr(seplist, input[1]) )
			{
				sepstr[0] = input[1];

				subst_lex = lex_new(not_mode ? NREGEX_SUBST : REGEX_SUBST, 0);
				input += 2;

				spl_lex_string(sepstr, LEX_STRING_REGEX, 0);
				lex_new(REGEX_SEP, 0);

				spl_lex_string(sepstr, LEX_STRING_REGEX, 0);
				lex_new(REGEX_SEP, 0);
			} else
			if ( input[0] == 'e' && strchr(seplist, input[1]) )
			{
				eval_mode = 1;
				sepstr[0] = input[1];

				subst_lex = lex_new(not_mode ? NREGEX_EVAL : REGEX_EVAL, 0);
				input += 2;

				spl_lex_string(sepstr, LEX_STRING_REGEX, 0);
				lex_new(REGEX_SEP, 0);
			} else
			if ( strchr(seplist, input[0]) )
			{
				sepstr[0] = input[0];

				lex_new(not_mode ? NREGEX : REGEX, 0);
				input++;

				spl_lex_string(sepstr, LEX_STRING_REGEX, 0);
				lex_new(REGEX_SEP, 0);
			} else {
				my_asprintf(&lex_errstr, "Error in regex syntax.");
				longjmp(lex_goterr, __LINE__);
			}

			while ( isalpha((unsigned char)input[len]) ) len++;

			char *mod = my_strndup(input, len);

			if (subst_lex && strchr(mod, 'R')) {
				if (subst_lex->lex == REGEX_SUBST)
					subst_lex->lex = REGEX_SUBST_R;
				if (subst_lex->lex == NREGEX_SUBST)
					subst_lex->lex = NREGEX_SUBST_R;
				if (subst_lex->lex == REGEX_EVAL)
					subst_lex->lex = REGEX_EVAL_R;
				if (subst_lex->lex == NREGEX_EVAL)
					subst_lex->lex = NREGEX_EVAL_R;
			}

			if (eval_mode) {
				char *new_mod;
				if (strchr(mod, 'N') || strchr(mod, 'P') ||
				    strchr(mod, 'A') || strchr(mod, 'I') ||
				    strchr(mod, 'E') || strchr(mod, 'L')) {
					my_asprintf(&lex_errstr, "Error in regex syntax.");
					longjmp(lex_goterr, __LINE__);
				}
				my_asprintf(&new_mod, "%sEANP", mod);
				free(mod); mod = new_mod;
			}

			lex_new(VALUE, mod);
			input += len;

			lex_new(REGEX_SEP, 0);

			goto next_symbol;
		}

		case '/':
			if (input[1] == '/') {
				while (*input && *input != '\r' && *input != '\n') input++;
				goto next_symbol;
			}
			if (input[1] == '*') {
				while (input[0] && input[1] &&
					(input[0] != '*' || input[1] != '/')) input++;
				if (*input) input++;
				if (*input) input++;
				goto next_symbol;
			}
			goto just_a_normal_operator;

		case '<': {
			int i = 1, with_indent = 0;
			if (input[i] == ':') {
				with_indent = 1;
				i++;
			}
			while (isalpha((unsigned char)input[i])) i++;
			if (input[i] == '>') {
				char endtag[i+32];
				snprintf(endtag, i+32, "</%.*s>", i-(1+with_indent), input+1+with_indent);
				input += i+1;
				if (with_indent)
					input += strspn(input, " \t\r\n");
				spl_lex_string(endtag, LEX_STRING_SPLTAGS, with_indent ? ':' : 0);
				goto next_symbol;
			}
			goto just_a_normal_operator;
		}

		case '?':
			if (php_like_tags_active && input[1] == '>') {
				if (!strcmp(term, "?>")) goto lex_prog_return;
				input += 2;
				spl_lex_string("<?spl?>", LEX_STRING_SPLTAGS, 0);
				goto next_symbol;
			}
			goto just_a_normal_operator;

just_a_normal_operator:
		default: {
			if ( term && !strncmp(input, term, tlen) ) goto lex_prog_return;
			for (int i=0; lex_ops[i].text; i++)
			  if ( !strncmp(input, lex_ops[i].text, strlen(lex_ops[i].text)) ) {
			    input += strlen(lex_ops[i].text);
			    switch ( lex_ops[i].lex ) {
				case STRING_EOL: {
					if ( *input == ' ' || *input == '\t' ) input++;
					int len = strcspn(input, "\r\n");
					if ( input[len] == '\r' ) len++;
					if ( input[len] == '\n' ) len++;
					lex_new(VALUE, my_strndup(input, len));
					input += len;
					goto next_symbol;
				}
				case STRING_EOL_S: {
					if ( *input == ' ' || *input == '\t' ) input++;
					spl_lex_string("\n", LEX_STRING_BACKSLASHES, 0);
					goto next_symbol;
				}
				case STRING_LABEL: {
					input += strspn(input, " \t\r\n");
					int len = strspn(input, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
					char *label = my_strndupa(input, len);
					char indenting_delim = 0;
					input += len;
					if ( *input == ' ' || *input == '\t' ||
						*input == '\r' || *input == '\n' ) input++;
					else {
						indenting_delim = *(input++);
						if ( *input == ' ' || *input == '\t' ||
							*input == '\r' || *input == '\n' ) input++;
					}
					char *end = strstr(input, label);
					if (!end) {
						my_asprintf(&lex_errstr, "End label missing.");
						longjmp(lex_goterr, __LINE__);
					}
					int id_status = 0;
					lex_new(VALUE, strndup_with_indenting_delim(input,
							end-input, indenting_delim, &id_status));
					input = end + len;
					goto next_symbol;
				}
				case STRING_LABEL_S: {
					input += strspn(input, " \t\r\n");
					int len = strspn(input, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
					char *label = my_strndupa(input, len);
					char indenting_delim = 0;
					input += len;
					if ( *input == ' ' || *input == '\t' ||
						*input == '\r' || *input == '\n' ) input++;
					else {
						indenting_delim = *(input++);
						if ( *input == ' ' || *input == '\t' ||
							*input == '\r' || *input == '\n' ) input++;
					}
					spl_lex_string(label, LEX_STRING_BACKSLASHES, indenting_delim);
					goto next_symbol;
				}
				default:
					if (lex_ops[i].lex == SPECIALREF &&
					    lex_item_list_last &&
					    (lex_item_list_last->lex == ID ||
					     lex_item_list_last->lex == ']' ||
					     lex_item_list_last->lex == SPECIALREF))
						lex_new('.', 0);

					if (lex_ops[i].lex == SPECIALREF) {
						char *lookupcode = "";
						if (input[-2] == '*') lookupcode = "";
						if (input[-2] == '+') lookupcode = "!CLS";
						if (input[-2] == '/') lookupcode = "!ROOT";
						if (input[-2] == '.') lookupcode = "!THIS";
						lex_new(lex_ops[i].lex, strdup(lookupcode));
					} else
						lex_new(lex_ops[i].lex, 0);
					goto next_symbol;
			    }
			  }
			if (*input == '[' && lex_item_list_last &&
			    (lex_item_list_last->lex == ID ||
			     lex_item_list_last->lex == ')' ||
			     lex_item_list_last->lex == ']' ||
			     lex_item_list_last->lex == SPECIALREF))
				lex_new('.', 0);
			lex_new(*(input++), 0);
			goto next_symbol;
		}
	}

	longjmp(lex_goterr, __LINE__);

lex_prog_return:
	lex_translate_ptr = old_lex_translate_ptr;
	lex_translate_count = old_lex_translate_count;
}

static char *last_debug_info;

static void create_debug_op(int force)
{
	char *newinfo;

	if (!gen_debug_info) return;

	int lineno = 1, charno = 1;
	const char *c = lex_last_item->src->text;

	while (c < lex_last_item->pos)
		if (*(c++) == '\n' ) lineno++, charno=1;
		else charno++;

	my_asprintf(&newinfo, "%d:%d:%s",
		lineno, charno, lex_last_item->src->name);

	if (!force && last_debug_info && !strcmp(last_debug_info, newinfo)) {
		free(newinfo);
		return;
	}

	if (last_debug_info) free(last_debug_info);
	last_debug_info = newinfo;

	spl_asm_add(as, SPL_OP_DBGSYM, newinfo);
}

static char *get_encoding_pragma(const char *text)
{
	char *token = "#encoding ";
	int token_size = strlen(token);

	const char *begin = strstr(text, token);
	if ( !begin ) return 0;

	begin += token_size;

	token_size = strcspn(begin, " \r\n\t");
	if ( token_size <= 0 ) return 0;

	return my_strndup(begin, token_size);
}

extern int spl_compiler(struct spl_asm *a, const char *prog, const char *name, spl_malloc_file_function *mff, int gd)
{
#ifdef ENABLE_PTHREAD_SUPPORT
	pthread_mutex_lock(&compiler_lck);
#endif

	as = a;
	malloc_file_func = mff;
	gen_debug_info = gd;

	no_checkp_insn = 0;
	php_like_tags_active = 0;
	php_like_tags_term = 0;
	define_list = 0;
	current_define = "";
	define_recursion = 0;
	in_pragma_arg = 0;

	rvtolv_counter = 0;
	import_asm_label_counter = 0;

	if ( as->labels ) {
		spl_report(SPL_REPORT_COMPILER, as, "Compiler called with an assembler with non-empty label list!\n");
#ifdef ENABLE_PTHREAD_SUPPORT
		pthread_mutex_unlock(&compiler_lck);
#endif
		return -1;
	}

	encoding = get_encoding_pragma(prog);

	if (encoding) {
		prog = spl_utf8_import(prog, encoding);
		if (!prog) {
			free(encoding);
			spl_report(SPL_REPORT_COMPILER, as,
				"Character set (#encoding) '%s' is unknown!\n", encoding);
#ifdef ENABLE_PTHREAD_SUPPORT
			pthread_mutex_unlock(&compiler_lck);
#endif
			return -1;
		}
	}

	if ( spl_utf8_check(prog) ) {
		spl_report(SPL_REPORT_COMPILER, as,
			"Compiler called with non-utf8 encoded program code!\n"
			"A decoder bug or just a missing '#encoding' pragma?\n");
		if (encoding) {
			free(encoding);
			free((char*)prog);
		}
#ifdef ENABLE_PTHREAD_SUPPORT
		pthread_mutex_unlock(&compiler_lck);
#endif
		return -1;
	}

	input = prog;

	lex_srcfile_current = malloc(sizeof(struct lex_srcfile));
	lex_srcfile_current->next = 0;
	lex_srcfile_current->text = input;
	lex_srcfile_current->name = name;
	lex_srcfile_list = lex_srcfile_current;

	lex_item_list_first = 0;
	lex_item_list_last = 0;
	lex_last_item = 0;

	lex_errstr = strdup("Generic lexer error");

	label_stack_index = 0;
	label_stack_counter = 0;
	label_stack[label_stack_index] = label_stack_counter;

	breakcont_stack_index = 0;
	breakcont_stack_counter = 0;
	breakcont_stack[breakcont_stack_index] = breakcont_stack_counter;

	packpatch_stack_index = 0;
	last_debug_info = 0;

	// the 'volatile' is to make the compiler happy.
	// (a volatile variable can't be clobbered by a 'longjmp')
	volatile int ret = 1;
	int errlnr = 0;

	// this is to make the compiler happy.
	// (the new prog_free_ptr can't be clobbered by a 'longjmp')
	void * volatile prog_free_ptr = (void *)prog;

	if ( !(errlnr = setjmp(lex_goterr)) ) {
		spl_lex_prog(0);
		ret = spl_yyparse ();
	} else {
		int lineno = 1, charno = 1;
		const char *c = lex_srcfile_current->text;
		const char *orig_input = c;

		while (c < input)
			if (*(c++) == '\n' ) lineno++, charno=1;
			else charno++;

		char *code;
		my_asprintf(&code, "%.40s", input-30 > orig_input ? input-30 : orig_input);

		for (int i=0; code[i]; i++)
			if ( *input == '\r' || code[i] == '\n' || code[i] == '\t' ) code[i] = ' ';

		spl_report(SPL_REPORT_LEXER, as,
			"[%d] near line %d, char %d in %s: %s\n>> %s\n   %*s^\n",
			errlnr, lineno, charno, lex_srcfile_current->name,
			lex_errstr, code, 30, "");
		free(code);
	}

	if ( !ret && packpatch_stack_index ) {
		spl_yyerror("Parser returned with non-empty packpatch stack!");
		ret = 1;
	}

	if ( !ret && label_stack_index ) {
		spl_yyerror("Parser returned with non-empty label stack!");
		ret = 1;
	}

	while ( define_list ) {
		struct define *next = define_list->next;
		free(define_list->name);
		free(define_list->text);
		if (define_list->args)
			free(define_list->args);
		free(define_list);
		define_list = next;
	}

	while ( lex_srcfile_list ) {
		struct lex_srcfile *next = lex_srcfile_list->next;

		if (next) {
			// we allocated those, so we can cast them
			// to non-const and free them.
			free((char*)lex_srcfile_list->text);
			free((char*)lex_srcfile_list->name);
		}

		free(lex_srcfile_list);
		lex_srcfile_list = next;
	}
	if (last_debug_info) free(last_debug_info);
	if (lex_last_item) free(lex_last_item);
	free(lex_errstr);

	spl_asm_resolve_labels(as);

	if (encoding) {
		free(encoding);
		free(prog_free_ptr);
	}

#ifdef ENABLE_PTHREAD_SUPPORT
	pthread_mutex_unlock(&compiler_lck);
#endif
	return ret;
}

static void spl_yyerror (char const *err)
{
	int lineno = 1, charno = 1;
	const char *c = lex_last_item->src->text;
	const char *orig_input = c;

	while (c < lex_last_item->pos)
		if (*(c++) == '\n' ) lineno++, charno=1;
		else charno++;

	char *code;
	my_asprintf(&code, "%.40s", lex_last_item->pos-30 > orig_input ? lex_last_item->pos-30 : orig_input);

	for (int i=0; code[i]; i++)
		if ( *input == '\r' || code[i] == '\n' || code[i] == '\t' ) code[i] = ' ';

	spl_report(SPL_REPORT_COMPILER, as,
		"near line %d, char %d in %s: %s\n>> %s\n   %*s^\n",
		lineno, charno, lex_last_item->src->name, err, code, 30, "");

	free(code);
}



