/************************************************************
*  Interface between Tcl/Tk and spk interface routines
************************************************************/

#include "incall.h"

extern "C" {
#include "tk.h"
}

ConfigInfo conf;
CommandSet Cmds;
Locks      MLock;
VModem     Modem;
int        OnLine = 0;

/**********************************************************
*  Initialize everything
**********************************************************/
int initSpkApp(Tcl_Interp* interp)
{
   conf.ReadConfig(CONFIG_FILE);
   MLock.Init(&conf);
   Cmds.Init(&conf);
   if (!MLock.MakeLockFile()) 
   {
      interp->result = "Could not lock port!";
      return TCL_ERROR;
   }
   if (!Modem.Init(&conf))
   {
      interp->result = "Could not initialize the modem!";
      return TCL_ERROR;
   }

   MLock.RemoveLockFile();
   return TCL_OK;
}

/**********************************************************
*  "dial" callback
**********************************************************/
int spkDialCmd(ClientData /*clientData*/, Tcl_Interp* interp,
               int argc, char** argv) 
{
   if (argc < 2) 
   {
      interp->result = "wrong # args";
      return TCL_ERROR;
   }

   // Initialize the modem and pick up line
   if (!OnLine)
   {
      if (!MLock.MakeLockFile()) 
      {
         interp->result = "Could not lock port!";
         return TCL_ERROR;
      }
      if (!Modem.InitRead())
      {
         interp->result = "Could not initialize the port!";
         return TCL_ERROR;
      }
      Modem.ExecuteSequence(Cmds.GetSequence("SPEAKER_ON"));
      sleep(1);
      OnLine = 1;
   }

   char bufcmd[256];
   int  place, length;
   CommandSequence* sq;
   sq = Cmds.GetSequence("DIAL");
   strcpy(bufcmd, sq->GetCommand());
   place = strlen(bufcmd);
   bufcmd[place+1] = 0;

   for (int i = 1; i < argc; i++)
   {
      length = strlen(argv[i]);
      for (int j = 0; j < length; j++)
      {
         if (argv[i][j] == '[')
         {
            if (strncmp(&(argv[i][j]),"[PAUSE]", 7) == 0)
            {
               sleep(1);
               j += 6;
            }
            if (strncmp(&(argv[i][j]),"[FLASH]", 7) == 0)
            {
               bufcmd[place] = '!';
//               printf("Dialing: \"%s\"\n", bufcmd);
               Modem.MsgExchange(bufcmd, sq->GetAnswer());
               j += 6;
            }
         } else
         {
            bufcmd[place] = argv[i][j];
//            printf("Dialing: \"%s\"\n", bufcmd);
            Modem.MsgExchange(bufcmd, sq->GetAnswer());
         }
      }
   }
   return TCL_OK;
}

/**********************************************************
*  "hangup" callback
**********************************************************/
int spkHangupCmd(ClientData /*clientData*/, Tcl_Interp* interp,
               int argc, char** /*argv*/) 
{
   if (argc != 1) 
   {
      interp->result = "wrong # args";
      return TCL_ERROR;
   }
//   printf("Hanging up...\n");

   if (OnLine)
   {
      Modem.ExecuteSequence(Cmds.GetSequence("SPEAKER_OFF"));
      Modem.StopRead();
      MLock.RemoveLockFile();
      OnLine = 0;
   }
   return TCL_OK;
}

/************************************************************
*   GSPK_AppInit --
*       Initialization for gspk
************************************************************/
int GSPK_Init(Tcl_Interp *interp)
{
   initSpkApp(interp);

   Tcl_CreateCommand(interp, "dial", spkDialCmd,
                     (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);

   Tcl_CreateCommand(interp, "hangup", spkHangupCmd,
                     (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
   return TCL_OK;
}
