//************************************************************
//  locks.C - source file for creation and removal of port 
//             locks
//************************************************************
#include "incall.h"

Locks::Locks()
{
   PortLocked = 0;
   LockFileName = NULL;
}

Locks::~Locks()
{
   if (LockFileName)
   {
      RemoveLockFile();
      delete LockFileName;
   }
}

void Locks::Init(ConfigInfo* conf)
{
   int  i;
   LockFileName = new char[strlen(conf->LockPath) + 
                           7 + strlen(conf->SerialPort)];

   strcpy(LockFileName, conf->LockPath);
   strcat(LockFileName, "/LCK..");
   for (i=strlen(conf->SerialPort)-1; i > 0 && conf->SerialPort[i]!='/'; i--);
   i++;
   
   strcat(LockFileName, &(conf->SerialPort[i]));
}

// Attempts to create a lock file for the specified ttyS.
// returns:
//  1 - success
//  0 - device is locked by another process
//  -1 - Something is really screwed (permissions?)
int Locks::MakeLockFile()
{
   char LockBuf[MAXPATHLEN];
   int  fd, procID;

   if (PortLocked) return 1;

   // If you use NFS, see man open for different implementation,
   // I'm toooooo lazy to do it the RIGHT way. Sorry.
   fd = open( LockFileName, O_WRONLY | O_CREAT | O_EXCL, 
              S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);

   if (fd == -1)
   {
      // Something did not work
      if (errno != EEXIST)
         return -1; // Go, figure....

      // File exists, the port may be locked by another process
      // Check if the process exist...
      fd = open( LockFileName, O_RDONLY );
      if (fd == -1) return 0;

      if (read( fd, LockBuf, sizeof(LockBuf)) <= 0)
      {
         close(fd);
         return 0;
      }
      close(fd);
      
      if (sscanf(LockBuf, "%d", &procID) != 1)
      {
         return 0;
      }

      if (-1 != kill(procID, 0) || errno != ESRCH )
         return 0;

      syslog(LOG_WARNING,"Removing stale lock file.");
      unlink( LockFileName );

      // Yet another retry
      fd = open( LockFileName, O_WRONLY | O_CREAT | O_EXCL, 
                 S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);

      // Oh, I give up
      if (fd == -1) return 0;
      
   }

   sprintf( LockBuf, "%d", getpid());
   write(fd, LockBuf, strlen(LockBuf)+1);
   close(fd);
   PortLocked = 1;
   return 1;
}

// Checks for existance of the lock file
// returns:
//  1 - No lock file
//  0 - device is locked by another process
int Locks::CheckLockFile()
{
   int  fd;

   if (PortLocked) return 1;

   // If you use NFS, see man open for different implementation,
   // I'm toooooo lazy to do it the RIGHT way. Sorry.
   fd = open( LockFileName, O_RDONLY );
   if (fd == -1)
   {
      return 1; // No lock file...
   }

   close(fd);
   return 0;
}

// The name sez it all. 
void Locks::RemoveLockFile()
{
   FILE* fp;
   int pid;
   syslog(LOG_DEBUG,"Removing lock file name: %s",LockFileName);
   fp = fopen(LockFileName, "r");
   if (fp)
   {
      fscanf(fp, "%d", &pid);
      fclose(fp);
      if (pid == getpid())
         unlink( LockFileName );
      else
         syslog(LOG_ERR,
            "The lock file belongs to another process. Could not remove");
   }
   PortLocked = 0;
};
