///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: SimpleTokenSelector.cc 245 2006-01-26 22:20:21Z brian $
//
// Copyright (C) 2005 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#include "Message.h"
#include "Token.h"
#include "SimpleTokenSelector.h"

SimpleTokenSelector::SimpleTokenSelector(int required_flags,
                                         const string &required_prefix)
:  m_requiredFlags(required_flags),
   m_requiredPrefix(required_prefix)
{
}

SimpleTokenSelector::~SimpleTokenSelector()
{
}

bool SimpleTokenSelector::shouldAcceptToken(Token *tok)
{
  return starts_with(tok->getWord(), m_requiredPrefix) && ((tok->getFlags() & m_requiredFlags) != 0);
}
