/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick    
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#ifndef __ERRORSTRING_H__
#define __ERRORSTRING_H__

#include <glib.h>

/* Overflow limmit */
#define MAX_VALUE 1e300

/* Underflow limmit */
#define MIN_VALUE 1e-300


#define	NO_ERROR                    0
#define	SYN_ERROR                   1
#define	UNCLOSED_PAREN              2
#define	UNDEFINED_RESULT            3
#define	INFINITE_RESULT             4
#define	AG_OVERFLOW                 5
#define	MISSING_ARGUMENT            6
#define	FACTORIAL_NOT_INT           7
#define	FACTORIAL_NOT_POSITIVE      8
#define LOGIC_NOT_POSITIVE          9

/* str_error 
 * Copies the error message to result result_str */
void 
str_error(gchar *str);


#endif /* __ERRORSTRING_H__ */




