/* 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/*
 * 12/06/2007   Michael.Kang  <blackfin.kang@gmail.com>
 */

#include "ppc_cpu.h"
#include "ppc_mmu.h"
#include "ppc_exc.h"
#include "ppc_memory.h"
#include "ppc_io.h"
#include "types.h"
#include "tracers.h"

#include "skyeye_types.h"
#include "skyeye_config.h"
#include "sysendian.h"


extern PPC_CPU_State gCPU;

/* For load OS image such as linux, we need to fill some entry in TLB to get 16M sdram mapped, then we can load linux to such memory */
static void bootloader(){
}
static void
ppc_reset_state ()
{
}

static void
ppc_init_state ()
{
	ppc_cpu_init();
	/* initial phsical memory to DEFAULT_GMEMORY_SIZE */
	if(!(boot_rom = malloc(DEFAULT_BOOTROM_SIZE))){
		fprintf(stderr, "can not initialize physical memory...\n");
		skyeye_exit(-1);
	}
	/*we set start_addr */
	boot_rom_start_addr = 0xFFFFFFFF - DEFAULT_BOOTROM_SIZE + 1;
	boot_romSize = DEFAULT_BOOTROM_SIZE;

	/* initialize init_ram parameters */
	if(!(init_ram = malloc(INIT_RAM_SIZE))){
		fprintf(stderr, "malloc failed!\n");
		skyeye_exit(-1);
	}
	if(!(ddr_ram = malloc(DDR_RAM_SIZE))){
		fprintf(stderr, "malloc failed!\n");
                skyeye_exit(-1);

	}
	init_ram_size = INIT_RAM_SIZE;
	init_ram_start_addr = 0xe4010000;

	gCPU.por_conf.porpllsr = 0x40004;
	
	e500_mmu_init();
	
	/* write something to a file for debug or profiling */
	if (!prof_file) {
                prof_file = fopen ("./kernel_prof.txt", "w");
        }

}

typedef struct bd_s{
	uint16 flag;
	uint16 len;
	uint32 buf_addr;
}bd_t;

static void ppc_io_do_cycle(){
	/* If SCC0 Receive enalbed */
	if(gCPU.cpm_reg.scc[0].gsmrl & 0x00000020){
	}
	/* If SCC0 transmit enabled */
	if(gCPU.cpm_reg.scc[0].gsmrl & 0x00000010){
		byte * ram = &gCPU.cpm_reg.dpram[0];
		/* Param is stored at 0x8000 for SCC1 */
		int rx_base = 0x8000; /* Receive buffer base address */
		int tx_base = 0x8002; /* Transmit buffer base address */
		int trans_bd_base = ppc_half_from_BE(ram[tx_base]); 
		trans_bd_base = 0x88;
		short bd_flag = ppc_half_from_BE(ram[trans_bd_base]);	
		short bd_len = ppc_half_from_BE(ram[trans_bd_base + 2]);
		uint32 buf_addr = ppc_word_from_BE(*((uint32 *)&ram[trans_bd_base + 4]));
		//fprintf(prof_file, "trans_bd_base=0x%x,bf_falg=0x%x,buf_addr=0x%x\n",trans_bd_base, bd_flag,buf_addr);
		 /* If data ready */
		if(bd_flag & 0x8000){
			char c = ram[buf_addr - 0xe0080000];
			skyeye_uart_write(-1, &c, 1, NULL);
			*((sint16 *)&ram[trans_bd_base]) &= ppc_half_to_BE(~0x8000);
		}
	}

}
static void
ppc_step_once ()
{
	PPC_CPU_TRACE("execution started at %08x\n", gCPU.pc);
	uint ops=0;
	uint32 real_addr;
	//gCPU.effective_code_page = 0xffffffff;
//	ppc_fpu_test();
//	return;
	if (true) {
		static uint32_t dbg_start = 0xfff84000;
		static uint32_t dbg_end = 0xfff83254;
		static uint32_t init_value = 0xfd25a0;
		static int flag = 0;
		gCPU.npc = gCPU.pc + 4;
		ppc_effective_to_physical(gCPU.pc, 0, &real_addr);
		if(real_addr > boot_rom_start_addr)
			gCPU.current_opc = ppc_word_from_BE(*((int *)&boot_rom[real_addr - boot_rom_start_addr]));
		else if(real_addr >0 && real_addr < DDR_RAM_SIZE)
			gCPU.current_opc = ppc_word_from_BE(*((int *)&ddr_ram[real_addr]));  	
		else{
			fprintf(stderr,"Can not get instruction from addr 0x%x\n",real_addr);
			skyeye_exit(-1);
		}
		if(gCPU.pc == dbg_start)
			flag = 1;
		if(flag)
			fprintf(prof_file,"DBG:before exec pc=0x%x,r0=0x%x,dpram=0x%x\n", gCPU.pc, gCPU.gpr[0], gCPU.cpm_reg.dpram);
	
		ppc_exec_opc();
		ppc_io_do_cycle();
		
		gCPU.pc = gCPU.npc;
	}		
}

static void
ppc_set_pc (WORD pc)
{
	gCPU.pc = pc;
	/* Fixme, for e500 core, the first instruction should be executed at 0xFFFFFFFC */
	gCPU.pc = 0xFFFFFFFC;
}
static WORD
ppc_get_pc(){
	return gCPU.pc;
}
static int
ppc_ICE_write_byte (WORD addr, uint8_t v)
{
	int offset;
	if(addr <= 0xFFFFFFFF && (addr > boot_rom_start_addr)){
		offset = addr - boot_rom_start_addr;	
		boot_rom[offset] = v;
		return 0;	
	}
	return 1;
}
static int ppc_ICE_read_byte (WORD addr, uint8_t *pv){
	int offset;
        if(addr <= 0xFFFFFFFF && (addr > boot_rom_start_addr)){
                offset = addr - boot_rom_start_addr;
		return ppc_read_physical_byte(offset, pv);
        }

	return 0;
}

static int
ppc_parse_cpu (const char *params[])
{
	return 0;
}

extern void mpc8560_mach_init();
machine_config_t ppc_machines[] = {
        /* machine define for MPC8560 */
        {"mpc8560", mpc8560_mach_init, NULL, NULL, NULL},
};
static int
ppc_parse_mach (machine_config_t * mach, const char *params[])
{	
	int i;
	for (i = 0; i < (sizeof (ppc_machines) / sizeof (machine_config_t));
	     i++) {
		if (!strncmp
		    (params[0], ppc_machines[i].machine_name,
		     MAX_PARAM_NAME)) {
			skyeye_config.mach = &ppc_machines[i];
			SKYEYE_INFO
				("mach info: name %s, mach_init addr %p\n",
				 skyeye_config.mach->machine_name,
				 skyeye_config.mach->mach_init);
			return 0;
		}
	}
	SKYEYE_ERR ("Error: Unkonw mach name \"%s\"\n", params[0]);

	return -1;
}
static mem_config_t ppc_mem;
static int
ppc_parse_mem (int num_params, const char *params[])
{
	char name[MAX_PARAM_NAME], value[MAX_PARAM_NAME];
	int i, num;
	mem_config_t *mc = &ppc_mem;
	mem_bank_t *mb = mc->mem_banks;

	mc->bank_num = mc->current_num++;
	num = mc->current_num - 1;	/*mem_banks should begin from 0. */
	mb[num].filename[0] = '\0';
	for (i = 0; i < num_params; i++) {
		if (split_param (params[i], name, value) < 0)
			SKYEYE_ERR
				("Error: mem_bank %d has wrong parameter \"%s\".\n",
				 num, name);

		if (!strncmp ("map", name, strlen (name))) {
			if (!strncmp ("M", value, strlen (value))) {
				mb[num].read_byte = ppc_read_byte;
				mb[num].write_byte = ppc_write_byte;
				mb[num].read_halfword = ppc_read_halfword;
				mb[num].write_halfword = ppc_write_halfword;
				mb[num].read_word = ppc_read_word;
				mb[num].write_word = ppc_write_word;
				mb[num].type = MEMTYPE_RAM;
			}
			else if (!strncmp ("I", value, strlen (value))) {
				mb[num].read_byte = ppc_read_byte;
				mb[num].write_byte = ppc_write_byte;
				mb[num].read_halfword = ppc_read_halfword;
				mb[num].write_halfword = ppc_write_halfword;
				mb[num].read_word = ppc_read_word;
				mb[num].write_word = ppc_write_word;
				mb[num].type = MEMTYPE_IO;

				/*ywc 2005-03-30 */
			}
			else if (!strncmp ("F", value, strlen (value))) {
				mb[num].read_byte = ppc_read_byte;
				mb[num].write_byte = ppc_write_byte;
				mb[num].read_halfword = ppc_read_halfword;
				mb[num].write_halfword = ppc_write_halfword;
				mb[num].read_word = ppc_read_word;
				mb[num].write_word = ppc_write_word;
				mb[num].type = MEMTYPE_FLASH;
			}
			else {
				SKYEYE_ERR
					("Error: mem_bank %d \"%s\" parameter has wrong value \"%s\"\n",
					 num, name, value);
			}
		}
		else if (!strncmp ("type", name, strlen (name))) {
			//chy 2003-09-21: process type
			if (!strncmp ("R", value, strlen (value))) {
				if (mb[num].type == MEMTYPE_RAM)
					mb[num].type = MEMTYPE_ROM;
				mb[num].write_byte = warn_write_byte;
				mb[num].write_halfword = warn_write_halfword;
				mb[num].write_word = warn_write_word;
			}
		}
		else if (!strncmp ("addr", name, strlen (name))) {

			if (value[0] == '0' && value[1] == 'x')
				mb[num].addr = strtoul (value, NULL, 16);
			else
				mb[num].addr = strtoul (value, NULL, 10);

		}
		else if (!strncmp ("size", name, strlen (name))) {

			if (value[0] == '0' && value[1] == 'x')
				mb[num].len = strtoul (value, NULL, 16);
			else
				mb[num].len = strtoul (value, NULL, 10);

		}
		else if (!strncmp ("file", name, strlen (name))) {
			strncpy (mb[num].filename, value, strlen (value) + 1);
		}
		else if (!strncmp ("boot", name, strlen (name))) {
			/*this must be the last parameter. */
			if (!strncmp ("yes", value, strlen (value)))
				skyeye_config.start_address = mb[num].addr;
		}
		else {
			SKYEYE_ERR
				("Error: mem_bank %d has unknow parameter \"%s\".\n",
				 num, name);
		}
	}
	return 0;
}

void
init_ppc_arch ()
{

	static arch_config_t ppc_arch;

	ppc_arch.arch_name = "ppc";
	ppc_arch.init = ppc_init_state;
	ppc_arch.reset = ppc_reset_state;
	ppc_arch.set_pc = ppc_set_pc;
	ppc_arch.get_pc = ppc_get_pc;
	ppc_arch.step_once = ppc_step_once;
	ppc_arch.ICE_write_byte = ppc_ICE_write_byte;
	ppc_arch.ICE_read_byte = ppc_ICE_read_byte;
	ppc_arch.parse_cpu = ppc_parse_cpu;
	ppc_arch.parse_mach = ppc_parse_mach;
	ppc_arch.parse_mem = ppc_parse_mem;

	register_arch (&ppc_arch);
}
