/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    tools.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// fgetstr() Function
int fgetstr (FILE *point, char *string, int len) {
	char inchr;
	int i;

	for (i=0; i<len; i++) {
		inchr=fgetc(point);
		if ((inchr==EOF) || (inchr==10)) {
			string[i]=0;
			break;
		}
		string[i]=inchr;
	}
	return strlen(string);
}

// killcrlf() Function
int killcrlf (char *string, int len) {
	int i, c=0, inchr;
	char tmpstring [INPUT_STRING];

	for (i=0; i<len; i++) {
		inchr=string[i];
		if ((inchr!=10) && (inchr!=13)) {
			tmpstring[c]=inchr;
			c++;
			if (c==INPUT_STRING) break;
		}
	}
	for (i=c; i<INPUT_STRING; i++)
		tmpstring[i]=0;
	c--;
	strcpy (string, tmpstring);
	return c;
}

// cinstr() Function
int cinstr (char *string, char character) {
	int i;

	for (i=0; i<strlen(string); i++)
		if (string[i]==character) return i;
	return -1;
}

// rstring() Function
int rstring (char *string, int start, char *retstring) {
	int i=0, c=0;

	for (i=start; i<strlen(string); i++) {
		retstring[c]=string[i];
		c++;
	}
	retstring[c]='\0';
	return c;
}

// fillstring() Function
int fillstring (char *string, char chr, int length) {
	int i=0;

	for (i=0; i<length; i++)
		string[i]=chr;
	return i;
}

// nostr() Function
int nostr (char *string, char character) {
	int i;

	for (i=0; i<=strlen(string) + 1; i++)
		if (string[i]!=character) break;
	if (string[i]==character) return -1;
	return i;
}

// rnostr() Function
int rnostr (char *string, char character) {
	int i;

	for (i=(strlen(string)-1); i>=0; i--)
		if (string[i]!=character) break;
	return i;
}

// ltrim() Function
void ltrim (char *string) {
	int start=0;
	start=nostr(string, ' ');
	if (start==-1) return;
	strcpy (string, string+start);
	return;
}

// rtrim() Function
void rtrim (char *string) {
	int end=0;
	end=rnostr(string, ' ');
	if (end==-1) return;
	string[end+1]=0;
	return;
}

// trim() Function
void trim (char *string) {
	ltrim (string);
	rtrim (string);
	return;
}


