/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    parport.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handleparport ()
//	determine the correct procedure to use
void handleparport () {
	//  proc/parport in all kernels are compatible
	handleparportv20 ();
}

// handleparportv20() Function
void handleparportv20 () {
	DIR *dirp;
	struct dirent *dirlist;
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int c=0;
	int len;

	// Open and Read /proc/parport
	sprintf (filename, "%sparport", PROCLOC);
	dirp=opendir(filename);
	if (dirp==NULL) return;
	do {
		dirlist=readdir(dirp);
		if (dirlist==NULL) break;
		strncpy (tmpstring, dirlist->d_name, INPUT_STRING-1);
		tmpstring[INPUT_STRING-1]=0;
		if (strncmp(tmpstring, ".", 1)==0) continue;
		PARPORT[c]=malloc(PARPORT_STRUCT_SIZE);
		if (PARPORT[c]==NULL) error_handler(ERROR_MALLOC);
		strncpy (PARPORT[c]->NAME, tmpstring, STORAGE_STRING-1);
		PARPORT[c]->NAME[STORAGE_STRING-1]=0;
		// autoprobe
		sprintf (filename, "%sparport/%s/autoprobe", PROCLOC, PARPORT[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgets(tmpstring, INPUT_STRING, filep);
			len=killcrlf(tmpstring, strlen(tmpstring));
			strncpy (PARPORT[c]->AUTOPROBE, tmpstring, len);
			PARPORT[c]->AUTOPROBE[len]=0;
			fclose (filep);
		}
		// devices
		sprintf (filename, "%sparport/%s/devices", PROCLOC, PARPORT[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgets (tmpstring, INPUT_STRING, filep);
			killcrlf (tmpstring, strlen(tmpstring));
			strncpy (PARPORT[c]->DEVICES, tmpstring+1, STORAGE_STRING-1);
			PARPORT[c]->DEVICES[STORAGE_STRING-1]=0;
			fclose (filep);
		}
		// hardware
		sprintf (filename, "%sparport/%s/hardware", PROCLOC, PARPORT[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (feof(filep)!=0) break;
				killcrlf (tmpstring, strlen(tmpstring));
				if (strncmp(tmpstring, "base:", 5)==0)
					sscanf (tmpstring, "base:\t%s", PARPORT[c]->IOPORT);
				if (strncmp(tmpstring, "irq:", 4)==0)
					sscanf (tmpstring, "irq:\t%s", PARPORT[c]->IRQ);
				if (strncmp(tmpstring, "dma:", 4)==0)
					sscanf (tmpstring, "dma:\t%s", PARPORT[c]->DMA);
				if (strncmp(tmpstring, "modes:", 6)==0)
					sscanf (tmpstring, "modes:\t%s", PARPORT[c]->PORTTYPE);
			} while (0==0);
			fclose (filep);
		}
		c++;
		if (c==PARPORT_COUNT_MAX) break;
	} while (0==0);
	NUM_PARPORT=c-1;
	closedir (dirp);
	// Return
	return;
}

