/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    misc.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlemisc ()
//	determine the correct procedure to use
void handlemisc () {
	//  proc/misc in all kernels are compatible
	handlemiscv20 ();
}

// handlemiscv20() Function
void handlemiscv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int c=0;

	// Open and Handle /proc/misc
	sprintf (filename, "%smisc", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		killcrlf (tmpstring, strlen(tmpstring));
		MISC[c]=malloc(DEV_STRUCT_SIZE);
		if (MISC[c]==NULL) error_handler(ERROR_MALLOC);
		initializedev (MISC[c]);
		sscanf (tmpstring, "%d %s", &MISC[c]->NUMBER, MISC[c]->NAME);
		c++;
		if (c==MISC_COUNT_MAX) break;
	} while (0==0);
	fclose (filep);
	NUM_MISC=c-1;
	// Return
	return;
}

