/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    ide.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handleide ()
//	determine the correct procedure to use
void handleide () {
	//  proc/ide in all kernels are compatible
	handleidev20 ();
}

// handleidev20() Function
void handleidev20 () {
	FILE *filep;
	DIR *dirp;
	DIR *dirq;
	DIR *dirr;
	struct dirent *dir;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	char idename [INPUT_STRING];
	char hdname [INPUT_STRING];
	int c=0;
	int space=0;

	// IDE Drivers
	sprintf (filename, "%side/drivers", PROCLOC);
	filep=fopen(filename, "r");
	if (filep!=NULL) {
		do {
			fgetstr (filep, tmpstring, INPUT_STRING);
			if (strlen(tmpstring)==0) break;
			space=cinstr(tmpstring, ' ');
			IDEDRV[c]=malloc(IDEDRV_STRUCT_SIZE);
			if (IDEDRV[c]==NULL) error_handler(ERROR_MALLOC);
			IDEDRV[c]->NAME[0]=0;
			IDEDRV[c]->VERSION[0]=0;
			strncpy (IDEDRV[c]->NAME, tmpstring, space);
			IDEDRV[c]->NAME[space]=0;
			rstring (tmpstring, space+8, IDEDRV[c]->VERSION);
			c++;
			if (c==IDEDRV_COUNT_MAX) break;
		} while (0==0);
		NUM_IDEDRV=c-1;
		fclose (filep);
	}
	// IDE Devices
	c=0;
	sprintf (filename, "%side/", PROCLOC);
	dirp=opendir(filename);
	if (dirp==NULL) return;
	do {
		dir=readdir(dirp);
		if (dir==NULL) break;
		strncpy (idename, dir->d_name, INPUT_STRING-1);
		idename[INPUT_STRING-1]=0;
		// Test for Directory
		if (strncmp(idename, ".", 1)==0) continue;
		sprintf (filename, "%side/%s/", PROCLOC, idename);
		dirq=opendir(filename);
		if (dirq==NULL) continue;
		do {
			dir=readdir(dirq);
			if (dir==NULL) break;
			strncpy (hdname, dir->d_name, INPUT_STRING-1);
			hdname[INPUT_STRING-1]=0;
			if (strncmp(hdname, ".", 1)==0) continue;
			sprintf (filename, "%side/%s/%s", PROCLOC, idename, hdname);
			dirr=opendir(filename);
			if (dirr==NULL) continue;
			IDEDEV[c]=malloc(IDEDEV_STRUCT_SIZE);
			if (IDEDEV[c]==NULL) error_handler(ERROR_MALLOC);
			initializeidedev (IDEDEV[c]);
			strncpy (IDEDEV[c]->NAME, hdname, STORAGE_STRING-1);
			IDEDEV[c]->NAME[STORAGE_STRING-1]=0;
			strncpy (IDEDEV[c]->PARENT, idename, STORAGE_STRING-1);
			IDEDEV[c]->PARENT[STORAGE_STRING-1]=0;
			c++;
			if (c==IDEDEV_COUNT_MAX) break;
			closedir (dirr);
		} while (0==0);
		closedir (dirq);
	} while (0==0);
	closedir (dirp);
	NUM_IDEDEV=c-1;
	// Information on Each Device
	for (c=0; c<=NUM_IDEDEV; c++) {
		// driver
		sprintf (filename, "%side/%s/%s/driver", PROCLOC, IDEDEV[c]->PARENT, IDEDEV[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgets (IDEDEV[c]->DRIVER, STORAGE_STRING, filep);
			killcrlf (IDEDEV[c]->DRIVER, strlen(IDEDEV[c]->DRIVER));
			fclose (filep);
		}
		// media
		sprintf (filename, "%side/%s/%s/media", PROCLOC, IDEDEV[c]->PARENT, IDEDEV[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgets (IDEDEV[c]->MEDIA, STORAGE_STRING, filep);
			killcrlf (IDEDEV[c]->MEDIA, strlen(IDEDEV[c]->MEDIA));
			fclose (filep);
		}
		// model
		sprintf (filename, "%side/%s/%s/model", PROCLOC, IDEDEV[c]->PARENT, IDEDEV[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgets (IDEDEV[c]->MODEL, STORAGE_STRING, filep);
			killcrlf (IDEDEV[c]->MODEL, strlen(IDEDEV[c]->MODEL));
			fclose (filep);
		}
		// settings
		sprintf (filename, "%side/%s/%s/settings", PROCLOC, IDEDEV[c]->PARENT, IDEDEV[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL)
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (feof(filep)!=0) break;
				if (strncmp(tmpstring, "name", 4)==0) continue;
				if (strncmp(tmpstring, "----", 4)==0) continue;
				if (strncmp(tmpstring, "bios_cyl", 7)==0)
					sscanf (tmpstring, "%*24s %d", &IDEDEV[c]->CYL);
				if (strncmp(tmpstring, "bios_head", 8)==0)
					sscanf (tmpstring, "%*24s %d", &IDEDEV[c]->HEAD);
				if (strncmp(tmpstring, "bios_sect", 8)==0)
					sscanf (tmpstring, "%*24s %d", &IDEDEV[c]->SECT);
			} while (0==0);
	}
	// Return
	return;
}


// initializeidedev ()
void initializeidedev (struct IDEDEV_STRUCT *idedevstr) {
	idedevstr->NAME[0]=0;
	idedevstr->PARENT[0]=0;
	idedevstr->DRIVER[0]=0;
	idedevstr->MEDIA[0]=0;
	idedevstr->MODEL[0]=0;
	idedevstr->CYL=0;
	idedevstr->HEAD=0;
	idedevstr->SECT=0;
	return;
}

