/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    devices.c

    si - System Information Viewer
    Copyright (C) 1999-2001  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handledevices ()
//	determine the correct procedure to use
void handledevices () {
	//  proc/devices in all kernels are compatible
	handledevicesv20 ();
}

// handledevicesv20() Function
void handledevicesv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int c;

	sprintf (filename, "%sdevices", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	// Character Devices
	c=0;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (strlen(tmpstring)==1) continue;
		if (strncmp(tmpstring, "Character devices", 17)==0) continue;
		if (strncmp(tmpstring, "Block devices", 13)==0) break;
		killcrlf (tmpstring, strlen(tmpstring));
		CHARDEV[c]=malloc(DEV_STRUCT_SIZE);
		if (CHARDEV[c]==NULL) error_handler(ERROR_MALLOC);
		initializedev (CHARDEV[c]);
		sscanf (tmpstring, "%d %s", &CHARDEV[c]->NUMBER, CHARDEV[c]->NAME);
		c++;
		if (c==CHARDEV_COUNT_MAX) break;
	} while (0==0);
	NUM_CHARDEV=c-1;
	// Block Devices
	c=0;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		if (strncmp(tmpstring, "Block devices", 13)==0) continue;
		killcrlf (tmpstring, strlen(tmpstring));
		BLOCKDEV[c]=malloc(DEV_STRUCT_SIZE);
		if (BLOCKDEV[c]==NULL) error_handler(ERROR_MALLOC);
		initializedev (BLOCKDEV[c]);
		sscanf (tmpstring, "%d %s", &BLOCKDEV[c]->NUMBER, BLOCKDEV[c]->NAME);
		c++;
		if (c==BLOCKDEV_COUNT_MAX) break;
	} while (0==0);
	NUM_BLOCKDEV=c-1;
	// Cleanup
	fclose (filep);
	return;
}


// initializedev ()
void initializedev (struct DEV_STRUCT *devstr) {
	devstr->NAME[0]=0;
	devstr->NUMBER=0;
	return;
}

