import time, sys

class Log:

    def __init__(self, logfile=None):
        if logfile:
            self.logfile = open(logfile, "a")
        else:
            self.logfile = sys.stderr
        
    def log(self, text):
        self.logfile.write(text+"\n")
        self.logfile.flush()

    def logr(self, ip, command): # time, ip, command
        t = time.time()
        line = "%s %s %s" % (time.ctime(t), ip, command)
        self.log(line)
        
    def closelog(self):
        self.logfile.close()

    def __del__(self):
        self.logfile.close()
        
