#include <iostream>
#include <fstream>

#include <seqan/index.h>
#include <seqan/statistical_index.h>

using namespace std;
using namespace seqan;

int main()
{
    typedef Dna TAlphabet;
	typedef String<TAlphabet> TSequence;

	TSequence str2 = "CCCAAAGC";
	TSequence str3 = "CCCAAAGTAAATT";

    TSequence str1a = "AGAAGCCTCAGATGAGGAGGGTTTTGCTGTGTGCTGCAAGTATCAGGGAGAAAGCATTTCTGCCCTCTCTGGAACATGGTGTGAACTTCATCCCTGTAATGATATTGTTTGAATTTTCCATGAAAAATTGTCAGCATGAGAGTAAGAAAAGTGTACGATGGGAAAATATTGAACCAAACAGACAAAAATGGTAGAGTCACATGACCAGTTTACTCATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAAATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTGAGGAGTGAGGTGAAGCATCATTCCTCTGATGCACAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGTGTCTGGAGAGCAGCGTGCATGGTAACCTGTCCTCCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGGTACAGTCTTCATCAAAGGTCAGGATCCAGTCCATGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAAATGCCTCCTGCGACATCTTGTTTGTGTCATTTACTAGAGTTGGCACTGTCTTAAGATGGGGGCATGGCTGACATTTTCAACTATCATCAGTGAGTCACTTGCCCAAATGAGGACCATGGTATTAATCTTGCATGTTTTTGGAACTGTTTAAAAAATGTCTGATTTTTGTTGTTTAGTGTCTGTTTTTGAATTTCCCCTTCTCTGCAGTTCTTGGTTTCTATCTCACTGAGTGCAGAGGATTTTAATTGTTGCTGTCTATCTGTGCTTCGCAGCATGAGAGAGCAATGCCTACGGGCTCTTGTGGTGCTTTGGGGTTGACGGGTTTTATGTCTGAGCAAGCAGATGTCATAGTAGCCATGCTGGATTGCAGTAATAAATGTGTCCTTTTTTTCCTTCTGTAGCATTGAAAGCCGAAAAGAGAAGAAAGCTGACTCAGGGAAAGGTGTTGACAGGGAGACTTGTCTATGACTCGATCTTCAATTTATTTTTTACATATATATGAGAAGAGTGTCACAATTATTAATAAAACTGCTTTGATCATGTATTGTAAATTCTGTCCCTCAACCCAAATCCACCTTCATACTGTAAGTAGTGCAATACTTGTTTCATTTCTGTGTTTAAACTTCTGAGCAGTGAGACATCCCTGTGAGCAGATACAATAGCCAATGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACATTTGTAAACTGGATTCTGATTGTCAGTTTTATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTACCTAGTTTGTATTTTCCTACTTTAGTGACCTGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAGGTAGTCTTACTTCTTTTTAGTTTTTATAGCTTAGCATTAGTGACTTATTTCAAAAGACCCAAATCAAAAAGTTAGTTTGAAAGCATTTTTTAATAATTGTATTTATGCATTTCCTTGATTTAATATGATAAATTTAATACTTAACAATTTATATGTAACTAAAACTTAAAGTCATTTGAAAAATATATAGAAACCTATTTACAACTTGTTAAGGACAATCAGACATAATGCAGAGTTAAGTAGTATTTGCTTAAAATTCAAGTTGTGACTAATGATCAAATACTAGGCTTGTACGAAATGCTTTAGAAAAACTTTGTAACAGTTTTGTGGGATTTTTCAATATAAACCTTTATCAGAAATATACTAAGTTTGTCTCCCACTGACAACAGATGTTTTCCAAATAAACATATTCTATACATACTTGTGGAATGCCACATGGTGAATCATTGTATATGAAATTCCACTCCTGTACAGTTACTCTGCAGCTAATGGTCATGCACTGCTTAATGCTGGTCCTGAATCATGTTCTCATGTTAGACCAACAGCTCTCCAATTGTCATTTTTTTTCTGCAGAGTTTTTTTTTTCCACTTTTAAATTAAATGCATGTTGTGGAAAAACAGTCTTTTAAAATGAAATTTCAGATTCCATTTGAGAAGGTTCTGTAGATATTTCAGTCCATATAAAATAATACATCTTTACTAAACTTATATAAGGGGAGAGAAAGTTATGAAGTTTTGGACATTACTAAAAGTACAGTATTTGATTTCACTTTCAATGAATGTGAAGTTAATAAAACTAAATCTCATAATGCTCTTGGTTCCTAAGAATGAGTAGTAATCATCAACTTTATAATACTCCAATATTCCGTTTTATAATAATTCAGAGCCCTGTGGCTTTTACACACCGTTAATTATGTACTCTGTTGGAAGTGCACATGAAAAGTGAAGAAAAGTTCCTCTTGTGATTAAACTAATGGGAGGAAATAAATCAACAAAGTCTCCATTAAGTTCTACATTTTGAGACCTTTTAAAAATTCCCCTCACAATTCTTTAAGGAGCCCCCCTTTTTATGGAACATGAGCCTAAAAATTATAGAAAGAAGAATTTTAAGTTAATAAAGTTTGTATTTATAAATGCTGAAAAAATACAGAAACTTTCTGTTCCAAATGTGTTGCTTTGTGTATTTTATAATACAGATACTACATTGTAAACATTTCCATTGTTTTATGATTTAGCCAGTGATTCCCCAAAGCAGCCTCTTAGTGTTTTAATATATTAATAACTGTTTTGTTAAAAATGATCATAGTGAATTTAAATCTTCACATGATCACCTATTTGAATAAGCAATCATATCCAATGAAATTCTGTATTTCTGAGTATTTTTATAGTCATTTTGTTCTTGTGTGAATTTTAAAGCTATCCCTATGTTAATCCTAATATTTTGAAATCATATAAAATATAATAAAAATGTAGTATTATATATTTACTTCTAATTTCAGATTCCTGGTCAAAATTACTAAATATCTTGAATGTAATTTAGTGCCAAGTTTAAATAATGTGTAAATGTGACTAGGATATTGTGTTTTTCACAATTAAGAAATGTTATGTGGAAATAAATATTTATCCTAACTTCCTTGCACATTTTAAATTGTGATACAAAGTGTCTTGTCTTTTTTCTTTGTTTTAATTAGTAAATCAGTGTAAAACATTTTGATTGTTTGAATATAATATTTAAATTTAGACAGCCCCAAAGCTAAGAACTCTTGGTGATGTAAACAATTTATGAGTATGTTTCAAGAGTAAACAATTTGAACTTTATGAACAGAAGATTATGAGAACTATATAAAGATATATTTACTCATTTTTCCAGAAATGGGTGCAGATGACACGGTTTCTTATGCTAGGAAAAACCTCCAAGGTCGTTAGTAGTAGTATTCCTCATTATTAGAACTCTATTTAGACTTCCGTTTTTAACTTCCATGGGGAAAGCATTGCCTAAAATTTGTCTCCTCCCTGTTTCTTACAAAAGTCAGATGGGACCATTATTCTTTGGTAGCCATCTGGCAGTGTGTTGTGGAGATAATTGCATTCAGAATTCTATCTAACCTACTGCTTGGTATTTTTCTCTTGACTAGTGAGTTTACTTTGTAATTGCTCCTGTTTCACAGCCTACAATATTGGAAAGTTTTTTTCCTGTATAATATAATATAGGAATATATATATTCCTATGTATGTATAGGATATCCTATATATCCTGTATAGATGAATGTCTCCTTGGTATAGTTTAAACCCGAGTTTGAAAGAAACTCTCCACTGATGATCCAAAAGCAACTTGTATTTCAACATGATTCCTAGATCTTTTTGGATTTTTCTTGACTCTTAGAAGTGTGACTTACCTGTTTTCTATGGCACTGACCTACCTCTGTTTTGGTTTAACTTTAGCCTATTAGCTCCTGGGCACTTGTCTATTTTACTATCATTGCAAGATTGCTCTCTCATTTTTCCAATATATTAATATCTATCTCATATATTCACACAATGAAATGAAATGAGATTACATCCATTTGAAAGTTTTATGAGAGTCATTTGGATAATATGATGGTTCTCTAAATGTCTACATCAAGAGGCTAATTGTAGTTAGTCCCCTTGAAGAGGCTTAATAATCAAAGATTACTGGTAATACTTTATTTTAGAGATCTCCTTCGATGTTCTTCATGGAATGCTGTGGCTAACTGATACAACTGTCACACCAATTCCGTTCCTGTTGGTGTACTGGGTACTATCATTTCTGCTGGAACTTTGAAAATAGGACTATGATCCTTGCTTCTAAGGGCAGGGTGGATACATAGCTGTAAATAATGTGATATGTGCTGGTTGGCCATATGAGTAAAGCCATTTTTTGAATAGGGCAGAGTTTGACGAAAACATTATAGTAGAGGTAGCATGTGAATTAGAATGGAAATGGGGAAGGAAATGTACTCCAGATGTTGAAGGAACCCCTGCCTACTAGGCCTCTGGTCTAATGAAGTATGACCAGAATGACTCCATCTTGAAGTGAAGAGCTAGAACACTCTTAAGGCACCTATAAGATTAATGCTTGTGGTCTGAAAATAGCCACTTTCCAAGCTGGCTACAACCTATTATTACAGAATATTTATGACCATACAGAGCATCTCCCACCATGCCTGCAGAATGTCCCTATGTCCTAAGAATTCAGCCCTCCTTACTTAGAGATAACGTTAATGAACAAGCTTAGGTTAAAAGATTAAGGGTCATGTAATATCAATGACACTGAAGGCCCCTGCCTTTAGTGAGCACATAGACACATTCCAAGTTTAATTGTAGCTCTTTGTAACTCCTTATAAAAGTAGAGGCGCTAACAAAGGACAGGGCATTCCTCCTTTTGCTTTCAGAGGATATCCCACACTGTAACGAAACGGTTTCTGAAAAACTTACTTCTTCCACTATGCTCTGTGGCTTTCCTTGAATTCTCTCCTTTGCAAGATCCAAGGACCCATTTTTGGGGTCTGGATCAGGACCCCTTTTCCAGCAACACCGGAACTACAAAGATTCTCAAACCTATGTCGGTATTGAAATAAAGATGAAATTTAAAAGTAAAGCTATATGGCATAACTAGAGCCTGGCATATTTTATGTATGGCATATTTGGAACCCAGCAAACAGCCCAATATGGTGGAGTGTTAGAAGGGTAGTGAAGACTTGTAGGAAAAGACAGAAACACAAGTCAGAGACATTACAAATGATGTTAAATTCTATCCTAGAACTGTTGGAATTTTACCCATTAAAAGTTTTGAGTAATGAATTTTGAAATGATTAATAGAGCAGCACAGTAGAGAATATAGTGGGGAAACAGTGGAATTGCCTCCTCAGGGATCTCCCTTCCAGGATGACTCTCAGATGACAAAACTAAGTTTTCATGATCTATAAATTTCTATTAGGATAGAAACGAAACAGGCTCAAGTATACTCCTTAGGTACCTAACCCGTAACTCTAGACACAATAGCTTAATTATAATTACTTTTATGTAGTGCATTCCCTTATATATGGAGATTTTATATATATATATATATATATATATATATATATATATATATATATATATATCTTCATAACAATGCAACAGTTCTGTAAGGTAGGTCTTTTTGTACTTTTTACAAATTAAGACACTGGAGTTCAAAGAGCCTAAGTATTGTTCTTTATATATATATATATATATAGCACATATTTGTGTATATAGTTACATTTGAAAAAAAAAAGTGTTCTGAAAAGCACAGTGTCCACAGCAAGCCTGAGACTGTTAAAGAAACCTAAGTGTGGTGCACAGTTCAGACAATGACTGCTTCATAATAATCCAGAAACCACCTTCTCTCCGCCCAGCCTTGAATCCTACCCTACATTCTTACCCTGGATTCAGTTTTCTGTCTGGATCCTCTTGCCTTCCGGTGTGTGTAGAGTTAAATATTTTTTTCATGTGACTTCTTTTTTCCATTTATTTATAAACTCCTTGAAGGTAGGGATGGTGTTTGGTGTTTTGCCCCTCTTTTGTAACTCTCCAGAGCCCAGATCTGTGCTCTGCTGTTTACCCAGCCAGCAAAGGCTCTTGATATAATAAGTAAAATATACCAGAAGATCCTGCTGCTCAGTTTATTAAGAATGATTAAAAGTCCAAAAAGAATTGTCACGGACATGTCAGTATTGGAACACAGCAAATGCTTAATGAGTACCTTCAAGTGCCCAGCACCTGAGGACACAGAAGACTAAGGCAAGAATCTGTGTAATCTATGGAGCCATTAAGAAGCAGCTACATGGTTGTGACTAGAAGGAGGGAAAAGGTGAAAGGAAGGTGTCAGGCATTGTATCTATGTAAATCTTCAGAGCAATGCAACCAGTTCTGTAAGGTAGGTCTTTTTGTACTTTTTACAAATTAAGACACTGGAGTTCAAAGAGGCTAAGTATTGTTCTTTAAATGTTCCCCATTAGTGAGTTGGTGGTACTGAGACTCTAACCCAGGTCCAACTGACCTCAGCTGCAGGGCACTGTGTCTCCAGCAGGAGGTGAGATGTGACCGCCTTCCTCCTTATCAGGTTATTCATTCTGGCTCATGGAACCAGAATCAGGTTATGATGATTAATATTTCTGCTTAATATGTTACATTTTCTTTGCCACCAATCTTTCTGTTATTAACACTGGAAACCAAACTTACCCAGTGAAACACCTTTTTTGCTCATGAGTCACAAATATCAGGACCTTGGATAGAAGAAGCTTAAAAAATAAAAAGGGTTTTTGATTGTTGGATGGTCACACTTCACACCACACTCACACATGCTTTTTAAATAATTTGAAGAGTGGGTTCAGATGAAAGACTATATAGAATAAGAATTTTTATCGAGTTTGTTGAGGCTTAAAGCCTGTAAGCACCAAAAAAAAAAGTTTTCTCTCAATTAAGGAAGTTAACTATTAATTCAAATTCTTGGGTGTAAATGTTAATATTGTCACAGAAAGAAGACTGTGCAGAAAGATGATACATTTCTATGGGCCATAATATTGGTCCATTCATACCATGCTCTGAGCTTTCCTCATGGGATAGTGATGTTATACTTTGTTTATGTATTTATTTATTTATTTTGAGATGGAGTCTCGCTCTGTCACCCAGGCTGGAGTGCAATGGCGCGATCTCTGCTAACTGCAACCTCCGACTCCCGGGTTCAAGTGATTCTCCTGTCTCAGACTCCCGAGTAGCTGGGATTACAGGAGCACACCACCATGCCTGGCTACTTTTTTGTATTTCAATAAAGACGGGGTTTCACCGTGTTACCCAGGCTGGTCTCGAACTGGGCTCAGGCAATCCACCCCGCTTGGCCTCCCAAAGTGCTATGATTACAGGTGTGAGCCGCCACCATGCCTGGCTGTGATGTTATACTTTATAACCCACACTTGTCTATTATTCTCAACCATCTGTATCCCTCAGACATCCTGAATACACACTCTAGGTCACTCAGGATGTACACAAAAGAGTTCTTGGACGCTGCTGAAATAACTGCCACAGAGTTGGCCAACAAAATCCTCTTACTTTATGGAAAAAAGTCATGCTTATGTTTTGTTGTGTTTTCTATTTAGAGTTTATTGAATCATAAATATTGTACAAATCTAGTAGTCTTATAAATCAGTATTCTCACATCAACTTCGAGCAAAAGTAGCAAATGCCAAGAAGTGGAACTGGTAGCCTCAGTGACTACCTGTGAATAAGAAAAGAAACAGAAAATATGCAGAATGTCACGAAGCCCAGTATGTTCATTAACTTTTATGGTAGTGGCTCTGAGTTATCAAGAATGCATTGAATTATATTCTGTGCCTGATATTTAATAAAGTATGAAGGTATGTACTCATATTTAGCAAAATTTCCAACAAACATGTTAAAAAATAATTCATAGTGATTTTCTAAAAATCTTGATAGAAACTTAAAAAACCAACCCTGTATCCATAGAAGAGATGTAAGCCATTTCTCCCTTCTTTTCGTGTATGTGCCTCTGGGCACTGGTGTACTCTCACAGGTTGTTATGAAAGGAGTCTTAGCCATTCCTGTGTCTGCAGAGGCTGCAGCTATGAATGTCAAGACAAGTCTGCACATCTTAGTGGTATGACTGGTTCCTGTATGTTTTAAACTTATTCTCAGATTAAGTTTATCTCTAACTTATTTGTCCATTTTCTTCTTTTTTCCATAAGCTAATTTAAAACTCTCATTGGAAAGGAAAACTTGTCCTATGAGGGTCAAATGAAAACTACTTCGACTTTACTCACATTATTACTTTTTGCAGCCTTCAATGCTTGAAAAATATGTGCTGGGATTACCTCACTCCAGAGAAAATACTGCACATGCTTAGAAACTAAAGAAATATTAATCCATATCATTTTGATATTGTATAAATATTAAATAGTATCTGACTTAGATATTACGATTATAATATCTGACTTGTATGATATATGATGTTGTACAATATCTGACATTGTACAATGTCTGGCTTCAATTAAGATAAAAGGAGAATTTCTATTTAATTTGCTTTTATGACTATTAATGCTGTCCAGGATGTGAACATATATTACTACCGCTTCTTGATATACAATTCTGCAAAGATTGATCCAGCTACTCACAATGATTGAACTGTATTAAGAAACAGAATTTTGACAAGAAGAGTCCTACAGATTGGAAGGTCAGTTTGTGGTTCCAATGGAGGAGTGGGAGTTGAGATTTAATTAAGGTGAAGTGACTCAATGGCATGCTCTGAAGCTGTAGTTGAAGATGGATTTCACAATCCTCTGTCCATTCCTATGCATGACTCACCAGTCTCATGTTCAATTGGTAGATTTTTTTTTCCATTTCTTCCATTTTTAGGTTTTTATGCTGTAGCTCACCCTGTCTGGGAAAACTTTGTCTAGCAAATGGTCTGAAGCTAAGTTTAAACTCATAAAGTCAAATTTTTAAAAATGAGGCTGTTTTGCAAATAATTGAAAAAAATGATGTTTTCTGTTATCTGGATATTGCTTTGCTAGGCCAAATTCAGCATTTAAAATTATTGCTTTCGGTCAGATGTGGTGGCTCACGCCTGTAATCCTAGCACTTTGGAAGGCCAAGGCGGGCGGATCACCTGAGGTTAAGAGTTCGTGACCAGCCTAGCCAACAGGACAAAAACCCATCTCTACTAAAAATACAAAAATTAGCCAGGCATGGTGGCACGCACCTGTAATCCCAGCTACTTGGGAGGCTGAGACAGAAGAATCGTTTGAACCCAGGAGCCGAGATCATGCCACTGCACTCCAGCCTGGGCAACAGAGCAAGACTCTGTCTCGGAAAAAAAAAAAATTTATGCTTTCTTTTTTTCTTTTTTTTTTTTTTTTTGAGACGGAGTCTCATTCTGTAGCCCAGGCTGGAGTACAGTGGTGTGATCTCGGCTCACTGCAACTTCCGCCTCCCGGGTTCACACCATTCTCCTGCCTCAGTGTCCCCAGTAGGTGGGACTACAGGCGCCCGCCACGATGCCTAGCTAATTTTTTGTATTTTTAGTAGAGATGGGGTTTCACTGTGTTAGCCAGGATGATCTCGATCTCCTGACCTCGTGATCTGCCTGCCTCAGCCTCCCAAAGGGCTGAGATTACAGGCGTGAGCCACCATGCCTGGCCACTTTCATTTTTATAGTAATGTCAACCACAAATAGTCAACCACTTAAATAATTGACTACTTCTACTGAGCCATAAGAACTGCCAGAATGATATTTCTGATCTTATTCGTTCTTATATAAGCCTCATCATAGTTCCCTGGAATAAAATTATAAATTGTGTATGATATAAGTAACTAAAATTAGTTTAAGTTGATTTCTCAAAAGCTGTATGTATTTATGATAAGAGAAATTGCACATTATTAGGCAAAAACCTATGAACTGTTTAGCTTAACACATTTTTATATATCTAATTTTTTTACCAAAGCTGAACTCTTTCCATGTTTACAAGGTAGTCTGGGATTACTAACAAAATAAACAAGAGCCTTTCTAGATAAATGTGTCCATATGCCAGTGCGGTTTAGGTCTTATTCAAGACACAAGTCATTACTT";
	TSequence str1b = "TGAGGACCTCAGATGAGGAGGGTTTTGCTGTAAACAAGTATCAGGGAGAAAGCATTTCTGCCCTCTCTGCTGTGTGCTGCAAGTACTTCATCCCTGTAATGATATTGTTTGAATTTTCCATGAAAAATTGTCAGCATGAGAGTAAGAAAAGTGTACGATGGGAAAATATTGAACCAAACAGACAAAAATGGTAGAGTCACATGACCAGTTTACTCATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAAATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTGAGGAGTGAGGTGAAGCATCATTCCTCTGATGCACAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGTGTCTGGAGAGCAGCGTGCATGGTAACCTGTCCTCCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGGTACAGTCTTCATCAAAGGTCAGGATCCAGTCCATGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAAATGCCTCCTGCGACATCTTGTTTGTGTCATTTACTAGAGTTGGCACTGTCTTAAGATGGGGGCATGGCTGACATTTTCAACTATCATCAGTGAGTCACTTGCCCAAATGAGGACCATGGTATTAATCTTGCATGTTTTTGGAACTGTTTAAAAAATGTCTGATTTTTGTTGTTTAGTGTCTGTTTTTGAATTTCCCCTTCTCTGCAGTTCTTGGTTTCTATCTCACTGAGTGCAGAGGATTTTAATTGTTGCTGTCTATCTGTGCTTCGCAGCATGAGAGAGCAATGCCTACGGGCTCTTGTGGTGCTTTGGGGTTGACGGGTTTTATGTCTGAGCAAGCAGATGTCATAGTAGCCATGCTGGATTGCAGTAATAAATGTGTCCTTTTTTTCCTTCTGTAGCATTGAAAGCCGAAAAGAGAAGAAAGCTGACTCAGGGAAAGGTGTTGACAGGGAGACTTGTCTATGACTCGATCTTCAATTTATTTTTTACATATATATGAGAAGAGTGTCACAATTATTAATAAAACTGCTTTGATCATGTATTGTAAATTCTGTCCCTCAACCCAAATCCACCTTCATACTGTAAGTAGTGCAATACTTGTTTCATTTCTGTGTTTAAACTTCTGAGCAGTGAGACATCCCTGTGAGCATTTGCTGTAAAGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACATTTGTAAACTGGATTCTGATTGTCAGTTTTATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTACCTAGTTTGTATTTTCCTACTTTAGTGACCTGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAGGTAGTCTTACTTCTTTTTAGTTTTTATAGCTTAGCATTAGTGACTTATTTCAAAAGACCCAAATCAAAAAGTTAGTTTGAAAGCATTTTTTAATAATTGTATTTATGCATTTCCTTGATTTAATATGATAAATTTAATACTTAACAATTTATATGTAACTAAAACTTAAAGTCATTTGAAAAATATATAGAAACCTATTTACAACTTGTTAAGGACAATCAGACATAATGCAGAGTTAAGTAGTATTTGCTTAAAATTCAAGTTGTGACTAATGATCAAATACTAGGCTTGTACGAAATGCTTTAGAAAAACTTTGTAACAGTTTTGTGGGATTTTTCAATATAAACCTTTATCAGAAATATACTAAGTTTGTCTCCCACTGACAACAGATGTTTTCCAAATAAACATATTCTATACATACTTGTGGAATGCCACATGGTGAATCATTGTATATGAAATTCCACTCCTGTACAGTTACTCTGCAGCTAATGGTCATGCACTGCTTAATGCTGGTCCTGAATCATGTTCTCATGTTAGACCAACAGCTCTCCAATTGTCATTTTTTTTCTGCAGAGTTTTTTTTTTCCACTTTTAAATTAAATGCATGTTGTGGAAAAACAGTCTTTTAAAATGAAATTTCAGATTCCATTTGAGAAGGTTCTGTAGATATTTCAGTCCATATAAAATAATACATCTTTACTAAACTTATATAAGGGGAGAGAAAGTTATGAAGTTTTGGACATTACTAAAAGTACAGTATTTGATTTCACTTTCAATGAATGTGAAGTAAACTTCTGAGCAGTGAGACATCCCTGTGAGCAGATACAATAGCCAATGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACATTTGTAAACTGGATTCTGATTGTCAGTTTTATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTACCTAGTTTGTATTTTCCTACTTTAGTGACCTGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAGGTAGTCTTACTTCTCTTGGTTCCTAAGAATGAGTAGTAATCATCAACTTTATAATACTCCAATATTCCGTTTTATAATAATTCAGAGCCCTGTGGCTTTTACACACCGTTAATTATGTACTCTGTTGGAAGTGCACATGAAAAGTGAAGAAAAGTTCCTCTTGTGATTAAACTAATGGGAGGAAATAAATCAACAAAGTCTCCATTAAGTTCTACATTTTGAGACCTTTTAAAAATTCCCCTCACAATTCTTTAAGGAGCCCCCCTTTTTATGGAACATGAGCCTAAAAATTATAGAAAGAAGAATTTTAAGTTAATAAAGTTTGTATTTATAAATGCTGAAAAAATACAGAAACTTTCTGTTCCAAATGTGTTGCTTTGTGTATTTTATAATACAGATACTACATTGTAAACATTTCCATTGTTTTATGATTTAGCCAGTGATTCCCCAAAGCAGCCTCTTAGTGTTTTAATATATTAATAACTGTTTTGTTAAAAATGATCATAGTGAATTTAAATCTTCACATGATCACCTATTTGAATAAGCAATCATATCCAATGAAATTCTGTATTTCTGAGTATTTTTATAGTCATTTTGTTCTTGTGTGAATTTTAAAGCTATCCCTATGTTAATCCTAATATTTTGAAATCATATAAAATATAATAAAAATGTAGTATTATATATTTACTTCTAATTTCAGATTCCTGGTCAAAATTACTAAATATCTTGAATGTAATTTAGTGCCAAGTTTAAATAATGTGTAAATGTGACTAGGATATTGTGTTTTTCACAATTAAGAAATGTTATGTGGAAATAAATATTTATCCTAACTTCCTTGCACATTTTAAATTGTGATACAAAGTGTCTTGTCTTTTTTCTTTGTTTTAATTAGTAAATCAGTGTAAAACATTTTGATTGTTTGAATATAATATTTAAATTTAGACAGCCCCAAAGCTAAGAACTCTTGGTGATGTAAACAATTTATGAGTATGTTTCAAGAGTAAACAATTTGAACTTTATGAACAGAAGATTATGAGAACTATATAAAGATATATTTACTCATTTTTCCAGAAATGGGTGCAGATGACACGGTTTCTTATGCTAGGAAAAACCTCCAAGGTCGTTAGTAGTAGTATTCCTCATTATTAGAACTCTATTTAGACTTCCGTTTTTAACTTCCATGGGGAAAGCATTGCCTAAAATTTGTCTCCTCCCTGTTTCTTACAAAAGTCAGATGGGACCATTATTCTTTGGTAGCCATCTGGCAGTGTGTTGTGGAGATAATTGCATTCAGAATTCTATCTAACCTACTGCTTGGTATTTTTCTCTTGACTAGTGAGTTTACTTTGTAATTGCTCCTGTTTCACAGCCTACAATATTGGAAAGTTTTTTTCCTGTATAATATAATATAGGAATATATATATTCCTATGTATGTATAGGATATCCTATATATCCTGTATAGATGAATGTCTCCTTGGTATAGTTTAAACCCGAGTTTGAAAGAAACTCTCCACTGATGATCCAAAAGCAACTTGTATTTCAACATGATTCCTAGATCTTTTTGGATTTTTCTTGACTCTTAGAAGTGTGACTTACCTGTTTTCTATGGCACTGACCTACCTCTGTTTTGGTTTAACTTTAGCCTATTAGCTCCTGGGCACTTGTCTATTTTACTATCATTGCAAGATTGCTCTCTCATTTTTCCAATATATTAATATCTATCTCATATATTCACACAATGAAATGAAATGAGATTACATCCATTTGAAAGTTTTATGAGAGTCATTTGGATAATATGATGGTTCTCTAAATGTCTACATCAAGAGGCTAATTGTAGTTAGTCCCCTTGAAGAGGCTTAATAATCAAAGATTACTGGTAATACTTTATTTTAGAGATCTCCTTCGATGTTCTTCATGGAATGCTGTGGCTAACTGATACAACTGTCACACCAATTCCGTTCCTGTTGGTGTACTGGGTACTATCATTTCTGCTGGAACTTTGAAAATAGGACTATGATCCTTGCTTCTAAGGGCAGGGTGGATACATAGCTGTAAATAATGTGATATGTGCTGGTTGGCCATATGAGTAAAGCCATTTTTTGAATAGGGCAGAGTTTGACGAAAACATTATAGTAGAGGTAGCATGTGAATTAGAATGGAAATGGGGAAGGAAATGTACTCCAGATGTTGAAGGAACCCCTGCCTACTAGGCCTCTGGTCTAATGAAGTATGACCAGAATGACTCCATCTTGAAGTGAAGAGCTAGAACACTCTTAAGGCACCTATAAGATTAATGCTTGTGGTCTGAAAATAGCCACTTTCCAAGCTGGCTACAACCTATTATTACAGAATATTTATGACCATACAGAGCATCTCCCACCATGCCTGCAGAATGTCCCTATGTCCTAAGAATTCAGCCCTCCTTACTTAGAGATAACGTTAATGAACAAGCTTAGGTTAAAAGATTAAGGGTCATGTAATATCAATGACACTGAAGGCCCCTGCCTTTAGTGAGCACATAGACACATTCCAAGTTTAATTGTAGCTCTTTGTAACTCCTTATAAAAGTAGAGGCGCTAACAAAGGACAGGGCATTCCTCCTTTTGCTTTCAGAGGATATCCCACACTGTAACGAAACGGTTTCTGAAAAACTTACTTCTTCCACTATGCTCTGTGGCTTTCCTTGAATTCTCTCCTTTGCAAGATCCAAGGACCCATTTTTGGGGTCTGGATCAGGACCCCTTTTCCAGCAACACCGGAACTACAAAGATTCTCAAACCTATGTCGGTATTGAAATAAAGATGAAATTTAAAAGTAAAGCTATATGGCATAACTAGAGCCTGGCATATTTTATGTATGGCATATTTGGAACCCAGCAAACAGCCCAATATGGTGGAGTGTTAGAAGGGTAGTGAAGACTTGTAGGAAAAGACAGAAACACAAGTCAGAGACATTACAAATGATGTTAAATTCTATCCTAGAACTGTTGGAATTTTACCCATTAAAAGTTTTGAGTAATGAATTTTGAAATGATTAATAGAGCAGCACAGTAGAGAATATAGTGGGGAAACAGTGGAATTGCCTCCTCAGGGATCTCCCTTCCAGGATGACTCTCAGATGACAAAACTAAGTTTTCATGATCTATAAATTTCTATTAGGATAGAAACGAAACAGGCTCAAGTATACTCCTTAGGTACCTAACCCGTAACTCTAGACACAATAGCTTAATTATAATTACTTTTATGTAGTGCATTCCCTTATATATGGAGATTTTATATATATATATATATATATATATATATATATATATATATATATATATATCTTCATAACAATGCAACAGTTCTGTAAGGTAGGTCTTTTTGTACTTTTTACAAATTAAGACACTGGAGTTCAAAGAGCCTAAGTATTGTTCTTTATATATATATATATATATAGCACATATTTGTGTATATAGTTACATTTGAAAAAAAAAAGTGTTCTGAAAAGCACAGTGTCCACAGCAAGCCTGAGACTGTTAAAGAAACCTAAGTGTGGTGCACAGTTCAGACAATGACTGCTTCATAATAATCCAGAAACCACCTTCTCTCCGCCCAGCCTTGAATCCTACCCTACATTCTTACCCTGGATTCAGTTTTCTGTCTGGATCCTCTTGCCTTCCGGTGTGTGTAGAGTTAAATATTTTTTTCATGTGACTTCTTTTTTCCATTTATTTATAAACTCCTTGAAGGTAGGGATGGTGTTTGGTGTTTTGCCCCTCTTTTGTAACTCTCCAGAGCCCAGATCTGTGCTCTGCTGTTTACCCAGCCAGCAAAGGCTCTTGATATAATAAGTAAAATATACCAGAAGATCCTGCTGCTCAGTTTATTAAGAATGATTAAAAGTCCAAAAAGAATTGTCACGGACATGTCAGTATTGGAACACAGCAAATGCTTAATGAGTACCTTCAAGTGCCCAGCACCTGAGGACACAGAAGACTAAGGCAAGAATCTGTGTAATCTATGGAGCCATTAAGAAGCAGCTACATGGTTGTGACTAGAAGGAGGGAAAAGGTGAAAGGAAGGTGTCAGGCATTGTATCTATGTAAATCTTCAGAGCAATGCAACCAGTTCTGTAAGGTAGGTCTTTTTGTACTTTTTACAAATTAAGACACTGGAGTTCAAAGAGGCTAAGTATTGTTCTTTAAATGTTCCCCATTAGTGAGTTGGTGGTACTGAGACTCTAACCCAGGTCCAACTGACCTCAGCTGCAGGGCACTGTGTCTCCAGCAGGAGGTGAGATGTGACCGCCTTCCTCCTTATCAGGTTATTCATTCTGGCTCATGGAACCAGAATCAGGTTATGATGATTAATATTTCTGCTTAATATGTTACATTTTCTTTGCCACCAATCTTTCTGTTATTAACACTGGAAACCAAACTTACCCAGTGAAACACCTTTTTTGCTCATGAGTCACAAATATCAGGACCTTGGATAGAAGAAGCTTAAAAAATAAAAAGGGTTTTTGATTGTTGGATGGTCACACTTCACACCACACTCACACATGCTTTTTAAATAATTTGAAGAGTGGGTTCAGATGAAAGACTATATAGAATAAGAATTTTTATCGAGTTTGTTGAGGCTTAAAGCCTGTAAGCACCAAAAAAAAAAGTTTTCTCTCAATTAAGGAAGTTAACTATTAATTCAAATTCTTGGGTGTAAATGTTAATATTGTCACAGAAAGAAGACTGTGCAGAAAGATGATACATTTCTATGGGCCATAATATTGGTCCATTCATACCATGCTCTGAGCTTTCCTCATGGGATAGTGATGTTATACTTTGTTTATGTATTTATTTATTTATTTTGAGATGGAGTCTCGCTCTGTCACCCAGGCTGGAGTGCAATGGCGCGATCTCTGCTAACTGCAACCTCCGACTCCCGGGTTCAAGTGATTCTCCTGTCTCAGACTCCCGAGTAGCTGGGATTACAGGAGCACACCACCATGCCTGGCTACTTTTTTGTATTTCAATAAAGACGGGGTTTCACCGTGTTACCCAGGCTGGTCTCGAACTGGGCTCAGGCAATCCACCCCGCTTGGCCTCCCAAAGTGCTATGATTACAGGTGTGAGCCGCCACCATGCCTGGCTGTGATGTTATACTTTATAACCCACACTTGTCTATTATTCTCAACCATCTGTATCCCTCAGACATCCTGAATACACACTCTAGGTCACTCAGGATGTACACAAAAGAGTTCTTGGACGCTGCTGAAATAACTGCCACAGAGTTGGCCAACAAAATCCTCTTACTTTATGGAAAAAAGTCATGCTTATGTTTTGTTGTGTTTTCTATTTAGAGTTTATTGAATCATAAATATTGTACAAATCTAGTAGTCTTATAAATCAGTATTCTCACATCAACTTCGAGCAAAAGTAGCAAATGCCAAGAAGTGGAACTGGTAGCCTCAGTGACTACCTGTGAATAAGAAAAGAAACAGAAAATATGCAGAATGTCACGAAGCCCAGTATGTTCATTAACTTTTATGGTAGTGGCTCTGAGTTATCAAGAATGCATTGAATTATATTCTGTGCCTGATATTTAATAAAGTATGAAGGTATGTACTCATATTTAGCAAAATTTCCAACAAACATGTTAAAAAATAATTCATAGTGATTTTCTAAAAATCTTGATAGAAACTTAAAAAACCAACCCTGTATCCATAGAAGAGATGTAAGCCATTTCTCCCTTCTTTTCGTGTATGTGCCTCTGGGCACTGGTGTACTCTCACAGGTTGTTATGAAAGGAGTCTTAGCCATTCCTGTGTCTGCAGAGGCTGCAGCTATGAATGTCAAGACAAGTCTGCACATCTTAGTGGTATGACTGGTTCCTGTATGTTTTAAACTTATTCTCAGATTAAGTTTATCTCTAACTTATTTGTCCATTTTCTTCTTTTTTCCATAAGCTAATTTAAAACTCTCATTGGAAAGGAAAACTTGTCCTATGAGGGTCAAATGAAAACTACTTCGACTTTACTCACATTATTACTTTTTGCAGCCTTCAATGCTTGAAAAATATGTGCTGGGATTACCTCACTCCAGAGAAAATACTGCACATGCTTAGAAACTAAAGAAATATTAATCCATATCATTTTGATATTGTATAAATATTAAATAGTATCTGACTTAGATATTACGATTATAATATCTGACTTGTATGATATATGATGTTGTACAATATCTGACATTGTACAATGTCTGGCTTCAATTAAGATAAAAGGAGAATTTCTATTTAATTTGCTTTTATGACTATTAATGCTGTCCAGGATGTGAACATATATTACTACCGCTTCTTGATATACAATTCTGCAAAGATTGATCCAGCTACTCACAATGATTGAACTGTATTAAGAAACAGAATTTTGACAAGAAGAGTCCTACAGATTGGAAGGTCAGTTTGTGGTTCCAATGGAGGAGTGGGAGTTGAGATTTAATTAAGGTGAAGTGACTCAATGGCATGCTCTGAAGCTGTAGTTGAAGATGGATTTCACAATCCTCTGTCCATTCCTATGCATGACTCACCAGTCTCATGTTCAATTGGTAGATTTTTTTTTCCATTTCTTCCATTTTTAGGTTTTTATGCTGTAGCTCACCCTGTCTGGGAAAACTTTGTCTAGCAAATGGTCTGAAGCTAAGTTTAAACTCATAAAGTCAAATTTTTAAAAATGAGGCTGTTTTGCAAATAATTGAAAAAAATGATGTTTTCTGTTATCTGGATATTGCTTTGCTAGGCCAAATTCAGCATTTAAAATTATTGCTTTCGGTCAGATGTGGTGGCTCACGCCTGTAATCCTAGCACTTTGGAAGGCCAAGGCGGGCGGATCACCTGAGGTTAAGAGTTCGTGACCAGCCTAGCCAACAGGACAAAAACCCATCTCTACTAAAAATACAAAAATTAGCCAGGCATGGTGGCACGCACCTGTAATCCCAGCTACTTGGGAGGCTGAGACAGAAGAATCGTTTGAACCCAGGAGCCGAGATCATGCCACTGCACTCCAGCCTGGGCAACAGAGCAAGACTCTGTCTCGGAAAAAAAAAAAATTTATGCTTTCTTTTTTTCTTTTTTTTTTTTTTTTTGAGACGGAGTCTCATTCTGTAGCCCAGGCTGGAGTACAGTGGTGTGATCTCGGCTCACTGCAACTTCCGCCTCCCGGGTTCACACCATTCTCCTGCCTCAGTGTCCCCAGTAGGTGGGACTACAGGCGCCCGCCACGATGCCTAGCTAATTTTTTGTATTTTTAGTAGAGATGGGGTTTCACTGTGTTAGCCAGGATGATCTCGATCTCCTGACCTCGTGATCTGCCTGCCTCAGCCTCCCAAAGGGCTGAGATTACAGGCGTGAGCCACCATGCCTGGCCACTTTCATTTTTATAGTAATGTCAACCACAAATAGTCAACCACTTAAATAATTGACTACTTCTACTGAGCCATAAGAACTGCCAGAATGATATTTCTGATCTTATTCGTTCTTATATAAGCCTCATCATAGTTCCCTGGAATAAAATTATAAATTGTGTATGATATAAGTAACTAAAATTAGTTTAAGTTGATTTCTCAAAAGCTGTATGTATTTATGATAAGAGAAATTGCACATTATTAGGCAAAAACCTATGAACTGTTTAGCTTAACACATTTTTATATATCTAATTTTTTTACCAAAGCTGAACTCTTTCCATGTTTACAAGGTAGTCTGGGATTACTAACAAAATAAACAAGAGCCTTTCTAGATAAATGTGTCCATATGCCAGTGCGGTTTAGGTCTTATTCAAGACACAAGTCATTACTT";
	TSequence str1c = "CATGGTGTGAACTTCATCCCTGTAATGATATTGTTTGAATTTTCCATGAAAAATTGTCAGCATGAGAGTAAGAAAAGTGTACGATGGGAAAATATTGAACCAAACAGACAAAAATGGTAGAGTCACATGACCAGTTTACTCATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAAATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTGAGGAGTGAGGTGAAGCATCATTCCTCTGATGCACAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGTGTCTGGAGAGCAGCGTGCATGGTAACCTGTCCTCCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGGTACAGTCTTCATCAAAGGTCAGGATCCAGTCCATGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAAATGCCTCCTGCGAGTTTTGCTGTAAACAAGTATCAGGGAGAAAGCATTTCTGCCCTCTCTGCTGTGTGCTGCAAGTACTTCATCCCTGTAATGATATTGTTTGAATTTTCCATGAAAAATTGTCAGCATGAGAGTAAGAAAAGTGTACGATGGGAAAATATTGAACCAAACAGACAAAAATGGTAGAGTCACATGACCAGTTTACTCATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAAATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTGAGGAGTGAGGTGAAGCATCATTCCTCTGATGCACAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGTGTCTGGAGAGCAGCGTGCATGGTAACCTGTCCTCCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGGTACAGTCTTCATCAAAGGTCAGGATCCAGTCCATGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAAATGCCTCCTGCGACATCTTGTTTGTGTCATTTACTAGAGTTGGCACTGTCTTAAGATGGGGGCATGGCTGACATTTTCAACTATCATCAGTGAGTCACTTGCCCAAATGAGGACCATGGTATTAATCTTGCATGTTTTTGGAACTGTTTAAAAAATGTCTGATTTTTGTTGTTTAGTGTCTGTTTTTGAATTTCCCCTTCTCTGCAGTTCTTGGTTTCTATCTCACTGAGTGCAGAGGATTTTAATTGTTGCTGTCTATCTGTGCTTCGCAGCATGAGAGAGCAATGCCTACGGGCTCTTGTGGTGCTTTGGGGTTGACGGGTTTTATGTCTGAGCAAGCAGATGTCATAGTAGCCATGCTGGATTGCAGTAATAAATGTGTCCTTTTTTTCCTTCTGTAGCATTGAAAGCCGAAAAGAGAAGAAAGCTGACTCAGGGAAAGGTGTTGACAGGGAGACTTGTCTATGACTCGATCTTCAATTTATTTTTTACATATATATGAGAAGAGTGTCACAATTATTAATAAAACTGCTTTGATCATGTATTGTAAATTCTGTCCCTCAACCCAAATCCACCTTCATACTGTAAGTAGTGCAATACTTGTTTCATTTCTGTGTTTAAACTTCTGAGCAGTGAGACATCCCTGTGAGCATTTGCTGTAAAGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACATTTGTAAACTGGATTCTGATTGTCAGTTTTATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTACCTAGTTTGTATTTTCCTACTTTAGTGACCTGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAGGTAGTCTTACTTCTTTTTAGTTTTTATAGCTTAGCATTAGTGACTTATTTCAAAAGACCCAAATCAAAAAGTTAGTTTGAAAGCATTTTTTAATAATTGTATTTATGCATTTCCTTGATTTAATATGATAAATTTAATACTTAACAATTTATATGTAACTAAAACTTAAAGTCATTTGAAAAATATATAGAAACCTATTTACAACTTGTTAAGGACAATCAGACATAATGCAGAGTTAAGTAGTATTTGCTTAAAATTCAAGTTGTGACTAATGATCAAATACTAGGCTTGTACGAAATGCTTTAGAAAAACTTTGTAACAGTTTTGTGGGATTTTTCAATATAAACCTTTATCAGAAATATACTAAGTTTGTCTCCCACTGACAACAGATGTTTTCCAAATAAACATATTCTATACATACTTGTGGAATGCCACATGGTGAATCATTGTATATGAAATTCCACTCCTGTACAGTTACTCTGCAGCTAATGGTCATGCACTGCTTAATGCTGGTCCTGAATCATGTTCTCATGTTAGACCAACAGCTCTCCAATTGTCATTTTTTTTCTGCAGAGTTTTTTTTTTCCACTTTTAAATTAAATGCATGTTGTGGAAAAACAGTCTTTTAAAATGAAATTTCAGATTCCATTTGAGAAGGTTCTGTAGATATTTCAGTCCATATAAAATAATACATCTTTACTAAACTTATATAAGGGGAGAGAAAGTTATGAAGTTTTGGACATTACTAAAAGTACAGTATTTGATTTCACTTTCAATGAATGTGAAGTAAACTTCTGAGCAGTGAGACATCCCTGTGAGCAGATACAATAGCCAATGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACATTTGTAAACTGGATTCTGATTGTCAGTTTTATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTACCTAGTTTGTATTTTCCTACTTTAGTGACCTGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAGGTAGTCTTACTTCTCTTGGTTCCTAAGAATGAGTAGTAATCATCAACTTTATAATACTCCAATATTCCGTTTTATAATAATTCAGAGCCCTGTGGCTTTTACACACCGTTAATTATGTACTCTGTTGGAAGTGCACATGAAAAGTGAAGAAAAGTTCCTCTTGTGATTAAACTAATGGGAGGAAATAAATCAACAAAGTCTCCATTAAGTTCTACATTTTGAGACCTTTTAAAAATTCCCCTCACAATTCTTTAAGGAGCCCCCCTTTTTATGGAACATGAGCCTAAAAATTATAGAAAGAAGAATTTTAAGTTAATAAAGTTTGTATTTATAAATGCTGAAAAAATACAGAAACTTTCTGTTCCAAATGTGTTGCTTTGTGTATTTTATAATACAGATACTACATTGTAAACATTTCCATTGTTTTATGATTTAGCCAGTGATTCCCCAAAGCAGCCTCTTAGTGTTTTAATATATTAATAACTGTTTTGTTAAAAATGATCATAGTGAATTTAAATCTTCACATGATCACCTATTTGAATAAGCAATCATATCCAATGAAATTCTGTATTTCTGAGTATTTTTATAGTCATTTTGTTCTTGTGTGAATTTTAAAGCTATCCCTATGTTAATCCTAATATTTTGAAATCATATAAAATATAATAAAAATGTAGTATTATATATTTACTTCTAATTTCAGATTCCTGGTCAAAATTACTAAATATCTTGAATGTAATTTAGTGCCAAGTTTAAATAATGTGTAAATGTGACTAGGATATTGTGTTTTTCACAATTAAGAAATGTTATGTGGAAATAAATATTTATCCTAACTTCCTTGCACATTTTAAATTGTGATACAAAGTGTCTTGTCTTTTTTCTTTGTTTTAATTAGTAAATCAGTGTAAAACATTTTGATTGTTTGAATATAATATTTAAATTTAGACAGCCCCAAAGCTAAGAACTCTTGGTGATGTAAACAATTTATGAGTATGTTTCAAGAGTAAACAATTTGAACTTTATGAACAGAAGATTATGAGAACTATATAAAGATATATTTACTCATTTTTCCAGAAATGGGTGCAGATGACACGGTTTCTTATGCTAGGAAAAACCTCCAAGGTCGTTAGTAGTAGTATTCCTCATTATTAGAACTCTATTTAGACTTCCGTTTTTAACTTCCATGGGGAAAGCATTGCCTAAAATTTGTCTCCTCCCTGTTTCTTACAAAAGTCAGATGGGACCATTATTCTTTGGTAGCCATCTGGCAGTGTGTTGTGGAGATAATTGCATTCAGAATTCTATCTAACCTACTGCTTGGTATTTTTCTCTTGACTAGTGAGTTTACTTTGTAATTGCTCCTGTTTCACAGCCTACAATATTGGAAAGTTTTTTTCCTGTATAATATAATATAGGAATATATATATTCCTATGTATGTATAGGATATCCTATATATCCTGTATAGATGAATGTCTCCTTGGTATAGTTTAAACCCGAGTTTGAAAGAAACTCTCCACTGATGATCCAAAAGCAACTTGTATTTCAACATGATTCCTAGATCTTTTTGGATTTTTCTTGACTCTTAGAAGTGTGACTTACCTGTTTTCTATGGCACTGACCTACCTCTGTTTTGGTTTAACTTTAGCCTATTAGCTCCTGGGCACTTGTCTATTTTACTATCATTGCAAGATTGCTCTCTCATTTTTCCAATATATTAATATCTATCTCATATATTCACACAATGAAATGAAATGAGATTACATCCATTTGAAAGTTTTATGAGAGTCATTTGGATAATATGATGGTTCTCTAAATGTCTACATCAAGAGGCTAATTGTAGTTAGTCCCCTTGAAGAGGCTTAATAATCAAAGATTACTGGTAATACTTTATTTTAGAGATCTCCTTCGATGTTCTTCATGGAATGCTGTGGCTAACTGATACAACTGTCACACCAATTCCGTTCCTGTTGGTGTACTGGGTACTATCATTTCTGCTGGAACTTTGAAAATAGGACTATGATCCTTGCTTCTAAGGGCAGGGTGGATACATAGCTGTAAATAATGTGATATGTGCTGGTTGGCCATATGAGTAAAGCCATTTTTTGAATAGGGCAGAGTTTGACGAAAACATTATAGTAGAGGTAGCATGTGAATTAGAATGGAAATGGGGAAGGAAATGTACTCCAGATGTTGAAGGAACCCCTGCCTACTAGGCCTCTGGTCTAATGAAGTATGACCAGAATGACTCCATCTTGAAGTGAAGAGCTAGAACACTCTTAAGGCACCTATAAGATTAATGCTTGTGGTCTGAAAATAGCCACTTTCCAAGCTGGCTACAACCTATTATTACAGAATATTTATGACCATACAGAGCATCTCCCACCATGCCTGCAGAATGTCCCTATGTCCTAAGAATTCAGCCCTCCTTACTTAGAGATAACGTTAATGAACAAGCTTAGGTTAAAAGATTAAGGGTCATGTAATATCAATGACACTGAAGGCCCCTGCCTTTAGTGAGCACATAGACACATTCCAAGTTTAATTGTAGCTCTTTGTAACTCCTTATAAAAGTAGAGGCGCTAACAAAGGACAGGGCATTCCTCCTTTTGCTTTCAGAGGATATCCCACACTGTAACGAAACGGTTTCTGAAAAACTTACTTCTTCCACTATGCTCTGTGGCTTTCCTTGAATTCTCTCCTTTGCAAGATCCAAGGACCCATTTTTGGGGTCTGGATCAGGACCCCTTTTCCAGCAACACCGGAACTACAAAGATTCTCAAACCTATGTCGGTATTGAAATAAAGATGAAATTTAAAAGTAAAGCTATATGGCATAACTAGAGCCTGGCATATTTTATGTATGGCATATTTGGAACCCAGCAAACAGCCCAATATGGTGGAGTGTTAGAAGGGTAGTGAAGACTTGTAGGAAAAGACAGAAACACAAGTCAGAGACATTACAAATGATGTTAAATTCTATCCTAGAACTGTTGGAATTTTACCCATTAAAAGTTTTGAGTAATGAATTTTGAAATGATTAATAGAGCAGCACAGTAGAGAATATAGTGGGGAAACAGTGGAATTGCCTCCTCAGGGATCTCCCTTCCAGGATGACTCTCAGATGACAAAACTAAGTTTTCATGATCTATAAATTTCTATTAGGATAGAAACGAAACAGGCTCAAGTATACTCCTTAGGTACCTAACCCGTAACTCTAGACACAATAGCTTAATTATAATTACTTTTATGTAGTGCATTCCCTTATATATGGAGATTTTATATATATATATATATATATATATATATATATATATATATATATATATATCTTCATAACAATGCAACAGTTCTGTAAGGTAGGTCTTTTTGTACTTTTTACAAATTAAGACACTGGAGTTCAAAGAGCCTAAGTATTGTTCTTTATATATATATATATATATAGCACATATTTGTGTATATAGTTACATTTGAAAAAAAAAAGTGTTCTGAAAAGCACAGTGTCCACAGCAAGCCTGAGACTGTTAAAGAAACCTAAGTGTGGTGCACAGTTCAGACAATGACTGCTTCATAATAATCCAGAAACCACCTTCTCTCCGCCCAGCCTTGAATCCTACCCTACATTCTTACCCTGGATTCAGTTTTCTGTCTGGATCCTCTTGCCTTCCGGTGTGTGTAGAGTTAAATATTTTTTTCATGTGACTTCTTTTTTCCATTTATTTATAAACTCCTTGAAGGTAGGGATGGTGTTTGGTGTTTTGCCCCTCTTTTGTAACTCTCCAGAGCCCAGATCTGTGCTCTGCTGTTTACCCAGCCAGCAAAGGCTCTTGATATAATAAGTAAAATATACCAGAAGATCCTGCTGCTCAGTTTATTAAGAATGATTAAAAGTCCAAAAAGAATTGTCACGGACATGTCAGTATTGGAACACAGCAAATGCTTAATGAGTACCTTCAAGTGCCCAGCACCTGAGGACACAGAAGACTAAGGCAAGAATCTGTGTAATCTATGGAGCCATTAAGAAGCAGCTACATGGTTGTGACTAGAAGGAGGGAAAAGGTGAAAGGAAGGTGTCAGGCATTGTATCTATGTAAATCTTCAGAGCAATGCAACCAGTTCTGTAAGGTAGGTCTTTTTGTACTTTTTACAAATTAAGACACTGGAGTTCAAAGAGGCTAAGTATTGTTCTTTAAATGTTCCCCATTAGTGAGTTGGTGGTACTGAGACTCTAACCCAGGTCCAACTGACCTCAGCTGCAGGGCACTGTGTCTCCAGCAGGAGGTGAGATGTGACCGCCTTCCTCCTTATCAGGTTATTCATTCTGGCTCATGGAACCAGAATCAGGTTATGATGATTAATATTTCTGCTTAATATGTTACATTTTCTTTGCCACCAATCTTTCTGTTATTAACACTGGAAACCAAACTTACCCAGTGAAACACCTTTTTTGCTCATGAGTCACAAATATCAGGACCTTGGATAGAAGAAGCTTAAAAAATAAAAAGGGTTTTTGATTGTTGGATGGTCACACTTCACACCACACTCACACATGCTTTTTAAATAATTTGAAGAGTGGGTTCAGATGAAAGACTATATAGAATAAGAATTTTTATCGAGTTTGTTGAGGCTTAAAGCCTGTAAGCACCAAAAAAAAAAGTTTTCTCTCAATTAAGGAAGTTAACTATTAATTCAAATTCTTGGGTGTAAATGTTAATATTGTCACAGAAAGAAGACTGTGCAGAAAGATGATACATTTCTATGGGCCATAATATTGGTCCATTCATACCATGCTCTGAGCTTTCCTCATGGGATAGTGATGTTATACTTTGTTTATGTATTTATTTATTTATTTTGAGATGGAGTCTCGCTCTGTCACCCAGGCTGGAGTGCAATGGCGCGATCTCTGCTAACTGCAACCTCCGACTCCCGGGTTCAAGTGATTCTCCTGTCTCAGACTCCCGAGTAGCTGGGATTACAGGAGCACACCACCATGCCTGGCTACTTTTTTGTATTTCAATAAAGACGGGGTTTCACCGTGTTACCCAGGCTGGTCTCGAACTGGGCTCAGGCAATCCACCCCGCTTGGCCTCCCAAAGTGCTATGATTACAGGTGTGAGCCGCCACCATGCCTGGCTGTGATGTTATACTTTATAACCCACACTTGTCTATTATTCTCAACCATCTGTATCCCTCAGACATCCTGAATACACACTCTAGGTCACTCAGGATGTACACAAAAGAGTTCTTGGACGCTGCTGAAATAACTGCCACAGAGTTGGCCAACAAAATCCTCTTACTTTATGGAAAAAAGTCATGCTTATGTTTTGTTGTGTTTTCTATTTAGAGTTTATTGAATCATAAATATTGTACAAATCTAGTAGTCTTATAAATCAGTATTCTCACATCAACTTCGAGCAAAAGTAGCAAATGCCAAGAAGTGGAACTGGTAGCCTCAGTGACTACCTGTGAATAAGAAAAGAAACAGAAAATATGCAGAATGTCACGAAGCCCAGTATGTTCATTAACTTTTATGGTAGTGGCTCTGAGTTATCAAGAATGCATTGAATTATATTCTGTGCCTGATATTTAATAAAGTATGAAGGTATGTACTCATATTTAGCAAAATTTCCAACAAACATGTTAAAAAATAATTCATAGTGATTTTCTAAAAATCTTGATAGAAACTTAAAAAACCAACCCTGTATCCATAGAAGAGATGTAAGCCATTTCTCCCTTCTTTTCGTGTATGTGCCTCTGGGCACTGGTGTACTCTCACAGGTTGTTATGAAAGGAGTCTTAGCCATTCCTGTGTCTGCAGAGGCTGCAGCTATGAATGTCAAGACAAGTCTGCACATCTTAGTGGTATGACTGGTTCCTGTATGTTTTAAACTTATTCTCAGATTAAGTTTATCTCTAACTTATTTGTCCATTTTCTTCTTTTTTCCATAAGCTAATTTAAAACTCTCATTGGAAAGGAAAACTTGTCCTATGAGGGTCAAATGAAAACTACTTCGACTTTACTCACATTATTACTTTTTGCAGCCTTCAATGCTTGAAAAATATGTGCTGGGATTACCTCACTCCAGAGAAAATACTGCACATGCTTAGAAACTAAAGAAATATTAATCCATATCATTTTGATATTGTATAAATATTAAATAGTATCTGACTTAGATATTACGATTATAATATCTGACTTGTATGATATATGATGTTGTACAATATCTGACATTGTACAATGTCTGGCTTCAATTAAGATAAAAGGAGAATTTCTATTTAATTTGCTTTTATGACTATTAATGCTGTCCAGGATGTGAACATATATTACTACCGCTTCTTGATATACAATTCTGCAAAGATTGATCCAGCTACTCACAATGATTGAACTGTATTAAGAAACAGAATTTTGACAAGAAGAGTCCTACAGATTGGAAGGTCAGTTTGTGGTTCCAATGGAGGAGTGGGAGTTGAGATTTAATTAAGGTGAAGTGACTCAATGGCATGCTCTGAAGCTGTAGTTGAAGATGGATTTCACAATCCTCTGTCCATTCCTATGCATGACTCACCAGTCTCATGTTCAATTGGTAGATTTTTTTTTCCATTTCTTCCATTTTTAGGTTTTTATGCTGTAGCTCACCCTGTCTGGGAAAACTTTGTCTAGCAAATGGTCTGAAGCTAAGTTTAAACTCATAAAGTCAAATTTTTAAAAATGAGGCTGTTTTGCAAATAATTGAAAAAAATGATGTTTTCTGTTATCTGGATATTGCTTTGCTAGGCCAAATTCAGCATTTAAAATTATTGCTTTCGGTCAGATGTGGTGGCTCACGCCTGTAATCCTAGCACTTTGGAAGGCCAAGGCGGGCGGATCACCTGAGGTTAAGAGTTCGTGACCAGCCTAGCCAACAGGACAAAAACCCATCTCTACTAAAAATACAAAAATTAGCCAGGCATGGTGGCACGCACCTGTAATCCCAGCTACTTGGGAGGCTGAGACAGAAGAATCGTTTGAACCCAGGAGCCGAGATCATGCCACTGCACTCCAGCCTGGGCAACAGAGCAAGACTCTGTCTCGGAAAAAAAAAAAATTTATGCTTTCTTTTTTTCTTTTTTTTTTTTTTTTTGAGACGGAGTCTCATTCTGTAGCCCAGGCTGGAGTACAGTGGTGTGATCTCGGCTCACTGCAACTTCCGCCTCCCGGGTTCACACCATTCTCCTGCCTCAGTGTCCCCAGTAGGTGGGACTACAGGCGCCCGCCACGATGCCTAGCTAATTTTTTGTATTTTTAGTAGAGATGGGGTTTCACTGTGTTAGCCAGGATGATCTCGATCTCCTGACCTCGTGATCTGCCTGCCTCAGCCTCCCAAAGGGCTGAGATTACAGGCGTGAGCCACCATGCCTTTCTCATCATAGTTCCCTGGAATAAAATTATAAATTGTGTATGATATAAGTAACTAAAATTAGTTTAAGTTGATTTCTCAAAAGCTGTATGTATTTATGATAAGAGAAATTGCACATTATTAGGCAAAAACCTATGAACTGTTTAGCTTAACACATTTTTATATATCTAATTTTTTTACCAAAGCTGAACTCTTTCCATGTTTACAAGGTAGTCTGGGATTACTAACAAAATAAACAAGAGCCTTTCTAGATAAATGTGTCCATATGCCAGTGCGGTTTAGGTCTTATTCAAGACACAAGTCATTACTT";

	MarkovModel<TAlphabet> mm(3);

	FILE *fd = fopen("zscore_human_mm.3","r");
	read(fd, mm);
	fclose(fd);

	StringSet<TSequence> X;
	appendValue(X, str1a);
    appendValue(X, str1b);
	appendValue(X, str1c);

	StringSet<TSequence> W;
	appendValue(W,str2);
	appendValue(W,str3);

	std::cout << zscore<AhoCorasick>(W,X,mm) << std::endl;
	//std::cout << zscore<WuManber>(W,X,mm) << std::endl;

	return 0;
}
