/*
 * THIS SOFTWARE IS PROVIDED BY THE CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef _SENDPAGE_H_
#define _SENDPAGE_H_

#include <stdio.h>
#include "config.h"

#if HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
#endif

#if HAVE_SYS_UNISTD_H
# include <sys/unistd.h>
#endif

#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#if HAVE_SYSLOG_H
# include <syslog.h>
#endif

/* does your system require malloc.h? */
#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif

/* does your system require ioctl.h? */
#ifdef HAVE_SYS_IOCTL_H
# include <sys/ioctl.h>
#endif

#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif

#ifdef HAVE_LIMITS_H
# include <limits.h>
#endif

/* deal with bcopy/memcpy */
#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
# define bzero(s, n)	   memset((s), 0, (n))
#else
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n)  bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

/* deal with direct structs */
#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

/*
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
*/

#if TM_IN_SYS_TIME
# include <sys/time.h>
#else
# include <time.h>
#endif

#ifdef HAVE_TERMIO_H
# include <termio.h>
#endif
#ifdef HAVE_TERMIOS_H
# include <termios.h>
#endif

#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif

/* need to autoconf these still? */
#include <ctype.h>

/* these seem to be safe */
#include <pwd.h>
#include <signal.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <fcntl.h>

/* who should get signals? */
#ifdef HAVE_SIGACTION
# define signal mysignal
#endif

/* this one MUST exist */
#ifdef HAVE_DB_185_H
# include <db_185.h>
#elif HAVE_DB_H
# include <db.h>
#elif HAVE_SYS_DB_H
# include <sys/db.h>
#else
# error You must have a valid db.h somewhere
#endif

#ifdef ARSYSTEM_NOTIFIER
# include <nt.h>
# include <nterrno.h>
# include <ntsextrn.h>
#endif /* ARSYSTEM_NOTIFIER */

#ifndef _POSIX_SOURCE
# ifdef FAKE_POSIX_SOURCE
#  define _POSIX_SOURCE
# endif
#endif

/* c_cflag hardware settings... set to 0 for none */
/* see io.c */
#ifndef CRTSCTS
# define CRTSCTS 0
#endif
#ifndef CLOCAL
# define CLOCAL 0
#endif
#ifndef CS8
# define CS8 0
#endif

#if defined(_AIX)
# define C_FLAG CLOCAL | CRTSCTS | HUPCL /* (AIX) */
#else
  /* CRTSCTS - enable RTS/CTS flow control */
  /* CS8 - keep hit bits */
  /* CLOCAL - ignore modem control lines */
# define C_FLAG  CS8 | CLOCAL | CRTSCTS | HUPCL 
#endif
/* Use the following for BSDI and Sun ALM-II boards: */
/* #define C_FLAG CS8 | CLOCAL | CRTSCTS | HUPCL */

/*
 *
 * Shouldn't need to configure anything below here 
 *
*/

/* max # of splits a message can take.  This can safely be set as
 * high as 100 but 5 or 6 is a reasonable value.  > 10 is probably
 * not a good idea.
*/
#define MAX_MSG_SPLIT 5

#define MODEM_DIAL      "ATDT"
#define MODEM_PLUS      "+++"
#define	MODEM_WORDS	"ATV1\r"
#define	MODEM_NUMS	"ATV0\r"
#define MODEM_HANG	"ATH0\r"
#define	MODEM_WORD_OK	"OK\r"
#define	MODEM_NUM_OK	"0\r"
#define MODEM_NUM_C300	"1\r"
#define	MODEM_NUM_C1200	"5\r"
#define	MODEM_NUM_BUSY	"7\r"
#define	MODEM_NUM_NOANS	"8\r"
#define	MODEM_NUM_NOCAR	"3\r"
#define	MODEM_NUM_NODIA	"6\r"
#define	MODEM_RES_OK		0
#define MODEM_RES_C300		1
#define	MODEM_RES_C1200		5
#define	MODEM_RES_C2400		10
#define	MODEM_RES_C4800		11
#define	MODEM_RES_C9600		12
#define	MODEM_RES_C14400	15
#define	MODEM_RES_C38400	17
#define	MODEM_RES_BUSY	7
#define	MODEM_RES_NOANS	8
#define	MODEM_RES_NOCAR	3
#define	MODEM_RES_NODIA	6
#define	MODEM_RES_RING	52
#define	MODEM_RES_INTER	9999

/*
char *PrintBytes();
char *GetNextRecipient();
struct dynstring AliasExpand(), ReadAliasByFile(), ReadAliasByProgram();
void sig_hup(), sig_usr1(), sig_alrm(), sig_quit(), sig_pipe();
char *CheckTagField();
char *pr_ModemResultCode();
*/


#define	PET_REPLY_ACCEPT		0
#define	PET_REPLY_REJECT		1
#define	PET_REPLY_ABANDON		2
#define	PET_REPLY_GOODBYE		3
#define	PET_REPLY_GOAHEAD		4
#define	PET_ERROR	       	     9999
#define	PET_REPLIES                     5

#define	PET_START_SEQ1	"\033PG1"
#define	PET_START_SEQ3	"\033PG3"
#define	PET_END_SEQ	"\004\015"
#define	PET_ID		"ID="

struct pet_lookup {
	char *msg;
	int msglen;
};

#define	ASCII_NUL	0x00
#define ASCII_SOH	0x01
#define ASCII_STX	0x02
#define ASCII_ETX	0x03
#define ASCII_EOT	0x04
#define ASCII_ENQ	0x05
#define ASCII_ACK	0x06
#define ASCII_BEL	0x07
#define ASCII_BS	0x08
#define ASCII_HT	0x09
#define	ASCII_LF	0x0a
#define ASCII_VT	0x0b
#define ASCII_NP	0x0c
#define	ASCII_CR	0x0d
#define ASCII_SO	0x0e
#define ASCII_SI	0x0f
#define ASCII_DLE	0x10
#define ASCII_DC1	0x11
#define ASCII_DC2	0x12
#define ASCII_DC3	0x13
#define ASCII_DC4	0x14
#define	ASCII_NAK	0x15
#define ASCII_SYN	0x16
#define ASCII_ETB	0x17
#define ASCII_CAN	0x18
#define ASCII_EM	0x19
#define ASCII_SUB	0x1a
#define	ASCII_ESC	0x1b
#define ASCII_FS	0x1c
#define ASCII_GS	0x1d
#define	ASCII_RS	0x1e
#define ASCII_US	0x1f


/* must be larger than longest string to match */
#define CBUF_BYTES 1024

struct cbuf {
	unsigned char buf[CBUF_BYTES];
	int bufused;
	int start, end, len;
	int eof;
}; 

#define	RUN_CLIENT		0
#define RUN_DAEMON		1
#define	RUN_PRINTQUEUE	        2
#define	RUN_VERIFY		3
#define RUN_DAEMON_SNPP		4
#define	RUN_UNKNOWN	      999

#define	SNPP_PORT	      444

struct linebuf {
	int len, len2;
	int bufused;
	int nblocks;
	char *buf;
};

/* allocate buffers for a line chunks of */
#define	ADD_LINE_BLOCKSIZE	1024

/* allocate dynamic strings in chunks of */
#define	ADD_STR_BLOCKSIZE	128

/* allocate delivery list types in chunks of */
#define ADD_DTLIST_BLOCKSIZE	10

struct messagequeue {
  time_t queuetime;			/* time message was queued */
  time_t delivertime;			/* time message was delivered */
  int retries;				/* number of times delivery retried */
  int status;				/* what's going on */
  int recipientlen;			/* lenth of recipient string */
  int recipient2len;			/* lenth of recipient2 string */
                                        /* recipient2 has gone through alias
					   expansion */
  int senderlen;			/* length of sender string */
  int messagelen;			/* length of message */
  int emailCCLen;			/* length of cc string */
  int flags;				/* flags */
  /* recipient, recipient2, sender, message, and cc follow here in */
};

struct dynstring {
	int nblocks;
	int bufused;
	char *buf;
};

#define STATUS_NONE		0
#define	STATUS_DELIVERING	1	/* being delivered */
#define	STATUS_EXPANDED		2	/* gone through alias expansion */
#define	STATUS_NODELIVER1	4	/* can't be delivered 
					   - unknown recipient */
#define	STATUS_NODELIVER2	8	/* can't be delivered 
					   - internal error */
#define	STATUS_NODELIVER3	16	/* can't be delivered 
					   - page rejected */
#define STATUS_DELIVERED	32	/* delivered */
#define	STATUS_TMPFAIL		128	/* temporary failure */
#define	STATUS_EXPIRED		1024    /* retried too many times */

/* macro to determine if message status is good or bad */
#define CHECKSTATUS(status)\
	((status & STATUS_NODELIVER1) ||\
	(status & STATUS_NODELIVER2) ||\
	(status & STATUS_NODELIVER3) ||\
	(status & STATUS_TMPFAIL) ||\
	(status & STATUS_EXPIRED))

#define	MSGQ_FLAGS_NONE		      0/* no flags */
#define	MSGQ_FLAGS_MAIL_GOOD	      1/* send mail reply confirmation */
#define	MSGQ_FLAGS_MAIL_BAD	      2/* if sending mail, limit to errs */
#define	MSGQ_FLAGS_SIZETRUNCATE1      4
#define	MSGQ_FLAGS_SIZETRUNCATE2      8/* msg truncated due to config limit */
#define	MSGQ_FLAGS_MAIL_NONE	     16/* don't send mail reply
					  used by client only */

/* config file line types */
#define	CF_UNKNOWN	0
#define	CF_PC		1
#define	CF_ALIAS	2
#define	CF_TRMAP	3
#define	CF_PROFILE	4
#define	CF_SET		5
#define	CF_GLOBAL	6
#define	CF_DOPPLE	7
#define	CF_ERROR	99

/* protocol types */
#define	PC_UNKNOWN	0
#define	PC_PET1		1
#define PC_PET3		2
#define	PC_NULL		3
#define	PC_REMEDY	4

/* dialer types */
#define DIALER_INTERNAL 1
#define DIALER_EXTERNAL 1

/* when to assume an alias is expanding to itself */
#define MAX_ALIAS_RECURSE_DEPTH 10

/* interesting return code for sendmail */
#if !defined EX_OK
#define EX_OK        0   /* successful termination */
#endif /* defined EX_OK */
#if !defined EX_TEMPFAIL
#define EX_TEMPFAIL 75  /* temp failure; user is invited to retry */
#endif /* defined EX_TEMPFAIL */
#if !defined EX_SOFTWARE
#define EX_SOFTWARE 70  /* internal software error */
#endif /* EX_SOFTWARE */
#if !defined EX_NOINPUT
#define EX_NOINPUT  66  /* cannot open input */
#endif /* EX_NOINPUT */

     /* max size of key names in sendpage.cf file */
#define	MAX_CF_DB_KEYLEN	32

     /* max size of some data names in sendpage.cf file */
#define	MAX_CF_DB_DATALEN	32

     /* struct for paging central information */
#define PCINFO_STR_LEN	80
struct pcinfo {
  int	id;		          /* order in the config file */
  int	dialer;		          /* DIALER_INTERNAL or DIALER_EXTERNAL */
  char	name[PCINFO_STR_LEN];	  /* symbolic name */
  char	phone[PCINFO_STR_LEN];	  /* phone number || remedy server */
  char	password[PCINFO_STR_LEN]; /* password */
  char	modemInit[PCINFO_STR_LEN];/* modem init string */
  char	modemDev[PCINFO_STR_LEN]; /* modem device */
  char	modemDial[PCINFO_STR_LEN];/* modem dial string */
  int	answerTime;		  /* # of seconds to wait for answer */
  int	speed;			  /* B1200, B2400 ... */
  int	parity;			  /* PARENB, PARODD ... */
  int	databits;		  /* CS5, CS6 ... */
  int	stopbits;		  /* CSTOPB for 2, else 0 */
  int	protocol;		  /* PC_PET1, PC_PET2, PC_NULL, etc */
  int	msgRetries;		  /* # retries before message expires */
  int	maxMsgSize;		  /* max size of message in bytes */
  int	maxTransactions;	  /* max # transactions pc will accept */
  int	retryNotify;		  /* which retry to send notification */
  char	trMap[PCINFO_STR_LEN];	  /* tr all msgs to this pc through */
  char	fallBackGateway[PCINFO_STR_LEN];/* resend to this gw on fail */
  char	emailReplyTo[PCINFO_STR_LEN];	/* use this Reply-To: header */
  char	emailFrom[PCINFO_STR_LEN];	/* use this From: header */
  /*
   * add flags, so paging central also has profile
   */
  int	flags;			  /* see PROFILE_FLAGS_* */
  int	pc_set;			  /* were the flags set in cf profile */
  int	mangle;			  /* Mangle CR's etc (DEF yes) */
  /*
   * Add bits for PC_ALIAS bits
   */
  int	pc_alias;		   /* is this really an alias */
  int	dopple_set;		   /* various dopple properties */
  char	alias_name[PCINFO_STR_LEN];/* symbolic name */
};

struct profile {
  char	name[PCINFO_STR_LEN];	/* symbolic name */
  char	emailCC[PCINFO_STR_LEN];/* also send e-mail here */
  char	trMap[PCINFO_STR_LEN];	/* tr all msgs to through this */
  int	flags;			/* see PROFILE_FLAGS_* */
  int	maxMsgSize;		/* max size of individual message */
};

struct global {
  int	maxMsgSize;			/* maxMessageSize to queue */
  int	maxMsgSplit;			/* max # of splits per message TODO */
  int	syslogFacility;			/* syslog facility TODO */
  int	flags;				/* flags */
  char	emailFrom[PCINFO_STR_LEN];	/* use this From: header */
};

#define	GLOBAL_FLAGS_MONTH_FIRST	1	/* Month/Day/Year */
#define	GLOBAL_FLAGS_SET_REPLYTO	2	/* set reply to on outgoing mail */

#define	PROF_FLAGS_INC_SENDER	0x01  /* include sender */
#define	PROF_FLAGS_INC_DATE	0x02  /* include date */
#define	PROF_FLAGS_INC_TIME	0x04  /* include time */
#define	PROF_FLAGS_MAIL_GOOD	0x08  /* send e-mail reply for confirmation */
#define	PROF_FLAGS_MAIL_BAD	0x10  /* limit e-mail for errors/warnings */

#define DOPPLE_TRMAP		0x01  /* trMap set in dopple */
#define	DOPPLE_MAXMSGSIZE	0x02  /* MaxMsgSize set in dopple */
#define DOPPLE_MANGLE		0x04  /* mangle set in dopple */

/* what to do with the queue file in QueueRun */
#define	QF_DELETE	1
#define	QF_UPDATE	2
#define	QF_DEFER	4

#endif /* _SENDPAGE_H_ */


/* External Declarations */
extern const char SendpageVersion[];
