/***************************************************************************
 *  Module:      $Id: deliver.c,v 2.19 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: message Delivery functions for sendpage
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: deliver.c,v $
Revision 2.19  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 2.18  1997/12/29 02:45:13  nemesis
include strengthening.  works with db 2.0+1.85 compats.  compiles/runs on HPUX

Revision 2.17  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.16  1997/12/26 02:37:31  nemesis
code clean up, b* -> mem* funcs, finding NL -> # bug

Revision 2.15  1997/12/25 08:30:52  nemesis
code cleanups

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.1  1997/12/15 15:56:30  nemesis
Initial revision

 * Revision 1.11  1996/02/14  07:09:40  maf
 * GLOBAL_FLAGS_MONTH_FIRST implementation
 *
 * Revision 1.10  1996/02/13  04:38:14  maf
 * REPLYTO
 *
 * Revision 1.9  1996/02/12  03:50:44  maf
 * entry->status -> entry->flags, emailCC support, from line support
 *
 * Revision 1.8  1995/11/13  04:43:41  maf
 * *** empty log message ***
 *
 * Revision 1.7  1995/11/13  03:28:34  maf
 * *** empty log message ***
 *
 * Revision 1.6  1995/10/09  01:41:09  maf
 * *** empty log message ***
 *
 * Revision 1.5  1995/08/28  02:00:34  maf
 * QueueTime thing, VERBOSE_MAIL_REPLY
 *
 * Revision 1.4  1995/05/24  00:47:24  maf
 * all unknown string sizes use %.512s for report()
 *
 * Revision 1.3  1995/03/17  04:15:23  maf
 * added error message for STATUS_EXPIRED
 *
 * Revision 1.2  1995/03/15  04:40:52  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:42:52  maf
 * Initial revision
 *
*/

#include "sendpage.h"
#include "report.h"
#include "cf.h"
#include "queue.h"

/*********************************************************************
 * Function: Deliver()
 *	upper most layer of delivery code.
 *
 *	Returns  0	good
 *		!0	bad
 *
 *	Implements code to handle signals, reads alias database, starts
 *	delivery run when appropiate
 *
 *	This will most likely return either on a SIGQUIT (clean exit)
 *	in which case the return code will be 0, or if an error occurs
 *	such as starting the daemon with an error on the config file.
 *
 *	errors are reported via report()
 *
 *********************************************************************/
int Deliver(void) {
  u_int   ncentral;
  DB *aliasdb, *pcdb, *trdb, *profdb;
  extern int need_readconfig, need_runqueue, need_quit;
  extern int debug, errno;
  int err, rerun, have_config;
  
  
  aliasdb = pcdb = trdb = profdb = (DB*)0;
  err = 1;              /* bad */
  have_config = 0;	/* don't have a config struct read */
  
  for (;;) {
    /* quit? */
    if (need_quit) {
      report (LOG_INFO, "sendpage exiting");
      err = 0;
      goto Deliverout;
    }
    
    /* read config file (aliases, etc) */
    if (need_readconfig) {
      need_readconfig = 0;
      
      if (ReadConfig(&aliasdb, &pcdb, &trdb, &profdb, &ncentral,
		     PATH_SENDPAGE_CONFIG)) {
	report (LOG_ERR, "ReadConfig() failed, exiting");
	if (!have_config) goto Deliverout;
	else report (LOG_INFO, "config file change ignored");
      }
      else have_config = 1;
    }
    
    /* run the queue */
    if (need_runqueue) {
      need_runqueue = 0;
      
      if (QueueRun(aliasdb, pcdb, profdb, trdb, ncentral, &rerun)) {
	report (LOG_ERR, "QueueRun() failed, exiting");
	goto Deliverout;
      }
    }
    
    /* if need to re-run the queue because something couldn't be
       delivered, sleep and try again else, sleep the longer QUEUE_CHECKTIME.
       
       This is not relying on the USR1 signal to wake us up, which may
       not be necessary, but this is safer */

    /* if we got the signal... */
    if (need_runqueue) continue;
    
    if (rerun) {
#ifdef DEBUG
      if (debug > 1)
	report (LOG_INFO, "sleeping for %u", (u_int)QUEUE_RUNTIME);
#endif /* DEBUG */
      alarm((u_int)QUEUE_RUNTIME);
      pause();
    }
    else {
#ifdef DEBUG
      if (debug > 1)
	report (LOG_INFO, "sleeping for %u", (u_int)QUEUE_CHECKTIME);
#endif /* DEBUG */
      alarm((u_int)QUEUE_CHECKTIME);
      pause();
    }
    alarm((u_int)0);
    
  } /* forever */
  
Deliverout:
  
  if (aliasdb)
    err |= aliasdb->close(aliasdb);
  if (pcdb)
    err |= pcdb->close(pcdb);
  if (trdb)
    err |= trdb->close(trdb);
  if (profdb)
    err |= profdb->close(profdb);
  
  return err;
} /* Deliver */

/*********************************************************************
 * Function: DeliverMAIL()
 *	sends mail via sendmail
 *
 *		Returns	0	good
 *				!0	bad
 *
 *	args:
 *		to		recipient
 *		qfname	queue file name
 *		qbuf	pointer to queue entry
 *
 *	This creates a pipe, forks a child sendmail process, and writes
 *	an appropiate message based upon the contents of the queue entry, 
 *	normally looking at the status bits.
 *
 *	Returning good doesn't necessarly mean the mail was sent, although
 *	it does mean an error wasn't detected.
 *
 *	errors are reported via report()
 *
 *********************************************************************/
int DeliverMAIL(char *from, char *to, char *qfname, char *qbuf) {

	pid_t	pid;
	extern int errno;
	int err, pipefd[2], statloc;
	FILE *FP;
	char *recipient, *recipient2, *sender, *message, *statusline;
	struct tm *ptm, tm, tm2;
	struct messagequeue *entry;
	extern int got_sigpipe;
	extern char *sendpage_env[];
	char *c, *emailCC;
	extern struct global globalOptions;

	err = 1;
	FP = (FILE*)NULL;
	pipefd[0] = pipefd[1] = -1;
	got_sigpipe = 0;

	if (!to || !to[0]) {
		report (LOG_INFO, "DeliverMAIL: no recipient");
		return 0;
	}

#ifdef PARANOID_REPLIES
	for (c = to; *c; ++c) 

		if (*c == '|' || *c == '/') {
			report (LOG_WARNING,
				"DeliverMAIL: POSSIBLE BREAKIN ATTEMPT - %.512s, ignoring", to);
				goto DeliverMAILout;
		}

		/* like there aren't a million others that I can't test for */
		if (*c == '\n' || *c == '\r') {
			report (LOG_WARNING,
		"DeliverMAIL: ATTEMPT TO EXPLOIT OLD SENDMAIL BUG - %.512s, ignoring",
				to);
				goto DeliverMAILout;
		}

#endif /* PARANOID_REPLIES */

	if (pipe(pipefd) == -1) {
		report (LOG_ERR, "DeliverMAIL: pipe(): %s", strerror(errno));
		goto DeliverMAILout;
	}

	if ((pid = fork()) == -1) {
		report (LOG_ERR, "DeliverMAIL: fork(): %s", strerror(errno));
		goto DeliverMAILout;
	}

	if (pid) { /* parent */

 		/* close read end */
		if (close (pipefd[0])) {
			report (LOG_ERR, "pipe read close(): %s", strerror(errno));
			goto DeliverMAILout;
		}
		pipefd[0] = -1;
			
		/* associate a stream with the write end */
		if (!(FP = fdopen(pipefd[1], "w"))) {
			report (LOG_ERR, "can't fdopen() pipe");
			goto DeliverMAILout;
		}

		entry = (struct messagequeue*)qbuf;
		recipient = (char*)qbuf + sizeof(struct messagequeue);
		recipient2 = recipient + entry->recipientlen + 1;
		sender = recipient2 + entry->recipient2len + 1;
		message = sender + entry->senderlen + 1;
		emailCC = message + entry->messagelen + 1;

		if (!(ptm = localtime(&(entry->queuetime)))) {
			report(LOG_ERR, "localtime() failed");
			goto DeliverMAILout;
		} else 
			memcpy(&tm, ptm, sizeof(tm));

		if (!(ptm = localtime(&(entry->delivertime)))) {
			report(LOG_ERR, "localtime() failed");
			goto DeliverMAILout;
		} else
			memcpy(&tm2, ptm, sizeof(tm2));

		/* note STATUS_DELIVERED also set for errors, so check the
		 * error conditions first */
		if (entry->status & STATUS_EXPIRED)
			statusline = 
			"*** Message not delivered -- too many retries.";
		else if (entry->status & STATUS_NODELIVER1)
			statusline = 
			"*** Message not delivered because recipient could not be found.";
		else if (entry->status & STATUS_NODELIVER2)
			statusline = 
			"*** Message not delivered due to fatal internal error.";
		else if (entry->status & STATUS_NODELIVER3)
			statusline = 
			"*** Message not delivered Page Rejected";
		else if (entry->status & STATUS_DELIVERED)
			statusline =  "*** Page accepted.";
		else if (entry->status & STATUS_TMPFAIL) 
			statusline = 
				"*** Temporary error while delivering page, will keep trying.";
		else
			statusline = "*** unknown status, help!";

		/* Header lines */
		fprintf(FP, "From: %s\n", from);
		fprintf(FP, "To: %s\n", to);
		if (emailCC[0])
			fprintf(FP, "CC: %s\n", emailCC);
		if ((globalOptions.flags & GLOBAL_FLAGS_SET_REPLYTO) && sender[0])
			fprintf(FP, "Reply-To: %s\n", sender);
		fprintf(FP, "Subject: %s\n", statusline);
		fprintf(FP, "X-Loop: sendpage\n");
		fprintf(FP, "Precedence: bulk\n\n");

		/* Body lines */
#ifdef VERBOSE_MAIL_REPLY
		fprintf(FP, "QueueID:     %s\n", qfname);
#endif /* VERBOSE_MAIL_REPLY */

		if (globalOptions.flags & GLOBAL_FLAGS_MONTH_FIRST)
			fprintf(FP, "QueueTime:   %d/%d/%d %d:%02d:%02d\n", tm.tm_mon+1,
				tm.tm_mday, tm.tm_year + ((tm.tm_year < 69) ? 2000 : 1900),
				tm.tm_hour, tm.tm_min, tm.tm_sec);
		else 
			fprintf(FP, "QueueTime:   %d/%d/%d %d:%02d:%02d\n", tm.tm_mday,
				tm.tm_mon+1, tm.tm_year + ((tm.tm_year < 69) ? 2000 : 1900),
				tm.tm_hour, tm.tm_min, tm.tm_sec);

		if ((entry->status & STATUS_DELIVERED) && (!(entry->status &
				(STATUS_NODELIVER1|STATUS_NODELIVER2|STATUS_NODELIVER3)))) 

			if (globalOptions.flags & GLOBAL_FLAGS_MONTH_FIRST)
				fprintf(FP,
					"DeliverTime: %d/%d/%d %d:%02d:%02d (%lu second delay)\n",
					tm2.tm_mon+1, tm2.tm_mday,
					tm.tm_year + ((tm.tm_year < 69) ? 2000 : 1900), tm2.tm_hour,
					tm2.tm_min, tm2.tm_sec,
					(u_long)((u_long)entry->delivertime -
						(u_long)entry->queuetime));
			else 
				fprintf(FP,
					"DeliverTime: %d/%d/%d %d:%02d:%02d (%lu second delay)\n",
					tm2.tm_mday, tm2.tm_mon+1,
					tm.tm_year + ((tm.tm_year < 69) ? 2000 : 1900), tm2.tm_hour,
					tm2.tm_min, tm2.tm_sec,
					(u_long)((u_long)entry->delivertime -
						(u_long)entry->queuetime));
		fprintf(FP, "Retries:     %d\n", entry->retries);
#ifdef VERBOSE_MAIL_REPLY
		fprintf(FP, "Status:      0x%X\n", entry->status);
#endif /* VERBOSE_MAIL_REPLY */
		fprintf(FP, "Sender:      %s\n", sender);
		fprintf(FP, "Recipient:   %s\n", recipient);
		fprintf(FP, "Message:     %s\n\n", message);

		fprintf(FP, "%s\n\n", statusline);

		if (entry->flags & MSGQ_FLAGS_SIZETRUNCATE1) {
			fprintf(FP,
"Note: message truncated due to administrative limit.\n\n");
		}

		if (entry->flags & MSGQ_FLAGS_SIZETRUNCATE2) 
			fprintf(FP,
"Note: message size reduced to conform to paging central configuration\n\n");

		fprintf(FP, "-- \n%s\n\n", SendpageVersion);

		if (fclose(FP)) {
			report (LOG_ERR, "pipe stream fclose() failed");
			goto DeliverMAILout;
		}
		FP = (FILE*)NULL;
		pipefd[1] = -1; 

		/* no zombies */
		if (waitpid(pid, &statloc, 0) == -1) 
			report (LOG_ERR, "waitpid(): %s", strerror(errno));

		/* expect exit status 0 */
		if (statloc)
			report (LOG_WARNING, "sendmail child exited with status %d",
				statloc);

		/* could of got a sigpipe too */
		if (got_sigpipe)
			report (LOG_WARNING, "got SIGPIPE while sending mail");


	} /* parent */ else {

		/* child */

		if (close (pipefd[1])) {
			report (LOG_ERR, "child: pipe write close(): %s", strerror(errno));
			exit (1);
		}

		/* pipe becomes stdin */
		if (dup2(pipefd[0], STDIN_FILENO) != STDIN_FILENO) {
			report (LOG_ERR, "child: dup2() to stdin failed");
			exit (1);
		}

		if (close (pipefd[0])) {
			report (LOG_ERR, "child: pipe read close(): %s", strerror(errno));
			exit (1);
		}
		pipefd[0] = -1;

		/* invoke sendmail  */
		/* -t get recipient from body */
		/* -o em set error mode to mail to sender */
		if (execle(PATH_SENDMAIL, "sendmail", "-t", "-oem", (char*)0L,
			sendpage_env) == -1) {
			report (LOG_ERR, "child: execl() sendmail: %s", strerror(errno));
			exit (1);
		} 
	} /* child */
		
	err = 0; /* good */

	report (LOG_INFO, "Mail sent to %.512s for %.512s", to, qfname);

DeliverMAILout:

	if (FP)
		err |= fclose(FP);

	if (pipefd[0] != -1)
		err |= close(pipefd[0]);

	if (pipefd[1] != -1)
		err |= close(pipefd[1]);

	return err;

}
