/***************************************************************************
 *  Module:      $Id: daemon.c,v 2.18 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: Daemon mode functions for sendpage
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: daemon.c,v $
Revision 2.18  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 2.17  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.16  1997/12/26 02:37:31  nemesis
code clean up, b* -> mem* funcs, finding NL -> # bug

Revision 2.15  1997/12/25 08:30:52  nemesis
code cleanups

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.2  1997/12/15 17:31:08  nemesis
added Steve Kennedy <steve@demon.net> patches for
being able to alias paging-centrals and having
various profile bits set in the pc.
see: http://www.gbnet.net/public/paging/sendpage-multi/

Revision 1.1  1997/12/15 15:56:21  nemesis
Initial revision

*/

#include "sendpage.h"
#include "report.h"
#include "mysignal.h"

/*********************************************************************
 * Function: BeADeamon()
 *	implements the daemon mode of sendpage
 *
 *	Returns:	 0	good
 *			!0	bad
 *
 *	records pid file, fork()'s, sets up flags to have config file
 *	read, sets up signal handlers, etc.  Attempts to prevent two 
 *	copies of sendpage running by sending a signal to the pid listed
 *	in PATH_SENDPAGE_PIDFILE
 *
 *********************************************************************/
int BeADaemon(int ignorePid) {
	extern int	need_readconfig, need_runqueue;
	extern int errno, debug;
	pid_t pid;
	int n;
	u_int pid2;
	FILE *FP;

	pid2 = 0;

	/* First check to make sure sendpage is not allready running */
	if (!ignorePid)
		if ((FP = fopen(PATH_SENDPAGE_PIDFILE, "r"))) {

			fscanf(FP, "%u", &pid2);
			fclose(FP);

			if (pid2 && (!kill((int)pid2, 0))) {
				report_init(0);
				report (LOG_ERR, "sendpage allready running as pid %u", pid2);
				return 1;
			} /* pid2 */
		} 

	/* need to read config file */
	need_readconfig = 1;

	/* need to check queue */
	need_runqueue = 1;

	/* Handle SIGHUP */
	signal(SIGHUP, sig_hup);

	/* Handle SIGUSR1 */
	signal(SIGUSR1, sig_usr1);

	/* Handle SIGALRM */
	signal(SIGALRM, sig_alrm);

	/* Handle SIGQUIT, SIGTERM */
	signal(SIGQUIT, sig_quit);
	signal(SIGTERM, sig_quit);

	/* Handle SIGPIPE */
	signal(SIGPIPE, sig_pipe);

	if (debug > 2)
		goto skipfork;

	if ((pid = fork()) == -1) {
		report_init(0);
		report(LOG_ERR, "Can't fork() to become daemon: %s", strerror(errno));
		return 1; 
	} else if (pid) /* parent exits here */
		exit (0);

	/* child... */

	/* set reasonable umask */
	umask(0022);

	/* become a session leader */
	setsid();

	/* close open fd'd (atleast NOFILE of them) */
	for (n = 0; n < NOFILE; ++n)
		close(n);

	/* need to call report_init */
	report_init(0);

skipfork:

	FP = (FILE*)NULL;

	if ((FP = fopen(PATH_SENDPAGE_PIDFILE, "w"))) {
		fprintf(FP, "%u\n", (unsigned)getpid());
		fclose(FP);
	} else {
		report (LOG_ERR, "Can't open pidfile %.512s", PATH_SENDPAGE_PIDFILE);
	}

	report (LOG_INFO, "%s daemon started", SendpageVersion);

	return 0;

} /* BeADaemon */

/*********************************************************************
 * Function: BeADeamonSNPP()
 *	implements the daemon mode of sendpage
 *
 *	Returns:	 0	good
 *			!0	bad
 *
 *	records pid file, fork()'s, sets up flags to have config file
 *	read, sets up signal handlers, etc.  Attempts to prevent two 
 *	copies of sendpage running by sending a signal to the pid listed
 *	in PATH_SENDPAGE_PIDFILE
 *	Same as BADaemon except adds SNPP support
 *
 *********************************************************************/
int BeADaemonSNPP(int ignorePid, int snpp_port) {

	extern int	need_readconfig, need_runqueue;
	extern int errno, debug;
	pid_t pid;
	int n;
	u_int pid2;
	FILE *FP;

	pid2 = 0;

	/* First check to make sure sendpage is not allready running */
	if (!ignorePid)
		if ((FP = fopen(PATH_SENDPAGE_PIDFILE, "r"))) {

			fscanf(FP, "%u", &pid2);
			fclose(FP);

			if (pid2 && (!kill((int)pid2, 0))) {
				report_init(0);
				report (LOG_ERR, "sendpage allready running as pid %u", pid2);
				return 1;
			} /* pid2 */
		} 

	/* need to read config file */
	need_readconfig = 1;

	/* need to check queue */
	need_runqueue = 1;

	/* Handle SIGHUP */
	signal(SIGHUP, sig_hup);

	/* Handle SIGUSR1 */
	signal(SIGUSR1, sig_usr1);

	/* Handle SIGALRM */
	signal(SIGALRM, sig_alrm);

	/* Handle SIGQUIT */
	signal(SIGQUIT, sig_quit);

	/* Handle SIGPIPE */
	signal(SIGPIPE, sig_pipe);

	if (debug > 2)
		goto skipfork;

	if ((pid = fork()) == -1) {
		report_init(0);
		report(LOG_ERR, "Can't fork() to become daemon: %s", strerror(errno));
		return 1; 
	} else if (pid) /* parent exits here */
		exit (0);

	/* child... */

	/* set reasonable umask */
	umask(0022);

	/* become a session leader */
	setsid();

	/* close open fd'd (atleast NOFILE of them) */
	for (n = 0; n < NOFILE; ++n)
		close(n);

	/* need to call report_init */
	report_init(0);

skipfork:

	FP = (FILE*)NULL;

	if ((FP = fopen(PATH_SENDPAGE_PIDFILE, "w"))) {
		fprintf(FP, "%u\n", (unsigned)getpid());
		fclose(FP);
	} else {
		report (LOG_ERR, "Can't open pidfile %.512s", PATH_SENDPAGE_PIDFILE);
	}

	report (LOG_INFO, "%s SNPP daemon started", SendpageVersion);

	return 0;

} /* BeADaemon */
