/*
    Copyright (C) 2003-2006 Teus Benschop.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#include "libraries.h"
#include <libgen.h>
#include <glib.h>
#include <config.h>
#include "scripturechecks.h"
#include "utilities.h"


int main (int argc, char *argv[])
{
  if (argc == 1) {
  cout << "Scripturechecks is a collection of programs for checking Scripture." << endl;
  cout << "More information is in the documentation included with the package." << endl;
  cout << "--version          Gives version information." << endl;
  cout << "--decimal-version  Gives version information." << endl;
  } else if (strcmp (argv[1], "--version") == 0) {
    cout << PACKAGE_VERSION << endl;
  } else if (strcmp (argv[1], "--decimal-version") == 0) {
    string version (PACKAGE_VERSION);
    for (unsigned int i = 0; i < version.length(); i++) {
      if (version[i] == '.') {
        version[i] = ' ';
      }
    }
    Parse parse (version, true);
    int decimalversion = 0;
    for (unsigned int i = 0; i < parse.words.size(); i++) {
      decimalversion *= 100;
      decimalversion += convert_to_int (parse.words[i]);
    }
    cout << decimalversion << endl;
  }
  return 0;
}
