/***************************************************************************
                          mspinbox.cpp  -  description
                             -------------------
    begin                : Sat Jun 16 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mspinbox.h"

MSpinBox::MSpinBox(QWidget *pa, int s):QSpinBox(pa)
{
	switch (s)
		{
		case 1:
			Decimals = 10;
			Width = 1;
			break;
		case 2:
			Decimals = 100;
			Width = 2;
		default:
			Decimals = 100;
			Width = 2;
			break;
		}
	setValidator(0);
}
MSpinBox::~MSpinBox()
{
}

QString MSpinBox::mapValueToText(int value)
{
	return QString::number(double(value) / Decimals, 'f', Width);
}

int MSpinBox::mapTextToValue(bool *)
{
	return int(text().toFloat()*Decimals);
}
